/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class MultiSelectEditor<T extends IdTitle>
extends JPanel {
    private List<T> items;
    private List<T> selectItems;
    private List<T> availableItems;
    private BGUList<T> selectList;
    private BGUList<T> availableList;

    public MultiSelectEditor(List<T> items) {
        super(new GridBagLayout());
        this.items = items;
        this.selectItems = new ArrayList<T>();
        this.selectList = new BGUList();
        this.availableItems = new ArrayList<T>();
        this.availableItems.addAll(items);
        this.availableList = new BGUList();
        this.availableList.setData(this.availableItems);
        this.add((Component)new JLabel("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)BGSwingUtilites.wrapScrollPane(this.selectList, (int)300, (int)200), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.getAddDeletePanel(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)BGSwingUtilites.wrapScrollPane(this.availableList, (int)300, (int)200), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getAddDeletePanel() {
        JButton addButton = new JButton(ClientUtils.getIcon((String)"arrow_left"));
        addButton.addActionListener(e -> this.moveIdTitle(true, this.availableItems, this.selectItems, this.availableList.getSelectedValuesList()));
        JButton deleteButton = new JButton(ClientUtils.getIcon((String)"arrow_right"));
        deleteButton.addActionListener(e -> this.moveIdTitle(false, this.selectItems, this.availableItems, this.selectList.getSelectedValuesList()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)deleteButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private void moveIdTitle(boolean add, List<T> from, List<T> to, List<T> selectList) {
        for (IdTitle idTitle : selectList) {
            boolean add1 = false;
            for (int index = 0; index < to.size(); ++index) {
                IdTitle toIdTitle = (IdTitle)to.get(index);
                if (toIdTitle.getTitle().compareTo(idTitle.getTitle()) <= 0) continue;
                to.add(index, idTitle);
                add1 = true;
                break;
            }
            if (!add1) {
                to.add(idTitle);
            }
            from.remove(idTitle);
        }
        this.selectList.setData(add ? to : from);
        this.availableList.setData(add ? from : to);
    }

    public void setSelect(String zone) {
        this.selectItems.clear();
        this.availableItems.clear();
        List zones = Utils.toIntegerList((String)zone);
        for (IdTitle idTitle : this.items) {
            if (zones.contains(idTitle.getId())) {
                this.selectItems.add(idTitle);
                continue;
            }
            this.availableItems.add(idTitle);
        }
        this.selectList.setData(this.selectItems);
        this.availableList.setData(this.availableItems);
    }

    public String getSelect() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        Enumeration enumeration = this.selectList.getModel().elements();
        while (enumeration.hasMoreElements()) {
            ids.add(((IdTitle)enumeration.nextElement()).getId());
        }
        return Utils.toString(ids);
    }
}

