/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.client.UserEditor;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.RoleItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.RoleService;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.common.event.RoleUpdateEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class UserManager
extends BGUPanel
implements EventSubscriber<RoleUpdateEvent> {
    private int dividerSize;
    private JSplitPane splitPane;
    private JLabel recordCountLabel = new JLabel();
    private UserEditor editor;
    private List<RoleItem> roleItems = null;
    private JTextField filterValue = new JTextField();
    private BGComboBox<FilterField> filterField = new BGComboBox();
    private BGComboBox<ComboBoxItem> typeBox = new BGComboBox();
    private BGUComboBox<IdTitle> roleFilter = new BGUComboBox();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private UserTableModel tableModel;
    private RoleService roleService = null;

    public UserManager(RoleService roleService) {
        this.roleService = roleService;
        this.filterField.addItem((Object)new FilterField("name", "\u0418\u043c\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f"));
        this.filterField.addItem((Object)new FilterField("login", "\u041b\u043e\u0433\u0438\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f"));
        this.filterField.addItem((Object)new FilterField("email", "E-mail"));
        this.filterField.addItem((Object)new FilterField("descr", "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"));
    }

    protected void jbInit() throws BGException {
        this.tableModel = new UserTableModel();
        BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    UserManager.this.performAction("edit");
                }
            }
        });
        this.splitPane = new JSplitPane(0);
        this.splitPane.setLeftComponent(new JScrollPane((Component)table));
        this.splitPane.setResizeWeight(1.0);
        this.dividerSize = this.splitPane.getDividerSize();
        this.splitPane.setDividerSize(0);
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.splitPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        EventBus.subscribe(RoleUpdateEvent.class, (EventSubscriber)this);
    }

    private JPanel getTopPanel() throws BGException {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getPagePanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getPagePanel() {
        this.pagePanel.addPropertyChangeListener(e -> {
            String name = e.getPropertyName();
            if (name != null && name.startsWith("to")) {
                this.performAction("refresh");
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.pagePanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 15, 0, 5), 0, 0));
        return panel;
    }

    private void doFilter() {
        this.pagePanel.setPageIndex(1);
        this.performAction("refresh");
    }

    private JPanel getFilterPanel() throws BGException {
        this.filterValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                UserManager.this.doFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UserManager.this.doFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UserManager.this.doFilter();
            }
        });
        this.typeBox.addItem((Object)new ComboBoxItem((Object)"-1", "\u0412\u0441\u0435"));
        this.typeBox.addItem((Object)new ComboBoxItem((Object)"0", "\u0420\u0430\u0431\u043e\u0442\u0430\u0435\u0442"));
        this.typeBox.addItem((Object)new ComboBoxItem((Object)"1", "\u0417\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
        this.typeBox.addActionListener(e -> this.doFilter());
        this.setDataRoleFilter();
        this.roleFilter.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.doFilter();
            }
        });
        JPanel constrPanel = new JPanel(new GridBagLayout());
        constrPanel.setBorder((Border)new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        constrPanel.add((Component)this.filterField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        constrPanel.add((Component)this.filterValue, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        constrPanel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        constrPanel.add((Component)this.typeBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        constrPanel.add((Component)new JLabel("\u0420\u043e\u043b\u044c"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        constrPanel.add((Component)this.roleFilter, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)constrPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private void setDataRoleFilter() throws BGException {
        ArrayList<IdTitle> roles = new ArrayList<IdTitle>();
        roles.add(new IdTitle(0, "----------------"));
        roles.addAll(this.getRoleItems());
        this.roleFilter.setData(roles);
    }

    protected void initActions() {
        new AbstractBGUPanel.AsyncAction<SearchResult<User>>("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            protected SearchResult<User> doInBackground() throws Exception {
                int selectedRoleItem = UserManager.this.roleFilter.getSelectedItem() != null ? ((IdTitle)UserManager.this.roleFilter.getSelectedItem()).getId() : -1;
                return ((UserService)((ClientContext)UserManager.this.getContext()).getWebService(UserService.class)).findUsers(((FilterField)UserManager.this.filterField.getSelectedItem()).getField(), UserManager.this.filterValue.getText(), Integer.parseInt(UserManager.this.typeBox.getSelectedId()), -1, UserManager.this.pagePanel.getPage(), selectedRoleItem);
            }

            protected void done(SearchResult<User> result) throws Exception {
                UserManager.this.tableModel.setData(result != null ? result.getList() : new ArrayList());
                UserManager.this.pagePanel.setPage(result != null ? result.getPage() : new Page());
                UserManager.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + (result != null ? result.getPage().getRecordCount() : 0));
            }
        };
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.roleItems.clear();
            User user = new User();
            user.setRoleId(-1);
            this.startEdit(user);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            User user = (User)((Object)((Object)this.tableModel.getSelectedRow()));
            if (user == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            }
            this.roleItems.clear();
            this.startEdit(user);
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            User user = (User)((Object)((Object)this.tableModel.getSelectedRow()));
            if (user == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                ((UserService)((ClientContext)this.getContext()).getWebService(UserService.class)).deleteUser(user.getId());
                this.performAction("refresh");
            }
        });
    }

    private UserEditor getUserEditor() throws BGException {
        if (this.editor == null) {
            this.editor = new UserEditor((ClientContext)this.getContext());
            this.editor.performAction("refresh");
            this.editor.setRoleItems(this.getRoleItems());
            this.editor.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
            this.editor.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    UserManager.this.splitPane.setDividerSize(0);
                    String lastActionCommand = UserManager.this.editor.getLastActionCommand();
                    if (Utils.notBlankString((String)lastActionCommand) && lastActionCommand.equals("ok")) {
                        UserManager.this.performAction("refresh");
                    }
                }
            });
        }
        return this.editor;
    }

    private void startEdit(User user) throws BGException {
        this.getUserEditor().setUser(user);
        this.splitPane.setDividerSize(this.dividerSize);
        this.splitPane.setRightComponent((Component)((Object)this.getUserEditor()));
    }

    private List<RoleItem> getRoleItems() throws BGException {
        if (Utils.isEmptyCollection(this.roleItems)) {
            this.roleItems = this.roleService.getRoleItems(false, true);
        }
        return this.roleItems;
    }

    public void onEvent(RoleUpdateEvent event) {
        try {
            this.roleItems.clear();
            this.setDataRoleFilter();
            if (this.editor != null) {
                this.editor.setRoleItems(this.getRoleItems());
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    class FilterField
    implements GuiTitlable {
        private String field;
        private String title;

        public FilterField(String field, String title) {
            this.field = field;
            this.title = title;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }

        public String getGuiTitle() {
            return this.title;
        }
    }

    private class UserTableModel
    extends BGTableModel<User> {
        public UserTableModel() throws BGException {
            super(UserTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f", -1, 90, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041b\u043e\u0433\u0438\u043d", 150, 150, 150, "login", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("E-mail", 100, 150, 180, "email", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 120, 120, 120, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u043e\u043b\u044c", -1, 120, -1, "roleId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, 400, -1, "description", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(User user, int column) throws BGException {
            Object result = "";
            String identifier = this.getIdentifier(column);
            result = "status".equals(identifier) ? user.getStatusString() : ("roleId".equals(identifier) && Utils.notEmptyCollection(UserManager.this.getRoleItems()) ? UserManager.this.getRoleItems().stream().filter(r -> r.getId() == user.getRoleId()).findFirst().map(IdTitle::getTitle).orElse("<\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430>") : super.getValue((Object)user, column));
            return result;
        }
    }
}

