/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.server;

import java.sql.Connection;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.RangeMap;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.RangeMapItem;
import ru.bitel.bgbilling.kernel.base.phone.server.bean.RangeMapDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.ref.ConcurrentReferenceHashMap;

public class RangeMapCache {
    private static final Logger logger = LogManager.getLogger();
    private final Map<Integer, List<RangeMapItem>> map;
    private static Map<Long, Future<RangeMapCacheItem>> futures = new HashMap<Long, Future<RangeMapCacheItem>>();
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final ConcurrentMap<Integer, ConcurrentReferenceHashMap<Long, RangeMapCacheItem>> cache = new ConcurrentHashMap<Integer, ConcurrentReferenceHashMap<Long, RangeMapCacheItem>>();

    public RangeMapCache(Map<Integer, List<RangeMapItem>> map) {
        this.map = map;
    }

    public List<RangeMapItem> getList(Integer rangeMapId) {
        return this.map.get(rangeMapId);
    }

    public boolean contains(Integer rangeMapId, String number) {
        List<RangeMapItem> list = this.map.get(rangeMapId);
        if (list == null) {
            return false;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!list.get(i).matches(number)) continue;
            return true;
        }
        return false;
    }

    public static synchronized RangeMapCache getInstance(Connection con, int moduleId, Calendar hour) throws BGException {
        ConcurrentReferenceHashMap map = (ConcurrentReferenceHashMap)cache.get(moduleId);
        if (map == null) {
            ConcurrentReferenceHashMap newMap = new ConcurrentReferenceHashMap(ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.SOFT);
            map = cache.putIfAbsent(moduleId, (ConcurrentReferenceHashMap<Long, RangeMapCacheItem>)newMap);
            if (map == null) {
                map = newMap;
            }
        }
        Calendar hourIn = (Calendar)hour.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)hourIn);
        hourIn.set(5, 1);
        Long dateMillis = hourIn.getTimeInMillis();
        Future<RangeMapCacheItem> future = futures.get(dateMillis);
        if (future != null && future.isDone()) {
            try {
                RangeMapCacheItem newItem = future.get();
                map.remove((Object)dateMillis);
                map.put((Object)dateMillis, (Object)newItem);
                futures.put(dateMillis, null);
                logger.info("Finish Reloading RangeMap cache for mid " + moduleId + " and millis=>" + dateMillis);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                futures.put(dateMillis, null);
            }
        }
        RangeMapCacheItem item = (RangeMapCacheItem)map.get((Object)dateMillis);
        Calendar dbModTime = ServerUtils.getLastModificationTime(con, "zone_map_" + moduleId);
        if (item != null && (dbModTime == null || dbModTime.getTimeInMillis() == item.lastModified)) {
            return item.cache;
        }
        if (item == null) {
            logger.info("Loading RangeMap cache for mid " + moduleId + " and millis=>" + dateMillis);
            item = RangeMapCache.load(con, moduleId, hourIn, dbModTime);
            map.put((Object)dateMillis, (Object)item);
        } else if (futures.get(dateMillis) == null) {
            logger.info("Reloading RangeMap cache for mid " + moduleId + " and millis=>" + dateMillis);
            futures.put(dateMillis, executor.submit(() -> RangeMapCache.load(con, moduleId, hourIn, dbModTime)));
        }
        return item.cache;
    }

    private static synchronized RangeMapCacheItem load(Connection con, int moduleId, Calendar hourIn, Calendar dbModTime) throws BGException {
        try (RangeMapDao rangeMapDao = new RangeMapDao(con, moduleId);){
            HashMap<Integer, List<RangeMapItem>> rangeMaps = new HashMap<Integer, List<RangeMapItem>>();
            for (RangeMap rangeMap : rangeMapDao.list()) {
                rangeMaps.put(rangeMap.getId(), rangeMapDao.listItems(rangeMap.getId(), hourIn.getTime()));
            }
            RangeMapCacheItem rangeMapCacheItem = new RangeMapCacheItem(new RangeMapCache(rangeMaps), dbModTime != null ? dbModTime.getTimeInMillis() : 0L);
            return rangeMapCacheItem;
        }
    }

    private static class RangeMapCacheItem {
        final RangeMapCache cache;
        final long lastModified;

        public RangeMapCacheItem(RangeMapCache cache, long lastModified) {
            this.cache = cache;
            this.lastModified = lastModified;
        }
    }
}

