/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.mail.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.mail.common.bean.MailConfig;
import ru.bitel.common.dao.AbstractDao;

public class MailConfigDao
extends AbstractDao<MailConfig> {
    public MailConfigDao(Connection con) {
        super(con, 0, "mail_config");
    }

    public List<MailConfig> list() throws BGException {
        return this.list(null, null, new Object[0]);
    }

    public MailConfig get(String componentId, int moduleId, String key) throws BGException {
        return (MailConfig)super.get("`component_id`=? AND `module_id`=? AND `key`=?", new Object[]{componentId, moduleId, key});
    }

    protected MailConfig getFromRS(ResultSet rs) throws SQLException, BGException {
        MailConfig mailConfig = new MailConfig();
        mailConfig.setComponentId(rs.getString("component_id"));
        mailConfig.setModuleId(rs.getInt("module_id"));
        mailConfig.setKey(rs.getString("key"));
        mailConfig.setSubjectMode(MailConfig.SubjectMode.valueOf(rs.getString("subject_mode")));
        mailConfig.setSubjectCustom(rs.getString("subject_custom"));
        mailConfig.setPatternMode(MailConfig.PatternMode.valueOf(rs.getString("pattern_mode")));
        mailConfig.setPatternCustom(rs.getString("pattern_custom"));
        mailConfig.setHandlerMode(MailConfig.HandlerMode.valueOf(rs.getString("handler_mode")));
        mailConfig.setHandlerCustom(rs.getString("handler_custom"));
        mailConfig.setHandlerParams(rs.getString("handler_params"));
        return mailConfig;
    }

    protected void updateImpl(MailConfig mailConfig) throws BGException, SQLException {
        int index;
        Objects.requireNonNull(mailConfig);
        boolean update = false;
        String querySet = "subject_mode=?, subject_custom=?, pattern_mode=?, pattern_custom=?, handler_mode=?, handler_custom=?, handler_params=?";
        String query = "UPDATE " + this.tableName + " SET " + querySet + " WHERE `component_id`=? AND `module_id`=? AND `key`=?";
        try (PreparedStatement psUpdate = this.con.prepareStatement(query);){
            index = 1;
            psUpdate.setString(index++, mailConfig.getSubjectMode().name());
            psUpdate.setString(index++, mailConfig.getSubjectCustom());
            psUpdate.setString(index++, mailConfig.getPatternMode().name());
            psUpdate.setString(index++, mailConfig.getPatternCustom());
            psUpdate.setString(index++, mailConfig.getHandlerMode().name());
            psUpdate.setString(index++, mailConfig.getHandlerCustom());
            psUpdate.setString(index++, mailConfig.getHandlerParams());
            psUpdate.setString(index++, mailConfig.getComponentId());
            psUpdate.setInt(index++, mailConfig.getModuleId());
            psUpdate.setString(index++, mailConfig.getKey());
            update = psUpdate.executeUpdate() > 0;
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        if (!update) {
            query = "INSERT INTO " + this.tableName + " SET `component_id`=?, `module_id`=?, `key`=?, " + querySet;
            try (PreparedStatement psInsert = this.con.prepareStatement(query);){
                index = 1;
                psInsert.setString(index++, mailConfig.getComponentId());
                psInsert.setInt(index++, mailConfig.getModuleId());
                psInsert.setString(index++, mailConfig.getKey());
                psInsert.setString(index++, mailConfig.getSubjectMode().name());
                psInsert.setString(index++, mailConfig.getSubjectCustom());
                psInsert.setString(index++, mailConfig.getPatternMode().name());
                psInsert.setString(index++, mailConfig.getPatternCustom());
                psInsert.setString(index++, mailConfig.getHandlerMode().name());
                psInsert.setString(index++, mailConfig.getHandlerCustom());
                psInsert.setString(index++, mailConfig.getHandlerParams());
                psInsert.executeUpdate();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }
}

