/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.ContractGroup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;

public class ContractGroupManager {
    private static final String TABLE_NAME = "contract_group";
    protected Connection con;

    public ContractGroupManager(Connection con) {
        this.con = con;
    }

    public List<ContractGroup> getGroupList() throws BGException {
        return this.getGroupList(true);
    }

    public List<ContractGroup> getGroupList(long groupMask) throws BGException {
        ArrayList<ContractGroup> list = new ArrayList<ContractGroup>();
        for (ContractGroup contractGroup : this.getGroupList(false)) {
            if ((groupMask & 1L << contractGroup.getId()) <= 0L) continue;
            list.add(contractGroup);
        }
        return list;
    }

    public List<ContractGroup> getEnableGroupList() throws BGException {
        ArrayList<ContractGroup> list = new ArrayList<ContractGroup>();
        for (ContractGroup contractGroup : this.getGroupList(false)) {
            if (!contractGroup.isEnabled()) continue;
            list.add(contractGroup);
        }
        return list;
    }

    public List<ContractGroup> getGroupList(boolean all) throws BGException {
        ArrayList<ContractGroup> list = new ArrayList<ContractGroup>();
        try {
            ContractGroup[] contractGroups = new ContractGroup[63];
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(TABLE_NAME).append(" ORDER BY ").append("title");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ContractGroup contractGroup = new ContractGroup();
                contractGroup.setId(rs.getInt("id"));
                contractGroup.setTitle(rs.getString("title"));
                contractGroup.setEnabled(rs.getBoolean("enable"));
                contractGroup.setEditable(rs.getBoolean("editable"));
                contractGroup.setComment(rs.getString("comment"));
                if (all) {
                    contractGroups[contractGroup.getId()] = contractGroup;
                    continue;
                }
                list.add(contractGroup);
            }
            rs.close();
            ps.close();
            if (all) {
                for (int index = 0; index < 63; ++index) {
                    ContractGroup contractGroup = contractGroups[index];
                    if (contractGroup != null) continue;
                    contractGroup = new ContractGroup();
                    contractGroup.setId(index);
                    contractGroup.setTitle("\u0413\u0440\u0443\u043f\u043f\u0430 " + String.format("%1$02d", index));
                    contractGroup.setEnabled(false);
                    contractGroup.setEditable(false);
                    contractGroup.setComment("");
                    contractGroups[index] = contractGroup;
                }
                for (ContractGroup contractGroup : contractGroups) {
                    if (contractGroup == null) continue;
                    list.add(contractGroup);
                }
                Collections.sort(list);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return list;
    }

    public boolean isEditable(int id) throws BGException {
        boolean result = true;
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT " + "editable" + " FROM " + TABLE_NAME + " WHERE " + "id=" + id);
            while (rs.next()) {
                result = rs.getBoolean(1);
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateGroup(ContractGroup contractGroup) throws BGException {
        if (contractGroup != null) {
            try {
                boolean updateRow = false;
                int groupId = contractGroup.getId();
                String query = "UPDATE contract_group SET title=?, enable=?, editable=?, comment=? WHERE id=" + groupId;
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setString(1, contractGroup.getTitle());
                ps.setInt(2, contractGroup.isEnabled() ? 1 : 0);
                ps.setInt(3, contractGroup.isEditable() ? 1 : 0);
                ps.setString(4, contractGroup.getComment());
                updateRow = ps.executeUpdate() > 0;
                ps.close();
                if (!updateRow && groupId >= 0 && groupId < 64) {
                    query = "INSERT INTO contract_group SET title=?, enable=?, editable=?, comment=?, id=" + groupId;
                    ps = this.con.prepareStatement(query);
                    ps.setString(1, contractGroup.getTitle());
                    ps.setInt(2, contractGroup.isEnabled() ? 1 : 0);
                    ps.setInt(3, contractGroup.isEditable() ? 1 : 0);
                    ps.setString(4, contractGroup.getComment());
                    ps.executeUpdate();
                    ps.close();
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public Map<Integer, Integer> getStatMap() throws BGException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT gr, COUNT(*) FROM contract GROUP BY gr");
            while (rs.next()) {
                int count = rs.getInt(2);
                int index = 0;
                for (long gr = rs.getLong(1); gr > 0L; gr >>= 1) {
                    if ((gr & 1L) > 0L) {
                        Integer grCount = (Integer)map.get(index);
                        if (grCount == null) {
                            grCount = 0;
                        }
                        grCount = grCount + count;
                        map.put(index, grCount);
                    }
                    ++index;
                }
            }
            st.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return map;
    }
}

