/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Reserve;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ReserveType;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ReserveTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWebMessagesEvent;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ContractBalanceUtils {
    public static WebBalanceData getWebBalanceData(Connection con, int contractId, int month, int year) throws BGMessageException {
        Period period = new Period(year, month - 1, 1, 32);
        return ContractBalanceUtils.getWebBalanceData(con, contractId, period, 3);
    }

    public static WebBalanceData getWebBalanceData(Connection con, int contractId, Period period, int lastItems) throws BGMessageException {
        WebBalanceData webBalanceData = new WebBalanceData();
        webBalanceData.setMonth(period.getMonthFrom());
        webBalanceData.setYear(period.getYearFrom());
        webBalanceData.setContractManager(new ContractManager(con));
        webBalanceData.setContract(webBalanceData.getContractManager().getContractById(contractId));
        ArrayList<Integer> contractIds = new ArrayList<Integer>();
        contractIds.add(contractId);
        if (Utils.notBlankString((String)webBalanceData.getContract().getDependSubList())) {
            contractIds.addAll(Utils.toIntegerList((String)webBalanceData.getContract().getDependSubList()));
        }
        BalanceUtils balanceUtils = new BalanceUtils(con);
        try {
            int typeId;
            ArrayList<Integer> typeIds;
            SearchResult searchResult;
            if (!webBalanceData.getContract().isDependSub()) {
                webBalanceData.setSumma1(balanceUtils.getBalanceSumma1(period.getDateFrom(), contractId));
            }
            try (PaymentDao paymentDao = new PaymentDao(con);
                 PaymentTypeDao paymentTypeDao = new PaymentTypeDao(con);){
                searchResult = new SearchResult();
                searchResult.setList(paymentDao.getPaymentList(contractIds, period, null));
                if (searchResult.getList().isEmpty()) {
                    paymentDao.searchLastPaymentList((SearchResult<Payment>)searchResult, contractIds, 3);
                }
                webBalanceData.setPaymentList(searchResult.getList());
                typeIds = new ArrayList<Integer>();
                for (Payment payment : webBalanceData.getPaymentList()) {
                    typeId = payment.getTypeId();
                    if (!typeIds.contains(typeId)) {
                        typeIds.add(typeId);
                    }
                    webBalanceData.setSumma2(webBalanceData.getSumma2().add(payment.getSum()));
                }
                webBalanceData.setPaymentTypeMap(paymentTypeDao.getTypeMapByIds(typeIds));
            }
            try (ChargeDao chargeDao = new ChargeDao(con);
                 ChargeTypeDao chargeTypeDao = new ChargeTypeDao(con);){
                searchResult = new SearchResult(period, null);
                chargeDao.searchChargeList((SearchResult<Charge>)searchResult, contractIds);
                if (searchResult.getList().isEmpty()) {
                    chargeDao.searchLastChargeList((SearchResult<Charge>)searchResult, contractIds, lastItems);
                }
                webBalanceData.setChargeList(searchResult.getList());
                typeIds = new ArrayList();
                for (Charge charge : webBalanceData.getChargeList()) {
                    typeId = charge.getTypeId();
                    if (!typeIds.contains(typeId)) {
                        typeIds.add(typeId);
                    }
                    webBalanceData.setSumma4(webBalanceData.getSumma4().add(charge.getSum()));
                }
                webBalanceData.setChargeTypeMap(chargeTypeDao.getTypeMapByIds(typeIds));
            }
            try (ReserveDao reserveDao = new ReserveDao(con);
                 ReserveTypeDao reserveTypeDao = new ReserveTypeDao(con);){
                webBalanceData.setReserveList(reserveDao.getReserveList(contractId, period, 2));
                ArrayList<Integer> typeIds2 = new ArrayList<Integer>();
                BigDecimal reserveSum = BigDecimal.ZERO;
                for (Reserve reserve : webBalanceData.getReserveList()) {
                    reserveSum = reserveSum.add(reserve.getSum());
                    typeId = reserve.getTypeId();
                    if (typeIds2.contains(typeId)) continue;
                    typeIds2.add(typeId);
                }
                webBalanceData.setReserve(reserveSum);
                webBalanceData.setReserveTypeMap(reserveTypeDao.getTypeMapByIds(typeIds2));
            }
            String query = "SELECT t2.title, ROUND(t1.summa,2) FROM contract_account AS t1 LEFT JOIN service AS t2 ON t1.sid=t2.id WHERE cid IN ( " + Utils.toString(contractIds) + " ) AND mm=? AND yy=?";
            try (PreparedStatement ps = con.prepareStatement(query);){
                ps.setInt(1, webBalanceData.getMonth());
                ps.setInt(2, webBalanceData.getYear());
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        String[] str = new String[2];
                        BigDecimal value = rs.getBigDecimal(2);
                        String title = rs.getString(1);
                        str[0] = title == null ? "?" : title;
                        str[1] = String.valueOf(value);
                        webBalanceData.getAccountList().add(str);
                        webBalanceData.setSumma3(webBalanceData.getSumma3().add(value));
                    }
                }
            }
            webBalanceData.setEvent(new ContractWebMessagesEvent(contractId));
            EventProcessor.getInstance().request(webBalanceData.getEvent());
            WebBalanceData webBalanceData2 = webBalanceData;
            balanceUtils.close();
            return webBalanceData2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    balanceUtils.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new BGMessageException(e.getLocalizedMessage());
            }
        }
    }

    public static class WebBalanceData {
        private int month = -1;
        private int year = -1;
        private BigDecimal summa1 = BigDecimal.ZERO;
        private BigDecimal summa2 = BigDecimal.ZERO;
        private BigDecimal summa3 = BigDecimal.ZERO;
        private BigDecimal summa4 = BigDecimal.ZERO;
        private BigDecimal reserve = BigDecimal.ZERO;
        private ContractManager contractManager = null;
        private Contract contract = null;
        private List<Charge> chargeList = null;
        private List<Payment> paymentList = null;
        private List<Reserve> reserveList = null;
        private Map<Integer, ChargeType> chargeTypeMap = null;
        private Map<Integer, PaymentType> paymentTypeMap = null;
        private Map<Integer, ReserveType> reserveTypeMap = null;
        private List<String[]> accountList = new ArrayList<String[]>();
        private ContractWebMessagesEvent event;

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public BigDecimal getSumma1() {
            return this.summa1;
        }

        public void setSumma1(BigDecimal summa1) {
            this.summa1 = summa1;
        }

        public BigDecimal getSumma2() {
            return this.summa2;
        }

        public void setSumma2(BigDecimal summa2) {
            this.summa2 = summa2;
        }

        public BigDecimal getSumma3() {
            return this.summa3;
        }

        public void setSumma3(BigDecimal summa3) {
            this.summa3 = summa3;
        }

        public BigDecimal getSumma4() {
            return this.summa4;
        }

        public void setSumma4(BigDecimal summa4) {
            this.summa4 = summa4;
        }

        public BigDecimal getReserve() {
            return this.reserve;
        }

        public void setReserve(BigDecimal reserve) {
            this.reserve = reserve;
        }

        public BigDecimal getSumma5() {
            return this.summa1.add(this.summa2).subtract(this.summa3).subtract(this.summa4);
        }

        public ContractManager getContractManager() {
            return this.contractManager;
        }

        public void setContractManager(ContractManager contractManager) {
            this.contractManager = contractManager;
        }

        public Contract getContract() {
            return this.contract;
        }

        public void setContract(Contract contract) {
            this.contract = contract;
        }

        public List<Payment> getPaymentList() {
            return this.paymentList;
        }

        public void setPaymentList(List<Payment> paymentList) {
            this.paymentList = paymentList;
        }

        public Map<Integer, PaymentType> getPaymentTypeMap() {
            return this.paymentTypeMap;
        }

        public void setPaymentTypeMap(Map<Integer, PaymentType> paymentTypeMap) {
            this.paymentTypeMap = paymentTypeMap;
        }

        public List<Charge> getChargeList() {
            return this.chargeList;
        }

        public void setChargeList(List<Charge> chargeList) {
            this.chargeList = chargeList;
        }

        public Map<Integer, ChargeType> getChargeTypeMap() {
            return this.chargeTypeMap;
        }

        public void setChargeTypeMap(Map<Integer, ChargeType> chargeTypeMap) {
            this.chargeTypeMap = chargeTypeMap;
        }

        public List<Reserve> getReserveList() {
            return this.reserveList;
        }

        public void setReserveList(List<Reserve> reserveList) {
            this.reserveList = reserveList;
        }

        public Map<Integer, ReserveType> getReserveTypeMap() {
            return this.reserveTypeMap;
        }

        public void setReserveTypeMap(Map<Integer, ReserveType> reserveTypeMap) {
            this.reserveTypeMap = reserveTypeMap;
        }

        public List<String[]> getAccountList() {
            return this.accountList;
        }

        public void setAccountList(List<String[]> accountList) {
            this.accountList = accountList;
        }

        public ContractWebMessagesEvent getEvent() {
            return this.event;
        }

        public void setEvent(ContractWebMessagesEvent event) {
            this.event = event;
        }
    }
}

