/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.bean;

import bitel.billing.server.admin.resource.bean.NumberResource;
import bitel.billing.server.admin.resource.bean.NumberResourceCategory;
import bitel.billing.server.admin.resource.bean.NumberResourceCategoryManager;
import bitel.billing.server.admin.resource.bean.ResourceManager;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class NumberResourceManager
extends ResourceManager<NumberResource> {
    public NumberResourceManager(Connection con, int moduleId) {
        super(con, moduleId);
    }

    @Override
    protected String getTableName() {
        return "number_resource";
    }

    @Override
    protected NumberResource getResourceFromRs(ResultSet rs) {
        NumberResource result = new NumberResource();
        try {
            this.loadStandartResourceFromRs(rs, result);
            result.setNumber(rs.getString("number"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    protected NumberResource getResourceFromRsWithContract(ResultSet rs) {
        NumberResource result = new NumberResource();
        try {
            this.loadStandartResourceFromRs(rs, result);
            result.setNumber(rs.getString("number"));
            result.setContractTitle(rs.getString("title"));
            result.setContractComment(rs.getString("comment"));
            Date dateReserve = rs.getDate("date_reserve");
            int userId = rs.getInt("ruse.reserve_user_id");
            if (dateReserve != null) {
                String comment = rs.getString("ruse.comment");
                StringBuilder contractComment = new StringBuilder();
                contractComment.append("[\u0420\u0435\u0437\u0435\u0440\u0432 \u0434\u043e " + dateReserve + " ] ");
                String cComment = result.getContractComment();
                if (Utils.isEmptyString((String)comment) && !Utils.isEmptyString((String)cComment)) {
                    contractComment.append(cComment);
                } else {
                    contractComment.append(comment);
                    User user = UserMap.getUser(userId);
                    contractComment.append(" ( \u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u043b " + user.getTitle() + ")");
                }
                result.setContractComment(contractComment.toString());
                result.setReserveComment(comment);
            }
            result.setDateReserve(dateReserve);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void updateResource(NumberResource res) {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (res.getId() <= 0) {
                query = "INSERT INTO " + this.tableName + " (date1, date2, category_id, number) VALUES (?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UDPATE " + this.tableName + " SET date1=?, date2=?, category_id=?, number=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, res.getId());
            }
            ps.setDate(1, TimeUtils.convertDateToSqlDate((java.util.Date)res.getDateFrom()));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((java.util.Date)res.getDateTo()));
            ps.setInt(3, res.getCategoryId());
            ps.setString(4, res.getNumber());
            ps.executeUpdate();
            if (res.getId() <= 0) {
                res.setId(ServerUtils.lastInsertId(ps));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<NumberResource> getResourceList(String number) {
        ArrayList<NumberResource> result = new ArrayList<NumberResource>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE number=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, number);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getResourceFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<NumberResource> getResourceListByIds(String ids) {
        ArrayList<NumberResource> result = new ArrayList<NumberResource>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE id IN (" + ids + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getResourceFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateResourcePeriod(String ids, Calendar date1, Calendar date2) {
        try {
            String query = "UPDATE " + this.tableName + " SET date1=?, date2=? WHERE id IN(" + ids + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, List<NumberResource>> getNumberResourceMap() {
        HashMap<String, List<NumberResource>> result = new HashMap<String, List<NumberResource>>();
        try {
            String query = "SELECT * FROM " + this.tableName;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                NumberResource res = this.getResourceFromRs(rs);
                String number = res.getNumber();
                ArrayList<NumberResource> resourceList = (ArrayList<NumberResource>)result.get(number);
                if (resourceList == null) {
                    resourceList = new ArrayList<NumberResource>(3);
                    result.put(number, resourceList);
                }
                resourceList.add(res);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void closeResources(String numbers, Calendar date) {
        try {
            String query = "UPDATE " + this.tableName + " SET date2=? WHERE number IN (" + numbers + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<NumberResource> getResourceList(int categoryId, String fromNumber, String toNumber) {
        ArrayList<NumberResource> result = new ArrayList<NumberResource>();
        try {
            StringBuilder query = new StringBuilder();
            query.append("SELECT res.*, contract.title,contract.comment, ruse.date_reserve, ruse.comment, ruse.reserve_user_id FROM ");
            query.append(this.tableName);
            query.append(" AS res LEFT JOIN number_resource_use_");
            query.append(this.mid);
            query.append(" AS ruse ON res.id=ruse.resource_id AND ruse.date1<= CURDATE() AND (ruse.date2 is null or ruse.date2>=CURDATE() or ruse.date_reserve>=CURDATE()) ");
            query.append(" LEFT JOIN contract ON contract.id=ruse.cid ");
            query.append(" WHERE 1>0 ");
            this.addFilters(categoryId, fromNumber, toNumber, query);
            query.append(" ORDER BY number");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getResourceFromRsWithContract(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<NumberResource> getFreeNumberList(int categoryId, Calendar date, String numberFrom, String numberTo, boolean reserved) {
        return this.getNumberList(categoryId, date, numberFrom, numberTo, true, reserved);
    }

    public List<NumberResource> getBusyNumberList(int categoryId, Calendar date, String numberFrom, String numberTo, boolean reserved) {
        return this.getNumberList(categoryId, date, numberFrom, numberTo, false, reserved);
    }

    private List<NumberResource> getNumberList(int categoryId, Calendar date, String numberFrom, String numberTo, boolean free, boolean reserved) {
        ArrayList<NumberResource> result = new ArrayList<NumberResource>();
        try {
            StringBuilder query = new StringBuilder(200);
            query.append("SELECT res.*, ruse.resource_id, contract.title, contract.comment, ruse.date_reserve, ruse.comment, ruse.reserve_user_id  FROM ");
            query.append(this.tableName);
            query.append(" AS res ");
            query.append(" LEFT JOIN ");
            query.append("number_resource_use_");
            query.append(this.mid);
            query.append(" AS ruse ON ruse.resource_id=res.id AND  (ruse.date1 IS NULL OR ruse.date1<=?) AND  ((ruse.date2 IS NULL OR ruse.date2>=?) OR ruse.date_reserve>=?)");
            query.append(" LEFT JOIN contract ON contract.id=ruse.cid ");
            query.append(" WHERE (res.date1 IS NULL OR res.date1<=?)  AND (res.date2 IS NULL OR res.date2>=?)");
            this.addFilters(categoryId, numberFrom, numberTo, query);
            if (free) {
                query.append(" HAVING ruse.resource_id IS NULL ");
                if (reserved) {
                    query.append(" OR  ruse.date_reserve IS NOT NULL ");
                }
            } else {
                query.append(" HAVING ruse.resource_id IS NOT NULL ");
                if (reserved) {
                    query.append(" AND  ruse.date_reserve IS NULL ");
                }
            }
            query.append(" ORDER BY number");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            Date sqlDate = TimeUtils.convertCalendarToSqlDate((Calendar)date);
            int index = 1;
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getResourceFromRsWithContract(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<NumberResource> getLastUseNumberList(int categoryId, Calendar date, String numberFrom, String numberTo, Calendar ldate) {
        ArrayList<NumberResource> result = new ArrayList<NumberResource>();
        try {
            StringBuilder query = new StringBuilder(200);
            query.append("SELECT res.*, outruse.ldate FROM ");
            query.append(this.tableName);
            query.append(" AS res ");
            query.append(" RIGHT JOIN ");
            query.append("( select resource_id, max(date2) as ldate from number_resource_use_" + this.mid + " as ruse  where not exists (select * from number_resource_use_" + this.mid + " as inruse where date2 is null and ruse.resource_id=inruse.resource_id)  group by resource_id  having ldate <= ?)");
            query.append(" AS outruse ON res.id = outruse.resource_id ");
            query.append(" WHERE (res.date1 IS NULL OR res.date1<=?)    AND (res.date2 IS NULL OR res.date2>=?)");
            this.addFilters(categoryId, numberFrom, numberTo, query);
            query.append(" UNION ALL ");
            query.append("SELECT res.*, null as ldate FROM  ");
            query.append(this.tableName);
            query.append(" AS res ");
            query.append(" WHERE NOT EXISTS ");
            query.append(" (select * from number_resource_use_" + this.mid + " as inruse where res.id=inruse.resource_id) ");
            query.append(" AND (res.date1 IS NULL OR res.date1<=?)  AND (res.date2 IS NULL OR res.date2>=?)");
            this.addFilters(categoryId, numberFrom, numberTo, query);
            query.append(" ORDER BY number");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            Date sqlDate = TimeUtils.convertCalendarToSqlDate((Calendar)date);
            ps.setDate(1, TimeUtils.convertCalendarToSqlDate((Calendar)ldate));
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            ps.setDate(5, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getResourceFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<NumberResource> getReservedNumberList(int categoryId, Calendar date, String numberFrom, String numberTo) {
        ArrayList<NumberResource> result = new ArrayList<NumberResource>();
        try {
            StringBuilder query = new StringBuilder(200);
            query.append("SELECT res.*, ruse.resource_id, contract.title, contract.comment, ruse.date_reserve, ruse.comment, ruse.reserve_user_id  FROM ");
            query.append(this.tableName);
            query.append(" AS res ");
            query.append(" LEFT JOIN ");
            query.append("number_resource_use_");
            query.append(this.mid);
            query.append(" AS ruse ON ruse.resource_id=res.id AND  (ruse.date1 IS NULL OR ruse.date1<=?) AND  ((ruse.date2 IS NULL OR ruse.date2>=?) OR ruse.date_reserve>=?)");
            query.append(" LEFT JOIN contract ON contract.id=ruse.cid ");
            query.append(" WHERE (res.date1 IS NULL OR res.date1<=?)  AND (res.date2 IS NULL OR res.date2>=?)");
            this.addFilters(categoryId, numberFrom, numberTo, query);
            query.append(" HAVING ruse.resource_id IS NOT NULL AND ruse.date_reserve IS NOT NULL ");
            query.append(" ORDER BY number");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            Date sqlDate = TimeUtils.convertCalendarToSqlDate((Calendar)date);
            int index = 1;
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ps.setDate(index++, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getResourceFromRsWithContract(rs));
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void addFilters(int categoryId, String numberFrom, String numberTo, StringBuilder query) {
        String list;
        if (categoryId > 0 && !Utils.isBlankString((String)(list = Utils.toString(this.getSubCategories(categoryId))))) {
            query.append(" AND category_id IN (" + list + ")");
        }
        if (Utils.notBlankString((String)numberFrom)) {
            query.append(" AND number>='");
            query.append(numberFrom);
            query.append("'");
        }
        if (Utils.notBlankString((String)numberTo)) {
            query.append(" AND number<='");
            query.append(numberTo);
            query.append("'");
        }
    }

    @Override
    public void syncResourceUse() throws BGException {
        boolean autoCommit = false;
        try {
            autoCommit = this.con.getAutoCommit();
            this.con.setAutoCommit(false);
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE FROM number_resource_use_" + this.mid);
            st.executeUpdate("INSERT INTO number_resource_use_" + this.mid + " (resource_id,date1,date2,cid) SELECT r.id, ci.date1, ci.date2, ci.cid from number_resource_" + this.mid + " as r JOIN phone_item_number_" + this.mid + " n on r.number=n.number JOIN phone_client_item_" + this.mid + " ci on ci.id=n.item_id");
            if (Setup.getSetup().getModuleSetup(this.mid).getBoolean("phone.resource.reserve", false)) {
                int reserveMothCount = Setup.getSetup().getModuleSetup(this.mid).getInt("phone.resource.reserve.month.count", 1);
                st.executeUpdate("UPDATE number_resource_use_" + this.mid + " nru INNER JOIN (  SELECT resource_id,max(date2) + interval " + reserveMothCount + " month date_reserve FROM number_resource_use_" + this.mid + " WHERE resource_id NOT IN ( SELECT resource_id FROM number_resource_use_" + this.mid + " WHERE date2 IS NULL)  GROUP BY resource_id HAVING date_reserve>=current_date) mstr  ON nru.resource_id=mstr.resource_id  SET nru.date_reserve=mstr.date_reserve WHERE nru.date2=mstr.date_reserve - interval " + reserveMothCount + " month");
            }
            st.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        finally {
            try {
                this.con.setAutoCommit(autoCommit);
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    private List<Integer> getSubCategories(int categoryId) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        NumberResourceCategory cat = new NumberResourceCategory();
        cat.setSubCategories(new NumberResourceCategoryManager(this.con, this.mid).getCategoryTree());
        this.getSub(res, cat, categoryId, false);
        return res;
    }

    private void getSub(List<Integer> res, NumberResourceCategory category, int categoryId, boolean add) {
        if (category.getId() == categoryId || add) {
            res.add(category.getId());
            add = true;
        }
        if (category.subCategories != null) {
            for (NumberResourceCategory subCategory : category.subCategories) {
                this.getSub(res, subCategory, categoryId, add);
            }
        }
    }

    public String checkResource(String number, Date dateFrom, Date dateTo) {
        StringBuilder result = new StringBuilder();
        try {
            StringBuilder query = new StringBuilder(200);
            query.append("SELECT res.*, ruse.resource_id FROM ");
            query.append(this.tableName);
            query.append(" AS res ");
            query.append(" INNER JOIN ");
            query.append("number_resource_use_");
            query.append(this.mid);
            query.append(" AS ruse ON ruse.resource_id=res.id   AND (? IS NULL OR  ?>=ruse.date2)  AND (? IS NULL OR ?<=ruse.date_reserve)");
            query.append(" AND number='");
            query.append(number);
            query.append("'");
            query.append(" ORDER BY number");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            Date date1 = TimeUtils.convertDateToSqlDate((java.util.Date)dateFrom);
            Date date2 = TimeUtils.convertDateToSqlDate((java.util.Date)dateTo);
            int index = 1;
            ps.setDate(index++, date2);
            ps.setDate(index++, date2);
            ps.setDate(index++, date1);
            ps.setDate(index++, date1);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                if (result.length() != 0) {
                    result.append("; ");
                }
                result.append(rs.getString("number"));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }
}

