/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn.detail;

import bitel.billing.server.load.bean.Source;
import bitel.billing.server.load.bean.SourceManager;
import bitel.billing.server.netflow.ipn.detail.DialUpRowSelector;
import bitel.billing.server.netflow.ipn.detail.FlowDetailMaker;
import bitel.billing.server.netflow.ipn.detail.IPNRowSelector;
import bitel.billing.server.netflow.ipn.detail.RowSelector;
import bitel.billing.server.netflow.ipn.detail.TrafficAnalizeReport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.datalog.FlowReader;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.kernel.network.flow.FlowSelector;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class MonthFlowDetailMaker
extends FlowDetailMaker {
    private static final Logger logger = LogManager.getLogger();

    @Override
    public void createDetail(DefaultServerSetup setup, Connection con, DetailCreateTask task) throws Exception {
        String[] fileList;
        logger.info("Create part of mount detail...");
        RowSelector selector = task.getModule() == 1 ? new DialUpRowSelector(task, (ParameterMap)setup) : new IPNRowSelector(task);
        long startTime = System.currentTimeMillis();
        StringBuilder messageBody = this.getMessageBody(task);
        StringBuilder fileName = new StringBuilder();
        String folderName = setup.get("ipn.collector.detail.folder", null);
        if (Utils.isEmptyString((String)folderName)) {
            this.sendAlarm("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u0434\u043b\u044f \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", fileName.toString());
            return;
        }
        File folder = new File(folderName);
        if (!folder.exists()) {
            this.sendAlarm("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u0434\u043b\u044f \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", fileName.toString());
            return;
        }
        if (Utils.isBlankString((String)task.getFileName())) {
            this.sendAlarm("\u041f\u0443\u0441\u0442\u043e\u0435 \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 \u0434\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438", "");
            return;
        }
        fileName.append(folderName);
        fileName.append(File.separator);
        fileName.append(task.getFileName());
        folder = new File(fileName.toString());
        if (!folder.exists() && !folder.mkdir()) {
            this.sendAlarm("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438", fileName.toString());
            return;
        }
        StringBuilder tempFileName = new StringBuilder();
        tempFileName.append(fileName.toString());
        tempFileName.append(File.separator);
        tempFileName.append("temp.tmp");
        File file = new File(tempFileName.toString());
        file.delete();
        logger.debug("Create_temp file => " + tempFileName.toString());
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tempFileName.toString())));
        TrafficAnalizeReport trafficReport = new TrafficAnalizeReport();
        out.write("\u0412\u0440\u0435\u043c\u044f;\u0421 \u0430\u0434\u0440\u0435\u0441\u0430;\u0421 \u043f\u043e\u0440\u0442\u0430;\u041d\u0430 \u0430\u0434\u0440\u0435\u0441;\u041d\u0430 \u043f\u043e\u0440\u0442;\u0411\u0430\u0439\u0442;\u0421 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430;\u041d\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\n".getBytes("UTF-8"));
        for (Calendar hour : selector.getLogHours()) {
            FlowReader reader;
            Source source = new SourceManager(con).getSource(task.getSourceId());
            IPHourlyDataLog dataLog = new IPHourlyDataLog((ParameterMap)setup, source.getId(), hour);
            long hourMillis = dataLog.getHourInMillis();
            while ((reader = (FlowReader)dataLog.nextReader(null, false)) != null) {
                FlowArray f;
                while ((f = reader.readChunk()) != null) {
                    int size = f.size;
                    for (int i = 0; i < size; ++i) {
                        Data flow = f.array[i];
                        FlowSelector.Result result = selector.test(hourMillis, flow);
                        if (!result.isClientRecord) continue;
                        out.write(TimeUtils.format((Date)new Date(flow.getMilliseconds()), (String)"dd.MM.yyyy HH:mm:ss").getBytes("UTF-8"));
                        out.write(";".getBytes("UTF-8"));
                        out.write(String.valueOf(flow.getSrcIpAddress()).getBytes("UTF-8"));
                        out.write(";".getBytes("UTF-8"));
                        out.write(String.valueOf(flow.getSrcPort()).getBytes("UTF-8"));
                        out.write(";".getBytes("UTF-8"));
                        out.write(String.valueOf(flow.getDstIpAddress()).getBytes("UTF-8"));
                        out.write(";".getBytes("UTF-8"));
                        out.write(String.valueOf(flow.getDstPort()).getBytes("UTF-8"));
                        out.write(";".getBytes("UTF-8"));
                        out.write(String.valueOf(flow.getOctets()).getBytes("UTF-8"));
                        out.write(";".getBytes("UTF-8"));
                        out.write(String.valueOf(flow.getInputInterface()).getBytes("UTF-8"));
                        out.write(";".getBytes("UTF-8"));
                        out.write(String.valueOf(flow.getOutputInterface()).getBytes("UTF-8"));
                        out.write("\n".getBytes("UTF-8"));
                        if (result.direction == 1) {
                            trafficReport.addFromHost(flow.getSrcAddress(), flow.getOctets());
                            continue;
                        }
                        trafficReport.addToHost(flow.getDstAddress(), flow.getOctets());
                    }
                }
            }
        }
        trafficReport.addAnalize(messageBody);
        long createEndTime = System.currentTimeMillis();
        logger.info("file writing by " + (createEndTime - startTime));
        out.flush();
        out.close();
        fileName.append(File.separator);
        fileName.append(selector.getFileName());
        fileName.append(".tmp");
        logger.debug("Create_detail file => " + fileName.toString());
        out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName.toString())));
        out.write(messageBody.toString().getBytes("UTF-8"));
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(tempFileName.toString())));
        int bufSize = 2048;
        byte[] buf = new byte[2048];
        int len = 0;
        while ((len = in.read(buf)) != -1) {
            out.write(buf, 0, len);
        }
        in.close();
        out.flush();
        out.close();
        logger.debug("Rename_detail file to txt");
        File from = new File(fileName.toString());
        fileName.replace(fileName.length() - 4, fileName.length(), "_" + task.getSourceId() + ".txt");
        File to = new File(fileName.toString());
        if (to.exists()) {
            to.delete();
        }
        if (!from.renameTo(to)) {
            this.sendAlarm("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430", from.toString() + " \u0432 " + to.toString());
        }
        if ((fileList = folder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.substring(name.length() - 3).equals("txt");
            }
        })).length == task.getCount()) {
            logger.info("Start create zip file => " + folderName + "/" + task.getFileName() + ".zip");
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(folderName + File.separator + task.getFileName() + ".zip")));
            for (String fName : fileList) {
                logger.debug("Read file =>" + folderName + "/" + task.getFileName() + "/" + fName);
                zos.putNextEntry(new ZipEntry(fName));
                FileInputStream inStream = new FileInputStream(folderName + File.separator + task.getFileName() + File.separator + fName);
                byte[] b = new byte[1000000];
                len = -1;
                while ((len = inStream.read(b)) != -1) {
                    zos.write(b, 0, len);
                }
                zos.closeEntry();
                inStream.close();
            }
            zos.flush();
            zos.close();
            for (String fName : fileList) {
                file = new File(folder.getAbsolutePath() + File.separator + fName);
                if (file.delete()) continue;
                this.sendAlarm("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430", file.getAbsolutePath());
            }
            file = new File(tempFileName.toString());
            file.delete();
            file = new File(folder.getAbsolutePath());
            if (!file.delete()) {
                this.sendAlarm("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0444\u0430\u0439\u043b\u0430", file.getAbsolutePath());
            }
        }
    }

    @Override
    protected void sendDetailImpl(DefaultServerSetup setup, Connection con, DetailCreateTask task, RowSelector selector, Iterable<IPHourlyDataLog> logs, StringBuilder messageBody, String subject) throws Exception {
        throw new UnsupportedOperationException();
    }
}

