/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client.contract;

import bitel.billing.module.admin.DialogContractAndDateSelect;
import bitel.billing.module.admin.DialogContractSelect;
import bitel.billing.module.admin.DialogEditPeriod;
import bitel.billing.module.common.CalendarDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.util.MACParser;
import ru.bitel.bgbilling.modules.inet.client.InetDevicePanel;
import ru.bitel.bgbilling.modules.inet.client.contract.InetServForm;
import ru.bitel.bgbilling.modules.inet.common.bean.InetDevice;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.enums.InetServState;
import ru.bitel.bgbilling.modules.inet.common.service.InetDeviceService;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.oss.systems.inventory.resource.common.DeviceManagerMethodType;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod;

public class InetServPanel
extends BGUPanel {
    private BGUTreeTable table;
    private PopupMenuListener popupMenuListener;
    private InetDeviceService wsDeviceService;
    private int oldMenuDeviceId = Integer.MIN_VALUE;
    private int oldMenuDeviceTypeId = Integer.MIN_VALUE;
    private List<JMenuItem> oldMenuItemList = new ArrayList<JMenuItem>();
    private JSeparator menuSeparator = new JSeparator();
    protected InetServTreeTableModel model = new InetServTreeTableModel();
    AbstractBGUPanel.MenuAction deviceStateEnable = new AbstractBGUPanel.MenuAction("inetServ.deviceState.enable", "\u0412\u043a\u043b\u044e\u0447\u0438\u0442\u044c (\u043e\u0442\u043b\u0430\u0434\u043a\u0430)"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0414\u0430\u043d\u043d\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u043e\u0431\u044b\u0447\u043d\u043e\u0439 \u0440\u0430\u0431\u043e\u0442\u0435.\n\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441 \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0435?", "\u0412\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435", 0) != 0) {
                return;
            }
            List inetServList = InetServPanel.this.model.getSelectedRows();
            for (InetServ inetServ : inetServList) {
                if (inetServ.getParentId() > 0) continue;
                ((InetServService)((ClientContext)InetServPanel.this.getContext()).getWebService(InetServService.class)).inetServStateModify(inetServ.getId(), InetServState.STATE_ENABLE.getCode(), -2);
            }
        }
    };
    AbstractBGUPanel.MenuAction deviceStateDisable = new AbstractBGUPanel.MenuAction("inetServ.deviceState.disable", "\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c (\u043e\u0442\u043b\u0430\u0434\u043a\u0430)"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0414\u0430\u043d\u043d\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u043e\u0431\u044b\u0447\u043d\u043e\u0439 \u0440\u0430\u0431\u043e\u0442\u0435.\n\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441 \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0435?", "\u041e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435", 0) != 0) {
                return;
            }
            List inetServList = InetServPanel.this.model.getSelectedRows();
            for (InetServ inetServ : inetServList) {
                if (inetServ.getParentId() > 0) continue;
                ((InetServService)((ClientContext)InetServPanel.this.getContext()).getWebService(InetServService.class)).inetServStateModify(inetServ.getId(), InetServState.STATE_DISABLE.getCode(), -2);
            }
        }
    };
    AbstractBGUPanel.MenuAction servDeviceSync = new AbstractBGUPanel.MenuAction("inetServ.device.sync", "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c (\u043e\u0442\u043b\u0430\u0434\u043a\u0430)"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441 \u043d\u0430 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0435?", "\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f", 0) != 0) {
                return;
            }
            List inetServList = InetServPanel.this.model.getSelectedRows();
            for (InetServ inetServ : inetServList) {
                if (inetServ.getParentId() > 0) continue;
                ((InetServService)((ClientContext)InetServPanel.this.getContext()).getWebService(InetServService.class)).inetServSaReinit(inetServ.getId());
            }
        }
    };
    AbstractBGUPanel.MenuAction servDeviceChange = new AbstractBGUPanel.MenuAction("inetServ.device.change", "\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ClientContext context = (ClientContext)InetServPanel.this.getContext();
            DialogContractSelect contractSelect = new DialogContractSelect(true, true, context.getContractId());
            contractSelect.setTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430");
            if (contractSelect.showDialog() == "ok") {
                String cidTo = contractSelect.getSingleId();
                if (Utils.isBlankString((String)cidTo)) {
                    JOptionPane.showMessageDialog(null, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    return;
                }
                InetServPanel.this.moveServices(cidTo);
            }
            contractSelect.dispose();
        }
    };
    AbstractBGUPanel.MenuAction servDeviceChangeDate = new AbstractBGUPanel.MenuAction("inetServ.device.changeDate", "\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 c \u0434\u0430\u0442\u044b"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            ClientContext context = (ClientContext)InetServPanel.this.getContext();
            DialogContractAndDateSelect contractSelect = new DialogContractAndDateSelect(context.getContractId());
            contractSelect.setTitle("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0438 \u0434\u0430\u0442\u0443 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u043d\u043e\u0441\u0430");
            if (contractSelect.showDialog() == "ok") {
                String toContractId = contractSelect.getSingleId();
                Date date = contractSelect.getDate();
                if (Utils.isBlankString((String)toContractId)) {
                    JOptionPane.showMessageDialog(null, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    return;
                }
                if (date == null) {
                    JOptionPane.showMessageDialog(null, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u0434\u0430\u0442\u0430", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    return;
                }
                InetServPanel.this.wrapServices(date, toContractId);
            }
            contractSelect.dispose();
        }
    };
    AbstractBGUPanel.MenuAction servDeleteForce = new AbstractBGUPanel.MenuAction("inetServ.deleteForce", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c (\u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e)"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            InetServ current = (InetServ)InetServPanel.this.model.getSelectedRow();
            if (current == null || current.getId() == 0) {
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0414\u0430\u043d\u043d\u043e\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u043e\u0431\u044b\u0447\u043d\u043e\u0439 \u0440\u0430\u0431\u043e\u0442\u0435.\n\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0440\u0438\u043d\u0443\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                ((InetServService)((ClientContext)InetServPanel.this.getContext()).getWebService(InetServService.class)).inetServDelete(current.getId(), true);
                InetServPanel.this.performAction("refresh");
            }
        }
    };
    AbstractBGUPanel.MenuAction servCopyDate = new AbstractBGUPanel.MenuAction("inetServ.copyFromDate", "\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441 \u0434\u0430\u0442\u044b"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            InetServ oldServ = (InetServ)InetServPanel.this.model.getSelectedRow();
            if (oldServ == null || oldServ.getId() == 0) {
                return;
            }
            CalendarDialog calendar = new CalendarDialog();
            calendar.setCalendar(Calendar.getInstance());
            calendar.setModal(true);
            if (calendar.showDialog().equals("ok")) {
                Calendar selectedDate = calendar.getCalendar();
                if (selectedDate == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443, \u043d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 \u0441\u0435\u0433\u043e\u0434\u043d\u044f\u0448\u043d\u0435\u0433\u043e \u0434\u043d\u044f!");
                    return;
                }
                Calendar now = TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)Calendar.getInstance());
                if (selectedDate.compareTo(now) < 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443, \u043d\u0430\u0447\u0438\u043d\u0430\u044f \u0441 \u0441\u0435\u0433\u043e\u0434\u043d\u044f\u0448\u043d\u0435\u0433\u043e \u0434\u043d\u044f!");
                    return;
                }
                if (oldServ.getDateFrom().compareTo(selectedDate.getTime()) >= 0) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u0430\u044f \u0434\u0430\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043f\u043e\u0441\u043b\u0435 \u0434\u0430\u0442\u044b \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043a\u043e\u043f\u0438\u0440\u0443\u0435\u043c\u043e\u0433\u043e \u0441\u0435\u0440\u0432\u0438\u0441\u0430!");
                    return;
                }
                List options = ((InetServService)((ClientContext)InetServPanel.this.getContext()).getWebService(InetServService.class)).inetServOptionList(oldServ.getId());
                Calendar cal = (Calendar)selectedDate.clone();
                cal.add(5, -1);
                oldServ.setDateTo(cal.getTime());
                ((InetServService)((ClientContext)InetServPanel.this.getContext()).getWebService(InetServService.class)).inetServUpdate(oldServ, options, false, false, 0L);
                InetServ newServ = oldServ.clone();
                newServ.setId(-1);
                newServ.setDateFrom(selectedDate.getTime());
                newServ.setDateTo(null);
                ((InetServService)((ClientContext)InetServPanel.this.getContext()).getWebService(InetServService.class)).inetServUpdate(newServ, options, false, false, 0L);
                InetServPanel.this.performAction("refresh");
            }
        }
    };

    public InetServPanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void jbInit() {
        this.table = new BGUTreeTable((BGTreeTableModel)this.model);
        this.table.setName("inetServ");
        BGEditor editor = new BGEditor("table");
        editor.addForm(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)this.table)), (Object)"table");
        editor.addForm((JComponent)((Object)new InetServForm(this)));
        editor.addPropertyChangeListener(e -> {
            if ("edit".equals(e.getPropertyName()) && !((Boolean)e.getNewValue()).booleanValue()) {
                this.performAction("refresh");
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)editor, "Center");
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)editor);
        JPopupMenu popupMenu = this.table.getComponentPopupMenu();
        if (popupMenu == null) {
            popupMenu = new JPopupMenu();
            this.table.setComponentPopupMenu(popupMenu);
        }
        JPopupMenu popupMenu_ = popupMenu;
        SwingUtilities.invokeLater(() -> {
            Action[] actions = new Action[]{this.deviceStateEnable, this.deviceStateDisable, this.servDeviceSync, this.servDeleteForce};
            Set actionSet = Stream.of(actions).collect(Collectors.toSet());
            Stream.of(popupMenu_.getComponents()).filter(a -> a instanceof JMenuItem && actionSet.contains(((JMenuItem)a).getAction())).forEach(a -> popupMenu_.remove((Component)a));
            JMenu debug = new JMenu("\u041e\u0442\u043b\u0430\u0434\u043a\u0430");
            Stream.of(actions).forEach(a -> debug.add((Action)a));
            popupMenu_.add(debug);
        });
    }

    private InetDeviceService getInetDeviceService() {
        if (this.wsDeviceService == null) {
            this.wsDeviceService = (InetDeviceService)((ClientContext)this.getContext()).getPort(InetDeviceService.class);
        }
        return this.wsDeviceService;
    }

    public InetServService getInetServService() {
        return (InetServService)((ClientContext)this.getContext()).getWebService(InetServService.class);
    }

    protected void shownNotify() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent((Component)((Object)this));
        final JPopupMenu popupMenu = this.table.getComponentPopupMenu();
        if (popupMenu != null && this.popupMenuListener == null) {
            final JMenuItem editDateItem = new JMenuItem("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0430\u0442\u0443");
            editDateItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List selectedAccounts = InetServPanel.this.model.getSelectedRows();
                    if (selectedAccounts == null || selectedAccounts.size() == 0) {
                        ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0438\u0441 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                        return;
                    }
                    InetServPanel.this.changeDateSelectedAccounts(selectedAccounts);
                }
            });
            final JMenuItem deleteItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
            deleteItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        InetServPanel.this.deleteAccount();
                    }
                    catch (BGException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.popupMenuListener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    popupMenu.add(editDateItem);
                    popupMenu.add(deleteItem);
                    InetServPanel.this.updateDeviceManagerMethodList(popupMenu);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
            popupMenu.addPopupMenuListener(this.popupMenuListener);
        }
    }

    private void changeDateSelectedAccounts(List<InetServ> selectedAccounts) {
        DialogEditPeriod dialogEditDate = new DialogEditPeriod();
        dialogEditDate.btnOk.addActionListener(e -> {
            Date dateTo;
            Date dateFrom = dialogEditDate.fromDate.getDate();
            if (dateFrom.after(dateTo = dialogEditDate.toDate.getDate())) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0440\u0430\u043d\u044c\u0448\u0435 \u0434\u0430\u0442\u044b \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f");
                return;
            }
            for (InetServ serv : selectedAccounts) {
                serv.setDateFrom(dateFrom);
                if (dateTo != null) {
                    serv.setDateTo(dateTo);
                }
                try {
                    ((InetServService)((ClientContext)this.getContext()).getWebService(InetServService.class)).inetServUpdate(serv, new ArrayList(), false, false, 0L);
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((String)ex.getMessage());
                }
            }
            dialogEditDate.dispose();
            this.performAction("refresh");
        });
    }

    private void deleteAccount() throws BGException {
        List selectedServ = this.model.getSelectedRows();
        if (selectedServ == null || selectedServ.size() == 0) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0435\u0440\u0432\u0438\u0441 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0435\u0440\u0432\u0438\u0441?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u0430", 0) == 0) {
            for (InetServ serv : selectedServ) {
                ((InetServService)((ClientContext)this.getContext()).getWebService(InetServService.class)).inetServDelete(serv.getId(), false);
            }
            this.performAction("refresh");
        }
    }

    private void updateDeviceManagerMethodList(JPopupMenu popupMenu) {
        InetServ serv = (InetServ)this.model.getSelectedRow();
        if (serv != null && serv.getDeviceId() == this.oldMenuDeviceId) {
            return;
        }
        try {
            InetDevice menuDevice;
            InetDevice inetDevice = menuDevice = serv != null ? this.getInetDeviceService().inetDeviceGet(serv.getDeviceId()) : null;
            if (menuDevice != null && menuDevice.getDeviceTypeId() == this.oldMenuDeviceTypeId) {
                return;
            }
            for (JMenuItem m : this.oldMenuItemList) {
                popupMenu.remove(m);
            }
            popupMenu.remove(this.menuSeparator);
            this.oldMenuItemList.clear();
            if (menuDevice == null) {
                this.oldMenuDeviceId = Integer.MIN_VALUE;
                this.oldMenuDeviceTypeId = Integer.MIN_VALUE;
                return;
            }
            this.oldMenuDeviceId = serv.getDeviceId();
            this.oldMenuDeviceTypeId = menuDevice.getDeviceTypeId();
            List methodList = this.getInetDeviceService().deviceManagerMethodList(menuDevice.getDeviceTypeId());
            if (methodList.size() > 0) {
                popupMenu.add(this.menuSeparator);
            }
            for (final DeviceManagerMethod deviceManagerMethod : methodList) {
                if (!deviceManagerMethod.getTypes().contains(DeviceManagerMethodType.ACCOUNT)) continue;
                AbstractBGUPanel.DefaultAction action = new AbstractBGUPanel.DefaultAction("command." + deviceManagerMethod.getMethod(), deviceManagerMethod.getTitle(), ClientUtils.getIcon((String)"fugue/terminal-network")){

                    public void actionPerformedImpl(ActionEvent e) throws Exception {
                        try {
                            InetDevicePanel.executeCommand((ClientContext)InetServPanel.this.getContext(), menuDevice.getInvDeviceId(), menuDevice.getId(), deviceManagerMethod.getMethod(), ((InetServ)InetServPanel.this.model.getSelectedRow()).getId(), 0);
                        }
                        catch (BGException ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                };
                JMenuItem menu = new JMenuItem((Action)action);
                popupMenu.add(menu);
                this.oldMenuItemList.add(menu);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void wrapServices(Date openDate, String cidTo) throws BGException {
        List inetServList = this.model.getSelectedRows();
        for (InetServ inetServ : inetServList) {
            ((InetServService)((ClientContext)this.getContext()).getWebService(InetServService.class)).inetServWrap(inetServ, Utils.parseInt((String)cidTo), openDate);
        }
        this.performAction("refresh");
    }

    private void moveServices(String cidTo) throws BGException {
        List inetServList = this.model.getSelectedRows();
        for (InetServ inetServ : inetServList) {
            ((InetServService)((ClientContext)this.getContext()).getWebService(InetServService.class)).inetServMove(inetServ, Utils.parseInt((String)cidTo));
        }
        this.performAction("refresh");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            InetServ root = ((InetServService)((ClientContext)this.getContext()).getWebService(InetServService.class)).inetServTree(((ClientContext)this.getContext()).getContractId());
            if (root == null) {
                return;
            }
            if (((ClientContext)this.getContext()).getObjectId() > 0 && root.getChildren() != null) {
                Iterator iter = root.getChildren().iterator();
                while (iter.hasNext()) {
                    InetServ s = (InetServ)iter.next();
                    if (s.getContractObjectId() == ((ClientContext)this.getContext()).getObjectId()) continue;
                    iter.remove();
                }
            }
            this.model.setData(root);
            this.table.addNotify();
            this.table.expand();
        });
    }

    class InetServTreeTableModel
    extends BGTreeTableModel<InetServ> {
        Icon folder2;
        Icon folder;
        Icon leaf;

        InetServTreeTableModel() {
            super(InetServTreeTableModel.class.getName());
            this.folder2 = ClientUtils.getIcon((String)"fugue/home-network");
            this.folder = ClientUtils.getIcon((String)"fugue/network-ethernet");
            this.leaf = ClientUtils.getIcon((String)"fugue/computer-network");
        }

        public Icon getIcon(InetServ value) {
            if (value == this.root) {
                return this.folder2;
            }
            if (value.getParentId() > 0) {
                return this.leaf;
            }
            return this.folder;
        }

        protected void initColumns() {
            this.addColumn("\u0421\u0435\u0440\u0432\u0438\u0441", InetServ.class, 120, 140, -1, null, false);
            this.addColumn("\u0422\u0438\u043f", 80, 100, -1, "typeTitle", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", 160, 200, -1, "deviceTitle", false);
            this.addColumn("\u0418\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441", 60, 100, -1, "interfaceTitle", false, false);
            this.addColumn("VLAN", 30, 50, -1, null, false, false);
            this.addColumn("\u041b\u043e\u0433\u0438\u043d", 40, 60, -1, "login", false, false);
            this.addColumn("IP-\u0430\u0434\u0440\u0435\u0441", 80, 120, -1, null, false, false);
            this.addColumn("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440", 60, 100, -1, null, false, false);
            this.addColumn("MAC-\u0430\u0434\u0440\u0435\u0441", 80, 100, -1, null, false, false);
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 140, 150, 180, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 60, 80, 100, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", 60, 80, -1, null, false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 80, 160, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }

        public Object getValue(InetServ val, int column) throws BGException {
            if (val == this.root && column != 0) {
                return "";
            }
            switch (column) {
                case 0: {
                    return val;
                }
                case 2: {
                    if (val.getParentId() <= 0) {
                        return super.getValue((Object)val, column);
                    }
                    return "";
                }
                case 4: {
                    return val.getVlan() != -1 ? String.valueOf(val.getVlan()) : "";
                }
                case 6: {
                    String to;
                    String from = val.getAddressFrom() != null ? IpAddress.toString((byte[])val.getAddressFrom()) : null;
                    String string = to = val.getAddressTo() != null ? IpAddress.toString((byte[])val.getAddressTo()) : null;
                    if (from == null && to == null) {
                        return "";
                    }
                    if (to == null || to.equals(from)) {
                        return from;
                    }
                    return from + "-" + to;
                }
                case 7: {
                    return Utils.toString((Iterable)val.getIdentifierList(), (String)", ");
                }
                case 8: {
                    List macs = val.getMacAddressList();
                    return macs == null ? "" : Utils.toString((Iterable)macs.stream().map(f -> MACParser.macAddressToString((byte[])f)).collect(Collectors.toList()), (String)", ");
                }
                case 9: {
                    return TimeUtils.formatPeriod((Date)val.getDateFrom(), (Date)val.getDateTo());
                }
                case 10: {
                    if (val.getParentId() > 0) {
                        return "";
                    }
                    return Optional.ofNullable(val.getStatus()).map(s -> s.getTitle()).orElse("---");
                }
                case 11: {
                    if (val.getParentId() > 0) {
                        return "";
                    }
                    switch (InetServState.getInetServState((int)val.getDeviceState())) {
                        case STATE_DELETED: {
                            return "\u0443\u0434\u0430\u043b\u0435\u043d";
                        }
                        case STATE_ENABLE: {
                            return "\u0432\u043a\u043b\u044e\u0447\u0435\u043d";
                        }
                        case STATE_DISABLE: {
                            String accessCodeTitle = val.getAccessCodeTitle();
                            return "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d" + (String)(accessCodeTitle != null ? " [" + accessCodeTitle + "]" : "");
                        }
                    }
                    return "---";
                }
            }
            return super.getValue((Object)val, column);
        }

        public Object getValueAt(int rowIndex, int column) {
            try {
                InetServ parent;
                TreePath treePath = this.getTree().getPathForRow(rowIndex);
                TreePath parentPath = treePath.getParentPath();
                InetServ val = (InetServ)treePath.getLastPathComponent();
                InetServ inetServ = parent = parentPath != null ? (InetServ)parentPath.getLastPathComponent() : null;
                if (val == this.root && column != 0) {
                    return "";
                }
                switch (column) {
                    case 0: {
                        return val;
                    }
                    case 2: {
                        if (val.getParentId() <= 0 || val.getDeviceId() > 0 && parent != null && parent.getDeviceId() != val.getDeviceId()) {
                            return super.getValue((Object)val, column);
                        }
                        return "";
                    }
                }
                return this.getValue(val, column);
            }
            catch (BGException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

