/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.auth.AuthModes;
import ru.bitel.bgbilling.kernel.auth.ModuleAuth;
import ru.bitel.bgbilling.kernel.auth.ModuleUser;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Utils;

public class ModuleAuthImpl
extends BGLogger
implements ModuleAuth {
    public ModuleUser findModuleUserByLogin(String login, int moduleId, int authMode, Connection con) {
        ModuleUser moduleUser = null;
        if (authMode == 1) {
            if (Utils.notBlankString((String)login) && moduleId > -1) {
                String query = "SELECT contract.id, contract.title, login.password FROM inet_serv_" + moduleId + " AS login INNER JOIN contract ON login.contractId=contract.id WHERE (login.dateFrom IS NULL OR login.dateFrom<=CURDATE() ) AND (login.dateTo IS NULL OR login.dateTo>=CURDATE() ) AND login.login=? LIMIT 1";
                try (PreparedStatement ps = con.prepareStatement(query);){
                    ps.setString(1, login);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            moduleUser = ModuleUser.builder().setContractId(rs.getInt(1)).setContractTitle(rs.getString(2)).setPassword(rs.getString(3)).build();
                        }
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            } else if (authMode == 2) {
                PreparedStatement ps;
                int servId = 0;
                String query = "SELECT servId FROM inet_connection_" + moduleId + " WHERE ipAddress=?";
                try {
                    ps = con.prepareStatement(query);
                    try {
                        byte[] ipAddress = InetAddress.getByName(login).getAddress();
                        ps.setBytes(1, ipAddress);
                        try (ResultSet rs = ps.executeQuery();){
                            while (rs.next()) {
                                if (servId > 0) {
                                    throw new BGException("Dublicate session for IP = " + login);
                                }
                                servId = rs.getInt(1);
                            }
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
                if (servId > 0) {
                    query = "SELECT contract.id, contract.title FROM inet_serv_" + moduleId + " AS serv INNER JOIN contract ON serv.contractId=contract.id WHERE serv.id=?";
                    try {
                        ps = con.prepareStatement(query);
                        try {
                            ps.setInt(1, servId);
                            try (ResultSet rs = ps.executeQuery();){
                                if (rs.next()) {
                                    moduleUser = ModuleUser.builder().setContractId(rs.getInt(1)).setContractTitle(rs.getString(2)).setPassword(AuthModes.passwordless()).build();
                                }
                            }
                        }
                        finally {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.logError(ex);
                    }
                }
            }
        }
        return moduleUser;
    }
}

