/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.action.apps;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.io.FilenameUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.filestorage.common.bean.BGServerFile;
import ru.bitel.bgbilling.modules.mobile.server.bean.ActionContext;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.server.action.apps.ActionAbstract;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.HelpdeskFileStorage;
import ru.bitel.bgbilling.plugins.helpdesk.server.filestorage.PreviewFileStorage;
import ru.bitel.common.Utils;
import ru.bitel.common.io.Base64;
import ru.bitel.common.util.FileDownload;
import ru.bitel.common.worker.ThreadContext;

public class ActionFileDownload
extends ActionAbstract {
    public void execute() throws BGException {
        int fileId = this.getIntParameter("id", -1);
        int method = this.getIntParameter("method", 1);
        HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.con);
        if (method == 1) {
            try (FileInputStream is = fileStorage.load(fileId);){
                this.actionMap.put("file", Base64.encode((InputStream)is));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            try (FileInputStream is = fileStorage.load(fileId);){
                this.toRequest(is, this.checkFile(fileStorage, fileId).getTitle());
            }
            catch (FileNotFoundException e) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (2).\n" + e.getLocalizedMessage());
            }
            catch (IOException e) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 OutputStream.\n" + e.getLocalizedMessage());
            }
        }
    }

    public void fileIsExist() throws BGException {
        int fileId = this.getIntParameter("id", -1);
        if (fileId > 0) {
            HelpdeskFileStorage fileStorage = new HelpdeskFileStorage(this.con);
            this.checkFile(fileStorage, fileId);
            File file = new File(fileStorage.getFileName(fileId));
            if (file.exists()) {
                this.actionMap.put("fileExist", true);
            }
        }
    }

    public void getPreviewImage() throws BGException, IOException {
        int fileId = this.getIntParameter("id", -1);
        HelpdeskFileStorage helpdeskFileStorage = new HelpdeskFileStorage(this.con);
        PreviewFileStorage previewStoreg = new PreviewFileStorage(this.con);
        BGServerFile bgFile = this.checkFile(helpdeskFileStorage, fileId);
        String ext = FilenameUtils.getExtension((String)bgFile.getTitle());
        File file = new File(previewStoreg.getFileName(fileId));
        if (!file.exists()) {
            int preferredHeight = this.plugin.getSetup().getInt("file.preview.preferred.height", 400);
            try (FileOutputStream outputFile = previewStoreg.save(bgFile.getId());){
                BufferedImage imgBuf = this.scaleImage(helpdeskFileStorage.getFileName(fileId), preferredHeight);
                ImageIO.write((RenderedImage)imgBuf, ext, outputFile);
                imgBuf.flush();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)imgBuf, ext, os);
                ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                os.flush();
                this.toRequest(is, bgFile.getTitle());
                ((InputStream)is).close();
                return;
            }
        }
        try (FileInputStream is = previewStoreg.load(fileId);){
            this.toRequest(is, bgFile.getTitle());
        }
    }

    private void toRequest(InputStream is, String fileTitle) throws IOException {
        ThreadContext cont = ServerContext.get();
        if (cont instanceof ActionContext) {
            ActionContext mobContext = (ActionContext)cont;
            this.dataMap.put("outputStreamWasCalled", "true");
            try (ServletOutputStream out = mobContext.getResponse().getOutputStream();){
                this.request.setAttribute("contentType", (Object)"binary");
                mobContext.getResponse().setContentType("application/octet-stream");
                mobContext.getResponse().setHeader("Content-Disposition", FileDownload.getContentDisposition((HttpServletRequest)this.request, (String)fileTitle, (boolean)false));
                Utils.flush((InputStream)is, (OutputStream)out);
            }
        }
    }

    private BufferedImage scaleImage(String filename, int preferredHeight) {
        BufferedImage bi = null;
        try {
            ImageIcon ii = new ImageIcon(filename);
            int height = ii.getIconHeight();
            int width = ii.getIconWidth();
            if (height > preferredHeight) {
                float scale = ii.getIconHeight() / preferredHeight;
                height = (int)((float)height / scale);
                width = (int)((float)width / scale);
            }
            bi = new BufferedImage(width, height, 1);
            Graphics2D g2d = bi.createGraphics();
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR));
            g2d.drawImage(ii.getImage(), 0, 0, width, height, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return bi;
    }

    private BGServerFile checkFile(HelpdeskFileStorage fileStorage, int fileId) throws BGException {
        BGServerFile serverFile = fileStorage.getFileById(fileId);
        if (serverFile == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u043e\u0438\u0441\u043a\u0430 \u0444\u0430\u0439\u043b\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (1)");
        }
        int fileCid = -1;
        TopicManager topicManager = new TopicManager(this.con, this.plugin);
        Message message = topicManager.getMessage(serverFile.getOwnerId());
        if (message != null) {
            fileCid = topicManager.getTopicOwnerId(message.getTopicId());
        }
        if (fileCid != this.contractId) {
            throw new BGMessageException("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438 OwnerId \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442!");
        }
        return serverFile;
    }
}

