/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.enaza.server.action.web;

import bitel.billing.server.ActionResultContentType;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.enaza.common.bean.EnazaTransaction;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaAccessToken;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaAccessTokenDao;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaBalanceManager;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaException;
import ru.bitel.bgbilling.modules.enaza.server.bean.EnazaTransactionDao;
import ru.bitel.bgbilling.modules.enaza.server.bean.event.GetAttensionEvent;
import ru.bitel.bgbilling.modules.enaza.server.servlet.ModuleExecutor;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ActionEnaza
extends AbstractAction {
    private static Logger logger = LogManager.getLogger();
    private static final String ENCODING = "utf-8";

    public ActionEnaza() {
        super("enaza");
    }

    public void execute() throws BGException {
        int protocolVersion = this.moduleSetup.getInt("enaza.protocol.version", 2);
        if (protocolVersion == 3) {
            try (EnazaAccessTokenDao enazaAccessTokenDao = new EnazaAccessTokenDao(this.con, this.moduleId);){
                EnazaAccessToken enazaAccessToken = enazaAccessTokenDao.getEnazaAccessTokenByContractId(this.contractId);
                if (enazaAccessToken == null) {
                    enazaAccessToken = new EnazaAccessToken();
                    enazaAccessToken.setContractId(this.contractId);
                }
                GregorianCalendar codeExpire = new GregorianCalendar();
                ((Calendar)codeExpire).add(12, this.moduleSetup.getInt("enaza3.code.expire", 5));
                enazaAccessToken.setCode(enazaAccessToken.generate());
                enazaAccessToken.setCodeExpire(codeExpire.getTime());
                enazaAccessTokenDao.update((Object)enazaAccessToken);
                String partnerId = this.moduleSetup.get("enaza3.partner.id", null);
                String userId = String.valueOf(this.contractId);
                this.setResultParam("partner_id", partnerId);
                this.setResultParam("internal_used_id", userId);
                this.setResultParam("partner_hash", Utils.getDigest((String)(partnerId + userId + this.moduleSetup.get("enaza3.password", "123456")), (String)ENCODING, (String)"SHA1").toLowerCase());
                this.setResultParam("usercode", enazaAccessToken.getCode());
            }
        } else {
            String secret = this.moduleSetup.get("enaza.secret", "123456");
            String partnerName = this.moduleSetup.get("enaza.partner.name", null);
            String hash = Utils.getDigest((String)(String.valueOf(this.contractId) + secret), (String)ENCODING, (String)"SHA1").toLowerCase();
            String src = "http://" + partnerName + ".enaza.ru/remotes/antivirus/all/?user_id=" + this.contractId + "&hash=" + hash;
            StringBuilder iframe = new StringBuilder();
            iframe.append("<iframe scrolling=\"auto\" id=\"enaza_iframe\" src=\"");
            iframe.append(Utils.escapeHTML((String)src));
            iframe.append("\"\tstyle=\"border:0; padding:0; margin:0; overflow:auto; height:");
            iframe.append(this.moduleSetup.get("enaza.iframe_height", "770px"));
            iframe.append("; width:");
            iframe.append(this.moduleSetup.get("enaza.iframe_width", "770px"));
            iframe.append("\" frameborder=\"0\"></iframe>");
            this.setResultParam("iframe", iframe.toString());
        }
        super.execute();
    }

    public void confirmation() throws BGException {
        this.setResultParam("contentType", ActionResultContentType.jsp);
        Long orderId = this.req.getLong("orderId", 0L);
        EnazaTransaction transaction = new EnazaTransactionDao(this.con, this.moduleId).get(orderId);
        GetAttensionEvent event = (GetAttensionEvent)EventProcessor.getInstance().request((QueueEvent)new GetAttensionEvent(this.moduleId, this.contractId, this.userId, transaction.getProductType().intValue(), transaction.getAmount()));
        if (event.isLock()) {
            this.setResultParam("lock", "lock");
            if (Utils.isEmptyString((String)event.getAnswer())) {
                this.setResultParam("desc", this.moduleSetup.get("enaza.lock", "\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0440\u0438\u043e\u0431\u0440\u0435\u0441\u0442\u0438 \u0434\u0430\u043d\u043d\u044b\u0439 \u0442\u043e\u0432\u0430\u0440: ${desc}").replaceAll("\\$\\{desc\\}", transaction.getDescription()));
            } else {
                this.setResultParam("desc", event.getAnswer());
            }
        } else if (Utils.isEmptyString((String)event.getAnswer())) {
            this.setResultParam("desc", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 " + Utils.formatBigDecimalSumm((BigDecimal)transaction.getAmount()) + " \u0440\u0443\u0431\u043b\u0435\u0439 \u0441 \u0412\u0430\u0448\u0435\u0433\u043e \u043b\u0438\u0446\u0435\u0432\u043e\u0433\u043e \u0441\u0447\u0435\u0442\u0430 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u043e\u043f\u043b\u0430\u0442\u044b \"" + transaction.getDescription() + "\"");
        } else {
            this.setResultParam("desc", event.getAnswer());
        }
        this.setResultParam("orderId", orderId);
    }

    private void requestAndCheckResponse(EnazaTransaction transaction, ParameterMap moduleSetup) throws IOException, EnazaException {
        URL url = new URL(ModuleExecutor.getEnazaBillingUrl(moduleSetup));
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        con.setDoOutput(true);
        con.setDoInput(true);
        PrintStream ps = new PrintStream(con.getOutputStream(), true);
        String orderId = String.valueOf(transaction.getOrderId());
        this.addParameter(ps, "order_id", orderId, false);
        String amount = Utils.formatBigDecimalSumm((BigDecimal)transaction.getAmount());
        this.addParameter(ps, "amount", amount, false);
        String payNum = String.valueOf(transaction.getChargeId());
        this.addParameter(ps, "pay_num", payNum, false);
        String clientPurse = String.valueOf(transaction.getContractId());
        this.addParameter(ps, "client_purse", clientPurse, false);
        String result = transaction.getStatus() == EnazaTransaction.STATUS_OK ? "0" : "1";
        this.addParameter(ps, "result", result, false);
        this.addParameter(ps, "date", TimeUtils.format((Date)transaction.getDate(), (String)"yyyy-MM-dd HH:mm:ss"), false);
        String valueForHash = orderId + amount + result + payNum + clientPurse + moduleSetup.get("enaza.password", "123456");
        this.addParameter(ps, "hash", Utils.getDigest((String)valueForHash, (String)ENCODING).toLowerCase(), true);
        ps.flush();
        ps.close();
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            InputStream inputStream = con.getInputStream();
            if (inputStream != null) {
                Document doc = XMLUtils.parseDocument((InputSource)new InputSource(inputStream));
                String orderIdElement = XMLUtils.selectText((Node)doc, (String)"/order/order_id/text()");
                String errorElement = XMLUtils.selectText((Node)doc, (String)"/order/error/text()");
                String errorTextElement = XMLUtils.selectText((Node)doc, (String)"/order/error_text/text()");
                if (errorTextElement == null) {
                    errorTextElement = "";
                }
                String hashElement = XMLUtils.selectText((Node)doc, (String)"/order/hash/text()");
                valueForHash = orderIdElement + errorElement + errorTextElement + moduleSetup.get("enaza.password", "123456");
                if (!hashElement.toLowerCase().equals(Utils.getDigest((String)valueForHash, (String)ENCODING).toLowerCase())) {
                    throw new EnazaException("[requestAndCheckResponse] Hashes are not equal!");
                }
            }
        } else {
            throw new EnazaException("[requestAndCheckResponse] HTTP Response code = " + responseCode);
        }
    }

    private void addParameter(PrintStream ps, String key, String value, boolean last) {
        ps.print(key);
        ps.print('=');
        ps.print(value.replaceAll("\\s", "%20"));
        if (!last) {
            ps.print('&');
        }
    }

    public void confirm() throws BGException, SQLException {
        EnazaBalanceManager manager = new EnazaBalanceManager(this.con, this.moduleId);
        Long orderId = this.req.getLong("orderId", 0L);
        EnazaTransaction transaction = manager.checkTransaction(orderId);
        if (transaction == null) {
            throw new BGException("\u0422\u0430\u043a\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        }
        transaction.setContractId(this.contractId);
        try {
            transaction = manager.chargeTransaction2(transaction);
            this.redirect();
        }
        catch (EnazaException ex) {
            logger.info(ex.getMessage());
            throw ex;
        }
        finally {
            try {
                this.requestAndCheckResponse(transaction, (ParameterMap)this.moduleSetup);
            }
            catch (IOException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public void redirect() throws BGException {
        Long orderId = this.req.getLong("orderId", 0L);
        try {
            if (this.moduleSetup.getBoolean("enaza.redirect", true)) {
                this.context.getResponse().sendRedirect(ModuleExecutor.getEnazaRedirectUrl((ParameterMap)this.moduleSetup) + "?order_id=" + orderId);
            } else {
                String src = ModuleExecutor.getEnazaRedirectUrl((ParameterMap)this.moduleSetup) + "?order_id=" + orderId;
                StringBuilder iframe = new StringBuilder();
                iframe.append("<iframe scrolling=\"auto\" id=\"enaza_iframe\" src=\"");
                iframe.append(Utils.escapeHTML((String)src));
                iframe.append("\" style=\"border:0; padding:0; margin:0; overflow:auto; height:");
                iframe.append(this.moduleSetup.get("enaza.iframe_height", "770px"));
                iframe.append("; width:");
                iframe.append(this.moduleSetup.get("enaza.iframe_width", "770px"));
                iframe.append("\" frameborder=\"0\"></iframe>");
                this.setResultParam("iframe", iframe.toString());
            }
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

