package ru.bitel.bgbilling.modules.cashcheck.dyn;

import java.sql.Connection;
import java.util.Set;

import bitel.billing.common.SummaToString;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.CheckMaker;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.Check;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

/**
 * Формат чека для стандартного шаблона ПКО (драйвер fop, шаблон cashcheck_pko.xsl).
 * Скрипт не обрабатывает попытку печати нескольких платежей.
 * Это пример, если вы хотите сделать свой шаблон - создайте рядом другой класс.
 * @author dimon
 */
public class PkoCheckSimple
	extends CheckMaker
{
	private Connection con;
	
	@Override
	public void init( Setup setup, Connection con, Connection conSlave )
		throws BGException
	{
		this.con = con;
	}

	@Override
	public void addPayment( Payment payment, Check check, Printer printer )
		throws BGException
	{
		//1. Сумма платежа: "120,00р." (делаем одну строку addPayment, чтобы в драйвере общая сумма посчиталась)
		check.addPayment( payment.getSumma(), String.valueOf(payment.getSumma()) + "р.", 0 );
		//2. Номер договора
		check.addString( payment.getContractTitle() );
		//3. Фамилия клиента: "ИВАНОВ И.И."
		check.addString( payment.getContractComment() );
		//4. Дата платежа: 20-04-2009
		check.addString( TimeUtils.format( payment.getDate(), "dd-MM-yyyy" ) );
		//5. Организация: ООО "ПРОВАЙДЕР"
		check.addString( "ООО \"ПРОВАЙДЕР\"" );
		//6. ФИО кассира (пользователя биллинга)
		UserManager um = new UserManager( con );   
		User user = um.get( payment.getUserId() );
		check.addString( user.getName() );
		//7. Тип платежа: "СПД  №"
		check.addString( "СПД  №" );
		//8. Сумма прописью: "Сто двадцать рублей 00 коп"
		check.addString( SummaToString.summaToString( String.valueOf(payment.getSumma()), true ) );
	}

	@Override
	public void endCreate( Set<Integer> cids, Check check, Printer printer )
		throws BGException
	{
	}

	@Override
	public void addPaymentRefund( Payment payment, Check check, Printer printer )
		throws BGException
	{
	}

	@Override
	public void endCreateRefund( int cid, Check check, Printer printer )
		throws BGException
	{
	}
}
