/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.DPayment;
import ru.bitel.bgbilling.modules.card.server.bean.DPaymentList;
import ru.bitel.bgbilling.modules.card.server.bean.DPaymentManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class ActionDPaymentList
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        Page page = this.getPage();
        Date from = this.getDateParameter("from");
        Date until = this.getDateParameter("until");
        int type = this.getIntParameter("type", 0);
        int did = this.getIntParameter("did", 0);
        DPaymentManager manager = new DPaymentManager((Preferences)this.moduleSetup, this.con, this.mid);
        DPaymentList paymentList = manager.getDPaymentList(did, from, until, type, page);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (DPayment payment : paymentList.getPaymentList()) {
            Element row = this.createElement(data, "row");
            int status = payment.getPaymentId() != 0 ? 1 : -1;
            row.setAttribute("id", String.valueOf(payment.getId()));
            row.setAttribute("cid", String.valueOf(payment.getContractId()));
            row.setAttribute("trans", payment.getTransId());
            row.setAttribute("summ", Utils.formatCost((BigDecimal)payment.getSumma()));
            row.setAttribute("date", TimeUtils.format((Date)payment.getDateTime(), (String)"dd.MM.yyyy HH.mm.ss"));
            row.setAttribute("comment", payment.getPaymentComment());
            row.setAttribute("contract", payment.getContractTitle());
            row.setAttribute("con_comment", payment.getContractComment());
            row.setAttribute("status", status == 1 ? "\u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d" : "\u043e\u0442\u043c\u0435\u043d\u0435\u043d");
            if (status != 1 && type != 0) continue;
        }
        table.setAttribute("pays", String.valueOf(paymentList.getNumber()));
        table.setAttribute("summa", Utils.formatCost((float)paymentList.getTotal()));
        this.setPageAttribute(table, paymentList.getPage());
    }
}

