/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client.admin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;

public class PeriodAndTimeoutPanel
extends JPanel {
    private DateFormat format = new SimpleDateFormat("dd.MM.yy HH:mm");
    private BGTextField periodStart = new BGTextField(10);
    private BGTextField periodStop = new BGTextField(10);
    private BGTextField timeout = new BGTextField(5);

    public PeriodAndTimeoutPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        BGButton allPeriod = new BGButton("\u0432\u0435\u0441\u044c \u043f\u0435\u0440\u0438\u043e\u0434");
        allPeriod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PeriodAndTimeoutPanel.this.timeout.setText(String.valueOf(PeriodAndTimeoutPanel.this.getAllPeriod()));
            }
        });
        this.periodStart.setInputVerifier((InputVerifier)new PeriodVerifier());
        this.periodStop.setInputVerifier((InputVerifier)new PeriodVerifier());
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("\u043f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.periodStart, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel("-"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.add((Component)this.periodStop, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel("\u043f\u0435\u0440\u0435\u0440\u044b\u0432:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.timeout, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel("\u043c\u0438\u043d."), new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)allPeriod, new GridBagConstraints(7, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)new JLabel("(\u0444\u043e\u0440\u043c\u0430\u0442 \u0432\u0432\u043e\u0434\u0430 - dd.MM.yy HH:mm)"), new GridBagConstraints(8, 0, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 15, 0, 5), 0, 0));
    }

    public void setPeriodStart(Date date) {
        if (date != null) {
            this.periodStart.setText(this.format.format(date));
        } else {
            this.periodStart.setText("");
        }
    }

    public void setPeriodStop(Date date) {
        if (date != null) {
            this.periodStop.setText(this.format.format(date));
        } else {
            this.periodStop.setText("");
        }
    }

    public void setTimeout(String data) {
        this.timeout.setText(data);
    }

    public Date getPeriodStart() {
        return this.getDate(this.periodStart.getText());
    }

    public Date getPeriodStop() {
        return this.getDate(this.periodStop.getText());
    }

    private Date getDate(String dateString) {
        Date date = null;
        try {
            date = this.format.parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public String getTimeout() {
        return this.timeout.getText();
    }

    private int getAllPeriod() {
        int timeout = 0;
        try {
            Date start = this.format.parse(this.periodStart.getText());
            Date stop = this.format.parse(this.periodStop.getText());
            timeout = (int)((stop.getTime() - start.getTime()) / 1000L) / 60;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeout;
    }

    class PeriodVerifier
    extends InputVerifier {
        PeriodVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            boolean result = true;
            JTextField field = (JTextField)input;
            String data = field.getText();
            if (data != null && !data.isEmpty()) {
                try {
                    PeriodAndTimeoutPanel.this.format.parse(field.getText());
                }
                catch (Exception e) {
                    result = false;
                }
            }
            return result;
        }
    }
}

