/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.cdr.voice;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.DynamicClass;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.events.VoiceLogProcessedEvent;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadFiles;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadToFTP;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.CDRItem;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.voice.CDRFieldMapper;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.voice.VoiceCDRUpload;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class VoiceCDRUploadImplementation
implements EventListener<VoiceLogProcessedEvent> {
    private static final Logger log = LogManager.getLogger();
    private final int sormModuleId;

    public VoiceCDRUploadImplementation(int sormModuleId) {
        this.sormModuleId = sormModuleId;
    }

    public void notify(VoiceLogProcessedEvent voiceLogProcessedEvent, EventListenerContext ctx) throws BGException {
        log.debug("VoiceLogProcessedEvent notify");
        Connection connection = ctx.getConnection();
        String tableName = ServerUtils.getModuleTableName((String)"sorm_voice_cdr_log", (int)voiceLogProcessedEvent.getModuleId());
        if (voiceLogProcessedEvent.getLineCount() <= 0) {
            return;
        }
        if (!ServerUtils.tableExists((Connection)connection, (String)tableName)) {
            log.error("\u0422\u0430\u0431\u043b\u0438\u0446\u0430 {} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", (Object)tableName);
            return;
        }
        log.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u043e\u0432\u044b\u0445 CDR \u0437\u0430\u043f\u0438\u0441\u0435\u0439. \u0417\u0430\u043f\u0438\u0441\u0435\u0439={}", (Object)voiceLogProcessedEvent.getLineCount());
        SormProject sormProject = this.getSormProject(voiceLogProcessedEvent.getModuleId());
        if (sormProject == null) {
            log.error("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0435\u043a\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e: \n-\u043d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 \u043f\u0440\u043e\u0435\u043a\u0442\u043e\u0432\n\u043c\u043e\u0434\u0443\u043b\u044c Voice \u0441 ID={} \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0432 \u043f\u0440\u043e\u0435\u043a\u0442\u0430", (Object)voiceLogProcessedEvent.getModuleId());
            return;
        }
        Preferences config = sormProject.getLoadedConfig();
        List<String[]> cdrLineFields = this.getCdrLineFields(this.getNewCDRLines(connection, tableName, voiceLogProcessedEvent.getVoiceDeviceId()), this.defineRegex(config));
        List<CDRItem> cdrItems = this.convertFieldListToCDRItems(config, cdrLineFields, voiceLogProcessedEvent.getVoiceDeviceId());
        log.debug("\u0421\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u044b \u043b\u043e\u0433\u0438 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: cdrLineFields size={}, cdrItems size={}", (Object)cdrLineFields.size(), (Object)cdrItems.size());
        VoiceCDRUpload voiceCDRUpload = this.defineCDRUploadImplementation(sormProject, config, voiceLogProcessedEvent.getNumberConverters());
        log.debug("VoiceCDRUpload \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043a\u0430\u043a = {}", voiceCDRUpload == null ? null : voiceCDRUpload.getClass().toString());
        if (voiceCDRUpload != null) {
            this.upload(config, voiceCDRUpload, cdrLineFields, cdrItems);
        }
        log.info("\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0441 CDR \u043b\u043e\u0433\u0430\u043c\u0438 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438. tableName={}, voiceDeviceId={}", (Object)tableName, (Object)voiceLogProcessedEvent.getVoiceDeviceId());
        this.clearCDRLogTable(connection, tableName, voiceLogProcessedEvent.getVoiceDeviceId());
    }

    private void clearCDRLogTable(Connection connection, String tableName, int voiceDeviceId) throws BGException {
        try (PreparedStatement ps = connection.prepareStatement("DELETE FROM " + tableName + " WHERE voiceDeviceId=?");){
            ps.setInt(1, voiceDeviceId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private SormProject getSormProject(int voiceModuleId) throws BGException {
        SormProject sormProject = null;
        ServerContext serverContext = (ServerContext)ServerContext.get();
        List projects = ((SormService)serverContext.getService(SormService.class, this.sormModuleId)).getActiveSormProject();
        block0: for (SormProject project : projects) {
            Preferences config = project.getLoadedConfig();
            for (Integer selectedModuleId : Utils.toIntegerList((String)config.get("sorm.upload.modules"))) {
                if (voiceModuleId != selectedModuleId) continue;
                sormProject = project;
                continue block0;
            }
        }
        return sormProject;
    }

    private List<String> getNewCDRLines(Connection connection, String tableName, int voiceDeviceId) throws BGException {
        ArrayList<String> lines = new ArrayList<String>();
        try (PreparedStatement ps = connection.prepareStatement("SELECT * FROM " + tableName + " WHERE voiceDeviceId=?");){
            ps.setInt(1, voiceDeviceId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    lines.add(rs.getString("line"));
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        log.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u043e cdr \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438={}", (Object)lines.size());
        return lines;
    }

    private String defineRegex(Preferences sormProjectConfig) {
        String regex = sormProjectConfig.get("sorm.upload.cdr.regex", "\t");
        log.debug("\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0434\u043b\u044f \u0440\u0430\u0437\u0431\u0438\u0442\u0438\u0435 CDR \u043d\u0430 \u043f\u043e\u043b\u044f = {}", (Object)regex);
        return regex;
    }

    private List<String[]> getCdrLineFields(List<String> lines, String regex) {
        ArrayList<String[]> cdrLineFields = new ArrayList<String[]>();
        for (String s : lines) {
            cdrLineFields.add(s.split(regex));
        }
        return cdrLineFields;
    }

    private List<CDRItem> convertFieldListToCDRItems(Preferences config, List<String[]> cdrFields, int voiceDeviceId) {
        ArrayList<CDRItem> items = new ArrayList<CDRItem>();
        CDRFieldMapper fieldMapper = new CDRFieldMapper(config);
        for (String[] fields : cdrFields) {
            items.add(fieldMapper.fieldsToCDRItem(fields, voiceDeviceId));
        }
        return items;
    }

    private VoiceCDRUpload defineCDRUploadImplementation(SormProject sormProject, Preferences config, String cdrConverterRules) throws BGException {
        SormManufacturer sormManufacturer = SormManufacturer.getType((int)config.getInt("sorm.manufacturer", -1));
        if (sormManufacturer == null) {
            return null;
        }
        ServerContext serverContext = (ServerContext)ServerContext.get();
        for (DynamicClass dynamicClass : ((DynamicCodeService)serverContext.getService(DynamicCodeService.class, 0)).getDynamicClassesByInterface(VoiceCDRUpload.class.getName())) {
            VoiceCDRUpload cdrUploadImplementation = (VoiceCDRUpload)DynamicClassManager.getInstance().newInstance(VoiceCDRUpload.class, dynamicClass.getClassName(), new Class[]{SormProject.class, String.class}, new Object[]{sormProject, cdrConverterRules});
            if (!sormManufacturer.equals((Object)cdrUploadImplementation.getSormManufacturer())) continue;
            return cdrUploadImplementation;
        }
        return null;
    }

    private void upload(Preferences config, VoiceCDRUpload voiceCDRUpload, List<String[]> cdrLineFields, List<CDRItem> cdrItems) throws BGException {
        log.debug("\u0417\u0430\u043f\u0438\u0441\u044c \u0432 \u0444\u0430\u0439\u043b \u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0430 FTP");
        Path cdrFile = voiceCDRUpload.getFile();
        try (SormCSVWriter csvFileWriter = this.getCSVWriter(voiceCDRUpload, cdrFile);){
            String[] item;
            String[] header = voiceCDRUpload.getHeader();
            if (header != null) {
                csvFileWriter.writeNext(header);
            }
            log.debug("\u0417\u0430\u043f\u0438\u0441\u044c cdrItems");
            for (CDRItem cdrItem : cdrItems) {
                item = voiceCDRUpload.getCDRItem(cdrItem);
                if (item == null || item.length <= 0) continue;
                csvFileWriter.writeNext(item);
                csvFileWriter.flush();
            }
            log.debug("\u0417\u0430\u043f\u0438\u0441\u044c cdrLineFields");
            for (String[] lineFields : cdrLineFields) {
                item = voiceCDRUpload.getCDRItem(lineFields);
                if (item == null) continue;
                csvFileWriter.writeNext(item);
                csvFileWriter.flush();
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        if ("1".equals(config.get("sorm.ftp.upload.enable"))) {
            log.info("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e CDR \u0444\u0430\u0439\u043b\u0430 \u043d\u0430 FTP: " + cdrFile);
            new UploadToFTP(new UploadFiles(false).addFile(cdrFile), config, null);
        } else {
            log.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043d\u0430 FTP \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430!");
        }
    }

    private SormCSVWriter getCSVWriter(VoiceCDRUpload voiceCDRUpload, Path cdrFile) throws IOException {
        boolean withQuote;
        SormManufacturer manufacturer = voiceCDRUpload.getSormManufacturer();
        boolean bl = withQuote = !manufacturer.equals((Object)SormManufacturer.MFISOFT) && !manufacturer.equals((Object)SormManufacturer.SPECIALTECHNOLOGY) && !manufacturer.equals((Object)SormManufacturer.NORSITRANS);
        if (manufacturer.equals((Object)SormManufacturer.NORSITRANS)) {
            return SormUtils.getCSVFile(cdrFile, Charset.forName("windows-1251"), '\u0000', '\t');
        }
        return withQuote ? SormUtils.getCSVFile(cdrFile) : SormUtils.getCSVFile(cdrFile, '\u0000');
    }
}

