/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.reports.beeline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceReportsService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class VoiceReportBasePanel
extends BGUPanel {
    private String key = null;
    private int recordCount = 0;
    private int recordIndex = 1;
    protected JSONArray records = null;
    private String aax = "XXX";
    private JTextField navData = null;
    private LocalDate period = LocalDate.now();
    private String[] fieldTitles = null;
    private BGTextField fileName = new BGTextField(20);
    private ReportTableModel reportTableModel = null;
    private VoiceReportsService voiceReportService = null;
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            VoiceReportBasePanel.this.showRecordData();
        }
    };

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getControlPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.getTablePanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected JPanel getControlPanel() {
        this.fileName.setEnabled(false);
        this.fileName.setBackground(new JTextField().getBackground());
        this.fileName.setDisabledTextColor(Color.BLACK);
        this.fileName.setHorizontalAlignment(0);
        JButton generateButton = new JButton("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c...");
        generateButton.addActionListener(e -> {
            try {
                String className = this.getVoiceReportsService().getParameter(this.getKey() + "_class");
                if (className == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430!");
                    return;
                }
                this.records = new JSONArray(this.getVoiceReportsService().getReportRecords(this.getKey(), this.period));
                this.recordCount = this.records.length();
                this.recordIndex = 1;
                this.setNavInfo();
                this.showRecordData();
            }
            catch (Exception e2) {
                ClientUtils.showErrorMessageDialog((Throwable)e2);
            }
        });
        JButton saveButton = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c...");
        saveButton.addActionListener(e -> {
            BGFileChooser fileChooser = new BGFileChooser((Component)((Object)this));
            fileChooser.setFileFilter((FileFilter)new FileNameExtensionFilter("CSV", "csv"));
            fileChooser.setSelectedFile(new File(this.fileName.getText()));
            fileChooser.setAcceptAllFileFilterUsed(false);
            if (fileChooser.showSaveDialog((Component)BGClientBase.getFrame()) == 0) {
                File file = fileChooser.getSelectedFile();
                try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(file.getAbsolutePath(), new String[0]), Charset.forName("Cp1251"), new OpenOption[0]);){
                    writer.write(this.getVoiceReportsService().getReportCSV(this.getKey(), this.period));
                }
                catch (Exception e1) {
                    ClientUtils.showErrorMessageDialog((Throwable)e1);
                }
            }
        });
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0424\u0430\u0439\u043b:"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.fileName, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)generateButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add((Component)saveButton, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getNavigationPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected void showRecordData() {
        ArrayList<RowData> datas = new ArrayList<RowData>();
        if (this.records != null && this.recordIndex <= this.records.length()) {
            int index = 0;
            JSONArray jsonArray = this.records.getJSONArray(this.recordIndex - 1);
            for (String row : this.getFieldTitle()) {
                JSONObject json = new JSONObject();
                json.put("name", (Object)row);
                json.put("value", index < jsonArray.length() ? jsonArray.get(index) : "");
                datas.add(new RowData(json));
                ++index;
            }
        }
        this.getTableModel().setData(datas);
    }

    public void setPeriod(LocalDate period) {
        this.period = period;
        this.setFileName();
    }

    private void setFileName() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy_MM");
        this.fileName.setText(this.getAax() + "_" + this.getType() + "_" + dateTimeFormatter.format(this.period) + ".csv");
    }

    private void setNavInfo() {
        this.navData.setText(Utils.formatInteger((int)this.recordIndex) + " \u0438\u0437 " + Utils.formatInteger((int)this.recordCount));
    }

    private JPanel getNavigationPanel() {
        ActionListener navActionListener = e -> {
            String command;
            switch (command = e.getActionCommand()) {
                case "to_first": {
                    this.recordIndex = 1;
                    break;
                }
                case "to_prev": {
                    this.recordIndex = this.recordIndex > 1 ? this.recordIndex - 1 : 1;
                    break;
                }
                case "to_next": {
                    this.recordIndex = this.recordIndex < this.recordCount ? this.recordIndex + 1 : this.recordCount;
                    break;
                }
                case "to_last": {
                    this.recordIndex = this.recordCount;
                    break;
                }
            }
            this.setNavInfo();
            this.showRecordData();
        };
        this.navData = new JTextField(10);
        this.navData.setEditable(false);
        this.navData.setHorizontalAlignment(0);
        this.setNavInfo();
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0417\u0430\u043f\u0438\u0441\u044c: "), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new NavButton("to_first", navActionListener), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new NavButton("to_prev", navActionListener), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.navData, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new NavButton("to_next", navActionListener), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new NavButton("to_last", navActionListener), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected VoiceReportsService getVoiceReportsService() {
        if (this.voiceReportService == null) {
            this.voiceReportService = (VoiceReportsService)((ClientContext)this.getContext()).getPort(VoiceReportsService.class);
        }
        return this.voiceReportService;
    }

    protected JPanel getTablePanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.getTableModel()));
        table.setSelectionMode(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected ReportTableModel getTableModel() {
        if (this.reportTableModel == null) {
            this.reportTableModel = new ReportTableModel(ReportTableModel.class.getName());
        }
        return this.reportTableModel;
    }

    protected String[] getFieldTitle() {
        if (this.fieldTitles == null) {
            this.fieldTitles = new String[0];
        }
        return this.fieldTitles;
    }

    public String getAax() {
        return this.aax;
    }

    public void setAax(String aax) {
        this.aax = aax;
        this.setFileName();
    }

    protected String getType() {
        return "XXX";
    }

    protected void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key != null ? this.key : this.getType().toLowerCase();
    }

    class ReportTableModel
    extends BGTableModel<RowData> {
        public ReportTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041f\u043e\u043b\u0435", 50, 400, 600, "name", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 50, 400, -1, "value", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RowData rowData, int column) throws BGException {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "name": {
                    return rowData.getJson().optString("name", "???");
                }
                case "value": {
                    return rowData.getJson().optString("value", "???");
                }
            }
            return super.getValue((Object)rowData, column);
        }
    }

    class NavButton
    extends JButton {
        public NavButton(String iconName, ActionListener navActionListener) {
            super(ClientUtils.getIcon((String)iconName));
            this.setPreferredSize(new Dimension(24, 24));
            this.setActionCommand(iconName);
            this.addActionListener(navActionListener);
        }
    }
}

