/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZone;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceZoneDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneService")
public class VoiceZoneServiceImpl
extends AbstractService
implements VoiceZoneService {
    public SearchResult<VoiceZone> searchVoiceZone(String[] sort, Page page) throws BGException, BGMessageException {
        if (sort != null && sort.length == 0) {
            sort = new String[]{"title:0"};
        }
        SearchResult searchResult = new SearchResult(null, page, sort);
        try (VoiceZoneDao voiceZoneDao = new VoiceZoneDao(this.getConnection(), this.moduleId);){
            voiceZoneDao.searchVoiceZone((SearchResult<VoiceZone>)searchResult);
        }
        return searchResult;
    }

    public List<VoiceZone> voiceZoneList() throws BGException {
        List list = this.context.getDirectory(VoiceZone.class, this.moduleId).list();
        Collections.sort(list, new Comparator<VoiceZone>(){

            @Override
            public int compare(VoiceZone o1, VoiceZone o2) {
                return o1.getTitle().compareTo(o2.getTitle());
            }
        });
        return list;
    }

    public VoiceZone voiceZoneGet(int zoneId) throws BGException {
        return (VoiceZone)this.context.getDirectory(VoiceZone.class, this.moduleId).get(zoneId);
    }

    public int voiceZoneUpdate(VoiceZone zone) throws BGException {
        this.context.newDirectory(VoiceZone.class, this.moduleId).update((Id)zone);
        return zone.getId();
    }

    public int voiceZoneDelete(int zoneId) throws BGException {
        return this.context.newDirectory(VoiceZone.class, this.moduleId).delete(zoneId);
    }
}

