/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.operator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.server.bean.operator.Report;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class Operator {
    protected static Logger log = LogManager.getLogger();
    protected int id;
    private int cid;
    private String title;
    protected int mid;
    protected Preferences moduleSetup;
    protected Preferences operatorSetup;
    protected List<Integer> serviceList = new ArrayList<Integer>();
    protected List<Integer> tariffList = new ArrayList<Integer>();
    protected Map<Integer, Integer> billingToOperServiceMap = new HashMap<Integer, Integer>();
    protected Map<Integer, Integer> operToBillingServiceMap = new HashMap<Integer, Integer>();
    protected static final String ABONENT_SNAPSHOT_TABLE_PREFIX = "phone_oper_abon_snapshot";
    protected String incorrectOperatorMessage = "Ok";

    public void init(int id, int cid, String title, int mid, Preferences moduleSetup, Preferences operatorSetup) {
        this.id = id;
        this.cid = cid;
        this.mid = mid;
        this.title = title;
        this.moduleSetup = moduleSetup;
        this.operatorSetup = operatorSetup;
        this.tariffList = Utils.toIntegerList((String)operatorSetup.get("tariff.list", ""));
        for (Map.Entry serviceDef : operatorSetup.sub("service.").entrySet()) {
            int operId = Utils.parseInt((String)((String)serviceDef.getKey()));
            int billingId = Utils.parseInt((String)((String)serviceDef.getValue()));
            if (operId <= 0 || billingId <= 0) continue;
            this.serviceList.add(billingId);
            this.billingToOperServiceMap.put(billingId, operId);
            this.operToBillingServiceMap.put(operId, billingId);
        }
        this.loadServiceMap();
    }

    private void loadServiceMap() {
        this.billingToOperServiceMap = new HashMap<Integer, Integer>();
        Iterator operServices = Utils.toIntegerList((String)this.operatorSetup.get("oper.services", null)).iterator();
        for (Integer billingSid : this.serviceList) {
            if (operServices.hasNext()) {
                this.billingToOperServiceMap.put(billingSid, (Integer)operServices.next());
                continue;
            }
            this.billingToOperServiceMap.put(billingSid, billingSid);
        }
    }

    public int getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public int getModuleId() {
        return this.mid;
    }

    public int getContractId() {
        return this.cid;
    }

    public List<Integer> getServiceList() {
        return this.serviceList;
    }

    public Map<Integer, Integer> getBillingToOperServiceMap() {
        return this.billingToOperServiceMap;
    }

    public Preferences getOperatorSetup() {
        return this.operatorSetup;
    }

    public Map<Integer, Integer> getOperToBillingServiceMap() {
        return this.operToBillingServiceMap;
    }

    public Preferences getModuleSetup() {
        return this.moduleSetup;
    }

    public boolean hasShapshot(Connection con, Date month) {
        boolean result = false;
        try {
            String tableName = ServerUtils.getModuleMonthTableName((String)ABONENT_SNAPSHOT_TABLE_PREFIX, (Date)month, (int)this.mid);
            result = ServerUtils.tableExists((Connection)con, (String)tableName);
            if (result) {
                String query = "SELECT COUNT(*) FROM " + tableName + " WHERE oper_id=?";
                PreparedStatement ps = con.prepareStatement(query);
                ps.setInt(1, this.id);
                ResultSet rs = ps.executeQuery();
                result = rs.next() && rs.getInt(1) > 0;
                rs.close();
                ps.close();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String checkAndCreateSnapshotTable(Connection con, Date month) {
        String tableName = ServerUtils.getModuleMonthTableName((String)ABONENT_SNAPSHOT_TABLE_PREFIX, (Date)month, (int)this.mid);
        if (!ServerUtils.tableExists((Connection)con, (String)tableName)) {
            try {
                String query = "CREATE TABLE " + tableName + "( oper_id INT NOT NULL, cid INT NOT NULL, param VARCHAR(200) NOT NULL,value VARCHAR(300) NOT NULL ,KEY oper_id(oper_id) )";
                PreparedStatement ps = con.prepareStatement(query);
                ps.executeUpdate();
                ps.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return tableName;
    }

    public Date getLastPrevSnapshot(Connection con, Date month) {
        Date result = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            ArrayList<String> tables = new ArrayList<String>();
            String query = "SHOW TABLES LIKE 'phone_oper_abon_snapshot%'";
            PreparedStatement ps = con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
            rs.close();
            ps.close();
            Collections.sort(tables, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o2.compareTo(o1);
                }
            });
            for (String table : tables) {
                int pos;
                Date date = TimeUtils.parseDate((String)table.substring((pos = table.lastIndexOf(95)) + 1), (DateFormat)dateFormat);
                if (date == null || TimeUtils.monthsDelta((Date)date, (Date)month) == 0 || !this.hasShapshot(con, date)) continue;
                result = date;
                break;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected PreparedStatement getInsertSnapshotPs(Connection con, Date month) throws SQLException {
        String tableName = this.checkAndCreateSnapshotTable(con, month);
        String query = "INSERT INTO " + tableName + " (oper_id, cid, param, value) VALUES (?,?,?,?)";
        PreparedStatement result = con.prepareStatement(query);
        result.setInt(1, this.id);
        return result;
    }

    protected void clearSnapshot(Connection con, Date month) throws SQLException {
        String tableName = this.checkAndCreateSnapshotTable(con, month);
        String query = "DELETE FROM " + tableName + " WHERE oper_id=?";
        PreparedStatement result = con.prepareStatement(query);
        result.setInt(1, this.id);
        result.executeUpdate();
    }

    private Map<Integer, Map<String, String>> getSnapshot(Connection con, Date month) {
        ConcurrentHashMap<Integer, Map<String, String>> result = new ConcurrentHashMap<Integer, Map<String, String>>();
        try {
            int lastContractId = 0;
            HashMap<String, String> lastContractParams = null;
            String tableName = this.checkAndCreateSnapshotTable(con, month);
            String query = "SELECT cid, param, value FROM " + tableName + " WHERE oper_id=? ORDER BY cid";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, this.id);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                int cid = rs.getInt(1);
                if (cid != lastContractId) {
                    lastContractParams = new HashMap<String, String>();
                    result.put(cid, lastContractParams);
                    lastContractId = cid;
                }
                lastContractParams.put(rs.getString(2), rs.getString(3));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public Set<Integer> getChangedAbonents(Connection con, Date toMonth) {
        HashSet<Integer> result = new HashSet<Integer>();
        Map<Object, Object> prevSnapshot = new HashMap();
        Date lastSnapshot = this.getLastPrevSnapshot(con, toMonth);
        if (lastSnapshot != null) {
            prevSnapshot = this.getSnapshot(con, lastSnapshot);
        }
        Map<Integer, Map<String, String>> currentSnapshot = this.getSnapshot(con, toMonth);
        for (Map.Entry<Integer, Map<String, String>> me : currentSnapshot.entrySet()) {
            int cid = me.getKey();
            Map<String, String> currentParams = me.getValue();
            Map prevParams = (Map)prevSnapshot.get(cid);
            if (prevParams == null) continue;
            boolean paramEquals = true;
            for (Map.Entry<String, String> param : currentParams.entrySet()) {
                String currentName = param.getKey();
                String currentValue = param.getValue();
                String prevValue = Utils.maskNull((String)((String)prevParams.get(currentName)));
                if (prevValue.equals(currentValue)) continue;
                paramEquals = false;
                break;
            }
            if (!paramEquals) continue;
            currentParams.remove(String.valueOf(cid));
            prevParams.remove(String.valueOf(cid));
        }
        result.addAll(prevSnapshot.keySet());
        result.addAll(currentSnapshot.keySet());
        return result;
    }

    public Report getReport(int id, Date month) {
        Report result = null;
        for (Report report : this.getReportList(month)) {
            if (report.getId() != id) continue;
            result = report;
            break;
        }
        return result;
    }

    public abstract boolean needAbonentSnapshot();

    public abstract void createAbonentSnapshot(Connection var1, Date var2);

    public List<Report> getReportList(Date month) {
        return this.getReportList(month, true);
    }

    public abstract List<Report> getReportList(Date var1, boolean var2);

    public List<Integer> getTariffList() {
        return this.tariffList;
    }

    public abstract void checkCorrectOperator() throws BGException;
}

