/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code;

import java.sql.Connection;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.server.bean.code.GeoCodeImportManager;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceGeographicCodeDao;

public class GeoCodeManager
implements AutoCloseable {
    private Connection con;
    private int moduleId;
    private int userId;
    private VoiceGeographicCodeDao codeDao;

    public GeoCodeManager(Connection con, int moduleId, int userId) {
        this.con = con;
        this.moduleId = moduleId;
        this.userId = userId;
        this.codeDao = new VoiceGeographicCodeDao(con, moduleId);
    }

    public List<VoiceGeographicCode> list(int codeId, int operatorId) throws BGException {
        return this.codeDao.list(codeId, operatorId);
    }

    public int delete(List<Integer> codes) throws BGException {
        return this.codeDao.delete(codes);
    }

    @Override
    public void close() {
        try {
            this.codeDao.recycle();
            this.codeDao.close();
        }
        catch (BGException e) {
            e.printStackTrace();
        }
    }

    protected VoiceGeographicCode get(String code, int codeId, int operatorId) throws BGException {
        return this.codeDao.get(code, codeId, operatorId);
    }

    public int updateGeographicCode(VoiceGeographicCode code) throws BGException {
        return new GeoCodeImportManager(this.con, this.moduleId, this.userId).updateGeographicCode(code);
    }

    public String importGeographicCode(int operatorId, boolean addNew, boolean updateExist, Holder<DataHandler> importContent) throws BGException {
        return new GeoCodeImportManager(this.con, this.moduleId, this.userId).importGeographicCode(operatorId, addNew, updateExist, importContent);
    }
}

