/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMap;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class VoiceCostMapDao
extends AbstractIdDao<VoiceCostMap> {
    private static final String COST_MAP_TABLE_NAME = "voice_cost_map";

    public VoiceCostMapDao(Connection con, int mid) {
        super(con, mid, COST_MAP_TABLE_NAME);
    }

    protected VoiceCostMap getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceCostMap result = new VoiceCostMap();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setComment(rs.getString("comment"));
        result.setOperatorId(rs.getInt("operatorId"));
        return result;
    }

    protected void updateImpl(VoiceCostMap b) throws BGException, SQLException {
        String query = b.getId() > 0 ? "UPDATE " + this.tableName + " SET title=?, comment=?, operatorId = ? WHERE id=?" : "INSERT INTO " + this.tableName + "(title, comment, operatorId ) VALUES (?, ?, ? )";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, b.getTitle());
            ps.setString(index++, b.getComment());
            if (b.getOperatorId() > 0) {
                ps.setInt(index++, b.getOperatorId());
            } else {
                ps.setNull(index++, b.getOperatorId());
            }
            if (b.getId() > 0) {
                ps.setInt(index++, b.getId());
            }
            ps.executeUpdate();
            if (b.getId() <= 0) {
                b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public List<VoiceCostMap> list(int operatorId) throws BGException {
        String filter = "operatorId" + (String)(operatorId > 0 ? "=" + operatorId : " IS NULL ");
        return super.list(filter, "id", new Object[0]);
    }
}

