package ru.bitel.bgbilling.kernel.dyn.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebContractSearchModuleBase;
import ru.bitel.bgbilling.kernel.admin.webmenu.server.bean.WebContractSearchResult;
import ru.bitel.common.model.IdTitle;

public class WebSearchContractByAddress
    extends WebContractSearchModuleBase
{
    public WebSearchContractByAddress()
    {
        contractSearchParams = Arrays.asList( title, useForAccessRestore, useForPayment, searchTextPlaceHolder, searchTextComment, searchByContractParamId, popupHintCount,
                                              verifyByCustomerEmail, verifyByContractParameterEmailId, verifyByCustomerPhone, verifyByContractParameterPhoneId);
    }
    
    @Override
    public List<IdTitle> doHintSearch( String searchText )
        throws BGException
    {
        return new ArrayList<IdTitle>();
    }
    
    @Override
    public List<WebContractSearchResult> doSearch( String searchText )
        throws BGException
    {
        List<WebContractSearchResult> list = super.doSearch( searchText );

        if ( !searchText.matches( "^\\d{3,}$" ) )
        {
            return list;
        }
        
        return list;        
    }
    
    @Override
    public boolean useHintSerach()
    {
        return true;
    }
    
    @Override
    public String getTitleText()
    {
        return "по адресу услуги";
    }
    
    @Override
    protected String getSearchTextPlaceHolderText()
    {
        return "почтовый индекс, дом, квартира";
    }

    @Override
    protected String getSearchTextCommentText()
    {
        return "Введите адрес предоставления услуги по договору";
    }
}