/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.common.bean;

import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.inet.IpRange;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceInstance;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceRange;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceUtils;

public class IpResourceNet
extends IpNet
implements IpResourceInstance {
    private int ipResourceId;

    public IpResourceNet() {
    }

    public IpResourceNet(int ipResourceId, byte[] subnet, int mask) {
        super(subnet, mask);
        this.ipResourceId = ipResourceId;
    }

    @Override
    @XmlAttribute(name="resId")
    public int getIpResourceId() {
        return this.ipResourceId;
    }

    @Override
    public void setIpResourceId(int ipResourceId) {
        this.ipResourceId = ipResourceId;
    }

    public static void newIpResourceNetList(IpResource resource, List<IpResourceSubscription> subscriptionList, String filter, int mask, final int max, final List<IpResourceNet> result) {
        boolean ipv6;
        boolean bl = ipv6 = resource.getAddressFrom() != null && resource.getAddressFrom().length == 16;
        if (mask <= 0 && resource.getPrefixLength() > 0) {
            mask = resource.getPrefixLength();
        } else if (mask > resource.getPrefixLength() && resource.getPrefixLength() > 0) {
            mask = resource.getPrefixLength();
        } else if (mask <= 0) {
            mask = ipv6 ? 64 : 32;
        }
        final int maskf = mask;
        new IpResourceRange.IpResourceRangeExtractor(max, IpResourceUtils.getFilterIpRange(filter, ipv6)){

            @Override
            protected boolean next(int resourceId, IpRange ipRange) {
                IpResourceNet.subnet(result, resourceId, ipRange, this.filter, maskf, max - result.size(), ipv6);
                return result.size() < max;
            }
        }.process(resource, subscriptionList);
    }

    public static void newIpResourceNetList(Iterable<IpResourceRange> rangeList, int mask, int max, List<IpResourceNet> result) {
        for (IpResourceRange range : rangeList) {
            byte[] addressFrom = range.getAddressFrom();
            boolean ipv6 = addressFrom != null && addressFrom.length == 16;
            IpResourceNet.subnet(result, range.getIpResourceId(), range, null, mask, max, ipv6);
            if ((max -= result.size()) > 0) continue;
            break;
        }
    }

    private static void subnet(List<IpResourceNet> list, int ipResourceId, IpRange ipRange, IpRange filter, int mask, int max, boolean ipv6) {
        int len = ipRange.getAddressFrom().length;
        byte[] addressFrom = new byte[len];
        byte[] addressTo = new byte[len];
        System.arraycopy(ipRange.getAddressFrom(), 0, addressFrom, 0, len);
        if (filter != null && IpAddress.compare(addressFrom, filter.getAddressFrom()) < 0 && IpAddress.compare(addressFrom = filter.getAddressFrom(), ipRange.getAddressTo()) >= 0) {
            return;
        }
        System.arraycopy(addressFrom, 0, addressTo, 0, len);
        for (int k = 0; k < max; ++k) {
            int i;
            for (i = addressFrom.length - 1; i > mask / 8; --i) {
                addressFrom[i] = 0;
                addressTo[i] = -1;
            }
            if (mask % 8 != 0) {
                int n = i;
                addressFrom[n] = (byte)(addressFrom[n] & (byte)(255 << 8 - mask % 8));
                int n2 = i;
                addressTo[n2] = (byte)(addressTo[n2] | (byte)(255 >> mask % 8));
            } else if (mask / 8 == (ipv6 ? 16 : 4)) {
                int n = i;
                addressTo[n] = (byte)(addressTo[n] | 0);
            } else {
                int n = i;
                addressTo[n] = (byte)(addressTo[n] | (byte)(255 >> mask % 8));
            }
            if (IpAddress.compare(addressTo, ipRange.getAddressTo()) > 0) break;
            if (IpAddress.compare(ipRange.getAddressFrom(), addressFrom) <= 0) {
                list.add(new IpResourceNet(ipResourceId, addressFrom, mask));
            }
            if ((addressFrom = IpAddress.newAndIncrement(addressTo)) == null || filter != null && IpAddress.compare(addressFrom, filter.getAddressTo()) > 0) break;
            System.arraycopy(addressFrom, 0, addressTo, 0, len);
        }
    }

    @Override
    public String getGuiTitle() {
        return this.toString();
    }
}

