/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.common.bean;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import ru.bitel.common.model.TreeNode;

@XmlRootElement(name="n")
public class GeographicCode
implements TreeNode<GeographicCode> {
    private String code;
    private List<GeographicCode> children;
    private int destinationId;
    private String destination;
    private int level;
    private int startLevel;
    private int endLevel;

    @XmlAttribute(name="c")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    @XmlElement(name="n")
    public List<GeographicCode> getChildren() {
        return this.children;
    }

    public void setChildren(List<GeographicCode> children) {
        this.children = children;
    }

    @XmlAttribute(name="d")
    public int getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(int destinationId) {
        this.destinationId = destinationId;
    }

    @XmlAttribute(name="t")
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @XmlAttribute(name="l")
    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @XmlAttribute(name="sl")
    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int startLevel) {
        this.startLevel = startLevel;
    }

    @XmlAttribute(name="el")
    public int getEndLevel() {
        return this.endLevel;
    }

    public void setEndLevel(int endLevel) {
        this.endLevel = endLevel;
    }

    public GeographicCode findCodeMatch(String code) {
        if (this.code.equals(code)) {
            return this;
        }
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                GeographicCode child = this.children.get(i);
                if (!code.startsWith(child.code)) continue;
                return child.findCodeMatch(code);
            }
        }
        return null;
    }

    public GeographicCode findParent(String code) {
        return this.findParent(code, this);
    }

    private GeographicCode findParent(String code, GeographicCode parent) {
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                GeographicCode child = this.children.get(i);
                if (!code.startsWith(child.code)) continue;
                if (code.equals(child.code)) {
                    return this;
                }
                return child.findParent(code, this);
            }
        }
        return this;
    }

    public GeographicCode findCode(String code) {
        if (this.code.equals(code)) {
            return this;
        }
        if (this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                GeographicCode child = this.children.get(i);
                if (!code.startsWith(child.code)) continue;
                return child.findCode(code);
            }
        }
        return this;
    }

    public GeographicCode findCode(String code, int startLevel, int endLevel) {
        if (this.startLevel > 0 && this.endLevel > 0) {
            startLevel = this.startLevel;
            endLevel = this.endLevel;
        }
        if (!this.code.equals(code) && this.children != null) {
            int size = this.children.size();
            for (int i = 0; i < size; ++i) {
                GeographicCode child = this.children.get(i);
                if (!code.startsWith(child.code)) continue;
                GeographicCode result = child.findCode(code, startLevel, endLevel);
                if (result == null) break;
                return result;
            }
        }
        if (startLevel <= 0 || endLevel <= 0 || this.level >= startLevel && this.level <= endLevel) {
            return this;
        }
        return null;
    }

    public void addChild(GeographicCode child) {
        if (this.children == null) {
            this.children = new ArrayList<GeographicCode>();
        }
        this.children.add(child);
    }

    public String toString() {
        return this.code;
    }
}

