/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.client;

import bitel.billing.module.common.IntTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.oss.systems.inventory.resource.client.VlanResourceSubscriptionPanel;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceGroup;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanResource;
import ru.bitel.oss.systems.inventory.resource.common.service.ResourceService;

public class VlanResourcePanel
extends BGUPanel {
    private ResourceService resourceService = null;
    private VlanResourceTableModel model = new VlanResourceTableModel();
    private BGUTable table = new BGUTable(this.model);
    private VlanCategoryTreeTableModel treeModel = new VlanCategoryTreeTableModel();
    private VlanResourceTablePanel vlanResourceTablePanel = new VlanResourceTablePanel();
    private VlanResourceSubscriptionPanel vlanResourceSubscriptionPanel = new VlanResourceSubscriptionPanel();

    public VlanResourcePanel(ClientContext clientContext) {
        super((LayoutManager)new BorderLayout(), clientContext);
    }

    private ResourceService getResourceService() {
        if (this.resourceService == null) {
            this.resourceService = ((ClientContext)this.getContext()).getPort(ResourceService.class);
        }
        return this.resourceService;
    }

    @Override
    protected void jbInit() {
        this.table.setSelectionMode(0);
        BGEditor mainEditor = new BGEditor("table");
        mainEditor.addForm(this.vlanResourceTablePanel, "table");
        mainEditor.addForm(this.vlanResourceSubscriptionPanel);
        BGSwingUtilites.buildPopupMenu(this.table, (Container)this, "vlanResource");
        BGUTreeTable treeTable = new BGUTreeTable(this.treeModel);
        this.add((Component)new BGSplitPaneNoBorder(1, BGSwingUtilites.wrapBorder(new JScrollPane(treeTable), "\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438"), (Component)mainEditor, 400L), "Center");
        treeTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.performAction("vlan.refresh");
            }
        });
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VlanCategory category = (VlanCategory)VlanResourcePanel.this.treeModel.getSelectedRow();
                VlanResourcePanel.this.treeModel.setData(VlanResourcePanel.this.getResourceService().vlanCategoryRoot());
                VlanResourcePanel.this.treeModel.setSelectedRow(category);
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VlanCategory vlanCategory = new VlanCategory();
                VlanCategory parentVlanCategory = (VlanCategory)VlanResourcePanel.this.treeModel.getSelectedRow();
                if (parentVlanCategory != null) {
                    vlanCategory.setParentId(parentVlanCategory.getId());
                }
                new VlanCategoryEditorDialog("\u041d\u043e\u0432\u0430\u044f \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f", vlanCategory).getDialog().setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VlanCategory vlanCategory = (VlanCategory)VlanResourcePanel.this.treeModel.getSelectedRow();
                if (vlanCategory == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
                    return;
                }
                new VlanCategoryEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438", vlanCategory).getDialog().setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VlanCategory vlanCategory = (VlanCategory)VlanResourcePanel.this.treeModel.getSelectedRow();
                if (vlanCategory != null && BGSwingUtilites.confirmDelete("\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e", vlanCategory)) {
                    VlanResourcePanel.this.getResourceService().vlanCategoryDelete(vlanCategory.getId());
                    VlanResourcePanel.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("vlan.refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VlanCategory category = (VlanCategory)VlanResourcePanel.this.treeModel.getSelectedRow();
                VlanResourcePanel.this.model.setData(VlanResourcePanel.this.getResourceService().vlanResourceList(category != null ? category.getId() : -1));
            }
        };
        new AbstractBGUPanel.MenuAction("vlanResource.subscription", "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VlanResource vlanResource = (VlanResource)VlanResourcePanel.this.model.getSelectedRow();
                if (vlanResource != null) {
                    BGSwingUtilites.wrapBorder(VlanResourcePanel.this.vlanResourceSubscriptionPanel, " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 " + vlanResource + " ");
                    VlanResourcePanel.this.vlanResourceSubscriptionPanel.setVlanResource(vlanResource);
                    VlanResourcePanel.this.vlanResourceSubscriptionPanel.performAction("refresh");
                    VlanResourcePanel.this.vlanResourceSubscriptionPanel.performActionOpen();
                }
            }
        };
    }

    class VlanResourceTableModel
    extends BGTableModel<VlanResource> {
        public VlanResourceTableModel() {
            super(VlanResourceTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", DeviceGroup.class, -1, 300, -1, "title", false, false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d", String.class, -1, 120, -1, null, false, false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", String.class, -1, 120, -1, null, false, false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, 400, -1, "comment", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(VlanResource val, int column) throws BGException {
            switch (column) {
                case 2: {
                    return val.getVlanFrom() + "-" + val.getVlanTo();
                }
                case 3: {
                    return TimeUtils.formatPeriod(val.getDateFrom(), val.getDateTo());
                }
            }
            return super.getValue(val, column);
        }
    }

    class VlanCategoryTreeTableModel
    extends BGTreeTableModel<VlanCategory> {
        public VlanCategoryTreeTableModel() {
            super(VlanCategoryTreeTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", VlanCategory.class, -1, 300, -1, "title", false);
            this.addColumnId(false);
        }
    }

    class VlanResourceTablePanel
    extends BGUPanel {
        private BGDialogToolBar toolBar = new BGDialogToolBar();

        VlanResourceTablePanel() {
        }

        @Override
        protected void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            this.setName("table");
            this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 3), 0, 0));
            this.add((Component)new JScrollPane(VlanResourcePanel.this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 3, 3), 0, 0));
            BGSwingUtilites.buildToolBar(this.toolBar, this);
            this.toolBar.compact();
            BGSwingUtilites.handleEdit("resource", VlanResourcePanel.this.table, this);
        }

        @Override
        protected void initActions() {
            new AbstractBGUPanel.DefaultAction("resource.new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441", (Icon)ClientUtils.getIcon("item_add")){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    VlanCategory vlanCategory = (VlanCategory)VlanResourcePanel.this.treeModel.getSelectedRow();
                    if (vlanCategory == null || vlanCategory.getId() <= 0) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
                        return;
                    }
                    VlanResource vlanResource = new VlanResource();
                    vlanResource.setId(-1);
                    vlanResource.setCategoryId(vlanCategory.getId());
                    new VlanResourceEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441", vlanResource).getDialog().setVisible(true);
                }
            };
            new AbstractBGUPanel.DefaultAction("resource.edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441", (Icon)ClientUtils.getIcon("item_edit")){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    VlanResource vlanResource = (VlanResource)VlanResourcePanel.this.model.getSelectedRow();
                    if (vlanResource == null) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0441\u0443\u0440\u0441");
                        return;
                    }
                    new VlanResourceEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u0430", vlanResource).getDialog().setVisible(true);
                }
            };
            new AbstractBGUPanel.DefaultAction("resource.delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441", (Icon)ClientUtils.getIcon("item_delete")){

                @Override
                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    VlanResource vlanResource = (VlanResource)VlanResourcePanel.this.model.getSelectedRow();
                    if (vlanResource == null) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0441\u0443\u0440\u0441");
                        return;
                    }
                    if (BGSwingUtilites.confirmDelete("\u0440\u0435\u0441\u0443\u0440\u0441 vlan", vlanResource)) {
                        VlanResourcePanel.this.getResourceService().vlanResourceDelete(vlanResource.getId());
                        VlanResourcePanel.this.performAction("vlan.refresh");
                    }
                }
            };
        }
    }

    class VlanResourceEditorDialog
    extends BGEditorDialog<VlanResource> {
        private BGTextField title;
        private IntTextField vlanFrom;
        private IntTextField vlanTo;
        private BGControlPanelPeriodNoB period;
        private JTextArea comment;

        public VlanResourceEditorDialog(String title, VlanResource data) {
            super(title, data);
            this.title = new BGTextField(30);
            this.vlanFrom = new IntTextField();
            this.vlanTo = new IntTextField();
            this.period = new BGControlPanelPeriodNoB(false);
            this.comment = new JTextArea(3, 0);
        }

        @Override
        public void doDialogPanel() {
            this.comment.setLineWrap(true);
            this.comment.setWrapStyleWord(true);
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0414\u0438\u0430\u043f\u0430\u0437\u043e\u043d VLAN:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
            this.panel.add((Component)this.getVlanFromToPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
            this.panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 3, 0.5, 0.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
            this.title.setText(((VlanResource)this.data).getTitle());
            this.vlanFrom.setValue(((VlanResource)this.data).getVlanFrom());
            this.vlanTo.setValue(((VlanResource)this.data).getVlanTo());
            this.period.setLocalDateFrom(TimeUtils.convertDateToLocalDate(((VlanResource)this.data).getDateFrom()));
            this.period.setLocalDateTo(TimeUtils.convertDateToLocalDate(((VlanResource)this.data).getDateTo()));
            this.comment.setText(((VlanResource)this.data).getComment());
        }

        private JPanel getVlanFromToPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.vlanFrom, new GridBagConstraints(-1, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)new JLabel(" - "), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)this.vlanTo, new GridBagConstraints(-1, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        @Override
        public boolean doApply() throws Exception {
            int id;
            ((VlanResource)this.data).setTitle(this.title.getText());
            ((VlanResource)this.data).setVlanFrom((int)this.vlanFrom.getValue());
            ((VlanResource)this.data).setVlanTo((int)this.vlanTo.getValue());
            ((VlanResource)this.data).setDateFrom(TimeUtils.convertCalendarToDate(this.period.getDateCalendar1()));
            ((VlanResource)this.data).setDateTo(TimeUtils.convertCalendarToDate(this.period.getDateCalendar2()));
            ((VlanResource)this.data).setComment(this.comment.getText());
            VlanCategory vlanCategory = (VlanCategory)VlanResourcePanel.this.treeModel.getSelectedRow();
            if (vlanCategory == null) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
                return false;
            }
            ((VlanResource)this.data).setCategoryId(vlanCategory.getId());
            try {
                id = VlanResourcePanel.this.getResourceService().vlanResourceUpdate((VlanResource)this.data);
            }
            finally {
                VlanResourcePanel.this.performAction("refresh");
            }
            VlanResourcePanel.this.model.setSelectedRow(id);
            return true;
        }
    }

    class VlanCategoryEditorDialog
    extends BGTitleEditorDialog<VlanCategory> {
        public VlanCategoryEditorDialog(String title, VlanCategory data) {
            super(title, data);
        }

        @Override
        protected void doUpdate() throws Exception {
            int id = VlanResourcePanel.this.getResourceService().vlanCategoryUpdate((VlanCategory)this.data);
            VlanResourcePanel.this.performAction("refresh");
            VlanResourcePanel.this.treeModel.setSelectedRow(id);
        }
    }
}

