/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.Recyclable;

public class FileSort<V>
implements Recyclable,
Iterable<V> {
    private final int bufferSize;
    private final Comparator<V> comparator;
    private List<V> currentList;
    private boolean currentListSorted;
    private final List<ChunkFile> chunkFileList = new ArrayList<ChunkFile>();
    private static final AtomicLong counter = new AtomicLong();
    private final long count;

    public FileSort(Comparator<V> comparator, int bufferSize) {
        bufferSize = Math.max(bufferSize, 10000);
        this.comparator = comparator;
        this.bufferSize = bufferSize;
        this.count = counter.incrementAndGet();
        this.currentList = new ArrayList<V>(bufferSize);
        this.currentListSorted = false;
    }

    public void add(V v) throws IOException {
        if (this.currentList.size() >= this.bufferSize) {
            Collections.sort(this.currentList, this.comparator);
            ChunkFile chunkFile = new ChunkFile(this.currentList);
            this.chunkFileList.add(chunkFile);
            this.currentList.clear();
        }
        this.currentList.add(v);
        this.currentListSorted = false;
    }

    public void addAll(Collection<V> collection) throws IOException {
        for (V v : collection) {
            if (this.currentList.size() >= this.bufferSize) {
                Collections.sort(this.currentList, this.comparator);
                ChunkFile chunkFile = new ChunkFile(this.currentList);
                this.chunkFileList.add(chunkFile);
                this.currentList.clear();
            }
            this.currentList.add(v);
        }
        this.currentListSorted = false;
    }

    protected void writeFile(File file, List<V> list) throws FileNotFoundException, IOException {
        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file), 32768));
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            os.writeObject(list.get(i));
        }
        os.flush();
        os.close();
    }

    protected Iterator<V> readFile(File file) throws IOException {
        return new ObjectFileIterator(file);
    }

    @Override
    public Iterator<V> iterator() {
        if (this.chunkFileList.size() == 0) {
            if (!this.currentListSorted) {
                Collections.sort(this.currentList, this.comparator);
                this.currentListSorted = true;
            }
            return this.currentList.iterator();
        }
        ArrayList iteratorList = new ArrayList();
        try {
            for (ChunkFile chunkFile : this.chunkFileList) {
                iteratorList.add(this.readFile(chunkFile.file));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (this.currentList.size() > 0) {
            if (!this.currentListSorted) {
                Collections.sort(this.currentList, this.comparator);
                this.currentListSorted = true;
            }
            iteratorList.add(this.currentList.iterator());
        }
        return new MergeIter(iteratorList, this.comparator);
    }

    public void clear() {
        for (ChunkFile chunkFile : this.chunkFileList) {
            chunkFile.file.delete();
        }
        this.chunkFileList.clear();
        this.chunkFileList.clear();
        this.currentListSorted = false;
    }

    @Override
    public void recycle() {
        this.clear();
    }

    protected void finalize() throws Throwable {
        if (this.chunkFileList.size() > 0) {
            this.recycle();
        }
    }

    public static void main(String[] args) throws IOException {
        FileSort<Integer> fileSort = new FileSort<Integer>(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 - o2;
            }
        }, 400000);
        System.gc();
        System.gc();
        System.gc();
        System.out.println(Utils.memoryStatus());
        Random random = new Random();
        for (int i = 0; i < 1000000; ++i) {
            fileSort.add(random.nextInt(100000000));
        }
        System.gc();
        System.gc();
        System.gc();
        System.out.println(Utils.memoryStatus());
        int c = Integer.MIN_VALUE;
        for (Integer i : fileSort) {
            if (c > i) {
                System.out.println("ERROR");
            }
            c = i;
        }
        c = Integer.MIN_VALUE;
        for (Integer i : fileSort) {
            if (c > i) {
                System.out.println("ERROR");
            }
            c = i;
        }
        fileSort.recycle();
        System.gc();
        System.gc();
        System.gc();
        System.out.println(Utils.memoryStatus());
    }

    class ChunkFile {
        final File file;

        private ChunkFile(List<V> list) throws IOException {
            this.file = File.createTempFile("sort" + FileSort.this.count + "_", null);
            FileSort.this.writeFile(this.file, list);
        }
    }

    class ObjectFileIterator
    implements Iterator<V>,
    Closeable {
        private final ObjectInputStream is;
        private V v;

        public ObjectFileIterator(File file) throws FileNotFoundException, IOException {
            this.is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file), 32768));
        }

        @Override
        public boolean hasNext() {
            if (this.v == null) {
                try {
                    this.v = this.is.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    this.v = null;
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return this.v != null;
        }

        @Override
        public V next() {
            Object res = this.v;
            this.v = null;
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }
    }

    static class MergeIter<V>
    implements Iterator<V> {
        SubIter<V>[] subIters;
        final Comp<V> comp;
        int currentIndex;

        public MergeIter(List<Iterator<V>> iteratorList, Comparator<V> comparator) {
            ArrayList<SubIter<V>> list = new ArrayList<SubIter<V>>(iteratorList.size());
            int size = iteratorList.size();
            for (int i = 0; i < size; ++i) {
                Iterator<V> iterator = iteratorList.get(i);
                if (!iterator.hasNext()) continue;
                list.add(new SubIter<V>(iteratorList.get(i)));
            }
            this.subIters = list.toArray(new SubIter[iteratorList.size()]);
            this.comp = new Comp<V>(comparator);
            Arrays.sort(this.subIters, this.comp);
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.subIters.length != 0;
        }

        @Override
        public V next() {
            SubIter<V>[] subIters = this.subIters;
            int currentIndex = this.currentIndex;
            SubIter<V> current = subIters[currentIndex];
            V result = current.next();
            if (current.current == null) {
                SubIter[] newSubIters = new SubIter[this.subIters.length - 1];
                System.arraycopy(subIters, 0, newSubIters, 0, currentIndex);
                System.arraycopy(subIters, currentIndex + 1, newSubIters, currentIndex, newSubIters.length - currentIndex);
                this.subIters = newSubIters;
                subIters = newSubIters;
                if (current.iterator instanceof Closeable) {
                    try {
                        ((Closeable)((Object)current.iterator)).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (subIters.length >= 1) {
                    this.currentIndex = 0;
                    currentIndex = 0;
                    current = subIters[0];
                } else {
                    return result;
                }
            }
            switch (subIters.length) {
                case 1: {
                    break;
                }
                case 2: {
                    if (this.comp.compare(subIters[0], subIters[1]) > 0) {
                        this.currentIndex = 1;
                        break;
                    }
                    this.currentIndex = 0;
                    break;
                }
                case 3: {
                    if (this.comp.compare(subIters[0], subIters[1]) > 0) {
                        if (this.comp.compare(subIters[1], subIters[2]) > 0) {
                            this.currentIndex = 2;
                            break;
                        }
                        this.currentIndex = 1;
                        break;
                    }
                    if (this.comp.compare(subIters[0], subIters[2]) > 0) {
                        this.currentIndex = 2;
                        break;
                    }
                    this.currentIndex = 0;
                    break;
                }
                default: {
                    int i;
                    int idx = currentIndex;
                    for (i = idx + 1; i < subIters.length; ++i) {
                        if (this.comp.compare(current, subIters[i]) <= 0) continue;
                        current = subIters[i];
                        currentIndex = i;
                    }
                    for (i = 0; i < idx; ++i) {
                        if (this.comp.compare(current, subIters[i]) <= 0) continue;
                        current = subIters[i];
                        currentIndex = i;
                    }
                    this.currentIndex = currentIndex;
                    break;
                }
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void finalize() throws Throwable {
            SubIter<V>[] subIters = this.subIters;
            if (subIters != null && subIters.length > 0) {
                for (int i = 0; i < subIters.length; ++i) {
                    Iterator iter = subIters[i].iterator;
                    if (!(iter instanceof Closeable)) continue;
                    ((Closeable)((Object)iter)).close();
                }
            }
        }
    }

    static class Comp<V>
    implements Comparator<SubIter<V>> {
        private final Comparator<V> comparator;

        Comp(Comparator<V> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(SubIter<V> o1, SubIter<V> o2) {
            return this.comparator.compare(o1.current, o2.current);
        }
    }

    static class SubIter<V> {
        final Iterator<V> iterator;
        V current;

        SubIter(Iterator<V> iterator) {
            this.iterator = iterator;
            this.current = iterator.next();
        }

        public V next() {
            V result = this.current;
            if (result != null) {
                this.current = this.iterator.hasNext() ? this.iterator.next() : null;
            }
            return result;
        }
    }
}

