/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.groovy;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyShell;
import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.util.ConfigObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.runtime.InvokerHelper;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.groovy.MetaClassDelegate;

public class GroovyBeanBuilder
extends GroovyObjectSupport {
    private ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
    private final Map<String, Class<?>> mapper = new HashMap();
    private final Map<String, Object> initialVariables = new HashMap<String, Object>();
    private final Map<String, Object> result = new HashMap<String, Object>();
    private Object currentBeanConfig;
    private List<String> staticStars = new ArrayList<String>();
    private static final CopyOnWriteArraySet<String> STATIC_STARS = new CopyOnWriteArraySet();
    private final AtomicInteger stack = new AtomicInteger(0);
    private Binding binding = new Binding(){

        public void setVariable(String name, Object value) {
            super.setVariable(name, value);
        }

        public Object getVariable(String name) {
            return super.getVariable(name);
        }

        public boolean hasVariable(String name) {
            return super.hasVariable(name);
        }
    };

    public static void addCommonStaticStars(String s) {
        STATIC_STARS.add(s);
    }

    public GroovyBeanBuilder() {
        this.staticStars.addAll(STATIC_STARS);
    }

    public void addStaticStars(String a) {
        this.staticStars.add(a);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public GroovyBeanBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Map<String, Class<?>> getMapper() {
        return this.mapper;
    }

    public GroovyBeanBuilder setMappedClass(String name, Class<?> clazz) {
        this.mapper.put(name, clazz);
        return this;
    }

    public GroovyBeanBuilder setInitialVariable(String name, Object variable) {
        this.initialVariables.put(name, variable);
        return this;
    }

    public Map<String, Object> getInitialVariables() {
        return this.initialVariables;
    }

    public Object getProperty(String property) {
        return super.getProperty(property);
    }

    public Object invokeMethod(String name, Object arg) {
        boolean setResult = this.currentBeanConfig == null;
        Object[] args = (Object[])arg;
        final Object o = this.initialVariables.get(name);
        if (o != null && !this.binding.hasVariable(name) && args.length >= 0 && args[0] instanceof Closure) {
            Closure c = new Closure((Object)this){
                private static final long serialVersionUID = -2778328821635253740L;

                public Object call(Object ... args) {
                    Object oldBean = GroovyBeanBuilder.this.currentBeanConfig;
                    GroovyBeanBuilder.this.currentBeanConfig = o;
                    Closure callable = (Closure)args[0];
                    callable.setDelegate((Object)this);
                    callable.setResolveStrategy(1);
                    callable.call(new Object[]{o});
                    GroovyBeanBuilder.this.currentBeanConfig = oldBean;
                    return null;
                }
            };
            return c.call(args);
        }
        try {
            Object result = args.length > 0 && args[0] instanceof Closure ? this.invokeBeanDefiningMethod(name, args) : (args.length > 0 && args[0] instanceof Class || args.length > 0 && args[0] instanceof Map ? this.invokeBeanDefiningMethod(name, args) : (args.length > 1 && args[args.length - 1] instanceof Closure ? this.invokeBeanDefiningMethod(name, args) : (this.mapper.containsKey(name) ? this.invokeBeanDefiningMethod(name, args) : super.invokeMethod(name, (Object)args))));
            if (setResult && result != null) {
                this.result.put(name, result);
            }
            Object c = result;
            return c;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.stack.getAndDecrement();
        }
    }

    public void setProperty(String property, Object newValue) {
        InvokerHelper.setProperty((Object)this.currentBeanConfig, (String)property, (Object)newValue);
    }

    public ConfigObject load(InputStream is) throws BGException {
        return this.load(is, null);
    }

    public ConfigObject load(InputStream is, String fileName) throws BGException {
        try {
            CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
            ImportCustomizer importCustomizer = new ImportCustomizer();
            try {
                importCustomizer.addStarImports(new String[]{Collectors.class.getPackage().getName()});
                for (String s : this.staticStars) {
                    ClassLoader cl = this.getClassLoader();
                    if (cl == null) {
                        cl = ((Object)((Object)this)).getClass().getClassLoader();
                    }
                    cl.loadClass(s);
                    importCustomizer.addStaticStars(new String[]{s});
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
            GroovyShell shell = this.classLoader == null ? new GroovyShell(this.binding, compilerConfiguration) : new GroovyShell(this.classLoader, this.binding, compilerConfiguration);
            Script script = fileName != null ? shell.parse((Reader)new InputStreamReader(is, "UTF-8"), fileName) : shell.parse((Reader)new InputStreamReader(is, "UTF-8"));
            MetaClass metaClass = script.getMetaClass();
            MetaClassDelegate d = new MetaClassDelegate(metaClass){

                @Override
                public Object invokeMethod(Object arg0, String arg1, Object[] arg2) {
                    return GroovyBeanBuilder.this.invokeMethod(arg1, arg2);
                }

                @Override
                public Object invokeMethod(Class arg0, Object arg1, String arg2, Object[] arg3, boolean arg4, boolean arg5) {
                    return GroovyBeanBuilder.this.invokeMethod(arg2, arg3);
                }

                @Override
                public Object invokeMethod(Object arg0, String arg1, Object arg2) {
                    return super.invokeMethod(arg0, arg1, arg2);
                }

                @Override
                public Object invokeMissingMethod(Object arg0, String arg1, Object[] arg2) {
                    return super.invokeMissingMethod(arg0, arg1, arg2);
                }

                @Override
                public Object getProperty(Object arg0, String arg1) {
                    try {
                        return super.getProperty(arg0, arg1);
                    }
                    catch (MissingPropertyException missingPropertyException) {
                        if (GroovyBeanBuilder.this.currentBeanConfig != null) {
                            try {
                                Object result = InvokerHelper.getProperty((Object)GroovyBeanBuilder.this.currentBeanConfig, (String)arg1);
                                if (result != null) {
                                    return result;
                                }
                            }
                            catch (MissingPropertyException result) {
                                // empty catch block
                            }
                        }
                        try {
                            return GroovyBeanBuilder.this.invokeBeanDefiningMethod(arg1, new Object[]{null});
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                            throw new MissingPropertyException(arg1, arg0.getClass(), (Throwable)e);
                        }
                    }
                }
            };
            script.setMetaClass((MetaClass)d);
            script.run();
            shell.getClassLoader().clearCache();
            ConfigObject result = new ConfigObject();
            result.putAll(this.initialVariables);
            result.putAll(this.result);
            ConfigObject configObject = result;
            return configObject;
        }
        catch (Throwable e) {
            throw new BGException("Error evaluating bean definition script: " + e.getMessage(), e);
        }
        finally {
            this.classLoader = null;
            this.result.clear();
            this.currentBeanConfig = null;
        }
    }

    protected void invokeBeanDefiningClosure(Closure<?> callable) {
        callable.setDelegate((Object)this);
        callable.call();
        callable.setDelegate((Object)this);
        callable.setResolveStrategy(1);
        callable.call(new Object[]{this.currentBeanConfig});
    }

    protected Object invokeBeanDefiningMethod(String name, Object[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> clazz;
        Class<?> beanClass;
        boolean hasClosureArgument;
        Object oldBean;
        Object newBean = oldBean = this.currentBeanConfig;
        boolean bl = hasClosureArgument = args.length > 0 && args[args.length - 1] instanceof Closure;
        if (args.length > 0 && args[0] instanceof Class) {
            Class<?> clazz2 = beanClass = args[0] instanceof Class ? (Class<?>)args[0] : args[0].getClass();
            if (args.length >= 1) {
                newBean = this.constructor(args, hasClosureArgument, beanClass, true);
            }
        } else if (args.length > 0 && args[0] instanceof Map) {
            if (args.length > 1 && args[1] instanceof Class) {
                List constructorArgs = this.resolveConstructorArguments(args, 2, hasClosureArgument ? args.length - 1 : args.length);
                newBean = ((Class)args[1]).getConstructor(this.resolveConstructorClasses(constructorArgs)).newInstance(constructorArgs.toArray());
                Map map = (Map)args[0];
                for (Object o : map.keySet()) {
                    String propName = (String)o;
                    InvokerHelper.setProperty((Object)newBean, (String)propName, map.get(propName));
                }
            } else {
                clazz = this.mapper.get(name);
                if (clazz != null) {
                    newBean = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
        } else if (this.mapper.containsKey(name)) {
            beanClass = this.mapper.get(name);
            newBean = args.length >= 1 ? this.constructor(args, hasClosureArgument, beanClass, false) : beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        } else if (args.length > 0 && args[0] instanceof Closure && (clazz = this.mapper.get(name)) != null) {
            newBean = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (newBean == oldBean) {
            newBean = new ConfigObject();
        }
        if (args.length > 0 && args[0] instanceof Map && (args.length <= 1 || !(args[1] instanceof Class))) {
            for (Map.Entry entry : ((Map)args[0]).entrySet()) {
                InvokerHelper.setProperty((Object)newBean, (String)((String)entry.getKey()), entry.getValue());
            }
        }
        this.binding.setVariable(name, newBean);
        this.currentBeanConfig = newBean;
        if (hasClosureArgument) {
            Closure callable = (Closure)args[args.length - 1];
            callable.setDelegate((Object)this);
            callable.setResolveStrategy(1);
            callable.call(new Object[]{newBean});
        }
        Object beanConfig = newBean;
        this.currentBeanConfig = oldBean;
        if (oldBean instanceof ConfigObject) {
            InvokerHelper.setProperty((Object)oldBean, (String)name, (Object)beanConfig);
        }
        return beanConfig;
    }

    private Object constructor(Object[] args, boolean hasClosureArgument, Class<?> beanClass, boolean hasClassArgument) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object newBean;
        int begin;
        int n = begin = hasClassArgument ? 1 : 0;
        if (hasClosureArgument) {
            if (args.length - 1 != begin) {
                List constructorArgs = this.resolveConstructorArguments(args, begin, args.length - 1);
                newBean = beanClass.getConstructor(this.resolveConstructorClasses(constructorArgs)).newInstance(constructorArgs.toArray());
            } else {
                newBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        } else {
            List constructorArgs = this.resolveConstructorArguments(args, begin, args.length);
            newBean = beanClass.getConstructor(this.resolveConstructorClasses(constructorArgs)).newInstance(constructorArgs.toArray());
        }
        return newBean;
    }

    protected List resolveConstructorArguments(Object[] args, int start, int end) {
        Object[] constructorArgs = this.subarray(args, start, end);
        this.filterGStringReferences(constructorArgs);
        return Arrays.asList(constructorArgs);
    }

    protected Class<?>[] resolveConstructorClasses(List list) {
        ArrayList result = new ArrayList();
        for (Object o : list) {
            result.add(o.getClass());
        }
        Class[] res = new Class[list.size()];
        return result.toArray(res);
    }

    protected void filterGStringReferences(Object[] constructorArgs) {
        for (int i = 0; i < constructorArgs.length; ++i) {
            Object constructorArg = constructorArgs[i];
            if (!(constructorArg instanceof GString)) continue;
            constructorArgs[i] = constructorArg.toString();
        }
    }

    protected Object[] subarray(Object[] args, int i, int j) {
        assert (j <= args.length) : "Upper bound can't be greater than array length";
        Object[] b = new Object[j - i];
        int n = 0;
        int k = i;
        while (k < j) {
            b[n] = args[k];
            ++k;
            ++n;
        }
        return b;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public static void main(String[] args) throws BGException, FileNotFoundException {
        GroovyBeanBuilder builder = new GroovyBeanBuilder();
        System.out.println(builder.load(new FileInputStream(new File("/Users/ildarfattakhov/Documents/servers/wildfly-18.0.1.Final/standalone/deployments/master.mybgbilling.war/WEB-INF/mybgbilling-menu.groovy"))).flatten());
    }
}

