/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.OceanTheme;

public class LookAndFeelUtils {
    private static HashSet<LookAndFeelTheme> lookAndFeelThemeSet;
    private static Comparator<LookAndFeelTheme> defaultComparator;
    public static final int DEFAULT_HEIGHT = 25;
    public static AtomicInteger BUTTON_HEIGHT;
    public static AtomicInteger COMBO_HEIGHT;
    private static Set<String> fontKeys;

    private static void processInstalled() {
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        HashSet<LookAndFeelTheme> lafs = new HashSet<LookAndFeelTheme>();
        block2: for (int i = 0; i < infos.length; ++i) {
            String lafClassName = infos[i].getClassName();
            for (LookAndFeelTheme t : lookAndFeelThemeSet) {
                if (!t.getLafClass().getName().equals(lafClassName)) continue;
                continue block2;
            }
            try {
                Class<?> clazz = Class.forName(lafClassName);
                lafs.add(new LookAndFeelTheme(clazz.asSubclass(LookAndFeel.class), null, infos[i].getName(), null));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        lookAndFeelThemeSet.addAll(lafs);
    }

    private static void processPgs() {
        try {
            Class<?> clazz = Class.forName("com.pagosoft.plaf.PgsLookAndFeel");
            Class<LookAndFeel> l = clazz.asSubclass(LookAndFeel.class);
            final Class[] params = new Class[]{};
            final Object[] args = new Object[]{};
            try {
                LookAndFeelUtils.addLookAndFeelTheme(new LookAndFeelTheme(l, Class.forName("com.pagosoft.plaf.themes.VistaTheme"), "PgsLookAndFeel", "VistaTheme"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LookAndFeelUtils.addLookAndFeelTheme(new LookAndFeelTheme(l, Class.forName("com.pagosoft.plaf.themes.SilverTheme"), "PgsLookAndFeel", "SilverTheme"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LookAndFeelUtils.addLookAndFeelTheme(new LookAndFeelTheme(l, Class.forName("com.pagosoft.plaf.themes.JGoodiesThemes").getMethod("getBrownSugar", params).invoke(null, args).getClass(), "PgsLookAndFeel", "JGoodiesTheme (BrownSugar)"){

                    @Override
                    protected Object getThemeInstance() throws Exception {
                        return Class.forName("com.pagosoft.plaf.themes.JGoodiesThemes").getMethod("getBrownSugar", params).invoke(null, args);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                LookAndFeelUtils.addLookAndFeelTheme(new LookAndFeelTheme(l, Class.forName("com.pagosoft.plaf.themes.JGoodiesThemes").getMethod("getDesertBlue", params).invoke(null, args).getClass(), "PgsLookAndFeel", "JGoodiesTheme (DesertBlue)"){

                    @Override
                    protected Object getThemeInstance() throws Exception {
                        return Class.forName("com.pagosoft.plaf.themes.JGoodiesThemes").getMethod("getDesertBlue", params).invoke(null, args);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                LookAndFeelUtils.addLookAndFeelTheme(new LookAndFeelTheme(l, Class.forName("com.pagosoft.plaf.themes.ElegantGrayTheme"), "PgsLookAndFeel", "ElegantGrayTheme"){

                    @Override
                    protected Object getThemeInstance() throws Exception {
                        return this.themeClass.getMethod("getInstance", params).invoke(null, args);
                    }
                });
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addLookAndFeelTheme(LookAndFeelTheme t) {
        lookAndFeelThemeSet.add(t);
    }

    public static List<LookAndFeelTheme> getLookAndFeelThemeList() {
        return LookAndFeelUtils.getLookAndFeelThemeList(defaultComparator);
    }

    public static List<LookAndFeelTheme> getLookAndFeelThemeList(Comparator<LookAndFeelTheme> comp) {
        ArrayList<LookAndFeelTheme> result = new ArrayList<LookAndFeelTheme>(lookAndFeelThemeSet);
        Collections.sort(result, comp);
        return result;
    }

    public static void setTheme(LookAndFeelTheme t) throws Exception {
        LookAndFeelUtils.setTheme(t, null);
    }

    public static void setTheme(LookAndFeelTheme t, Component component) throws Exception {
        if (t == null) {
            throw new NullPointerException();
        }
        LookAndFeel laf = !UIManager.getLookAndFeel().getClass().equals(t.getLafClass()) ? t.getLafClass().newInstance() : UIManager.getLookAndFeel();
        if (t.getThemeClass() != null) {
            if ("com.pagosoft.plaf.PgsLookAndFeel".equals(laf.getClass().getName())) {
                Class[] params = new Class[]{MetalTheme.class};
                Method method = Class.forName("com.pagosoft.plaf.PlafOptions").getMethod("setCurrentTheme", params);
                method.invoke(null, t.getThemeInstance());
                UIManager.put("TextArea.inactiveForeground", new Color(153, 153, 153));
                UIManager.put("TextPane.inactiveForeground", new Color(153, 153, 153));
                UIManager.put("TextField.inactiveForeground", new Color(153, 153, 153));
            } else if (laf instanceof MetalLookAndFeel && MetalTheme.class.isAssignableFrom(t.getThemeClass()) && !MetalLookAndFeel.getCurrentTheme().getClass().equals(t.getThemeClass())) {
                MetalLookAndFeel.setCurrentTheme((MetalTheme)t.getThemeInstance());
            }
        }
        UIManager.setLookAndFeel(laf);
        if (component != null) {
            component = SwingUtilities.getRoot(component);
            SwingUtilities.updateComponentTreeUI(component);
            component.repaint();
        }
    }

    public static LookAndFeelTheme getTheme(String lafName, String themeName) {
        for (LookAndFeelTheme t : lookAndFeelThemeSet) {
            if (!t.getLafName().equals(lafName) && !t.getLafClass().getName().equals(lafName) || (t.getThemeName() != null && t.getThemeName().length() != 0 || themeName != null && themeName.length() != 0) && (t.getThemeName() == null || !t.getThemeName().equals(themeName))) continue;
            return t;
        }
        for (LookAndFeelTheme t : lookAndFeelThemeSet) {
            if (!t.getLafName().equals(lafName) && !t.getLafClass().getName().equals(lafName)) continue;
            return t;
        }
        try {
            Class<LookAndFeel> clazz = Class.forName(lafName).asSubclass(LookAndFeel.class);
            return new LookAndFeelTheme(clazz, null, clazz.getSimpleName(), null);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void setTheme(String lafName, String themeName, Component component) throws Exception {
        LookAndFeelUtils.setTheme(LookAndFeelUtils.getTheme(lafName, themeName), component);
    }

    public static void setTheme(String lafName, String themeName) throws Exception {
        LookAndFeelUtils.setTheme(LookAndFeelUtils.getTheme(lafName, themeName), null);
    }

    public static LookAndFeelTheme getCurrent() {
        LookAndFeel laf = UIManager.getLookAndFeel();
        MetalTheme theme = "com.pagosoft.plaf.PgsLookAndFeel".equals(laf.getClass().getName()) ? MetalLookAndFeel.getCurrentTheme() : (laf instanceof MetalLookAndFeel ? MetalLookAndFeel.getCurrentTheme() : null);
        if (theme == null) {
            for (LookAndFeelTheme t : lookAndFeelThemeSet) {
                if (!t.getLafClass().equals(laf.getClass())) continue;
                return t;
            }
        } else {
            for (LookAndFeelTheme t : lookAndFeelThemeSet) {
                if (!t.getLafClass().equals(laf.getClass()) || !theme.getClass().equals(t.getThemeClass())) continue;
                try {
                    if ("com.pagosoft.plaf.PgsTheme".equals(t.themeClass.getName()) && !t.getThemeInstance().equals(theme)) continue;
                    return t;
                }
                catch (Exception exception) {
                }
            }
        }
        return new LookAndFeelTheme(laf.getClass(), null, laf.getName(), null);
    }

    public static void main(String[] args) {
        for (LookAndFeelTheme t : LookAndFeelUtils.getLookAndFeelThemeList()) {
            try {
                LookAndFeelUtils.setTheme(t.getLafName(), t.getThemeName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            LookAndFeelUtils.setTheme("Metal", "Ocean");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void processHeight(Font font, AtomicInteger size) {
        JButton b = new JButton();
        b.setText("Aaa");
        JTextField f = new JTextField();
        f.setText("Aaa");
        int a = b.getPreferredSize().height - f.getPreferredSize().height;
        int a2 = b.getMargin().top;
        int a3 = f.getMargin().top;
        int w = b.getMargin().left;
        UIManager.put("Button.margin", new InsetsUIResource(a2, w, a2, w));
        UIManager.put("ToggleButton.margin", new InsetsUIResource(2, w, 2, w));
        UIManager.put("TextField.margin", new InsetsUIResource(a3 + (a /= 2), 1, a3 + a, 1));
        UIManager.put("PasswordField.margin", new InsetsUIResource(a3 + a, 1, a3 + a, 1));
        if (font != null) {
            if (font.getSize() <= 10) {
                size.set(20);
            } else if (font.getSize() <= 11) {
                size.set(23);
            } else {
                size.set(25);
            }
        } else {
            size.set(25);
        }
        b = new JButton();
        b.setText("Aaa");
        f = new JTextField();
        f.setText("Aaa");
        BUTTON_HEIGHT.set(Math.max(22, b.getPreferredSize().height));
    }

    public static void setFont(Font myFont) {
        for (String key : fontKeys) {
            UIManager.put(key, myFont);
        }
    }

    public static void setFontSize(float size, FontUIResource defaultFont) {
        for (String key : fontKeys) {
            LookAndFeelUtils.setFontSize(key, size, defaultFont);
        }
    }

    public static void setFontSize(String key, float size, FontUIResource defaultFont) {
        Font font = UIManager.getFont(key);
        if (font != null) {
            UIManager.put(key, new FontUIResource(font.deriveFont(size)));
        } else if (defaultFont != null) {
            UIManager.put(key, defaultFont);
        }
    }

    public static void setStyle(String key, int style) {
        Font font = UIManager.getFont(key);
        if (font != null) {
            UIManager.put(key, new FontUIResource(font.deriveFont(style)));
        }
    }

    public static void minFontSize(int size) {
        JButton b = new JButton();
        b.setText("Aaa");
        int w = b.getMargin().left;
        if (size == -1) {
            LookAndFeelUtils.setFontSize(11.0f, null);
            LookAndFeelUtils.setStyle("Button.font", 1);
            LookAndFeelUtils.setStyle("ToggleButton.font", 1);
            LookAndFeelUtils.setStyle("List.font", 1);
            LookAndFeelUtils.setStyle("Menu.font", 1);
            LookAndFeelUtils.setStyle("ComboBox.font", 1);
            w = Math.min(w, 12);
            UIManager.put("Button.margin", new InsetsUIResource(2, w, 2, w));
        } else if (size < -1) {
            LookAndFeelUtils.setFontSize(10.0f, null);
            w = Math.min(w, 4);
            UIManager.put("Button.margin", new InsetsUIResource(1, w, 1, w));
        } else if (size == 1) {
            w = Math.min(w, 14);
            Iterator i = UIManager.getLookAndFeelDefaults().keySet().iterator();
            while (i.hasNext()) {
                String key = String.valueOf(i.next());
                if (!key.endsWith(".font")) continue;
                Font font = UIManager.getFont(key);
                Font biggerFont = font.deriveFont(1.5f * font.getSize2D());
                UIManager.put(key, biggerFont);
            }
            UIManager.put("Button.margin", new InsetsUIResource(2, w, 2, w));
        } else if (size >= 0) {
            w = Math.min(w, 14);
            UIManager.put("Button.margin", new InsetsUIResource(2, w, 2, w));
        }
        Font font = UIManager.getFont("Button.font");
        LookAndFeelUtils.processHeight(font, BUTTON_HEIGHT);
    }

    public static void updateOnChangeLookAndFeel(Container container) {
        final WeakReference<Container> ref = new WeakReference<Container>(container);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("lookAndFeel".equals(evt.getPropertyName())) {
                    Container c = (Container)ref.get();
                    if (c != null) {
                        SwingUtilities.updateComponentTreeUI(c);
                    } else {
                        UIManager.removePropertyChangeListener(this);
                    }
                }
            }
        };
        UIManager.addPropertyChangeListener(pcl);
    }

    static {
        Class<LookAndFeel> lafClass;
        Class<?> clazz;
        lookAndFeelThemeSet = new HashSet();
        lookAndFeelThemeSet.add(new LookAndFeelTheme(MetalLookAndFeel.class, DefaultMetalTheme.class, "Metal", null));
        LookAndFeelUtils.addLookAndFeelTheme(new LookAndFeelTheme(MetalLookAndFeel.class, OceanTheme.class, "Metal", "OceanTheme"));
        try {
            if (System.getProperty("os.name").startsWith("Windows")) {
                clazz = Class.forName("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                lafClass = clazz.asSubclass(LookAndFeel.class);
                LookAndFeelUtils.addLookAndFeelTheme(new LookAndFeelTheme(lafClass, null, "Windows", null));
            }
        }
        catch (ClassNotFoundException clazz2) {
            // empty catch block
        }
        try {
            clazz = Class.forName("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            lafClass = clazz.asSubclass(LookAndFeel.class);
            LookAndFeelUtils.addLookAndFeelTheme(new LookAndFeelTheme(lafClass, null, "Motif", null));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        LookAndFeelUtils.processPgs();
        LookAndFeelUtils.processInstalled();
        defaultComparator = new Comparator<LookAndFeelTheme>(){

            @Override
            public int compare(LookAndFeelTheme t1, LookAndFeelTheme t2) {
                String tn1 = t1.themeName != null ? t1.themeName : "";
                String tn2 = t2.themeName != null ? t2.themeName : "";
                return t1.lafName.compareTo(t2.lafName) * 100000 + tn1.compareTo(tn2);
            }
        };
        BUTTON_HEIGHT = new AtomicInteger(25);
        COMBO_HEIGHT = new AtomicInteger(25);
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("lookAndFeel".equals(evt.getPropertyName())) {
                    Font font = UIManager.getFont("Button.font");
                    LookAndFeelUtils.processHeight(font, BUTTON_HEIGHT);
                }
            }
        });
        fontKeys = new HashSet<String>();
        fontKeys.add("MenuBar.font");
        fontKeys.add("MenuItem.font");
        fontKeys.add("Menu.font");
        fontKeys.add("Menu.acceleratorFont");
        fontKeys.add("PopupMenu.font");
        fontKeys.add("MenuItem.acceleratorFont");
        fontKeys.add("OptionPane.messageFont");
        fontKeys.add("OptionPane.font");
        fontKeys.add("OptionPane.buttonFont");
        fontKeys.add("TextPane.font");
        fontKeys.add("TextField.font");
        fontKeys.add("FormattedTextField.font");
        fontKeys.add("PasswordField.font");
        fontKeys.add("TextArea.font");
        fontKeys.add("RadioButton.font");
        fontKeys.add("EditorPane.font");
        fontKeys.add("CheckBox.font");
        fontKeys.add("ComboBox.font");
        fontKeys.add("CheckBoxMenuItem.acceleratorFont");
        fontKeys.add("CheckBoxMenuItem.font");
        fontKeys.add("RadioButtonMenuItem.acceleratorFont");
        fontKeys.add("RadioButtonMenuItem.font");
        fontKeys.add("Tree.font");
        fontKeys.add("Panel.font");
        fontKeys.add("Label.font");
        fontKeys.add("ScrollPane.font");
        fontKeys.add("Viewport.font");
        fontKeys.add("TableHeader.font");
        fontKeys.add("Table.font");
        fontKeys.add("TabbedPane.font");
        fontKeys.add("List.font");
        fontKeys.add("ToolBar.font");
        fontKeys.add("ToggleButton.font");
        fontKeys.add("Button.font");
        fontKeys.add("InternalFrame.titleFont");
        fontKeys.add("ToolTip.font");
        fontKeys.add("TitledBorder.font");
    }

    public static class LookAndFeelTheme {
        private Class<? extends LookAndFeel> lafClass;
        protected Class<?> themeClass;
        private String lafName;
        private String themeName;

        public LookAndFeelTheme(Class<? extends LookAndFeel> lafClass, Class<?> themeClass, String lafName, String themeName) {
            this.lafClass = lafClass;
            this.themeClass = themeClass;
            this.lafName = lafName;
            this.themeName = themeName;
        }

        public Class<? extends LookAndFeel> getLafClass() {
            return this.lafClass;
        }

        public String getLafName() {
            return this.lafName;
        }

        public Class<?> getThemeClass() {
            return this.themeClass;
        }

        public String getThemeName() {
            return this.themeName;
        }

        public int hashCode() {
            if (this.lafClass != null) {
                if (this.themeClass != null) {
                    return this.lafClass.hashCode() ^ this.themeClass.hashCode();
                }
                return this.lafClass.hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (o instanceof LookAndFeelTheme) {
                LookAndFeelTheme t = (LookAndFeelTheme)o;
                if (t.lafClass.equals(this.lafClass) && (t.themeClass == null && this.themeClass == null || t.themeClass != null && t.themeClass.equals(this.themeClass) && (t.themeName == null && this.themeName == null || t.themeName != null && t.themeName.equals(this.themeName)))) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.lafName + (String)(this.themeName != null ? " " + this.themeName : "");
        }

        protected Object getThemeInstance() throws Exception {
            if (this.themeClass != null) {
                return this.themeClass.newInstance();
            }
            return null;
        }
    }
}

