/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroupTariff;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class TariffGroupDao
extends AbstractIdDao<TariffGroup>
implements Directory<TariffGroup> {
    private static final Logger logger = LogManager.getLogger();
    private PreparedStatement loadPlanListPS;

    public TariffGroupDao(Connection con) {
        super(con, 0, "tariff_group");
    }

    public List<TariffGroup> getTariffGroupList(int domainId) throws BGException {
        return this.list("domain_id", "title", domainId);
    }

    @Deprecated
    public Map<Integer, TariffGroup> getTariffGroupMap() {
        HashMap<Integer, TariffGroup> result = new HashMap<Integer, TariffGroup>();
        try {
            String query = "SELECT * FROM tariff_group";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                TariffGroup tpg = this.getFromRS(rs);
                result.put(tpg.getId(), tpg);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Map<Integer, TariffGroup> getTariffGroupMap(String ids) {
        HashMap<Integer, TariffGroup> result = new HashMap<Integer, TariffGroup>();
        try {
            String query = "SELECT * FROM tariff_group WHERE id IN (" + ids + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                TariffGroup tpg = this.getFromRS(rs);
                result.put(tpg.getId(), tpg);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public TariffGroup getTariffGroupById(int id) {
        try {
            return (TariffGroup)this.get(id);
        }
        catch (BGException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public Map<Integer, TariffGroup> getTariffGroupMask() {
        HashMap<Integer, TariffGroup> result = new HashMap<Integer, TariffGroup>();
        try {
            String query = "SELECT * FROM tariff_group";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                TariffGroup group = this.getFromRS(rs);
                result.put(group.getId(), group);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private void updateGroupTariffList(TariffGroup tariffGroup) throws SQLException {
        this.deleteGroupTariffList(tariffGroup.getId());
        if (tariffGroup.getPlanList() != null) {
            String query = "INSERT INTO tariff_group_tariff (tgid, tpid, date1, date2, comment) VALUES (?, ?, ?, ?, ?)";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, tariffGroup.getId());
            for (TariffGroupTariff plan : tariffGroup.getPlanList()) {
                ps.setInt(2, plan.getId());
                ps.setDate(3, TimeUtils.convertDateToSqlDate(plan.getDate1()));
                ps.setDate(4, TimeUtils.convertDateToSqlDate(plan.getDate2()));
                ps.setString(5, plan.getComment());
                ps.executeUpdate();
            }
            ps.close();
        }
    }

    private void deleteGroupTariffList(int tariffGroupId) throws SQLException {
        String query = "DELETE FROM tariff_group_tariff WHERE tgid=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, tariffGroupId);
        ps.executeUpdate();
        ps.close();
    }

    @Override
    public TariffGroup get(String title) throws BGException {
        return (TariffGroup)super.get("title=?", title);
    }

    @Override
    public List<TariffGroup> list() throws BGException {
        return super.list(null, "title", new Object[0]);
    }

    @Override
    protected TariffGroup getFromRS(ResultSet rs) throws SQLException, BGException {
        TariffGroup tariffGroup = new TariffGroup();
        tariffGroup.setId(rs.getInt("id"));
        tariffGroup.setTitle(rs.getString("title"));
        tariffGroup.setTransferMode(rs.getInt("tm"));
        tariffGroup.setDaysForward(rs.getInt("df"));
        tariffGroup.setPos(rs.getInt("pos"));
        tariffGroup.setDomainId(rs.getInt("domain_id"));
        if (this.loadPlanListPS == null) {
            this.loadPlanListPS = this.con.prepareStatement("SELECT `group`.tpid, tariff.title, `group`.date1, `group`.date2, `group`.comment FROM tariff_group_tariff as `group` LEFT JOIN tariff_plan as `tariff` ON tariff.id=`group`.tpid WHERE `group`.tgid=?");
        }
        this.loadPlanListPS.setInt(1, tariffGroup.getId());
        tariffGroup.setPlanList(new ArrayList<TariffGroupTariff>());
        ResultSet planListRS = this.loadPlanListPS.executeQuery();
        while (planListRS.next()) {
            int tariffId = planListRS.getInt(1);
            String tariffTitle = planListRS.getString(2);
            Date date1 = TimeUtils.convertSqlDateToDate(planListRS.getDate(3));
            Date date2 = TimeUtils.convertSqlDateToDate(planListRS.getDate(4));
            String comment = planListRS.getString(5);
            tariffGroup.addPlanList(tariffId, tariffTitle, date1, date2, comment);
        }
        planListRS.close();
        return tariffGroup;
    }

    @Override
    protected void updateImpl(TariffGroup tariffGroup) throws BGException, SQLException {
        boolean insert = tariffGroup.getId() < 1;
        String query = (insert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET title=?, tm=?, df=?, pos=?, domain_id=?" + (insert ? "" : " WHERE id=?");
        PreparedStatement ps = this.con.prepareStatement(query, 1);
        int parameterIndex = 1;
        ps.setString(parameterIndex++, tariffGroup.getTitle());
        ps.setInt(parameterIndex++, tariffGroup.getTransferMode());
        ps.setInt(parameterIndex++, tariffGroup.getDaysForward());
        ps.setInt(parameterIndex++, tariffGroup.getPos());
        ps.setInt(parameterIndex++, tariffGroup.getDomainId());
        if (!insert) {
            ps.setInt(parameterIndex++, tariffGroup.getId());
        }
        ps.executeUpdate();
        if (insert) {
            tariffGroup.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
        this.updateGroupTariffList(tariffGroup);
    }

    @Override
    public void close() throws BGException {
        super.close();
        try {
            if (this.loadPlanListPS != null && !this.loadPlanListPS.isClosed()) {
                this.loadPlanListPS.close();
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }
}

