/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import bitel.billing.server.radius.Antispam;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.kernel.network.ip.IpAddressSet;
import ru.bitel.bgbilling.kernel.network.processor.ProcessorRequest;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListener;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorkerContext;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.RadiusSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.common.model.Idable;
import ru.bitel.common.sql.ConnectionSet;

public class RadiusListenerWorker<N extends Nas<?, ?, ?>>
extends ProcessorRequest<RadiusListenerWorkerContext> {
    protected static final Logger logger = LogManager.getLogger();
    protected static final Logger loggerUpdate = LogManager.getLogger((String)(RadiusListenerWorker.class.getName() + ".update"));
    private final RadiusListener.Mode mode;
    protected final RadiusProcessor<?, N, ?> processor;
    private final RadiusListener<N> listener;
    protected final int overloadLevel;
    protected RadiusPacket request;
    protected RadiusSession<N, ?> radiusSession;
    protected N nas;
    protected int agentDeviceId;
    protected Object agentDevice;
    protected int accessCode;
    protected final IpAddressSet ipAddressSet = new IpAddressSet();
    protected RadiusPacket response;
    private boolean connectionModified;
    private Object circuitId;
    private int contractId;
    private int accountId;
    private boolean skip = false;
    private int connectionType = 0;
    protected static final ThreadLocal<RadiusListenerWorker<?>> worker = new ThreadLocal();

    public RadiusListenerWorker(RadiusListener<N> listener, SocketAddress clientAddress, long millis, ByteBuffer data, int overloadLevel) {
        super(listener, clientAddress, millis, data);
        this.listener = listener;
        this.mode = listener.mode;
        this.processor = listener.processor;
        this.overloadLevel = overloadLevel;
    }

    public int getAgentDeviceId() {
        return this.agentDeviceId;
    }

    public void setAgentDeviceId(int agentDeviceId) {
        this.agentDeviceId = agentDeviceId;
    }

    public Object getAgentDevice() {
        return this.agentDevice;
    }

    public void setAgentDevice(Object agentDevice) {
        this.agentDevice = agentDevice;
    }

    public boolean isConnectionModified() {
        return this.connectionModified;
    }

    public void setConnectionModified(boolean connectionModified) {
        this.connectionModified = connectionModified;
    }

    public IpAddressSet getIpAddressSet() {
        return this.ipAddressSet;
    }

    public Object getCircuitId() {
        return this.circuitId;
    }

    public void setCircuitId(Object circuitId) {
        this.circuitId = circuitId;
    }

    @Override
    public void runImpl() {
        worker.set(this);
        try {
            this.processPacket();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            worker.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket() throws Exception {
        boolean isAccountingUpdate;
        int accountingStatusType;
        if (this.overloadLevel > 0) {
            long millis = System.currentTimeMillis();
            long delta = millis - this.millis;
            if (delta > 5000L) {
                logger.warn("Due to high load skip packet processing what was recieved > 5 sec ago.");
                return;
            }
            this.request = RadiusPacket.parse(this.data);
            if (this.request.getCode() != 4) {
                if (this.overloadLevel > 1) {
                    if (delta > 1800L) {
                        logger.warn("Due to high load skip packet processing what was recieved > 2 sec ago.");
                        return;
                    }
                } else if (delta > 2300L) {
                    logger.warn("Due to high load skip packet processing what was recieved > 2 sec ago.");
                    return;
                }
            }
            isAccountingUpdate = (accountingStatusType = this.request.getIntAttribute(-1, 40, -1).intValue()) == 3;
            this.nas = this.processor.getNas(this.clientAddress, this.request);
            if (this.nas == null) {
                logger.error("NAS not found for packet (check radius.deviceTypeIds param for Inet/Voice): " + this.request.toString());
                return;
            }
            if (this.overloadLevel > 1 && this.request.getCode() == 4) {
                if (isAccountingUpdate) {
                    logger.warn("Update packet skipping.");
                    this.processor.accountingUpdateIgnoreCount.addRequestCount();
                    this.sendReponse(this.nas, this.request.createResponse());
                    return;
                }
                if ((this.overloadLevel > 2 || accountingStatusType == 1) && this.listener.isSkipAccountingRequestsOnSlow()) {
                    logger.warn("Start/stop packet skipping.");
                    this.processor.accountingIgnoreCount.addRequestCount();
                    this.sendReponse(this.nas, this.request.createResponse());
                    return;
                }
            }
        } else {
            this.request = RadiusPacket.parse(this.data);
            accountingStatusType = this.request.getIntAttribute(-1, 40, -1);
            isAccountingUpdate = accountingStatusType == 3;
            this.nas = this.processor.getNas(this.clientAddress, this.request);
            if (this.nas == null) {
                logger.error("NAS not found for packet (check radius.deviceTypeIds param for Inet/Voice): " + this.request.toString());
                return;
            }
        }
        byte packetType = this.request.getCode();
        if (this.request.authenticator == null) {
            logger.error("Incorrect request auth!!!");
        } else {
            this.request.vendorCode = ((Nas)this.nas).getVendorCode();
            if (((Nas)this.nas).isCheckMessageAuthenticator() && (this.request.getAttribute(-1, 79) != null || this.request.getAttribute(-1, 109) != null) && RadiusUtils.checkMessageAuthenticator(this.request, this.data, ((Nas)this.nas).getSecret()) <= 0) {
                logger.warn("Check message authenticator fault for packet " + this.request.toString());
                return;
            }
            RadiusUtils.decryptPassword(this.request, ((Nas)this.nas).getSecret());
            this.response = this.request.createResponse();
            assert (this.millis != 0L);
            Date time = new Date(this.millis);
            if (packetType == 1 && (this.mode == RadiusListener.Mode.authentication || this.mode == RadiusListener.Mode.both)) {
                logger.info("REQUEST:\n" + this.request.toString());
                if (Antispam.getAntispam().needBan(this.request)) {
                    logger.info("Blocked for multiple rejects");
                    this.sendReponse(this.nas, this.response);
                    logger.info("RESPONSE:\n" + this.response.toString());
                    this.processor.antispamIgnoreCount.addRequestCount();
                    return;
                }
                ConnectionSet connectionSet = ((RadiusListenerWorkerContext)this.context).getConnectionSet();
                try {
                    this.accessRequest(this.nas, this.request, this.response, connectionSet, time);
                    connectionSet.commit();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    connectionSet.recycle();
                }
                byte responseType = this.response.getCode();
                if (responseType == 3) {
                    Antispam.getAntispam().addReject(this.request);
                    this.processor.authenticationRejectCounter.addRequestCount();
                } else {
                    this.processor.authenticationAcceptCounter.addRequestCount();
                }
            } else if (packetType == 4 && (this.mode == RadiusListener.Mode.accounting || this.mode == RadiusListener.Mode.both)) {
                this.processAccountingRequest(this.nas, accountingStatusType, isAccountingUpdate, time);
            } else {
                logger.error("Packet type " + this.request.getCode() + " recieved by " + this.mode + " listener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAccountingRequest(N nas, int accountingStatusType, boolean isAccountingUpdate, Date time) throws InvalidKeyException, NoSuchAlgorithmException, IOException {
        if (isAccountingUpdate) {
            loggerUpdate.info("REQUEST:\n" + this.request.toString());
        } else {
            logger.info("REQUEST:\n" + this.request.toString());
        }
        switch (((Nas)nas).getResponseSendMode()) {
            default: {
                ConnectionSet connectionSet = ((RadiusListenerWorkerContext)this.context).getConnectionSet();
                try {
                    this.accountingRequest(nas, this.request, this.response, connectionSet, time);
                    connectionSet.commit();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    connectionSet.recycle();
                }
                this.sendReponse(nas, this.response);
                if (isAccountingUpdate) {
                    loggerUpdate.info("RESPONSE:\n" + this.response.toString());
                    this.processor.accountingUpdateCounter.addRequestCount();
                    break;
                }
                logger.info("RESPONSE:\n" + this.response.toString());
                if (accountingStatusType == 1) {
                    this.processor.accountingStartCounter.addRequestCount();
                    break;
                }
                if (accountingStatusType != 2) break;
                this.processor.accountingStopCounter.addRequestCount();
                break;
            }
            case 1: {
                if (isAccountingUpdate) {
                    this.sendReponse(nas, this.response);
                    loggerUpdate.info("RESPONSE:\n" + this.response.toString());
                    this.processor.accountingUpdateCounter.addRequestCount();
                }
                ConnectionSet connectionSet = ((RadiusListenerWorkerContext)this.context).getConnectionSet();
                try {
                    this.accountingRequest(nas, this.request, this.response, connectionSet, time);
                    connectionSet.commit();
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                }
                finally {
                    connectionSet.recycle();
                }
                if (isAccountingUpdate) break;
                this.sendReponse(nas, this.response);
                logger.info("RESPONSE:\n" + this.response.toString());
                if (accountingStatusType == 1) {
                    this.processor.accountingStartCounter.addRequestCount();
                    break;
                }
                if (accountingStatusType != 2) break;
                this.processor.accountingStopCounter.addRequestCount();
                break;
            }
            case 2: {
                this.sendReponse(nas, this.response);
                if (isAccountingUpdate) {
                    loggerUpdate.info("RESPONSE:\n" + this.response.toString());
                    this.processor.accountingUpdateCounter.addRequestCount();
                } else {
                    logger.info("RESPONSE:\n" + this.response.toString());
                    if (accountingStatusType == 1) {
                        this.processor.accountingStartCounter.addRequestCount();
                    } else if (accountingStatusType == 2) {
                        this.processor.accountingStopCounter.addRequestCount();
                    }
                }
                ConnectionSet connectionSet = ((RadiusListenerWorkerContext)this.context).getConnectionSet();
                try {
                    this.accountingRequest(nas, this.request, this.response, connectionSet, time);
                    connectionSet.commit();
                    break;
                }
                catch (Throwable t) {
                    logger.error(t.getMessage(), t);
                    break;
                }
                finally {
                    connectionSet.recycle();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accessRequest0(N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) throws BGException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        try {
            this.processor.accessRequest(this, nas, 0, request, response, connectionSet);
        }
        finally {
            this.sendReponse(nas, response);
            logger.info("RESPONSE:\n" + response.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accessRequest(N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) throws BGException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        ConnectionLogEntry entry = null;
        if (ConnectionLogEntry.coordEnable) {
            int[] coords = new int[3];
            this.data.rewind();
            ((RadiusListenerWorkerContext)this.context).writeRecord((Idable)nas, coords, this.data, time.getTime());
            entry = new ConnectionLogEntry();
            entry.setApplicationId(this.processor.applicationId);
            entry.setDeviceId(((Nas)nas).getId());
            entry.setDevicePort(request.getIntAttribute(-1, 5, 0));
            entry.setTime(time);
            entry.setAcctSessId(request.getStringAttribute(-1, 44, ""));
            entry.setLogType(1);
            entry.setRequestDataLogId(coords[0]);
            entry.setRequestChunkId(coords[1]);
            entry.setRequestPosition(coords[2]);
        }
        try {
            this.processor.accessRequest(this, nas, 0, request, response, connectionSet);
        }
        finally {
            ByteBuffer responseData = ByteBuffer.allocate(4096);
            response.write(responseData, ((Nas)nas).getSecret());
            responseData.flip();
            if (ConnectionLogEntry.coordEnable) {
                int[] coords = new int[3];
                ((RadiusListenerWorkerContext)this.context).writeRecord((Idable)nas, coords, responseData, time.getTime());
                responseData.rewind();
                entry.setResponseDataLogId(coords[0]);
                entry.setResponseChunkId(coords[1]);
                entry.setResponsePosition(coords[2]);
                ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(connectionSet, this.processor.moduleId);
                dataLogEntryDao.update(entry);
            }
            this.send(this.clientAddress, responseData);
            logger.info("RESPONSE:\n" + response.toString());
        }
    }

    protected void accountingRequest(N nas, RadiusPacket request, RadiusPacket response, ConnectionSet connectionSet, Date time) throws BGException, InvalidKeyException, NoSuchAlgorithmException, IOException {
        if (ConnectionLogEntry.coordEnable) {
            int[] coords = new int[3];
            ((RadiusListenerWorkerContext)this.context).writeRecord((Idable)nas, coords, this.data, time.getTime());
            ConnectionLogEntry entry = new ConnectionLogEntry();
            entry.setApplicationId(this.processor.applicationId);
            entry.setDeviceId(((Nas)nas).getId());
            entry.setDevicePort(request.getIntAttribute(-1, 5, 0));
            entry.setTime(time);
            entry.setAcctSessId(request.getStringAttribute(-1, 44, ""));
            entry.setLogType(2);
            entry.setRequestDataLogId(coords[0]);
            entry.setRequestChunkId(coords[1]);
            entry.setRequestPosition(coords[2]);
            new ConnectionLogEntryDao(connectionSet, this.processor.moduleId).update(entry);
        }
        this.processor.accountingRequest(this, nas, request, response, connectionSet, time);
    }

    protected ByteBuffer sendReponse(N nas, RadiusPacket response) throws InvalidKeyException, NoSuchAlgorithmException, IOException {
        ByteBuffer bb = ByteBuffer.allocate(4096);
        response.write(bb, ((Nas)nas).getSecret());
        bb.flip();
        this.send(this.clientAddress, bb);
        return bb;
    }

    public ServerContext getConext() {
        return (ServerContext)this.context;
    }

    public RadiusSession<N, ?> getRadiusSession() {
        return this.radiusSession;
    }

    public RadiusPacket getRequest() {
        return this.request;
    }

    public RadiusPacket getResponse() {
        return this.response;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    public int getContractId() {
        return this.contractId;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean dismiss) {
        this.skip = dismiss;
    }

    public int getConnectionType() {
        if (this.connectionType != 0) {
            return this.connectionType;
        }
        int skatServceType = this.request.getIntAttribute(43823, 6, 0);
        switch (skatServceType) {
            case 1: {
                this.connectionType = 8704;
                break;
            }
            case 7: {
                this.connectionType = 16896;
                break;
            }
            default: {
                this.connectionType = 512;
            }
        }
        return this.connectionType;
    }
}

