/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.AbstractConsumer;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PoolEventList;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.WorkerTask;

public final class Consumer
extends AbstractConsumer
implements MessageListener {
    private static final Logger logger = LogManager.getLogger();
    private static final Logger elRunnableLogger = LogManager.getLogger(EventListenerRunnable.class);

    public Consumer(EventProcessor eventProcessor, Session session, Class<? extends Event> clazz, EventType type, int moduleId, int pluginId, String destination, String query, boolean setMessageListener, boolean localSession) throws JMSException, JAXBException {
        super(eventProcessor, session, clazz, type, moduleId, pluginId, destination, query, setMessageListener, localSession);
    }

    public Consumer(EventProcessor eventProcessor, Session session, int moduleId, int pluginId, String destination, String query, boolean queue, boolean noLocal, int deliveryMode, int priority, long timeToLive, boolean localSession, Class<? extends Event> ... clazz) throws JMSException, JAXBException {
        super(eventProcessor, session, moduleId, pluginId, destination, query, queue, noLocal, deliveryMode, priority, timeToLive, localSession, clazz);
    }

    @Override
    protected boolean onMessage0(Message message, EventListenerContext eventListenerContext, EventListener<Event> listener) throws JMSException, JAXBException, BGException {
        Event e = (Event)this.parseMessage(message);
        if (e instanceof PoolEventList) {
            for (Event ee : ((PoolEventList)e).list) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Caught " + message.getStringProperty("bg:app") + ":" + ee);
                }
                try {
                    listener.notify(ee, eventListenerContext);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                eventListenerContext.commit();
            }
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Caught from " + message.getStringProperty("bg:app") + " " + e);
        }
        try {
            listener.notify(e, eventListenerContext);
            eventListenerContext.commit();
            this.trySendReply(message, e, null);
            return true;
        }
        catch (Exception ex) {
            this.trySendReply(message, e, ex);
            logger.error(ex.getMessage(), (Throwable)ex);
            eventListenerContext.recycle();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        if (this.eventProcessor.executor == null) {
            Object parentContext = ThreadContext.get();
            try {
                ThreadContext.set(this.eventListenerContext);
                this.onMessage0(message, this.eventListenerContext, this);
            }
            catch (Exception ex) {
                logger.error(this.destination + ": " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (parentContext != null) {
                    ThreadContext.set(parentContext);
                }
                this.eventListenerContext.recycle();
            }
        } else {
            this.eventProcessor.executor.execute(new EventListenerRunnable(message, this));
        }
    }

    static final class EventListenerRunnable
    extends WorkerTask<EventListenerContext>
    implements Runnable {
        private final Message message;
        private final AbstractConsumer consumer;

        protected EventListenerRunnable(Message message, AbstractConsumer consumer) {
            this.message = message;
            this.consumer = consumer;
        }

        @Override
        protected void runImpl() {
            try {
                this.consumer.onMessage0(this.message, (EventListenerContext)this.context, this.consumer);
            }
            catch (Exception ex) {
                elRunnableLogger.error(this.consumer.destination + ": " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

