/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicCodeTemplateEditPanel;
import ru.bitel.bgbilling.kernel.dynamic.common.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.common.templates.CustomTemplate;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.table.Column;
import ru.bitel.common.model.SearchResult;

public class DynamicCodeTemplatePanel
extends BGUTabPanel {
    private BGUTable templateTable;
    protected CustomTemplateTableModel model;
    private JLabel recordCountLabel = new JLabel();
    private BGControlPanelPages page = new BGControlPanelPages();
    protected DynamicCodeTemplateEditPanel templateEditPanel;
    protected JPanel tablePanel;
    protected DynamicCodeService dynCodeService;

    public DynamicCodeTemplatePanel(ClientContext clientContext) {
        super(clientContext);
        this.dynCodeService = clientContext.getPort(DynamicCodeService.class);
        this.page.setKey(this.getClass().getName());
    }

    @Override
    protected void jbInit() {
        this.model = new CustomTemplateTableModel();
        this.templateTable = new BGUTable(this.model);
        this.templateTable.setSelectionMode(0);
        this.templateTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    DynamicCodeTemplatePanel.this.performAction("edit");
                }
            }
        });
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 2, new Insets(3, 0, 0, 0), 0, 0));
        this.tablePanel.add((Component)new JScrollPane(this.templateTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.templateEditPanel = new DynamicCodeTemplateEditPanel(this);
        this.templateEditPanel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.templateEditPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.performAction("refresh");
    }

    private JPanel getFilterPanel() {
        this.page.init();
        this.page.addPropertyChangeListener(evt -> this.performAction("refresh"));
        JPanel pagePanel = new JPanel(new GridBagLayout());
        pagePanel.add((Component)this.recordCountLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 3, 0, 3), 0, 0));
        pagePanel.add((Component)this.page, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 3), 0, 0));
        return pagePanel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "new"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                DynamicCodeTemplatePanel.this.templateEditPanel.fillPanelEditor(null);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", ""){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                if (DynamicCodeTemplatePanel.this.model.getSelectedRow() == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435");
                    return;
                }
                DynamicCodeTemplatePanel.this.templateEditPanel.fillPanelEditor((CustomTemplate)DynamicCodeTemplatePanel.this.model.getSelectedRow());
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", ""){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                CustomTemplate template = (CustomTemplate)DynamicCodeTemplatePanel.this.model.getSelectedRow();
                if (template == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435");
                    return;
                }
                if (ClientUtils.confirm("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430")) {
                    DynamicCodeTemplatePanel.this.dynCodeService.deleteTepmlate(template.getId());
                    DynamicCodeTemplatePanel.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws Exception {
                SearchResult<CustomTemplate> customTemplateResult = DynamicCodeTemplatePanel.this.dynCodeService.getTemplateList(DynamicCodeTemplatePanel.this.page.getPage());
                DynamicCodeTemplatePanel.this.model.setData(customTemplateResult.getList());
                DynamicCodeTemplatePanel.this.page.setPage(customTemplateResult.getPage());
                DynamicCodeTemplatePanel.this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + customTemplateResult.getPage().getRecordCount());
            }
        };
    }

    protected JPanel getTablePanel() {
        return this.tablePanel;
    }

    class CustomTemplateTableModel
    extends BGTableModel<CustomTemplate> {
        private Directory<UserInfo> userDirectory;

        public CustomTemplateTableModel() {
            super(CustomTemplateTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 200, -1, "title", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 200, -1, "comment", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435", 100, 100, 100, "extension", false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", Column.DateTime.class, 170, 170, 170, "createDate", true);
            this.addColumn("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", Column.DateTime.class, 170, 170, 170, "lastModificationDate", true);
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 120, 150, 200, "user", false, HorizontalAlignmentTableCellRenderer.CENTER());
        }

        @Override
        public Object getValue(CustomTemplate template, int column) throws BGException {
            switch (column) {
                case 6: {
                    UserInfo user = this.getUserDirectory().get(template.getUserId());
                    return user != null ? user.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                }
            }
            return super.getValue(template, column);
        }

        private Directory<UserInfo> getUserDirectory() {
            if (this.userDirectory == null) {
                try {
                    this.userDirectory = ((ClientContext)DynamicCodeTemplatePanel.this.getContext()).getDirectory(UserInfo.class, 0);
                }
                catch (BGException ex) {
                    ((ClientContext)DynamicCodeTemplatePanel.this.getContext()).processException(ex);
                }
            }
            return this.userDirectory;
        }
    }
}

