/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatComboBox;
import bitel.billing.module.common.IntTextField;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.AbstractTabPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTabPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternBaseTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternCommentPatternsTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternLabelAndGroupTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternObjectsTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternParameterTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternPluginTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternScriptTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternTariffTabPanel;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternWebMenuTabPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;

public class PatternEditor
extends BGTabPanel
implements AbstractTabPanel {
    public static final String TAB_ID = "patternEditor";
    protected int patternId = -1;
    private ButtonGroup payModeButtonGroup = new ButtonGroup();
    private ButtonGroup faceButtonGroup = new ButtonGroup();
    private JToggleButton debetMode = new JToggleButton();
    private JToggleButton creditMode = new JToggleButton();
    private JToggleButton faceFiz = new JToggleButton();
    private JToggleButton faceUr = new JToggleButton();
    private JTabbedPane jTabbedPane = new JTabbedPane();
    private BGTextField patternTitle = new BGTextField();
    private BGTextField namePatternTf = new BGTextField();
    private CardLayout rightPanelLayout = new CardLayout();
    private FloatComboBox<String> limit = new FloatComboBox();
    private BGUTable patternListTable = null;
    private PatternTableModel patternListModel = null;
    private JPanel rightPanel = new JPanel();
    private IntTextField dtl_TF = new IntTextField();
    private BGComboBox<ComboBoxItem> statusCb = new BGComboBox();
    private BGUComboBox<Domain> domainComboBox = new BGUComboBox();

    public PatternEditor() {
        super(TAB_ID, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        this.module = "contract";
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dtl_TF.setMinValue(0L);
        this.dtl_TF.setMaxValue(10000L);
        ((JTextField)this.limit.getEditor().getEditorComponent()).setHorizontalAlignment(0);
        String values = this.setup.get("dbinfo.pattern.limit.values", "-1000;-500;-300;-150;-100;-50;-10;0;5;30;100;15;50;100");
        if (values != null) {
            StringTokenizer st = new StringTokenizer(values, ";");
            while (st.hasMoreTokens()) {
                this.limit.addItem(st.nextToken());
            }
        }
        this.setData();
    }

    private void jbInit() throws Exception {
        JPanelWithTitleBorder patternTitlePanel = new JPanelWithTitleBorder(" \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 ");
        JPanelWithTitleBorder limitPanel = new JPanelWithTitleBorder(" \u041b\u0438\u043c\u0438\u0442 ");
        JPanelWithTitleBorder statusPanel = new JPanelWithTitleBorder(" \u0421\u0442\u0430\u0442\u0443\u0441 ");
        JPanelWithTitleBorder paymodePanel = new JPanelWithTitleBorder(" \u0420\u0435\u0436\u0438\u043c ");
        JPanelWithTitleBorder facePanel = new JPanelWithTitleBorder(" \u041b\u0438\u0446\u043e ");
        JPanelWithTitleBorder lifetimePanel = new JPanelWithTitleBorder(" \u0412\u0440\u0435\u043c\u044f \u0436\u0438\u0437\u043d\u0438 (\u0434\u043d\u0438, 0 - \u043d\u0435\u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e) ");
        this.limit.setEditable(true);
        BGButtonPanelRestoreOkCancelHelp okCancelPanel = new BGButtonPanelRestoreOkCancelHelp();
        okCancelPanel.addActionListener(e -> this.okCancel_actionPerformed(e));
        this.debetMode.setToolTipText("\u0414\u0435\u0431\u0435\u0442");
        this.debetMode.setActionCommand("debet");
        this.debetMode.setText("\u0414");
        this.creditMode.setToolTipText("\u041a\u0440\u0435\u0434\u0438\u0442");
        this.creditMode.setActionCommand("credit");
        this.creditMode.setFocusPainted(true);
        this.creditMode.setSelected(true);
        this.creditMode.setText("\u041a");
        this.patternTitle.setMinimumSize(new Dimension(165, 24));
        this.patternTitle.setPreferredSize(new Dimension(165, 24));
        this.patternTitle.setColumns(15);
        this.faceUr.setToolTipText("\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0435");
        this.faceUr.setActionCommand("1");
        this.faceUr.setText("\u042e");
        this.faceFiz.setToolTipText("\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435");
        this.faceFiz.setActionCommand("0");
        this.faceFiz.setSelected(true);
        this.faceFiz.setText("\u0424");
        this.dtl_TF.setMinimumSize(new Dimension(4, 24));
        this.dtl_TF.setPreferredSize(new Dimension(224, 24));
        this.dtl_TF.setText("");
        this.dtl_TF.setColumns(20);
        patternTitlePanel.add((Component)this.patternTitle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        limitPanel.add(this.limit, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        statusPanel.add(this.statusCb, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        paymodePanel.add((Component)this.debetMode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        paymodePanel.add((Component)this.creditMode, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        facePanel.add((Component)this.faceUr, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        facePanel.add((Component)this.faceFiz, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        lifetimePanel.add((Component)this.dtl_TF, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.payModeButtonGroup.add(this.debetMode);
        this.payModeButtonGroup.add(this.creditMode);
        this.faceButtonGroup.add(this.faceUr);
        this.faceButtonGroup.add(this.faceFiz);
        JPanelWithTitleBorder patternPanel = new JPanelWithTitleBorder(" \u0428\u0430\u0431\u043b\u043e\u043d \u0438\u043c\u0435\u043d\u0438 ");
        patternPanel.add((Component)this.namePatternTf, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)patternTitlePanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)patternPanel, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)BGSwingUtilites.wrapBorder(this.domainComboBox, "\u0414\u043e\u043c\u0435\u043d"), new GridBagConstraints(4, 0, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)limitPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)statusPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)facePanel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)paymodePanel, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)lifetimePanel, new GridBagConstraints(4, 1, 1, 1, 0.3, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        Document moduleDoc1 = ClientUtils.getModuleDoc(this.getClass());
        this.jTabbedPane.add((Component)new PatternModuleTabPanel(moduleDoc1), "\u041c\u043e\u0434\u0443\u043b\u0438");
        this.jTabbedPane.add((Component)new PatternPluginTabPanel(moduleDoc1), "\u041f\u043b\u0430\u0433\u0438\u043d\u044b");
        this.jTabbedPane.add((Component)new PatternLabelAndGroupTabPanel(moduleDoc1), "\u041c\u0435\u0442\u043a\u0438, \u0433\u0440\u0443\u043f\u043f\u044b");
        this.jTabbedPane.add((Component)new PatternCommentPatternsTabPanel(moduleDoc1), "\u0428\u0430\u0431\u043b\u043e\u043d\u044b \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0435\u0432");
        this.jTabbedPane.add((Component)new PatternParameterTabPanel(moduleDoc1), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        this.jTabbedPane.add((Component)new PatternTariffTabPanel(moduleDoc1), "\u0413\u0440\u0443\u043f\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u0438 \u0442\u0430\u0440\u0438\u0444\u044b");
        this.jTabbedPane.add((Component)new PatternScriptTabPanel(moduleDoc1), "\u0421\u043a\u0440\u0438\u043f\u0442 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f");
        this.jTabbedPane.add((Component)new PatternObjectsTabPanel(moduleDoc1), "\u041e\u0431\u044a\u0435\u043a\u0442\u044b");
        this.jTabbedPane.add((Component)new PatternWebMenuTabPanel(moduleDoc1), "Web-\u043c\u0435\u043d\u044e");
        this.jTabbedPane.addChangeListener(e -> ((PatternBaseTabPanel)this.jTabbedPane.getSelectedComponent()).initUI());
        JPanel noSelectPanel = new JPanel(new GridBagLayout());
        noSelectPanel.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", 0), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 30, 0, 30), 0, 0));
        JPanel patternSelectedPanel = new JPanel(new GridBagLayout());
        patternSelectedPanel.add((Component)topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        patternSelectedPanel.add((Component)this.jTabbedPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        patternSelectedPanel.add((Component)okCancelPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.rightPanel.setLayout(this.rightPanelLayout);
        this.rightPanel.add((Component)noSelectPanel, "info");
        this.rightPanel.add((Component)patternSelectedPanel, "editor");
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getListPanel(), (Component)this.rightPanel, 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getListPanel() {
        this.patternListModel = new PatternTableModel(PatternTableModel.class.getName());
        this.patternListTable = new BGUTable(this.patternListModel);
        this.patternListTable.setSelectionMode(0);
        this.patternListTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    PatternEditor.this.editItem();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0428\u0430\u0431\u043b\u043e\u043d\u044b "));
        panel.add((Component)new JScrollPane(this.patternListTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    @Override
    public void setData() {
        if (this.patternListTable.isEnabled()) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ShowPattern");
            request.setAttribute("pid", this.patternId);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                ArrayList<IdTitle> list = new ArrayList<IdTitle>();
                for (Element itemElement : XMLUtils.selectElements(doc, "/data/patterns/item")) {
                    list.add(new IdTitle(Utils.parseInt(itemElement.getAttribute("id")), itemElement.getAttribute("title")));
                }
                this.patternListModel.setData(list, true);
                for (int index = 0; index < this.jTabbedPane.getComponentCount(); ++index) {
                    ((PatternBaseTabPanel)this.jTabbedPane.getComponent(index)).setData(doc);
                }
            }
            request = new Request();
            request.setModule("contract.status");
            request.setAction("StatusList");
            request.setAttribute("onlyManual", false);
            doc = this.getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.statusCb.setModel(ClientUtils.buildComboBox(XMLUtils.getElement(doc, "list"), ""));
            }
        } else {
            this.getPatternData();
        }
    }

    protected void getPatternData() {
        Async<List> domainList = Async.of(() -> {
            List<Domain> list = this.getContext().getDirectory(Domain.class, 0).list();
            Set parentIds = list.stream().map(a -> a.getParentId()).collect(Collectors.toSet());
            ArrayList<Domain> list2 = new ArrayList<Domain>(list.size() + 1);
            Domain nil = new Domain();
            nil.setTitle("---");
            list2.add(nil);
            list.stream().filter(a -> !parentIds.contains(a.getId())).collect(Collectors.toCollection(() -> list2));
            return list2;
        });
        if (this.patternId == -1) {
            this.patternTitle.setText("\u041d\u043e\u0432\u044b\u0439 \u0448\u0430\u0431\u043b\u043e\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
            this.debetMode.setSelected(true);
            this.faceFiz.setSelected(true);
            this.limit.setText("0");
            for (int index = 0; index < this.jTabbedPane.getComponentCount(); ++index) {
                ((PatternBaseTabPanel)this.jTabbedPane.getComponent(index)).resetData();
            }
            this.domainComboBox.setData(domainList.get());
        } else {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetPatternInfo");
            request.setAttribute("pid", this.patternId);
            Document doc = this.getDocument(request);
            if (!ClientUtils.checkStatus(doc)) {
                return;
            }
            Element pattern = XMLUtils.selectElement(doc, "//pattern");
            Element patternData = XMLUtils.selectElement(pattern, "data");
            pattern.setAttribute("webMenuId", patternData.getAttribute("webMenuId"));
            this.patternTitle.setText(XMLUtils.getAttribute(pattern, "title", ""));
            this.namePatternTf.setText(pattern.getAttribute("name_pattern"));
            this.limit.setText(XMLUtils.getAttribute(pattern, "limit", "0"));
            this.dtl_TF.setText(XMLUtils.getAttribute(pattern, "dtl", "0"));
            if ("0".equals(XMLUtils.getAttribute(pattern, "mode", "0"))) {
                this.creditMode.setSelected(true);
            } else {
                this.debetMode.setSelected(true);
            }
            if ("0".equals(XMLUtils.getAttribute(pattern, "face", "0"))) {
                this.faceFiz.setSelected(true);
            } else {
                this.faceUr.setSelected(true);
            }
            ClientUtils.setComboBoxSelection(this.statusCb, XMLUtils.getAttribute(pattern, "status", "0"));
            for (int index = 0; index < this.jTabbedPane.getComponentCount(); ++index) {
                ((PatternBaseTabPanel)this.jTabbedPane.getComponent(index)).setPatternData(pattern);
            }
            this.domainComboBox.setData(domainList.get());
            this.domainComboBox.setSelectedItem(Utils.parseInt(XMLUtils.getAttribute(pattern, "domainId", "0")));
        }
    }

    @Override
    public void newItem() {
        if (this.patternListTable.isEnabled()) {
            this.patternId = -1;
            this.getPatternData();
            this.rightPanelLayout.show(this.rightPanel, "editor");
            this.patternListTable.setEnabled(false);
            this.jTabbedPane.setSelectedIndex(0);
        }
    }

    @Override
    public void editItem() {
        if (this.patternListTable.isEnabled()) {
            IdTitle item = (IdTitle)this.patternListModel.getSelectedRow();
            if (item != null) {
                this.patternId = item.getId();
                this.getPatternData();
                this.rightPanelLayout.show(this.rightPanel, "editor");
                this.patternListTable.setEnabled(false);
                this.jTabbedPane.setSelectedIndex(0);
            } else {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d");
            }
        }
    }

    @Override
    public void deleteItem() {
        if (this.patternListTable.isEnabled()) {
            IdTitle item = (IdTitle)this.patternListModel.getSelectedRow();
            if (item != null) {
                if (ClientUtils.confirmDelete(item.getTitle())) {
                    Request request = new Request();
                    request.setModule(this.module);
                    request.setAction("DeleteContractPattern");
                    request.setAttribute("pid", item.getId());
                    ClientUtils.checkStatus(this.getDocument(request));
                    this.rightPanelLayout.show(this.rightPanel, "info");
                    this.patternListTable.setEnabled(true);
                    this.setData();
                }
            } else {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0448\u0430\u0431\u043b\u043e\u043d");
            }
        }
    }

    private void okCancel_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("reset".equals(actionCommand)) {
            this.getPatternData();
        } else if ("ok".equals(actionCommand)) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("UpdateContractPattern");
            request.setAttribute("pid", this.patternId);
            request.setAttribute("limit", this.limit.getText().trim());
            request.setAttribute("mode", this.payModeButtonGroup.getSelection().getActionCommand());
            request.setAttribute("face", this.faceButtonGroup.getSelection().getActionCommand());
            request.setAttribute("title", this.patternTitle.getText().trim());
            request.setAttribute("dtl", this.dtl_TF.getText());
            request.setAttribute("name_pattern", this.namePatternTf.getText());
            request.setAttribute("status", ClientUtils.getIdFromComboBox(this.statusCb));
            request.setAttribute("domainId", ((Domain)this.domainComboBox.getSelectedItem()).getId());
            boolean result = true;
            for (int index = 0; index < this.jTabbedPane.getComponentCount() && (result = ((PatternBaseTabPanel)this.jTabbedPane.getComponent(index)).setRequestData(request)); ++index) {
            }
            if (result && ClientUtils.checkStatus(this.getDocument(request))) {
                this.rightPanelLayout.show(this.rightPanel, "info");
                this.patternListTable.setEnabled(true);
                this.setData();
            }
        } else if ("cancel".equals(actionCommand)) {
            this.rightPanelLayout.show(this.rightPanel, "info");
            this.patternListTable.setEnabled(true);
        } else if ("help".equals(actionCommand)) {
            this.openHelp(this.getClass().getName());
        }
    }

    class PatternTableModel
    extends BGTableModel<IdTitle> {
        public PatternTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT);
            this.addColumnId();
        }
    }

    class JPanelWithTitleBorder
    extends JPanel {
        public JPanelWithTitleBorder(String borderTitle) {
            super(new GridBagLayout());
            this.setBorder(new BGTitleBorder(borderTitle));
        }
    }
}

