/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.limit.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitLog;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class ContractLimitLogManager
extends AbstractIdDao<ContractLimitLog> {
    public Map<String, String> fields = new HashMap<String, String>();

    public ContractLimitLogManager(Connection con) {
        super(con, 0, "log_contract_limit");
        this.fields.put("date", "dt");
    }

    public void searchContractLimitLog(SearchResult<ContractLimitLog> searchResult, int contractId) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            if (page == null) {
                page = new Page(1, Integer.MAX_VALUE);
                searchResult.setPage(page);
            }
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List<ContractLimitLog> list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND dt>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND dt<?");
                }
            }
            if (contractId > 0) {
                query.append(" AND cid=").append(contractId);
            }
            try {
                ResultSet rs = null;
                PreparedStatement ps = null;
                ps = this.con.prepareStatement("SELECT COUNT(*)" + query.toString());
                int parameterIndex = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp(period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp(TimeUtils.getNextDay(period.getDateTo())));
                    }
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    page.setRecordCount(rs.getInt(1));
                }
                rs.close();
                ps.close();
                if (page.getPageIndex() > page.getPageCount()) {
                    page.setPageIndex(page.getPageCount());
                }
                ps = this.con.prepareStatement("SELECT *" + query.toString() + this.getSQLOrder(sort, this.fields) + (page != null ? page.sqlLimit() : ""));
                parameterIndex = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp(period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp(TimeUtils.getNextDay(period.getDateTo())));
                    }
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException(e);
            }
        }
    }

    public void addContractLimitLog(ContractLimitLog contractLimitLog) throws BGException {
        try {
            String query = "INSERT INTO " + this.tableName + " SET dt=NOW(), uid=?, nvalue=?, cid=?, comment=?, days=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractLimitLog.getUserId());
            ps.setBigDecimal(2, contractLimitLog.getLimitValue());
            ps.setInt(3, contractLimitLog.getContractId());
            ps.setString(4, contractLimitLog.getComment() != null ? contractLimitLog.getComment() : "");
            ps.setInt(5, contractLimitLog.getDays());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void deleteContractLimitLog(int contractId, int userId) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE cid=? AND uid=?");
            ps.setInt(1, contractId);
            ps.setInt(2, userId);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    protected ContractLimitLog getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractLimitLog contractLimitLog = new ContractLimitLog();
        contractLimitLog.setContractId(rs.getInt("cid"));
        contractLimitLog.setDate(rs.getTimestamp("dt"));
        contractLimitLog.setUserId(rs.getInt("uid"));
        User user = UserMap.getUser((Integer)contractLimitLog.getUserId());
        contractLimitLog.setUserName(user == null ? "???" : user.getName());
        contractLimitLog.setLimitValue(rs.getBigDecimal("nvalue"));
        contractLimitLog.setComment(rs.getString("comment"));
        contractLimitLog.setDays(rs.getInt("days"));
        return contractLimitLog;
    }

    @Override
    protected void updateImpl(ContractLimitLog b) throws BGException, SQLException {
    }
}

