/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class PaymentDao
extends AbstractIdDao<Payment> {
    public PaymentDao(Connection con) {
        super(con, -1, "contract_payment");
    }

    public List<Payment> getPaymentList(int contractId, Period period, int members, Holder<BigDecimal> totalSum) throws BGException {
        SearchResult<Payment> searchResult = new SearchResult<Payment>();
        searchResult.setPeriod(period);
        this.searchPaymentList(searchResult, contractId, members);
        if (totalSum != null) {
            totalSum.value = searchResult.getSum();
        }
        return searchResult.getList();
    }

    public void searchPaymentList(SearchResult<Payment> searchResult, int contractId, int members) throws BGException {
        this.searchPaymentList(searchResult, Utils.toIntegerList(ContractUtils.getCidsStringForQuery((int)contractId, (int)members, (Connection)this.con)));
    }

    public List<Payment> getPaymentList(List<Integer> contractIds, Period period, Holder<BigDecimal> totalSum) throws BGException {
        SearchResult<Payment> searchResult = new SearchResult<Payment>();
        searchResult.setPeriod(period);
        this.searchPaymentList(searchResult, contractIds);
        if (totalSum != null) {
            totalSum.value = searchResult.getSum();
        }
        return searchResult.getList();
    }

    public void searchPaymentList(SearchResult<Payment> searchResult, List<Integer> contractIds) throws BGException {
        if (searchResult == null || contractIds == null || contractIds.isEmpty()) {
            return;
        }
        int index = 1;
        Period period = searchResult.getPeriod();
        List<Payment> result = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT p.id, p.cid, p.comment, p.dt, p.pt, p.summa, p.uid, p.lm FROM " + this.tableName + " AS p WHERE p.cid IN (" + Utils.toString(contractIds) + ")");
        if (period != null) {
            if (period.getDateFrom() != null) {
                query.append(" AND dt>=?");
            }
            if (period.getDateTo() != null) {
                query.append(" AND dt<=?");
            }
        }
        query.append(" ORDER BY dt");
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            if (period != null && period.getDateFrom() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(period.getDateFrom()));
            }
            if (period != null && period.getDateTo() != null) {
                ps.setDate(index++, TimeUtils.convertDateToSqlDate(period.getDateTo()));
            }
            ResultSet rs = ps.executeQuery();
            BigDecimal sumL = BigDecimal.ZERO;
            while (rs.next()) {
                sumL = sumL.add(rs.getBigDecimal("summa"));
                result.add(this.getFromRS(rs));
            }
            searchResult.setSum(sumL);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void searchLastPaymentList(SearchResult<Payment> searchResult, int contractId, int members, int lastPayments) throws BGException {
        this.searchLastPaymentList(searchResult, Utils.toIntegerList(ContractUtils.getCidsStringForQuery((int)contractId, (int)members, (Connection)this.con)), lastPayments);
    }

    public void searchLastPaymentList(SearchResult<Payment> searchResult, List<Integer> contractIds, int lastPayments) throws BGException {
        if (searchResult == null || contractIds == null || contractIds.isEmpty()) {
            return;
        }
        List<Payment> result = searchResult.getList();
        StringBuilder query = new StringBuilder("SELECT p.id, p.cid, p.comment, p.dt, p.pt, p.summa, p.uid, p.lm FROM " + this.tableName + " AS p WHERE p.cid IN (" + Utils.toString(contractIds) + ")");
        query.append(" ORDER BY dt DESC");
        if (lastPayments > 0) {
            query.append(" LIMIT ").append(lastPayments);
        }
        try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
            ResultSet rs = ps.executeQuery();
            BigDecimal sumL = BigDecimal.ZERO;
            while (rs.next()) {
                sumL = sumL.add(rs.getBigDecimal("summa"));
                result.add(this.getFromRS(rs));
            }
            searchResult.setSum(sumL);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    protected void updateImpl(Payment payment) throws BGException, SQLException {
        if (payment != null) {
            String query = null;
            PreparedStatement ps = null;
            if (payment.getId() < 1) {
                query = "INSERT INTO " + this.tableName + " SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=?";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE " + this.tableName + " SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(7, payment.getId());
            }
            ps.setDate(1, TimeUtils.convertDateToSqlDate(payment.getDate()));
            ps.setInt(2, payment.getContractId());
            ps.setInt(3, payment.getTypeId());
            ps.setInt(4, payment.getUserId());
            ps.setBigDecimal(5, payment.getSum());
            ps.setString(6, payment.getComment());
            ps.executeUpdate();
            if (payment.getId() < 0) {
                payment.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
    }

    public void zeroBalancePayment(Date date, int contractId, int paymentTypeId) throws BGException {
        this.zeroBalancePayment(date, contractId, paymentTypeId, "\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0434\u043b\u044f \u043e\u0431\u043d\u0443\u043b\u0435\u043d\u0438\u044f \u0431\u0430\u043b\u0430\u043d\u0441\u0430");
    }

    public void zeroBalancePayment(Date date, int contractId, int paymentTypeId, String paymentComment) throws BGException {
        if (date != null) {
            try (BalanceUtils bu = new BalanceUtils(this.con);){
                BigDecimal balance = bu.getBalance(date, contractId);
                if (balance.compareTo(BigDecimal.ZERO) >= 0) {
                    return;
                }
                BigDecimal delta = balance.abs();
                Payment payment = new Payment();
                payment.setTypeId(paymentTypeId);
                payment.setContractId(contractId);
                payment.setDate(date);
                payment.setSum(delta);
                payment.setComment(paymentComment);
                payment.setUserId(0);
                this.update(payment);
                bu.updateBalance(date, contractId);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<Payment> getPaymentsById(String idList) throws BGException {
        if (Utils.isBlankString(idList)) {
            return new ArrayList<Payment>();
        }
        String query = "SELECT * FROM " + this.tableName + " WHERE id IN (" + idList + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            List<Payment> list;
            block15: {
                ResultSet rs = ps.executeQuery();
                try {
                    list = this.getListFromRS(rs);
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    protected int deleteImpl(int id) throws BGException, SQLException {
        String query = "INSERT INTO " + this.tableName + "_deleted SELECT * FROM " + this.tableName + " WHERE id=" + id;
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.executeUpdate();
        ps.close();
        return super.deleteImpl(id);
    }

    public void deletePaymentsById(String idList) throws BGException {
        if (Utils.isEmptyString(idList)) {
            return;
        }
        try {
            String query = "INSERT INTO " + this.tableName + "_deleted SELECT * FROM " + this.tableName + " WHERE id IN (" + idList + ")";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
            query = "DELETE FROM " + this.tableName + " WHERE id IN (" + idList + ")";
            ps = this.con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException("error delete payments by id", e);
        }
    }

    @Override
    protected Payment getFromRS(ResultSet rs) throws SQLException, BGException {
        Payment payment = new Payment();
        payment.setId(rs.getInt("id"));
        payment.setContractId(rs.getInt("cid"));
        payment.setComment(rs.getString("comment"));
        payment.setDate(rs.getDate("dt"));
        payment.setTypeId(rs.getInt("pt"));
        payment.setSum(rs.getBigDecimal("summa"));
        payment.setUserId(rs.getInt("uid"));
        payment.setTimeChange(rs.getTimestamp("lm"));
        return payment;
    }
}

