/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ChargeType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentTypeItem;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;

public class ChargeTypeDao
extends AbstractIdDao<ChargeType>
implements Directory<ChargeType> {
    public ChargeTypeDao(Connection con) {
        super(con, 0, "contract_charge_types");
    }

    @Override
    public ChargeType get(String title) throws BGException {
        return null;
    }

    @Override
    public List<ChargeType> list() throws BGException {
        return this.list(null, null, null);
    }

    public List<ChargeType> list(Integer editable, Integer type, Boolean isPayback) throws BGException {
        List<ChargeType> list;
        block14: {
            StringBuilder query = new StringBuilder("SELECT * FROM " + this.tableName + " WHERE 1=1 ");
            int index = 1;
            if (editable != null && editable > -1) {
                query.append(" AND flag=?");
            }
            if (type != null && type > -1) {
                query.append(" AND type=?");
            }
            if (isPayback != null) {
                query.append(" AND payback=?");
            }
            query.append(" ORDER BY title");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            try {
                if (editable != null && editable > -1) {
                    ps.setInt(index++, editable);
                }
                if (type != null && type > -1) {
                    ps.setInt(index++, type);
                }
                if (isPayback != null) {
                    ps.setBoolean(index, isPayback);
                }
                list = this.getListFromRS(ps.executeQuery());
                if (ps == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BGException(e);
                }
            }
            ps.close();
        }
        return list;
    }

    public Map<Integer, ChargeType> getTypeMapByIds(List<Integer> typeIds) throws BGException {
        HashMap<Integer, ChargeType> resultMap = new HashMap<Integer, ChargeType>();
        for (ChargeType chargeType : this.list((String)(typeIds != null && typeIds.size() > 0 ? "id IN ( " + Utils.toString(typeIds) + " )" : ""), null, new Object[0])) {
            resultMap.put(chargeType.getId(), chargeType);
        }
        return resultMap;
    }

    public void move(int chargeTypeId, List<Integer> idList) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT up, type FROM " + this.tableName + " WHERE id=?");
            ps.setInt(1, chargeTypeId);
            HashSet<Integer> parentIds = new HashSet<Integer>();
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                if (rs.getInt(2) != 1) {
                    rs.close();
                    ps.close();
                    return;
                }
                int parentId = rs.getInt(1);
                while (true) {
                    parentIds.add(parentId);
                    ps.setInt(1, parentId);
                    rs = ps.executeQuery();
                    if (!rs.next()) break;
                    parentId = rs.getInt(1);
                }
                rs.close();
            } else {
                chargeTypeId = 0;
            }
            rs.close();
            ps.close();
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET up=? WHERE id!=? AND id=?");
            ps.setInt(1, chargeTypeId);
            ps.setInt(2, chargeTypeId);
            for (Integer i : idList) {
                if (parentIds.contains(i)) continue;
                ps.setInt(3, i);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public PaymentTypeItem getTree(int editable, boolean isPayback, boolean showEmptyRoot) throws BGException {
        PaymentTypeItem rootItem = new PaymentTypeItem();
        rootItem.setTitle("\u0422\u0438\u043f\u044b");
        rootItem.setType(1);
        rootItem.setEditable(true);
        this.addChild(rootItem.getId(), rootItem, this.list(editable, null, isPayback), showEmptyRoot);
        return rootItem;
    }

    @Override
    public int delete(int id) throws BGException {
        String query = "SELECT * FROM contract_charge WHERE pt= " + id + " LIMIT 1";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u043e! \u0414\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.");
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
        return super.delete(id);
    }

    @Override
    public void update(ChargeType chargeType) throws BGException {
        if (chargeType == null || chargeType.getParentId() < 0 || chargeType.getType() < 0 || chargeType.getType() > 1) {
            throw new BGIllegalArgumentException();
        }
        try {
            if (chargeType.getId() > 0) {
                this.updateImpl(chargeType);
            } else {
                PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, up, type, flag, payback) VALUES(?,?,?,?,?)", 1);
                ps.setString(1, chargeType.getTitle());
                ps.setInt(2, chargeType.getParentId());
                ps.setInt(3, chargeType.getType());
                ps.setBoolean(4, !chargeType.getEditable());
                ps.setBoolean(5, chargeType.isPayback());
                ps.executeUpdate();
                chargeType.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    @Override
    protected void updateImpl(ChargeType b) throws BGException, SQLException {
        PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, type=?, flag=?, up=?, payback=? WHERE id=?");
        ps.setString(1, b.getTitle());
        ps.setInt(2, b.getType());
        ps.setBoolean(3, !b.getEditable());
        ps.setInt(4, b.getParentId());
        ps.setBoolean(5, b.isPayback());
        ps.setInt(6, b.getId());
        ps.executeUpdate();
        ps.close();
    }

    @Override
    protected ChargeType getFromRS(ResultSet rs) throws SQLException, BGException {
        ChargeType charge = new ChargeType();
        charge.setId(rs.getInt("id"));
        charge.setTitle(rs.getString("title"));
        charge.setType(rs.getInt("type"));
        charge.setEditable(!rs.getBoolean("flag"));
        charge.setParentId(rs.getInt("up"));
        charge.setPayback(rs.getBoolean("payback"));
        return charge;
    }

    protected void addChild(int up, PaymentTypeItem rootItem, List<ChargeType> list, boolean showEmptyRoot) {
        for (ChargeType listItem : list) {
            if (up != listItem.getParentId()) continue;
            PaymentTypeItem ptItem = new PaymentTypeItem(listItem);
            rootItem.addChild(ptItem);
            this.addChild(ptItem.getId(), ptItem, list, showEmptyRoot);
            if (showEmptyRoot || !ptItem.isEmpty() || ptItem.getType() != 1) continue;
            rootItem.removeChild(ptItem);
        }
    }
}

