/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.converters.BGConverter;
import ru.bitel.common.Utils;

public class ConvertContractGroupsToLabels
implements BGConverter {
    private static final Logger logger = LogManager.getLogger((String)ConvertContractGroupsToLabels.class.getSimpleName());

    @Override
    public void runConverter(Connection connection) {
        this.convertContractGroupsToContractLabels(connection);
        this.convertHideForWebContractGroupsToContractLabels(connection);
    }

    private void convertContractGroupsToContractLabels(Connection connection) {
        HashMap<Integer, Long> tariffOptions = new HashMap<Integer, Long>();
        String query = "select id, contract_groups from tariff_option where contract_groups>0";
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                tariffOptions.put(rs.getInt("id"), rs.getLong("contract_groups"));
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage());
        }
        if (tariffOptions.size() == 0) {
            return;
        }
        query = "UPDATE tariff_option SET contract_groups=0, contract_labels=? WHERE id=?";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            tariffOptions.forEach((id, contractGroups) -> {
                try {
                    List ids = Utils.toIntegerList(Utils.maskToEnum(contractGroups)).stream().mapToInt(x -> x + 2).boxed().collect(Collectors.toList());
                    ps.setString(1, Utils.toString(ids));
                    ps.setInt(2, (int)id);
                    ps.addBatch();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            });
            ps.executeBatch();
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage());
        }
    }

    private void convertHideForWebContractGroupsToContractLabels(Connection connection) {
        HashMap<Integer, Long> tariffOptions = new HashMap<Integer, Long>();
        String query = "select id, hideForWebContractGroups from tariff_option where hideForWebContractGroups>0";
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                tariffOptions.put(rs.getInt("id"), rs.getLong("hideForWebContractGroups"));
            }
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage());
        }
        if (tariffOptions.size() == 0) {
            return;
        }
        query = "UPDATE tariff_option SET hideForWebContractGroups=0, hide_for_web_contract_labels=? WHERE id=?";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            tariffOptions.forEach((id, contractGroups) -> {
                try {
                    List ids = Utils.toIntegerList(Utils.maskToEnum(contractGroups)).stream().mapToInt(x -> x + 2).boxed().collect(Collectors.toList());
                    ps.setString(1, Utils.toString(ids));
                    ps.setInt(2, (int)id);
                    ps.addBatch();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            });
            ps.executeBatch();
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage());
        }
    }
}

