/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.groupaction.client;

import bitel.billing.module.admin.ContractGroupOperation;
import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.pattern.client.PatternModuleServicePanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class BreakResolvedService
extends ContractGroupOperation.ContractGroupOperationItem {
    PatternModuleServicePanel servicePanel = new PatternModuleServicePanel(-1);
    private JRadioButton br = new JRadioButton("\u041f\u0440\u0435\u0440\u0432\u0430\u0442\u044c", true);
    private JRadioButton del = new JRadioButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", false);
    private BGComboBox<ComboBoxItem> modules_CB = new BGComboBox();
    private BGControlPanelPeriod period = new BGControlPanelPeriod();

    public BreakResolvedService() {
        super(new GridBagLayout());
    }

    @Override
    protected void jbInit() throws Exception {
        JPanel leftPanel = new JPanel(new GridBagLayout());
        JPanel modulePanel = new JPanel(new GridBagLayout());
        JPanel actionPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)modulePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)this.period, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        leftPanel.add((Component)actionPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        modulePanel.setBorder(new BGTitleBorder("\u041c\u043e\u0434\u0443\u043b\u044c"));
        modulePanel.add(this.modules_CB, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        actionPanel.setBorder(new BGTitleBorder("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435"));
        actionPanel.add((Component)this.br, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        actionPanel.add((Component)this.del, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)leftPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.servicePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.period.setDateCalendar1(new GregorianCalendar());
        this.modules_CB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BreakResolvedService.this.showConfigPanel();
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.del);
        group.add(this.br);
        this.br.setActionCommand("br");
        this.del.setActionCommand("del");
        ActionListener actionListener = e -> this.setPeriodVisible(e);
        this.del.addActionListener(actionListener);
        this.br.addActionListener(actionListener);
    }

    private void setPeriodVisible(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("del")) {
            this.period.setEnabled(false);
        } else {
            this.period.setEnabled(true);
        }
    }

    @Override
    protected void setData() {
        this.setModule();
    }

    @Override
    protected boolean doItemOperation(String cids) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractGroupOperation");
        if (this.br.isSelected()) {
            request.setAttribute("type", "breakResolvedService");
            if (Utils.isEmptyString(this.period.getDateString1())) {
                ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
                return false;
            }
            request.setAttribute("date1", this.period.getDateString1());
            request.setAttribute("date2", this.period.getDateString2());
        }
        if (this.del.isSelected()) {
            request.setAttribute("type", "deleteResolvedService");
        }
        request.setAttribute("cids", cids);
        request.setAttribute("mids", Utils.parseInt(ClientUtils.getIdFromComboBox(this.modules_CB), -1));
        ArrayList<String> serviceList = new ArrayList<String>();
        this.servicePanel.serialise(serviceList);
        request.setAttribute("sids", Utils.toString(serviceList));
        return ClientUtils.checkStatus(TransferManager.getDocument(request));
    }

    @Override
    protected String getOperationTitle() {
        return "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435(\u041f\u0440\u0435\u0440\u044b\u0432\u0430\u043d\u0438\u0435 \u043d\u0430 \u043f\u0435\u0440\u0438\u043e\u0434) \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433";
    }

    private void setModule() {
        Request req = new Request();
        req.setModule("service");
        req.setAction("GetModules");
        Document doc = TransferManager.getDocument(req);
        Element node = XMLUtils.selectElement(doc, "//table/data");
        if (this.modules_CB == null) {
            return;
        }
        DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
        if (node != null && node.hasChildNodes()) {
            for (Element item : XMLUtils.elements(node.getChildNodes())) {
                String itemName = XMLUtils.getAttribute(item, "f1", null);
                String mid = XMLUtils.getAttribute(item, "f0", null);
                String pkg = XMLUtils.getAttribute(item, "f4", null);
                try {
                    Class<?> clazz = Class.forName(pkg + ".ServicePropertiesPanel");
                    if (!ServicePanel.isAllowedServiceAvaliable(clazz)) continue;
                    model.addElement(new ComboBoxItem(mid, itemName));
                }
                catch (ClassNotFoundException clazz) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.modules_CB.setModel(model);
        this.showConfigPanel();
    }

    private void showConfigPanel() {
        this.servicePanel.setMid(Utils.parseInt(ClientUtils.getIdFromComboBox(this.modules_CB), -1));
        this.servicePanel.setData(null);
    }
}

