/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.directory.address;

import bitel.billing.module.common.BGComboBox;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.directory.address.AddressEditorPanelBase;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.directory.api.common.service.DirectoryService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModel;

public class DirectoryAddressEditorTab
extends AbstractBGUPanel<ClientContext, BGUPanel> {
    private static final String COUNTRY = "country";
    private static final String CITY = "city";
    private static final String STREET = "street";
    private static final String AREA = "area";
    private static final String QUARTER = "quarter";
    private static final String HOUSE = "house";
    private String mode = "country";
    private String rbName;
    private CardLayout tableLayout = new CardLayout();
    private JPanel tablePanel = new JPanel();
    private JPanel editorPanel = new JPanel();
    private JPanel editorViewPanel = new JPanel();
    private JLabel titleLabel;
    private JLabel subTitleLabel = new JLabel("");
    private JLabel recordCountLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: 0");
    private JButton importButton = new JButton("\u0418\u043c\u043f\u043e\u0440\u0442...");
    private JTabbedPane tabbedPane = new JTabbedPane();
    private AddressEditorPanelBase currentViewPanel = null;
    private BGButtonPanelRestoreOkCancelHelp okCancelPanel;
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private Map<String, Component> tableMap = new HashMap<String, Component>();
    private Map<String, BGButton> buttonMap = new HashMap<String, BGButton>();
    private Map<String, BGTextField> filterMap = new HashMap<String, BGTextField>();
    private Map<String, Integer> objectIdMap = new HashMap<String, Integer>();
    private Map<String, BGComboBox<String>> searchModeMap = new HashMap<String, BGComboBox<String>>();
    private Map<String, BGTableModel<Element>> tableModelMap = new HashMap<String, BGTableModel<Element>>();
    private DirectoryService directoryService = null;

    @Override
    protected void jbInit() throws Exception {
        this.rbName = this.getClass().getPackage().getName() + ".setup";
        this.tableModelMap.put(COUNTRY, new CountryTableModel());
        this.tableModelMap.put(CITY, new CityTableModel());
        this.tableModelMap.put(AREA, new AreaTableModel());
        this.tableModelMap.put(QUARTER, new QuarterTableModel());
        this.tableModelMap.put(STREET, new StreetTableModel());
        this.tableModelMap.put(HOUSE, new HouseTableModel());
        this.tableMap.put(COUNTRY, new BGUTable(this.tableModelMap.get(COUNTRY)));
        this.tableMap.put(CITY, new BGUTable(this.tableModelMap.get(CITY)));
        this.tableMap.put(STREET, new BGUTable(this.tableModelMap.get(STREET)));
        this.tableMap.put(AREA, new BGUTable(this.tableModelMap.get(AREA)));
        this.tableMap.put(QUARTER, new BGUTable(this.tableModelMap.get(QUARTER)));
        this.tableMap.put(HOUSE, new BGUTable(this.tableModelMap.get(HOUSE)));
        this.tablePanel.setLayout(this.tableLayout);
        this.tablePanel.add((Component)new JScrollPane(this.tableMap.get(COUNTRY)), COUNTRY);
        this.tablePanel.add((Component)new JScrollPane(this.tableMap.get(CITY)), CITY);
        this.tablePanel.add((Component)new JScrollPane(this.tableMap.get(STREET)), STREET);
        this.tablePanel.add((Component)new JScrollPane(this.tableMap.get(AREA)), AREA);
        this.tablePanel.add((Component)new JScrollPane(this.tableMap.get(QUARTER)), QUARTER);
        this.tablePanel.add((Component)new JScrollPane(this.tableMap.get(HOUSE)), HOUSE);
        this.objectIdMap.put(COUNTRY, -1);
        this.objectIdMap.put(CITY, -1);
        this.objectIdMap.put(STREET, -1);
        this.objectIdMap.put(AREA, -1);
        this.objectIdMap.put(QUARTER, -1);
        this.objectIdMap.put(HOUSE, -1);
        this.titleLabel = new JLabel(""){
            {
                this.setFont(new Font("Dialog", 1, 18));
            }
        };
        this.subTitleLabel.setFont(new Font("Dialog", 1, 16));
        this.tableMap.get(COUNTRY).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Element element;
                Object sourceObject;
                if (event.getClickCount() == 2 && (sourceObject = event.getSource()) instanceof BGUTable && (element = DirectoryAddressEditorTab.this.tableModelMap.get(DirectoryAddressEditorTab.COUNTRY).getSelectedRow()) != null) {
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.COUNTRY, element.getAttribute("id"), element.getAttribute("title"));
                    DirectoryAddressEditorTab.this.pagePanel.setPageIndex(1);
                    DirectoryAddressEditorTab.this.setData(DirectoryAddressEditorTab.CITY);
                }
            }
        });
        this.tableMap.get(CITY).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Element element;
                Object sourceObject;
                if (event.getClickCount() == 2 && (sourceObject = event.getSource()) instanceof BGUTable && (element = DirectoryAddressEditorTab.this.tableModelMap.get(DirectoryAddressEditorTab.CITY).getSelectedRow()) != null) {
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.CITY, element.getAttribute("id"), element.getAttribute("title"));
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.COUNTRY, element.getAttribute("country_id"), element.getAttribute("country_title"));
                    DirectoryAddressEditorTab.this.pagePanel.setPageIndex(1);
                    DirectoryAddressEditorTab.this.setData(DirectoryAddressEditorTab.STREET);
                }
            }
        });
        this.tableMap.get(STREET).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Element element;
                Object sourceObject;
                if (event.getClickCount() == 2 && (sourceObject = event.getSource()) instanceof BGUTable && (element = DirectoryAddressEditorTab.this.tableModelMap.get(DirectoryAddressEditorTab.STREET).getSelectedRow()) != null) {
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.STREET, element.getAttribute("id"), element.getAttribute("title"));
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.CITY, element.getAttribute("city_id"), element.getAttribute("city_title"));
                    DirectoryAddressEditorTab.this.setBlock(DirectoryAddressEditorTab.COUNTRY, element.getAttribute("country_id"), element.getAttribute("country_title"));
                    DirectoryAddressEditorTab.this.pagePanel.setPageIndex(1);
                    DirectoryAddressEditorTab.this.setData(DirectoryAddressEditorTab.HOUSE);
                }
            }
        });
        this.tableMap.get(HOUSE).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    DirectoryAddressEditorTab.this.performAction("edit");
                }
            }
        });
        this.pagePanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name != null && name.startsWith("to")) {
                    DirectoryAddressEditorTab.this.setData(DirectoryAddressEditorTab.this.mode);
                }
            }
        });
        this.okCancelPanel = new BGButtonPanelRestoreOkCancelHelp();
        this.okCancelPanel.addActionListener(actionEvent -> this.okCancel_actionPerformed(actionEvent));
        this.setLayout(new BorderLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, this.getSearchPanel(), (Component)this.getResultPanel(), 400L), "Center");
        this.performAction("refresh");
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                DirectoryAddressEditorTab.this.setData(DirectoryAddressEditorTab.COUNTRY);
            }
        };
        new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                String clientClassName = ClientUtils.getValueFromResourceBundle(DirectoryAddressEditorTab.this.rbName, DirectoryAddressEditorTab.this.mode + ".editor.class");
                if (!DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.COUNTRY)) {
                    if (DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.CITY)) {
                        if (DirectoryAddressEditorTab.this.filterMap.get(DirectoryAddressEditorTab.COUNTRY).isEditable()) {
                            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u0442\u0440\u0430\u043d\u0443.");
                            return;
                        }
                    } else if (DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.AREA) || DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.QUARTER) || DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.STREET)) {
                        if (DirectoryAddressEditorTab.this.filterMap.get(DirectoryAddressEditorTab.COUNTRY).isEditable() || DirectoryAddressEditorTab.this.filterMap.get(DirectoryAddressEditorTab.CITY).isEditable()) {
                            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u0430\u043d\u0443 \u0438 \u0433\u043e\u0440\u043e\u0434");
                            return;
                        }
                    } else if (DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.HOUSE) && (DirectoryAddressEditorTab.this.filterMap.get(DirectoryAddressEditorTab.COUNTRY).isEditable() || DirectoryAddressEditorTab.this.filterMap.get(DirectoryAddressEditorTab.CITY).isEditable() || DirectoryAddressEditorTab.this.filterMap.get(DirectoryAddressEditorTab.STREET).isEditable())) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u0430\u043d\u0443, \u0433\u043e\u0440\u043e\u0434 \u0438 \u0443\u043b\u0438\u0446\u0443.");
                        return;
                    }
                }
                DirectoryAddressEditorTab.this.showEditor(clientClassName, null, null);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent event) throws Exception {
                int submode;
                String id = null;
                Element element = null;
                Component component = DirectoryAddressEditorTab.this.tableMap.get(DirectoryAddressEditorTab.this.mode);
                if (component instanceof BGUTable) {
                    BGTableModel<Element> tableModel = DirectoryAddressEditorTab.this.tableModelMap.get(DirectoryAddressEditorTab.this.mode);
                    element = tableModel.getSelectedRow();
                    if (element == null) {
                        ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                        return;
                    }
                    id = element.getAttribute("id");
                }
                if ((submode = DirectoryAddressEditorTab.this.tabbedPane.getSelectedIndex()) != 0 && DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.HOUSE)) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u043a\u043b\u0430\u0434\u043a\u0443 \"\u0423\u043b\u0438\u0446\u044b\" \u0432 \u0444\u0438\u043b\u044c\u0442\u0440\u0435.");
                    return;
                }
                String clientClassName = ClientUtils.getValueFromResourceBundle(DirectoryAddressEditorTab.this.rbName, DirectoryAddressEditorTab.this.mode + ".editor.class");
                DirectoryAddressEditorTab.this.showEditor(clientClassName, id, element);
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            @Override
            public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
                String idAttr = null;
                Element element = null;
                Component component = DirectoryAddressEditorTab.this.tableMap.get(DirectoryAddressEditorTab.this.mode);
                if (component instanceof BGUTable && (element = DirectoryAddressEditorTab.this.tableModelMap.get(DirectoryAddressEditorTab.this.mode).getSelectedRow()) != null) {
                    idAttr = element.getAttribute("id");
                }
                if (idAttr == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                    return;
                }
                if (ClientUtils.confirmDelete(element.getAttribute("title"))) {
                    int id = Utils.parseInt(idAttr);
                    try {
                        if (DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.COUNTRY)) {
                            DirectoryAddressEditorTab.this.getDirectoryService().addressCountryDelete(id, "new");
                        } else if (DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.HOUSE)) {
                            DirectoryAddressEditorTab.this.getDirectoryService().addressHouseDelete(id);
                        } else if (DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.CITY)) {
                            DirectoryAddressEditorTab.this.getDirectoryService().addressDirectoryDelete(id, 5, "new");
                        } else if (DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.AREA)) {
                            DirectoryAddressEditorTab.this.getDirectoryService().addressDirectoryDelete(id, 6, "new");
                        } else if (DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.QUARTER)) {
                            DirectoryAddressEditorTab.this.getDirectoryService().addressDirectoryDelete(id, 8, "new");
                        } else if (DirectoryAddressEditorTab.this.mode.equals(DirectoryAddressEditorTab.STREET)) {
                            DirectoryAddressEditorTab.this.getDirectoryService().addressDirectoryDelete(id, 7, "new");
                        }
                        DirectoryAddressEditorTab.this.setData(DirectoryAddressEditorTab.this.mode);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog(ex);
                    }
                }
            }
        };
    }

    private DirectoryService getDirectoryService() {
        if (this.directoryService == null) {
            this.directoryService = ((ClientContext)this.getContext()).getPort(DirectoryService.class);
        }
        return this.directoryService;
    }

    private void showEditor(String clientClassName, String id, Element element) throws BGException {
        this.currentViewPanel = Utils.newInstance(clientClassName, AddressEditorPanelBase.class);
        this.currentViewPanel.setId(id);
        this.currentViewPanel.init(clientClassName, 0);
        this.currentViewPanel.setModule(((ClientContext)this.getContext()).getModule());
        this.editorPanel.setVisible(false);
        this.editorViewPanel.removeAll();
        this.editorViewPanel.add(this.currentViewPanel);
        if (element != null) {
            if (this.mode.equals(CITY)) {
                this.currentViewPanel.setCountryId(Integer.valueOf(element.getAttribute("country_id")));
                this.currentViewPanel.setCountryLable("\u0421\u0442\u0440\u0430\u043d\u0430: " + element.getAttribute("country_title"));
            } else if (this.mode.equals(AREA) || this.mode.equals(QUARTER) || this.mode.equals(STREET)) {
                this.currentViewPanel.setCountryId(Integer.valueOf(element.getAttribute("country_id")));
                this.currentViewPanel.setCityId(Integer.valueOf(element.getAttribute("city_id")));
                this.currentViewPanel.setCountryLable("\u0421\u0442\u0440\u0430\u043d\u0430: " + element.getAttribute("country_title"));
                this.currentViewPanel.setCityLable("\u0413\u043e\u0440\u043e\u0434: " + element.getAttribute("city_title"));
            } else if (this.mode.equals(HOUSE)) {
                this.currentViewPanel.setCountryId(Integer.valueOf(element.getAttribute("country_id")));
                this.currentViewPanel.setCityId(Integer.valueOf(element.getAttribute("city_id")));
                this.currentViewPanel.setItemId(Integer.valueOf(element.getAttribute("item_id")));
                this.currentViewPanel.setCountryLable("\u0421\u0442\u0440\u0430\u043d\u0430: " + element.getAttribute("country_title"));
                this.currentViewPanel.setCityLable("\u0413\u043e\u0440\u043e\u0434: " + element.getAttribute("city_title"));
                this.currentViewPanel.setStreetLable("\u0423\u043b\u0438\u0446\u0430: " + element.getAttribute("item_title"));
            }
        } else if (this.mode.equals(CITY)) {
            this.currentViewPanel.setCountryId(this.objectIdMap.get(COUNTRY));
            this.currentViewPanel.setCountryLable("\u0421\u0442\u0440\u0430\u043d\u0430: " + this.filterMap.get(COUNTRY).getText());
        } else if (this.mode.equals(AREA) || this.mode.equals(QUARTER) || this.mode.equals(STREET)) {
            this.currentViewPanel.setCountryId(this.objectIdMap.get(COUNTRY));
            this.currentViewPanel.setCityId(this.objectIdMap.get(CITY));
            this.currentViewPanel.setCountryLable("\u0421\u0442\u0440\u0430\u043d\u0430: " + this.filterMap.get(COUNTRY).getText());
            this.currentViewPanel.setCityLable("\u0413\u043e\u0440\u043e\u0434: " + this.filterMap.get(CITY).getText());
        } else if (this.mode.equals(HOUSE)) {
            this.currentViewPanel.setCountryId(this.objectIdMap.get(COUNTRY));
            this.currentViewPanel.setCityId(this.objectIdMap.get(CITY));
            this.currentViewPanel.setItemId(this.objectIdMap.get(STREET));
            this.currentViewPanel.setCountryLable("\u0421\u0442\u0440\u0430\u043d\u0430: " + this.filterMap.get(COUNTRY).getText());
            this.currentViewPanel.setCityLable("\u0413\u043e\u0440\u043e\u0434: " + this.filterMap.get(CITY).getText());
            this.currentViewPanel.setStreetLable("\u0423\u043b\u0438\u0446\u0430: " + this.filterMap.get(STREET).getText());
        }
        this.currentViewPanel.setData();
        this.editorPanel.setVisible(true);
        this.editorViewPanel.invalidate();
    }

    private void resetData(String mode) {
        if (COUNTRY.equals(mode)) {
            this.unsetBlock(COUNTRY);
            this.unsetBlock(CITY);
            this.unsetBlock(STREET);
            this.unsetBlock(AREA);
            this.unsetBlock(QUARTER);
            this.unsetBlock(HOUSE);
        } else if (CITY.equals(mode)) {
            this.unsetBlock(CITY);
            this.unsetBlock(STREET);
            this.unsetBlock(AREA);
            this.unsetBlock(QUARTER);
            this.unsetBlock(HOUSE);
        } else if (STREET.equals(mode) || AREA.equals(mode) || QUARTER.equals(mode)) {
            this.unsetBlock(STREET);
            this.unsetBlock(AREA);
            this.unsetBlock(QUARTER);
            this.unsetBlock(HOUSE);
        } else if (HOUSE.equals(mode)) {
            this.unsetBlock(HOUSE);
        }
    }

    private JPanel getSearchPanel() {
        this.tabbedPane.add((Component)this.getSearchPanel("", STREET), "\u0423\u043b\u0438\u0446\u0430");
        this.tabbedPane.add((Component)this.getSearchPanel("", QUARTER), "\u041a\u0432\u0430\u0440\u0442\u0430\u043b");
        this.tabbedPane.add((Component)this.getSearchPanel("", AREA), "\u0420\u0430\u0439\u043e\u043d");
        int y = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0438\u0441\u043a\u0430"));
        Dimension dimension = panel.getPreferredSize();
        dimension.setSize(300.0, dimension.getHeight());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.setMaximumSize(dimension);
        panel.add((Component)this.getSearchPanel("\u0421\u0442\u0440\u0430\u043d\u0430:", COUNTRY), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getSearchPanel("\u0413\u043e\u0440\u043e\u0434:", CITY), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.tabbedPane, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(20, 10, 5, 10), 0, 0));
        panel.add((Component)this.getSearchPanel("\u0414\u043e\u043c/\u0434\u0440\u043e\u0431\u044c:", HOUSE), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(0, y++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getResultPanel() {
        this.importButton.addActionListener(e -> {
            if (STREET.equals(this.mode) || AREA.equals(this.mode) || QUARTER.equals(this.mode)) {
                new ImportDialog("\u0418\u043c\u043f\u043e\u0440\u0442", this.objectIdMap.get(CITY)).getDialog().setVisible(true);
            } else if (CITY.equals(this.mode)) {
                new ImportDialog("\u0418\u043c\u043f\u043e\u0440\u0442", this.objectIdMap.get(COUNTRY)).getDialog().setVisible(true);
            }
        });
        JPanel navPanel = new JPanel(new GridBagLayout());
        navPanel.add((Component)this.titleLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 15), 0, 0));
        navPanel.add((Component)this.subTitleLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 30), 0, 0));
        navPanel.add((Component)this.importButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        navPanel.add((Component)this.recordCountLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 20), 0, 0));
        navPanel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.setVisible(false);
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorViewPanel.setLayout(new BorderLayout());
        this.editorPanel.add((Component)this.editorViewPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)this.okCancelPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)navPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.tablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.editorPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        return panel;
    }

    private void okCancel_actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if ("ok".equals(actionCommand) && this.currentViewPanel != null && this.currentViewPanel.stopEdit()) {
            this.editorPanel.setVisible(false);
            this.setData(this.mode);
        }
        if ("cancel".equals(actionCommand)) {
            this.editorPanel.setVisible(false);
        }
    }

    private JPanel getSearchPanel(String title, String table) {
        BGTextField filter = new BGTextField();
        filter.setName(table);
        filter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyChar() == '\n') {
                    DirectoryAddressEditorTab.this.editorPanel.setVisible(false);
                    DirectoryAddressEditorTab.this.pagePanel.setPageIndex(1);
                    DirectoryAddressEditorTab.this.setData(((BGTextField)event.getSource()).getName());
                }
            }
        });
        this.filterMap.put(table, filter);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(title), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
        panel.add((Component)filter, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 5, 10), 0, 0));
        panel.add((Component)this.getButtonPanel(table), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 5, 10), 0, 0));
        return panel;
    }

    private JPanel getButtonPanel(String command) {
        BGButton clearButton = new BGButton("X");
        clearButton.setActionCommand(command);
        clearButton.addActionListener(actionEvent -> {
            this.pagePanel.setPageIndex(1);
            this.resetData(actionEvent.getActionCommand());
            this.setData(actionEvent.getActionCommand());
        });
        BGButton searchButton = new BGButton(">>");
        searchButton.setActionCommand(command);
        searchButton.addActionListener(actionEvent -> {
            this.editorPanel.setVisible(false);
            this.pagePanel.setPageIndex(1);
            this.setData(actionEvent.getActionCommand());
        });
        this.buttonMap.put(command, searchButton);
        BGComboBox<String> comboBox = new BGComboBox<String>();
        comboBox.addItem("\u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0430");
        comboBox.addItem("\u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f");
        comboBox.addItem("\u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
        comboBox.addItem("\u0440\u0430\u0432\u043d\u0430");
        this.searchModeMap.put(command, comboBox);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(comboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)clearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)searchButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    public void setData(String mode) {
        this.mode = mode;
        if (!this.filterMap.isEmpty()) {
            int cityId;
            Request request = new Request();
            request.setModule(((ClientContext)this.getContext()).getModule());
            request.setAction("SearchAddressDirectory");
            request.setAttribute("mode", mode);
            request.setPage(this.pagePanel);
            String titleLabelText = "";
            String subTitleLabelText = "";
            if (COUNTRY.equals(mode)) {
                titleLabelText = "\u0421\u0442\u0440\u0430\u043d\u044b";
                this.importButton.setVisible(true);
                request.setAttribute("searchCountry", this.filterMap.get(COUNTRY).getText());
                request.setAttribute("searchCountryMode", this.getSearchMode(this.searchModeMap.get(COUNTRY)));
            } else if (CITY.equals(mode)) {
                titleLabelText = "\u0413\u043e\u0440\u043e\u0434\u0430";
                int countryId = this.objectIdMap.get(COUNTRY);
                subTitleLabelText = countryId > 0 ? "( " + this.filterMap.get(COUNTRY).getText() + " )" : "(\u0441\u0442\u0440\u0430\u043d\u0430 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430)";
                this.importButton.setVisible(countryId > 0);
                request.setAttribute("countryId", countryId);
                request.setAttribute("searchCity", this.filterMap.get(CITY).getText());
                request.setAttribute("searchCityMode", this.getSearchMode(this.searchModeMap.get(CITY)));
            } else if (STREET.equals(mode)) {
                titleLabelText = "\u0423\u043b\u0438\u0446\u044b";
                cityId = this.objectIdMap.get(CITY);
                subTitleLabelText = cityId > 0 ? "( " + this.filterMap.get(CITY).getText() + " )" : "(\u0433\u043e\u0440\u043e\u0434 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d)";
                this.importButton.setVisible(cityId > 0);
                request.setAttribute("cityId", cityId);
                request.setAttribute("searchStreet", this.filterMap.get(STREET).getText());
                request.setAttribute("searchStreetMode", this.getSearchMode(this.searchModeMap.get(STREET)));
            } else if (AREA.equals(mode)) {
                titleLabelText = "\u0420\u0430\u0439\u043e\u043d\u044b";
                cityId = this.objectIdMap.get(CITY);
                subTitleLabelText = cityId > 0 ? "( " + this.filterMap.get(CITY).getText() + " )" : "(\u0433\u043e\u0440\u043e\u0434 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d)";
                this.importButton.setVisible(cityId > 0);
                request.setAttribute("cityId", cityId);
                request.setAttribute("searchArea", this.filterMap.get(AREA).getText());
                request.setAttribute("searchAreaMode", this.getSearchMode(this.searchModeMap.get(AREA)));
            } else if (QUARTER.equals(mode)) {
                titleLabelText = "\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u0430";
                cityId = this.objectIdMap.get(CITY);
                subTitleLabelText = cityId > 0 ? "( " + this.filterMap.get(CITY).getText() + " )" : "(\u0433\u043e\u0440\u043e\u0434 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d)";
                this.importButton.setVisible(cityId > 0);
                request.setAttribute("cityId", cityId);
                request.setAttribute("searchQuarter", this.filterMap.get(QUARTER).getText());
                request.setAttribute("searchQuarterMode", this.getSearchMode(this.searchModeMap.get(QUARTER)));
            } else if (HOUSE.equals(mode)) {
                titleLabelText = "\u0414\u043e\u043c\u0430";
                subTitleLabelText = "";
                int submode = this.tabbedPane.getSelectedIndex();
                request.setAttribute("submode", String.valueOf(submode));
                if (submode == 1) {
                    int quarterId = this.objectIdMap.get(QUARTER);
                    request.setAttribute("quarterId", quarterId);
                    subTitleLabelText = quarterId > 0 ? "( " + this.filterMap.get(QUARTER).getText() + " )" : "(\u043a\u0432\u0430\u0440\u0442\u0430\u043b \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d)";
                    this.importButton.setVisible(quarterId > 0);
                } else if (submode == 2) {
                    int areaId = this.objectIdMap.get(AREA);
                    request.setAttribute("areaId", areaId);
                    subTitleLabelText = areaId > 0 ? "( " + this.filterMap.get(AREA).getText() + " )" : "(\u0440\u0430\u0439\u043e\u043d \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d)";
                    this.importButton.setVisible(areaId > 0);
                } else {
                    int streeId = this.objectIdMap.get(STREET);
                    request.setAttribute("streetId", streeId);
                    subTitleLabelText = streeId > 0 ? "( " + this.filterMap.get(STREET).getText() + " )" : "(\u0443\u043b\u0438\u0446\u0430 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d)";
                    this.importButton.setVisible(streeId > 0);
                }
                request.setAttribute("searchHouse", this.filterMap.get(HOUSE).getText());
            }
            this.titleLabel.setText(titleLabelText);
            this.subTitleLabel.setText(subTitleLabelText);
            Document doc = ((ClientContext)this.getContext()).getDocument(request);
            if (ClientUtils.checkStatus(doc)) {
                this.setDocument(doc, mode);
            }
        }
        this.tableLayout.show(this.tablePanel, mode);
    }

    public void setDocument(Document doc) {
        this.setDocument(doc, COUNTRY);
    }

    public void setDocument(Document doc, String mode) {
        Node tableNode = XMLUtils.getNode(doc, "table");
        ArrayList<Element> data = new ArrayList<Element>();
        for (Element element : XMLUtils.selectElements(doc, "//table/data/row")) {
            data.add(element);
        }
        this.tableModelMap.get(mode).setData(data);
        this.pagePanel.setPageInfo((Element)tableNode);
        this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + ((Element)tableNode).getAttribute("recordCount"));
    }

    private String getSearchMode(BGComboBox<String> comboBox) {
        String result = "";
        String item = comboBox.getSelectedItem();
        if (item.equals("\u043f\u043e\u0434\u0441\u0442\u0440\u043e\u043a\u0430")) {
            result = "subs";
        } else if (item.equals("\u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f")) {
            result = "start";
        } else if (item.equals("\u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f")) {
            result = "end";
        } else if (item.equals("\u0440\u0430\u0432\u043d\u0430")) {
            result = "equal";
        }
        return result;
    }

    private void setBlock(String mode, String id, String title) {
        this.objectIdMap.put(mode, Utils.parseInt(id));
        this.filterMap.get(mode).setEditable(false);
        this.filterMap.get(mode).setText(title);
        this.buttonMap.get(mode).setEnabled(false);
        this.searchModeMap.get(mode).setEnabled(false);
    }

    private void unsetBlock(String mode) {
        this.objectIdMap.put(mode, -1);
        this.filterMap.get(mode).setEditable(true);
        this.filterMap.get(mode).setText("");
        this.buttonMap.get(mode).setEnabled(true);
        this.searchModeMap.get(mode).setEnabled(true);
    }

    class CountryTableModel
    extends BGTableModel<Element> {
        public CountryTableModel() {
            super(CountryTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0440\u0430\u043d\u0430", 0, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class CityTableModel
    extends BGTableModel<Element> {
        public CityTableModel() {
            super(CityTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0440\u0430\u043d\u0430", 100, 150, 200, "country_title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0413\u043e\u0440\u043e\u0434", 0, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class AreaTableModel
    extends BGTableModel<Element> {
        public AreaTableModel() {
            super(AreaTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0440\u0430\u043d\u0430", 100, 150, 200, "country_title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0413\u043e\u0440\u043e\u0434", 0, 150, 250, "city_title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0430\u0439\u043e\u043d", 0, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class QuarterTableModel
    extends BGTableModel<Element> {
        public QuarterTableModel() {
            super(QuarterTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0440\u0430\u043d\u0430", 100, 150, 200, "country_title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0413\u043e\u0440\u043e\u0434", 0, 150, 250, "city_title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u0432\u0430\u0440\u0442\u0430\u043b", 0, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class StreetTableModel
    extends BGTableModel<Element> {
        public StreetTableModel() {
            super(StreetTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0440\u0430\u043d\u0430", 100, 150, 200, "country_title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0413\u043e\u0440\u043e\u0434", 0, 150, 250, "city_title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0423\u043b\u0438\u0446\u0430", 0, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class HouseTableModel
    extends BGTableModel<Element> {
        public HouseTableModel() {
            super(HouseTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0421\u0442\u0440\u0430\u043d\u0430", 100, 150, 200, "country_title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0413\u043e\u0440\u043e\u0434", 0, 150, 250, "city_title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0420\u0430\u0439\u043e\u043d/\u041a\u0432\u0430\u0440\u0442\u0430\u043b/\u0423\u043b\u0438\u0446\u0430", 0, -1, -1, "item_title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u043e\u043c", 70, 70, 70, DirectoryAddressEditorTab.HOUSE, true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.RIGHT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 0, -1, -1, "comment", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    class ImportDialog
    extends BGEditorDialog<Integer> {
        private JTextArea text;

        public ImportDialog(String title, Integer data) {
            super(title, data);
            this.text = new JTextArea(20, 50);
        }

        @Override
        public void doDialogPanel() {
            this.text.setMargin(new Insets(3, 3, 3, 3));
            this.panel.add((Component)new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane(this.text), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.text.getText().isBlank()) {
                ClientUtils.showErrorMessageDialog("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430...");
                return false;
            }
            int mode = 0;
            switch (DirectoryAddressEditorTab.this.mode) {
                case "country": {
                    mode = 20;
                    break;
                }
                case "city": {
                    mode = 5;
                    break;
                }
                case "area": {
                    mode = 6;
                    break;
                }
                case "quarter": {
                    mode = 8;
                    break;
                }
                case "street": {
                    mode = 7;
                }
            }
            DirectoryAddressEditorTab.this.getDirectoryService().addressImport(mode, (Integer)this.data, this.text.getText());
            DirectoryAddressEditorTab.this.setData(DirectoryAddressEditorTab.this.mode);
            return super.doApply();
        }
    }
}

