/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import ru.bitel.bgbilling.client.common.BGMaskTextField;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CalendarPanel_v3
extends JPanel {
    private static final String ENTER = "ENTER";
    private static final String CLEAR = "CLEAR";
    private static final String YEAR_INC = "YEAR_INC";
    private static final String MONTH_INC = "MONTH_INC";
    private static final String MONTH_DEC = "MONTH_DEC";
    private static final String YEAR_DEC = "YEAR_DEC";
    private static final String[] weekDays = new String[]{"\u041f\u043d.", "\u0412\u0442.", "\u0421\u0440.", "\u0427\u0442.", "\u041f\u0442.", "\u0421\u0431.", "\u0412\u0441."};
    private static final Font fontBold = new Font("Dialog", 1, 12);
    private static final Font fontPlain = new Font("Dialog", 0, 10);
    private static final Font fontLabel = new Font("Dialog", 0, 9);
    private Calendar calendarOld = null;
    private Calendar calendarCurrent = null;
    private Calendar firstDate = null;
    private String typeButtonPress = null;
    private JPanel panelDays = new JPanel();
    private JPanel panelMonth = new JPanel();
    private JPanel panelYear = new JPanel();
    private JLabel labelDate = new JLabel();
    private JPanel thisPanel = this;
    private DateField dateField = new DateField();

    public CalendarPanel_v3() {
        this.getActionMap().put(MONTH_DEC, new AbstractAction(" < "){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CalendarPanel_v3.this.calendarCurrent != null) {
                    CalendarPanel_v3.this.calendarCurrent.add(2, -1);
                }
                CalendarPanel_v3.this.updateDate();
            }
        });
        this.getActionMap().put(MONTH_INC, new AbstractAction(" > "){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CalendarPanel_v3.this.calendarCurrent != null) {
                    CalendarPanel_v3.this.calendarCurrent.add(2, 1);
                }
                CalendarPanel_v3.this.updateDate();
            }
        });
        this.getActionMap().put(YEAR_DEC, new AbstractAction("<<"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CalendarPanel_v3.this.calendarCurrent != null) {
                    CalendarPanel_v3.this.calendarCurrent.add(1, -1);
                }
                CalendarPanel_v3.this.updateDate();
            }
        });
        this.getActionMap().put(YEAR_INC, new AbstractAction(">>"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CalendarPanel_v3.this.calendarCurrent != null) {
                    CalendarPanel_v3.this.calendarCurrent.add(1, 1);
                }
                CalendarPanel_v3.this.updateDate();
            }
        });
        this.getActionMap().put(CLEAR, new AbstractAction(" X "){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CalendarPanel_v3.this.typeButtonPress = "x";
                CalendarPanel_v3.this.calendarCurrent = null;
                CalendarPanel_v3.this.labelDate.setText(" ");
                CalendarPanel_v3.this.thisPanel.firePropertyChange("updateCalendar", true, false);
            }
        });
        try {
            this.jbInit();
            this.buildButtons();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getInputMap(1).put(KeyStroke.getKeyStroke(37, 128), MONTH_DEC);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(39, 128), MONTH_INC);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(40, 128), YEAR_DEC);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(38, 128), YEAR_INC);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), CLEAR);
        this.updateDate();
    }

    private void jbInit() throws Exception {
        NavButton buttonYearDec = new NavButton(this.getActionMap().get(YEAR_DEC));
        NavButton buttonMonthDec = new NavButton(this.getActionMap().get(MONTH_DEC));
        NavButton buttonClear = new NavButton(this.getActionMap().get(CLEAR));
        NavButton buttonMonthInc = new NavButton(this.getActionMap().get(MONTH_INC));
        NavButton buttonYearInc = new NavButton(this.getActionMap().get(YEAR_INC));
        this.panelDays.setLayout(new GridLayout(7, 7));
        this.panelMonth.setLayout(new GridLayout(7, 2));
        this.panelYear.setLayout(new GridLayout(7, 1));
        this.labelDate.setFont(fontBold);
        this.labelDate.setText(" ");
        this.panelDays.setOpaque(false);
        final AbstractAction enterAction = new AbstractAction("Ok"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String date = CalendarPanel_v3.this.dateField.getText();
                if (date != null) {
                    CalendarPanel_v3.this.typeButtonPress = "ok";
                    CalendarPanel_v3.this.calendarCurrent = (Calendar)CalendarPanel_v3.this.firstDate.clone();
                    CalendarPanel_v3.this.calendarCurrent.setTime(TimeUtils.convertStringToDate(date));
                    CalendarPanel_v3.this.updateDate();
                    CalendarPanel_v3.this.thisPanel.firePropertyChange("updateCalendar", true, false);
                }
            }
        };
        NavButton ok = new NavButton(enterAction);
        ok.getActionMap().put(ENTER, enterAction);
        ok.getInputMap().put(KeyStroke.getKeyStroke(10, 0), ENTER);
        this.dateField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("PressEnterByMaskTextField")) {
                    enterAction.actionPerformed(null);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.dateField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)ok, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 5, 0, 0), 0, 0));
        JPanel jPanel1 = new JPanel(new GridBagLayout());
        jPanel1.setOpaque(false);
        jPanel1.add((Component)buttonYearDec, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add((Component)buttonMonthDec, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add((Component)panel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        jPanel1.add((Component)buttonClear, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        jPanel1.add((Component)buttonMonthInc, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel1.add((Component)buttonYearInc, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel1, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.labelDate, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.panelDays, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.panelMonth, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.panelYear, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void buildButtons() {
        JButton button;
        int i;
        JLabel label = null;
        Insets insets = new Insets(0, 0, 0, 0);
        Dimension dimension = new Dimension(26, 20);
        ActionListener dbal = actionEvent -> this.dayClick(actionEvent);
        ActionListener mbal = actionEvent -> this.monthClick(actionEvent);
        ActionListener ybal = actionEvent -> this.yearClick(actionEvent);
        for (i = 0; i < 7; ++i) {
            label = new JLabel(weekDays[i]);
            label.setFont(fontLabel);
            label.setHorizontalAlignment(0);
            this.panelDays.add((Component)label, null);
        }
        for (i = 0; i < 42; ++i) {
            button = new JButton("  ");
            button.setActionCommand(String.valueOf(i));
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelDays.add((Component)button, null);
            button.addActionListener(dbal);
        }
        for (i = 0; i < 2; ++i) {
            label = new JLabel(" ");
            label.setFont(fontLabel);
            this.panelMonth.add((Component)label, null);
        }
        for (i = 0; i < 6; ++i) {
            button = new JButton("  ");
            button.setActionCommand(String.valueOf(i));
            button.setText("0" + String.valueOf(i + 1));
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelMonth.add((Component)button, null);
            button.addActionListener(mbal);
            button = new JButton("  ");
            button.setActionCommand(String.valueOf(i + 6));
            if (i + 7 < 10) {
                button.setText("0" + String.valueOf(i + 7));
            } else {
                button.setText(String.valueOf(i + 7));
            }
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelMonth.add((Component)button, null);
            button.addActionListener(mbal);
        }
        label = new JLabel(" ");
        label.setFont(fontLabel);
        this.panelYear.add((Component)label, null);
        dimension = new Dimension(40, 20);
        for (i = 0; i < 6; ++i) {
            button = new JButton("  ");
            button.setFont(fontPlain);
            button.setMargin(insets);
            button.setMinimumSize(dimension);
            button.setPreferredSize(dimension);
            this.panelYear.add((Component)button, null);
            button.addActionListener(ybal);
        }
        ((JButton)this.panelYear.getComponent(5)).setFont(fontBold);
    }

    private void updateDate() {
        JButton button;
        int i;
        int month;
        if (this.calendarCurrent == null) {
            return;
        }
        int year = this.calendarCurrent.get(1);
        GregorianCalendar calendar = new GregorianCalendar(year, month = this.calendarCurrent.get(2), 1);
        int DAY_OF_WEEK = calendar.get(7);
        if (DAY_OF_WEEK == 1) {
            ((Calendar)calendar).add(5, -7);
        } else {
            ((Calendar)calendar).add(5, 1 - DAY_OF_WEEK);
        }
        this.firstDate = (Calendar)((Calendar)calendar).clone();
        for (int i2 = 1; i2 < this.panelYear.getComponentCount(); ++i2) {
            JButton button2 = (JButton)this.panelYear.getComponent(i2);
            button2.setActionCommand(String.valueOf(year - 5 + i2));
            button2.setText(String.valueOf(year - 5 + i2));
        }
        String monthString = String.valueOf(month);
        for (i = 2; i < this.panelMonth.getComponentCount(); ++i) {
            button = (JButton)this.panelMonth.getComponent(i);
            if (monthString.equals(button.getActionCommand())) {
                button.setFont(fontBold);
                continue;
            }
            button.setFont(fontPlain);
        }
        for (i = 7; i < this.panelDays.getComponentCount(); ++i) {
            ((Calendar)calendar).add(5, 1);
            button = (JButton)this.panelDays.getComponent(i);
            button.setText("" + calendar.get(5));
            if (calendar.get(2) == month) {
                button.setFont(fontBold);
                button.setForeground(Color.black);
                continue;
            }
            button.setFont(fontPlain);
            button.setForeground(Color.darkGray);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.calendarCurrent.get(5));
        buf.append(' ');
        buf.append(TimeUtils.monthNames[month]);
        buf.append(' ');
        buf.append(year);
        this.labelDate.setText(buf.toString());
        SimpleDateFormat f = new SimpleDateFormat("dd.MM.yyyy");
        this.dateField.setText(f.format(this.calendarCurrent.getTime()));
        this.firePropertyChange("updateTitle", "", buf.toString());
    }

    private void dayClick(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        this.calendarCurrent = (Calendar)this.firstDate.clone();
        this.typeButtonPress = "day";
        this.calendarCurrent.add(5, Utils.parseInt(actionCommand, 0) + 1);
        this.updateDate();
        this.firePropertyChange("updateCalendar", true, false);
    }

    private void monthClick(ActionEvent actionEvent) {
        this.changeMonthYear(Utils.parseInt(actionEvent.getActionCommand(), 0), this.calendarCurrent.get(1));
        this.updateDate();
    }

    private void yearClick(ActionEvent actionEvent) {
        this.changeMonthYear(this.calendarCurrent.get(2), Utils.parseInt(actionEvent.getActionCommand(), 2000));
        this.updateDate();
    }

    private void changeMonthYear(int month, int year) {
        int day = this.calendarCurrent.get(5);
        this.calendarCurrent.set(5, 1);
        this.calendarCurrent.set(2, month);
        this.calendarCurrent.set(1, year);
        this.calendarCurrent.set(5, Math.min(day, this.calendarCurrent.getActualMaximum(5)));
    }

    public void setCalendar(Calendar calendar) {
        this.calendarOld = calendar;
        this.calendarCurrent = calendar == null ? new GregorianCalendar() : (Calendar)calendar.clone();
        this.calendarCurrent.clear(14);
        this.calendarCurrent.clear(13);
        this.calendarCurrent.clear(12);
        this.calendarCurrent.clear(11);
        this.calendarCurrent.clear(0);
        this.updateDate();
    }

    public Calendar getCalendar() {
        return this.calendarCurrent;
    }

    public Calendar getOldCalendar() {
        return this.calendarOld;
    }

    public void setVisibleLabelDate(boolean value) {
        this.labelDate.setVisible(value);
    }

    public BGMaskTextField getDateField() {
        return this.dateField;
    }

    public String getTypeButtonPress() {
        return this.typeButtonPress;
    }

    private class DateField
    extends BGMaskTextField {
        DateField() {
            super("  .  .    ", ".", new BGMaskTextField.IntegerValidator(1L, 31L, 2), new BGMaskTextField.IntegerValidator(1L, 12L, 2), new BGMaskTextField.IntegerValidator());
            this.setHorizontalAlignment(0);
        }
    }

    class NavButton
    extends JButton {
        public NavButton(Action action) {
            this.setMargin(new Insets(2, 2, 2, 2));
            this.setFont(fontBold);
            this.setAction(action);
        }
    }
}

