/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTableColumnVisibility;
import ru.bitel.bgbilling.client.common.BGUTableSearchPopupListener;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.tree.AbstractTreeTableModel;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.table.AbstractBGTableModel;
import ru.bitel.common.client.table.AbstractBGUTable;
import ru.bitel.common.client.table.BasicBGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;

public class BGUTable
extends AbstractBGUTable<ClientContext> {
    private ClientContext clientContext = null;
    private static Map<String, int[]> tableWidths = new HashMap<String, int[]>();
    private static Map<String, int[]> tablePositions = new HashMap<String, int[]>();
    private static Map<String, byte[]> tableVisibility = new HashMap<String, byte[]>();
    private static Map<String, Integer> tableColumnResize = new HashMap<String, Integer>();

    public BGUTable(TableModel model) {
        this(model, (ClientContext)null);
    }

    public BGUTable(TableModel model, ClientContext clientContext) {
        super(BGUTable.check(model));
        this.clientContext = clientContext;
        if (model instanceof BasicBGTableModel) {
            final BasicBGTableModel tm = (BasicBGTableModel)model;
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    Object selected;
                    if ((e.getModifiersEx() & 0x80) > 0 && e.getKeyCode() == 73 && (selected = (selected = tm.getSelectedRow()) instanceof Id ? Integer.valueOf(((Id)selected).getId()) : (selected instanceof Idable ? Integer.valueOf(((Idable)selected).getId()) : null)) != null) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041a\u043e\u0434 = " + selected, "\u041a\u043e\u0434 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f", 1);
                    }
                }
            });
            this.setSelectionModel(new BGListSelectionModel(this));
        }
    }

    @Override
    public ClientContext getContext() {
        ClientContext clientContext = (ClientContext)super.getContext();
        return clientContext != null ? clientContext : this.clientContext;
    }

    public void setContext(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    private static TableModel check(TableModel dm) {
        if (dm instanceof AbstractTreeTableModel) {
            throw new IllegalArgumentException();
        }
        return dm;
    }

    @Override
    protected void initHeaderMenu() {
        if (this.tableHeaderButton == null) {
            return;
        }
        JPopupMenu popupMenu = this.tableHeaderButton.getComponentPopupMenu();
        if (popupMenu == null) {
            popupMenu = new JPopupMenu();
            this.tableHeaderButton.setComponentPopupMenu(popupMenu);
        }
        JCheckBoxMenuItem resizeMenu = new JCheckBoxMenuItem(new BGUAction("table.columns.resize", "\u0420\u0430\u0441\u0442\u044f\u0433\u0438\u0432\u0430\u0442\u044c"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (BGUTable.this.getAutoResizeMode() == 0) {
                    BGUTable.this.setAutoResizeMode(3);
                } else {
                    BGUTable.this.setAutoResizeMode(0);
                }
            }
        });
        resizeMenu.setSelected(this.getAutoResizeMode() != 0);
        this.tableHeaderButton.addActionListener(e -> {
            resizeMenu.setSelected(this.getAutoResizeMode() != 0);
            this.tableHeaderButton.getComponentPopupMenu().show(this.tableHeaderButton, 0, this.tableHeaderButton.getHeight());
        });
        popupMenu.add(resizeMenu);
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0417\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUTable.saveColumnProperties(BGUTable.this, false);
            }
        }));
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.visibility", "\u0412\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u044c \u0441\u0442\u043e\u043b\u0431\u0446\u043e\u0432..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new BGUTableColumnVisibility(BGUTable.this, (Window)SwingUtilities.getRoot(BGUTable.this));
            }
        }));
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0421\u0431\u0440\u043e\u0441\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUTable.resetColumnProperties(BGUTable.this);
            }
        }));
        popupMenu.add(new JMenuItem(new BGUAction("table.columns.reset", "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BGUTable.saveColumnProperties(BGUTable.this, true);
            }
        }));
    }

    @Override
    protected final ClientContext innerGetContext(Container parent) {
        if (parent instanceof BGPanel) {
            return ((BGPanel)parent).getContext();
        }
        if (parent instanceof BGDialog) {
            return ((BGDialog)parent).getContext();
        }
        if (parent == null) {
            return ClientContext.get();
        }
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        BGUTable.loadColumnProperties(this);
    }

    public void loadColumnProperties() {
        BGUTable.loadColumnProperties(this);
    }

    static void loadColumnProperties(AbstractBGUTable<? extends ClientContext> table) {
        try {
            Preferences userConfig;
            ClientContext ctx = table.getContext();
            String module = ctx == null ? null : ctx.getModule();
            String tableId = table.getName();
            if (tableId == null) {
                return;
            }
            int[] widths = tableWidths.get(module + tableId);
            int[] positions = tablePositions.get(module + tableId);
            byte[] hiddens = tableVisibility.get(module + tableId);
            Integer columnResizeMode = tableColumnResize.get(module + tableId);
            if (widths != null && widths.length <= 0) {
                return;
            }
            String prefix = BGUTable.getPrefix(table);
            ClientSetup clientSetup = ClientSetup.getInstance();
            Preferences preferences = userConfig = clientSetup == null ? new Preferences() : clientSetup.getUserConfig();
            if (widths == null) {
                int i;
                String params = userConfig.get(prefix + ".columnsWidth", null);
                List<Integer> _params = Utils.toIntegerList(params);
                if (_params.size() > 0) {
                    widths = new int[_params.size()];
                    i = 0;
                    for (Integer par : _params) {
                        widths[i++] = par;
                    }
                }
                if ((_params = Utils.toIntegerList(params = userConfig.get(prefix + ".columnsPosition", null))).size() > 0) {
                    positions = new int[_params.size()];
                    i = 0;
                    for (Integer par : _params) {
                        positions[i++] = par;
                    }
                }
                if ((_params = Utils.toIntegerList(params = userConfig.get(prefix + ".columnsHidden", null))).size() > 0) {
                    hiddens = new byte[_params.size()];
                    i = 0;
                    for (Integer par : _params) {
                        hiddens[i++] = par.byteValue();
                    }
                }
                columnResizeMode = userConfig.getInt(prefix + ".columnsResize", 3);
                if (widths != null && widths.length <= 0) {
                    return;
                }
            }
            if (widths == null) {
                Request request = new Request();
                request.setAction("BGTable");
                request.setModule("admin");
                request.setAttribute("table", tableId);
                request.setAttribute("table_module", module);
                try {
                    Element param;
                    Document document = TransferManager.getDocument(request);
                    if (document != null && "ok".equals(document.getDocumentElement().getAttribute("status")) && (param = XMLUtils.getElement(document, "table_param")) != null) {
                        String params = param.getAttribute("width");
                        List<Integer> _params = Utils.toIntegerList(params);
                        if (_params.size() > 0) {
                            widths = new int[_params.size()];
                            int i = 0;
                            for (Integer par : _params) {
                                widths[i++] = par;
                            }
                            userConfig.set(prefix + ".columnsWidth", params);
                        }
                        if ((_params = Utils.toIntegerList(params = param.getAttribute("positions"))).size() > 0) {
                            positions = new int[_params.size()];
                            int i = 0;
                            for (Integer par : _params) {
                                positions[i++] = par;
                            }
                            userConfig.set(prefix + ".columnsPosition", params);
                        }
                        if ((_params = Utils.toIntegerList(params = param.getAttribute("hiddens"))).size() > 0) {
                            hiddens = new byte[_params.size()];
                            int i = 0;
                            for (Integer par : _params) {
                                hiddens[i++] = par.byteValue();
                            }
                            userConfig.set(prefix + ".columnHiddens", params);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (columnResizeMode != null) {
                table.setAutoResizeMode(columnResizeMode);
            }
            BGUTable.setHiddens(table, hiddens);
            BGUTable.setWidths(table, widths);
            BGUTable.setPositions(table, positions);
            if (widths == null) {
                widths = new int[]{};
            }
            tableWidths.put(module + tableId, widths);
            if (positions == null) {
                positions = new int[]{};
            }
            tablePositions.put(module + tableId, positions);
            tableVisibility.put(module + tableId, hiddens);
            tableColumnResize.put(module + tableId, table.getAutoResizeMode());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void setPositions(AbstractBGUTable<? extends ClientContext> table, int[] positions) {
        if (positions != null) {
            int i;
            int[] temp = new int[positions.length];
            for (int i2 = 0; i2 < positions.length; ++i2) {
                temp[positions[i2]] = i2;
            }
            Vector<Integer> vect = new Vector<Integer>();
            for (i = 0; i < temp.length; ++i) {
                vect.add(temp[i]);
            }
            i = 0;
            while (i < positions.length) {
                if ((Integer)vect.get(i) > i) {
                    int newPos = (Integer)vect.get(i);
                    table.getColumnModel().moveColumn(i, newPos);
                    vect.insertElementAt((Integer)vect.remove(i), newPos);
                    continue;
                }
                ++i;
            }
        }
    }

    private static void setWidths(AbstractBGUTable<? extends ClientContext> table, int[] widths) {
        if (widths != null) {
            int i = 0;
            Enumeration<TableColumn> columnList = table.getColumnModel().getColumns();
            while (columnList.hasMoreElements() && i < widths.length) {
                TableColumn column = columnList.nextElement();
                column.setPreferredWidth(widths[i++]);
            }
        }
    }

    private static void setHiddens(AbstractBGUTable<? extends ClientContext> table, byte[] hiddens) {
        if (hiddens != null) {
            int i = 0;
            Enumeration<TableColumn> columnList = table.getColumnModel().getColumns();
            while (columnList.hasMoreElements() && i < hiddens.length) {
                byte h;
                TableColumn column = columnList.nextElement();
                if ((h = hiddens[i++]) == 1) {
                    column.setMinWidth(0);
                    column.setPreferredWidth(0);
                    column.setMaxWidth(0);
                    continue;
                }
                if (h != 2) continue;
                column.setMinWidth(0);
                column.setPreferredWidth(100);
                column.setMaxWidth(200);
            }
        }
    }

    static void saveColumnProperties(AbstractBGUTable<? extends ClientContext> table, boolean asDefault) {
        int width;
        ClientContext ctx = table.getContext();
        String module = ctx.getModule();
        String tableId = table.getName();
        AbstractBGTableModel bgModel = null;
        if (table.getModel() instanceof AbstractBGTableModel) {
            bgModel = (AbstractBGTableModel)table.getModel();
        }
        TableColumnModel columnModel = table.getColumnModel();
        ArrayList<Integer> posList = new ArrayList<Integer>();
        byte[] hiddens = new byte[columnModel.getColumnCount()];
        int[] _widths = new int[columnModel.getColumnCount()];
        int[] _positions = new int[columnModel.getColumnCount()];
        int i = 0;
        Enumeration<TableColumn> columnList = columnModel.getColumns();
        while (columnList.hasMoreElements()) {
            TableColumn column = columnList.nextElement();
            int pos = column.getModelIndex();
            width = column.getWidth();
            if (width == 0 && bgModel != null) {
                width = bgModel.getColumnPrefferedWidth(column.getModelIndex());
            }
            _widths[column.getModelIndex()] = width;
            posList.add(column.getModelIndex());
            _positions[i] = pos;
            hiddens[pos] = bgModel != null && bgModel.getColumnMaxWidth(column.getModelIndex()) != 0 ? (column.getWidth() <= 0 ? 1 : 0) : (column.getWidth() <= 0 ? 0 : 2);
            ++i;
        }
        ArrayList<Integer> widthList = new ArrayList<Integer>();
        int[] pos = _widths;
        width = pos.length;
        for (int j = 0; j < width; ++j) {
            Integer w = pos[j];
            widthList.add(w);
        }
        String widths = Utils.toString(widthList);
        String positions = Utils.toString(posList);
        StringBuffer vis = new StringBuffer();
        if (hiddens.length > 0) {
            vis.append(hiddens[0]);
        }
        for (i = 1; i < hiddens.length; ++i) {
            vis.append(',').append(hiddens[i]);
        }
        Request request = new Request();
        request.setAction("BGTable");
        request.setModule("admin");
        request.setAttribute("table", tableId);
        request.setAttribute("table_module", module);
        request.setAttribute("width", widths);
        request.setAttribute("positions", positions);
        request.setAttribute("hiddens", vis.toString());
        request.setAttribute("as_default", asDefault);
        ClientUtils.checkStatus(TransferManager.getDocument(request));
        tableWidths.put(module + tableId, _widths);
        tablePositions.put(module + tableId, _positions);
        tableVisibility.put(module + tableId, hiddens);
        tableColumnResize.put(module + tableId, table.getAutoResizeMode());
        String prefix = BGUTable.getPrefix(table);
        Preferences userConfig = ClientSetup.getInstance().getUserConfig();
        userConfig.set(prefix + ".columnsWidth", widths);
        userConfig.set(prefix + ".columnsPosition", positions);
        userConfig.set(prefix + ".columnsHidden", vis.toString());
        userConfig.set(prefix + ".columnsResize", String.valueOf(table.getAutoResizeMode()));
    }

    private static String getPrefix(Component c) {
        return ClientUtils.getComponentKey(c, null);
    }

    static void resetColumnProperties(AbstractBGUTable<? extends ClientContext> table) {
        ClientContext ctx = table.getContext();
        String module = ctx.getModule();
        String tableId = table.getName();
        Request request = new Request();
        request.setAction("BGTable");
        request.setModule("admin");
        request.setAttribute("table", tableId);
        request.setAttribute("table_module", module);
        request.setAttribute("reset", "1");
        TransferManager.getDocument(request);
        tableWidths.put(module + tableId, new int[0]);
        tablePositions.remove(module + tableId);
        tableVisibility.remove(module + tableId);
        tableColumnResize.remove(module + tableId);
        for (int j = 1; j < table.getColumnModel().getColumnCount(); ++j) {
            Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
            int i = 0;
            while (columns.hasMoreElements()) {
                TableColumn column = columns.nextElement();
                int pos = column.getModelIndex();
                if (pos > i) {
                    table.getColumnModel().moveColumn(i, pos);
                }
                ++i;
            }
        }
        table.setAutoResizeMode(3);
        table.resetColumnsWidths();
    }

    public String[] getSort() {
        List<RowSorter.SortKey> sortList;
        ArrayList<String> sort = new ArrayList<String>();
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter != null && (sortList = rowSorter.getSortKeys()) != null) {
            BasicBGTableModel model = (BasicBGTableModel)this.getModel();
            for (RowSorter.SortKey sortKey : sortList) {
                if (sortKey.getSortOrder() == SortOrder.UNSORTED) continue;
                sort.add(model.getIdentifier(sortKey.getColumn()).concat(":").concat(String.valueOf(sortKey.getSortOrder().ordinal())));
            }
        }
        return sort.toArray(new String[0]);
    }

    public void enableSearchField() {
        this.addKeyListener(new BGUTableSearchPopupListener(this));
    }

    public boolean pointOnSelectRows(Point point) {
        boolean result = false;
        if (point != null) {
            int row = this.rowAtPoint(point);
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows != null && selectedRows.length > 0) {
                for (int index = 0; index < selectedRows.length; ++index) {
                    if (selectedRows[index] != row) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public class BGListSelectionModel
    extends DefaultListSelectionModel {
        public BGListSelectionModel(final BGUTable table) {
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (event.getSource() instanceof BGListSelectionModel) {
                        BasicBGTableModel tableModel = (BasicBGTableModel)table.getModel();
                        List list = tableModel.getSelectedRows();
                        int count = list.size();
                        BigDecimal sum = null;
                        for (Object rowObject : list) {
                            if (rowObject instanceof Element) {
                                Element rowElement = (Element)rowObject;
                                try {
                                    BigDecimal rowSum = new BigDecimal(rowElement.getAttribute("sum"));
                                    if (sum == null) {
                                        sum = BigDecimal.ZERO;
                                    }
                                    sum = sum.add(rowSum);
                                }
                                catch (Exception exception) {}
                                continue;
                            }
                            try {
                                BigDecimal rowSum = (BigDecimal)rowObject.getClass().getMethod("getSum", new Class[0]).invoke(rowObject, new Object[0]);
                                if (sum == null) {
                                    sum = BigDecimal.ZERO;
                                }
                                sum = sum.add(rowSum);
                            }
                            catch (Exception exception) {}
                        }
                        String text = null;
                        if (count > 0) {
                            DecimalFormat decimalFormat = new DecimalFormat("###,##0");
                            text = "\u0412\u044b\u0434\u0435\u043b\u0435\u043d\u043e: " + decimalFormat.format(count);
                            if (sum != null) {
                                decimalFormat = new DecimalFormat("###,###,##0.00");
                                text = text + "; \u041d\u0430 \u0441\u0443\u043c\u043c\u0443: " + decimalFormat.format(sum);
                            }
                        }
                        table.setToolTipText(text);
                    }
                }
            });
        }
    }
}

