/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.object;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.contract.object.ObjectEditor;
import bitel.billing.module.contract.object.TypeSelectPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.ListItem;

public class ContractObjectEditor
extends BGPanel
implements ActionListener {
    private static final String module = "contract.object";
    BGTextField filterTitle;
    BGComboBox<ListItem> filterType;
    BGControlPanelPages pages;
    JLabel records;
    private CardLayout cardLayout;
    private ObjectEditor objectEditor;
    private TypeSelectPanel typeSelect;
    ContractObjectTableModel objectModel = new ContractObjectTableModel(ContractObjectTableModel.class.getName());

    public void build() {
        this.cardLayout = new CardLayout();
        this.objectEditor = new ObjectEditor();
        this.typeSelect = new TypeSelectPanel();
        this.jbInit();
        this.cardLayout.show(this, "editor");
    }

    private void jbInit() {
        this.filterTitle = new BGTextField(20);
        this.filterType = new BGComboBox();
        this.pages = new BGControlPanelPages();
        this.records = new JLabel();
        this.filterTitle.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    ContractObjectEditor.this.pages.setPageIndex(1);
                    ContractObjectEditor.this.setData();
                }
            }
        });
        this.filterType.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.pages.setPageIndex(1);
                this.setData();
            }
        });
        this.pages.addPropertyChangeListener(event -> {
            if (event.getPropertyName().startsWith("to")) {
                this.setData();
            }
        });
        final JPopupMenu popupMenu = new JPopupMenu();
        final BGUTable table = new BGUTable(this.objectModel);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting() && this.objectModel.getSelectedRow() != null) {
                this.id = this.objectModel.getValueFromSelectedRow("id");
                this.openObject();
            }
        });
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (table.getSelectedRow() == table.rowAtPoint(e.getPoint()) && SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                    popupMenu.show(table, e.getX(), e.getY());
                }
            }
        });
        this.initTransferContractPopup(popupMenu, table, "MoveObject", "id", "oid");
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(this);
        toolBar.setToolBar(new String[]{"newItem", "copyItem", "deleteItem", "separator", "upItem", "downItem"});
        toolBar.setFloatable(false);
        toolBar.setOrientation(1);
        toolBar.compact();
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.filterTitle, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u0422\u0438\u043f: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        filterPanel.add(this.filterType, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.records, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 20), 0, 0));
        filterPanel.add((Component)this.pages, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.setBorder(new BGTitleBorder(" \u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 "));
        tablePanel.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 10, 3, new Insets(30, 0, 0, 5), 0, 0));
        tablePanel.add((Component)filterPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        tablePanel.add((Component)new JScrollPane(table), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.setLayout(this.cardLayout);
        this.add((Component)new BGSplitPaneNoBorder(0, tablePanel, (Component)this.objectEditor, 300L), "editor");
        this.add((Component)this.typeSelect, "type_select");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("upItem".equals(actionCommand)) {
            this.orderItem(true);
        } else if ("downItem".equals(actionCommand)) {
            this.orderItem(false);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule(module);
        request.setContractId(this.getContractId());
        request.setAction("ObjectTable");
        request.setPage(this.pages);
        request.setAttribute("filterTitle", this.filterTitle.getText());
        if (this.filterType.getItemCount() == 0) {
            request.setAttribute("loadObjectTypes", true);
        } else {
            request.setAttribute("filterTypeId", this.filterType.getSelectedItem().getId());
        }
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element tableElement = XMLUtils.selectElement(doc, "//table");
            ArrayList<Element> data = new ArrayList<Element>();
            for (Element rowElement : XMLUtils.selectElements(tableElement, "data/row")) {
                data.add(rowElement);
            }
            this.objectModel.setData(data, true);
            this.pages.setPageInfo(tableElement);
            this.records.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + tableElement.getAttribute("recordCount"));
            Element typesElement = XMLUtils.selectElement(doc, "//types");
            if (typesElement != null) {
                DefaultComboBoxModel<IdTitle> model = new DefaultComboBoxModel<IdTitle>();
                model.addElement(new IdTitle(-1, "\u041b\u044e\u0431\u043e\u0439"));
                for (Element itemElement : XMLUtils.selectElements(typesElement, "item")) {
                    model.addElement(new IdTitle(Utils.parseInt(itemElement.getAttribute("id")), itemElement.getAttribute("title")));
                }
                this.filterType.setModel(model);
            }
        }
    }

    @Override
    public void deleteItem() {
        this.getObjectId();
        if (this.id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(module);
            request.setAction("ObjectDelete");
            request.setContractId(this.getContractId());
            request.setAttribute("id", this.id);
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.setData();
            }
        }
    }

    @Override
    public void copyItem() {
        this.getObjectId();
        if (this.id != null) {
            int dialogResult = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043d\u0430 \u043d\u043e\u0432\u044b\u0439 \u043e\u0431\u044a\u0435\u043a\u0442?", "\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430", 0, 3);
            boolean clonePeriod = dialogResult == 0;
            Request req = new Request();
            req.setModule(module);
            req.setAction("ObjectClone");
            req.setAttribute("id", this.id);
            req.setAttribute("clonePeriod", clonePeriod);
            if (ClientUtils.checkStatus(this.getDocument(req))) {
                this.setData();
            }
        }
    }

    @Override
    public void editItem() {
        this.getObjectId();
        if (this.id != null) {
            this.openObject();
        }
    }

    @Override
    public void newItem() {
        this.typeSelect.setData();
        this.cardLayout.show(this, "type_select");
    }

    public void orderItem(boolean up) {
        this.getObjectId();
        if (this.id != null) {
            Request request = new Request();
            request.setModule(module);
            request.setAction("ObjectOrder");
            request.setAttribute("id", this.id);
            request.setAttribute("up", up ? "1" : "0");
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.setData();
            }
        }
    }

    private void getObjectId() {
        this.id = this.objectModel.getValueFromSelectedRow("id");
        if (this.id == null) {
            ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0431\u044a\u0435\u043a\u0442!");
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.objectEditor.init(module, mid);
        this.objectEditor.setContractObjectEditor(this);
        this.typeSelect.init(module, mid);
        this.typeSelect.setContractObjectEditor(this);
    }

    @Override
    public void setContractId(int id) {
        super.setContractId(id);
        this.objectEditor.setContractId(id);
    }

    private void openObject() {
        if (this.id != null) {
            this.objectEditor.setId(this.id);
            this.objectEditor.setData();
            this.cardLayout.show(this, "editor");
        }
    }

    public void typeSelected(String type) {
        Request request = new Request();
        request.setModule(module);
        request.setAction("ObjectUpdate");
        request.setContractId(this.getContractId());
        request.setAttribute("id", "0");
        request.setAttribute("type", type);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            this.id = doc.getDocumentElement().getAttribute("id");
            this.setData();
            this.openObject();
            this.cardLayout.show(this, "editor");
        }
    }

    public void typeSelectCanceled() {
        this.cardLayout.show(this, "editor");
    }

    class ContractObjectTableModel
    extends BGTableModel<Element> {
        public ContractObjectTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f", 150, 180, 200, "type", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, -1, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public void setSelectedRows(List<Element> selected) {
            ListSelectionModel selectionModel = this.table.getSelectionModel();
            selectionModel.clearSelection();
            if (selected != null && !selected.isEmpty()) {
                selectionModel.setValueIsAdjusting(true);
                HashSet<String> set = new HashSet<String>();
                for (Element selectedElement : selected) {
                    set.add(selectedElement.getAttribute("id"));
                }
                int size = this.getRowCount();
                for (int i = 0; i < size; ++i) {
                    String id = ((Element)this.getRows().get(i)).getAttribute("id");
                    if (!set.contains(id)) continue;
                    if (this.table.getRowSorter() != null) {
                        int row = this.table.getRowSorter().convertRowIndexToView(i);
                        selectionModel.addSelectionInterval(row, row);
                        continue;
                    }
                    selectionModel.addSelectionInterval(i, i);
                }
                selectionModel.setValueIsAdjusting(false);
            }
        }
    }
}

