/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ReserveType;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ReserveService;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.table.BGTableModel;

public class ReserveTypesEditor
extends BGPanel {
    protected BGTableModel<ReserveType> model;
    protected BGUTable table;
    protected BGPanel editPanel;
    protected BGTextField textFieldName;
    protected BGButtonPanelOkCancel okCancel;
    protected JCheckBox checkBoxUsed;

    public ReserveTypesEditor() {
        this.table = new BGUTable(this.model);
        this.editPanel = new BGPanel();
        this.textFieldName = new BGTextField();
        this.okCancel = new BGButtonPanelOkCancel();
        this.checkBoxUsed = new JCheckBox("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
        try {
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    if (e.getClickCount() == 2) {
                        ReserveTypesEditor.this.editItem();
                    }
                }
            });
            this.okCancel.addActionListener(e -> {
                String command = e.getActionCommand();
                if (command != null) {
                    try {
                        if (command.equals("ok")) {
                            this.save();
                            this.refresh();
                            this.editPanel.setVisible(false);
                            this.table.setEnabled(true);
                        } else {
                            this.table.setEnabled(true);
                            this.editPanel.setVisible(false);
                        }
                    }
                    catch (BGException e1) {
                        this.getContext().processException(e1);
                    }
                }
            });
            this.model = new BGTableModel<ReserveType>("\u0422\u0430\u0431\u043b\u0438\u0446\u0430"){

                @Override
                protected void initColumns() {
                    this.addColumnId();
                    this.addColumn("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f", 100, 100, 100, "used", true);
                    this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, 150, -1, "title", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
                }
            };
            this.jbInit();
        }
        catch (Exception ex) {
            this.getContext().processException(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.packEditPanel();
        this.table.setModel(this.model);
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.editPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.05, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
    }

    private void packEditPanel() {
        this.editPanel.setLayout(new GridBagLayout());
        this.editPanel.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.editPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)this.textFieldName, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)this.checkBoxUsed, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editPanel.add((Component)this.okCancel, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 13, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.editPanel.setVisible(false);
    }

    protected void refresh() throws BGException {
        this.model.setData(this.getContext().getPort(ReserveService.class).reserveTypeList(false));
    }

    protected void save() throws BGException {
        int id = 0;
        if (this.model.getSelectedRow() != null) {
            id = this.model.getSelectedRow().getId();
        }
        this.getContext().getDirectory(ReserveType.class).update(new ReserveType(id, this.textFieldName.getText(), this.checkBoxUsed.isSelected()));
    }

    @Override
    public void setData() {
        try {
            this.model.setData(this.getContext().getDirectory(ReserveType.class).list());
        }
        catch (BGException e) {
            this.getContext().processException(e);
        }
    }

    @Override
    public void newItem() {
        this.editPanel.setVisible(true);
        this.checkBoxUsed.setSelected(true);
        this.textFieldName.setText("");
        this.table.setEnabled(false);
        this.table.getSelectionModel().clearSelection();
    }

    @Override
    public void editItem() {
        if (this.table.getSelectedRow() != -1) {
            this.table.setEnabled(false);
            this.textFieldName.setText(this.model.getSelectedRow().getTitle());
            this.checkBoxUsed.setSelected(this.model.getSelectedRow().isUsed());
            this.editPanel.setVisible(true);
        }
    }

    @Override
    public void deleteItem() {
        if (this.table.getSelectedRow() != -1 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0442\u0438\u043f \u0440\u0435\u0437\u0435\u0440\u0432\u0430 ?", "", 0, 3) == 0) {
            try {
                this.getContext().getDirectory(ReserveType.class).delete(this.model.getSelectedRow().getId());
                this.refresh();
            }
            catch (BGException e) {
                this.getContext().processException(e);
            }
        }
    }
}

