/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class EntityTariffsPropertiesPanel
extends ServicePanel {
    private String currentId;
    private BGTable table = new BGTable();
    private JPanel editor = new JPanel(new GridBagLayout());
    private BGComboBox<ComboBoxItem> serviceCombo = new BGComboBox();
    private BGControlPanelPeriodNoB servicePeriod = new BGControlPanelPeriodNoB();
    private IntTextField colTf = new IntTextField();
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private HashSet<String> deleted = new HashSet();
    private Element currentData;
    private int currentRow;
    private JCheckBox showUsedOnlyFlag = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435");
    private JCheckBox useFilterFlag = new JCheckBox("\u0424\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443");

    public EntityTariffsPropertiesPanel() {
        this.jbInit();
        this.table.setHeader(this.rb_name, this.moduleDoc, "entity_tariffs");
        this.editor.setVisible(false);
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        final EntityTariffsPropertiesPanel thiz = this;
        this.toolBar.setDefaultButtons(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                thiz.actionPerformed(e);
            }
        });
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editor, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.setBorder(new BGTitleBorder(" \u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 "));
        this.showUsedOnlyFlag.setSelected(true);
        this.useFilterFlag.setSelected(true);
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        JPanel checkBoxPanel = new JPanel(new GridBagLayout());
        checkBoxPanel.add((Component)this.showUsedOnlyFlag, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        checkBoxPanel.add((Component)this.useFilterFlag, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityTariffsPropertiesPanel.this.getPlans();
            }
        };
        this.showUsedOnlyFlag.addActionListener(al);
        this.useFilterFlag.addActionListener(al);
        this.editor.add((Component)checkBoxPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)new JLabel("\u0422\u0430\u0440\u0438\u0444:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add(this.serviceCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)new JLabel("\u041f\u043e\u0437.:"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.colTf, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.servicePeriod, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 2, 5, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        okCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntityTariffsPropertiesPanel.this.stopEdit(e.getActionCommand().equals("ok"));
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    EntityTariffsPropertiesPanel.this.currentId = ClientUtils.getRowId(EntityTariffsPropertiesPanel.this.table, null, "id");
                    EntityTariffsPropertiesPanel.this.startEdit();
                }
            }
        });
        this.colTf.setMinValue(1L);
        this.colTf.setMaxValue(1000L);
    }

    @Override
    public void setData() {
        Request req = new Request();
        req.setModule("contract");
        req.setAction("ContractTariffPlans");
        req.setContractId(this.getContractId());
        req.setAttribute("entityMid", this.getModuleId());
        req.setAttribute("entityId", this.id);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            this.currentData = XMLUtils.selectElement(doc, "//table");
            this.table.updateData(this.currentData);
            this.currentData = XMLUtils.selectElement(doc, "//table/data");
        }
    }

    @Override
    public void deleteItem() {
        this.currentId = ClientUtils.getRowId(this.table);
        if (Utils.notBlankString(this.currentId) && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u0430\u0440\u0438\u0444?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Element row = null;
            for (Element r : XMLUtils.elements(this.currentData.getChildNodes())) {
                if (!this.currentId.equals(r.getAttribute("id"))) continue;
                row = r;
                break;
            }
            if (row != null) {
                if (Utils.parseInt(this.currentId, -1) > 0) {
                    this.deleted.add(this.currentId);
                }
                this.currentData.removeChild(row);
            }
            this.editor.setVisible(false);
            this.table.updateData(this.currentData.getParentNode());
        }
    }

    @Override
    public void editItem() {
        this.currentId = ClientUtils.getRowId(this.table);
        if (Utils.notBlankString(this.currentId)) {
            this.startEdit();
        }
    }

    @Override
    public void newItem() {
        this.currentId = "new";
        this.startEdit();
    }

    private void getPlans() {
        Request req = new Request();
        req.setModule("contract");
        req.setAction("ContractTariffPlan");
        req.setAttribute("id", this.currentId);
        req.setAttribute("showUsed", this.showUsedOnlyFlag.isSelected() ? 1 : 0);
        req.setAttribute("useFilter", this.useFilterFlag.isSelected() ? 1 : 0);
        req.setContractId(this.getContractId());
        req.setAttribute("mid", this.getModuleId());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus(doc)) {
            ClientUtils.buildComboBox(this.serviceCombo, XMLUtils.selectElement(doc, "//tariffPlans"), "");
        }
    }

    private void startEdit() {
        if (this.currentId.equals("new") || Utils.parseInt(this.currentId, -1) > 0) {
            this.getPlans();
        }
        this.serviceCombo.setEnabled(this.currentId.equals("new"));
        if (this.currentId.equals("new")) {
            this.currentRow = -1;
            if (this.serviceCombo.getItemCount() > 0) {
                this.serviceCombo.setSelectedIndex(0);
            }
            this.servicePeriod.setLocalDateFrom(LocalDate.now());
            this.colTf.setText("0");
        } else {
            this.currentRow = this.table.getSelectedRow();
            this.currentId = ClientUtils.getRowId(this.table, null, "id");
            String date1 = ClientUtils.getRowId(this.table, null, "date1");
            String date2 = ClientUtils.getRowId(this.table, null, "date2");
            String pos = ClientUtils.getRowId(this.table, null, "pos");
            String tpid = ClientUtils.getRowId(this.table, null, "tpid");
            this.colTf.setText(pos);
            this.servicePeriod.setDateString1(date1);
            this.servicePeriod.setDateString2(date2);
            ClientUtils.setComboBoxSelection(this.serviceCombo, tpid);
        }
        this.editor.setVisible(true);
    }

    private void stopEdit(boolean save) {
        if (save) {
            ComboBoxItem item = this.serviceCombo.getSelectedItem();
            if (item == null || ((String)item.getObject()).equals("0")) {
                ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0430\u0440\u0438\u0444");
                return;
            }
            String tpid = item.getObject().toString();
            String pos = this.colTf.getText();
            String title = item.toString();
            if (Utils.isBlankString(pos)) {
                pos = "0";
            }
            Element row = null;
            if (this.currentRow >= 0) {
                row = (Element)this.currentData.getChildNodes().item(this.currentRow);
            }
            if (row == null) {
                row = this.currentData.getOwnerDocument().createElement("row");
                this.currentData.appendChild(row);
            }
            if ("new".equals(this.currentId)) {
                this.currentId = "-1";
            }
            row.setAttribute("id", this.currentId);
            row.setAttribute("tpid", tpid);
            row.setAttribute("pos", pos);
            row.setAttribute("date1", this.servicePeriod.getDateString1());
            row.setAttribute("date2", this.servicePeriod.getDateString2());
            row.setAttribute("period", this.servicePeriod.getDateString1() + "-" + this.servicePeriod.getDateString2());
            row.setAttribute("title", title);
            this.editor.setVisible(false);
            this.table.updateData(this.currentData.getParentNode());
        } else {
            this.editor.setVisible(false);
        }
    }

    @Override
    public boolean updateData() {
        Request req;
        for (String id : this.deleted) {
            req = new Request();
            req.setModule("contract");
            req.setAction("DeleteContractTariffPlan");
            req.setContractId(this.getContractId());
            req.setAttribute("entityMid", this.getModuleId());
            req.setAttribute("entityId", this.id);
            req.setAttribute("id", id);
            if (ClientUtils.checkStatus(this.getDocument(req))) continue;
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            break;
        }
        this.deleted.clear();
        for (Element e : XMLUtils.elements(this.currentData.getChildNodes())) {
            req = new Request();
            req.setModule("contract");
            req.setAction("UpdateContractTariffPlan");
            req.setContractId(this.getContractId());
            req.setAttribute("entityMid", this.getModuleId());
            req.setAttribute("entityId", this.id);
            String id = e.getAttribute("id");
            if ("-1".equals(id)) {
                id = "new";
            }
            req.setAttribute("id", id);
            req.setAttribute("tpid", e.getAttribute("tpid"));
            req.setAttribute("pos", e.getAttribute("pos"));
            req.setAttribute("date1", e.getAttribute("date1"));
            req.setAttribute("date2", e.getAttribute("date2"));
            req.setAttribute("comment", e.getAttribute("comment"));
            if (ClientUtils.checkStatus(this.getDocument(req))) continue;
            EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
            return false;
        }
        return true;
    }
}

