/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.table.BGTreeNode;
import bitel.billing.module.contract.ContractEditor;
import bitel.billing.module.contract.ContractPanel;
import bitel.billing.module.contract.ContractSubPanel;
import bitel.billing.module.contract.ContractSubPanel_Additional;
import bitel.billing.module.contract.ContractSubPanel_Face;
import bitel.billing.module.contract.ContractSubPanel_Group;
import bitel.billing.module.contract.ContractSubPanel_Hierarchy;
import bitel.billing.module.contract.ContractSubPanel_LimitManage;
import bitel.billing.module.contract.ContractSubPanel_Mode;
import bitel.billing.module.contract.ContractSubPanel_Module;
import bitel.billing.module.contract.ContractSubPanel_Modules;
import bitel.billing.module.contract.ContractSubPanel_Note;
import bitel.billing.module.contract.ContractSubPanel_Objects;
import bitel.billing.module.contract.ContractSubPanel_Parameters;
import bitel.billing.module.contract.ContractSubPanel_Password;
import bitel.billing.module.contract.ContractSubPanel_Script;
import bitel.billing.module.contract.ContractSubPanel_TariffPlan;
import bitel.billing.module.contract.ContractSubPanel_WebMenu;
import bitel.billing.module.contract.ContractSubPanel_WebStat;
import bitel.billing.module.contract.ContractTitleEditorDialog;
import bitel.billing.module.contract.status.ContractSubPanel_Status;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventSubscriber;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGTreeTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.tree.DefaultTreeTableModel;
import ru.bitel.bgbilling.client.common.table.tree.TreeNode;
import ru.bitel.bgbilling.client.common.table.tree.TreeTableModel;
import ru.bitel.bgbilling.client.event.CustomerPanelReinitEvent;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractParameterService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.balance.client.ContractSubPanel_Balance;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ReserveService;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelType;
import ru.bitel.bgbilling.kernel.contract.label.common.service.ContractLabelService;
import ru.bitel.bgbilling.kernel.contract.limit.client.ContractSubPanel_Limit;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerPropertyDialog;
import ru.bitel.bgbilling.kernel.contract.param.client.CustomerSelectDialog;
import ru.bitel.bgbilling.kernel.contract.period.client.ContractSubPanel_Period;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.kernel.plugin.common.BGPlugInElement;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.RowData;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;

public class ContractPanel_Parameters
extends ContractPanel
implements ActionListener,
PropertyChangeListener,
EventSubscriber<UpdateContractTreeEvent> {
    private static final String KEY_BALANCE_0 = "balance_0";
    private static final String KEY_BALANCE_1 = "balance_1";
    private static final String KEY_BALANCE_2 = "balance_2";
    private static final String KEY_BALANCE_3 = "balance_3";
    private static final String KEY_BALANCE_4 = "balance_4";
    private static final String KEY_BALANCE_5 = "balance_5";
    private static final String KEY_BALANCE_6 = "balance_6";
    private static final String KEY_BALANCE_7 = "balance_7";
    private static final String KEY_BALANCE_OUTSALDO = "balance_OutSaldo";
    private HashMap<Integer, Contract> contractMap;
    private DefaultTreeTableModel<BGTreeNode> model = new DefaultTreeTableModel<BGTreeNode>((TreeNode)new BGTreeNode("root", null), new String[]{" ", " "}, new Class[]{TreeTableModel.class, String.class}, (DefaultTreeTableModel.GetTreeNodeFromElement)new DefaultTreeTableModel.GetTreeNodeFromElement<BGTreeNode>(){

        @Override
        public BGTreeNode getFromElement(Element el) {
            return null;
        }
    }){

        @Override
        public boolean isCellEditable(Object node, int column) {
            return node instanceof BGTreeNode && ((BGTreeNode)node).isEditable();
        }
    };
    private BGTreeTable tree = new BGTreeTable(this.model){

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            TableCellRenderer renderer = null;
            if (column == 1 && this.getValueAt(row, column) instanceof BigDecimal) {
                renderer = DecimalTableCellRenderer.DEFAULT.get();
            } else {
                renderer = super.getCellRenderer(row, column);
                if (renderer instanceof JLabel) {
                    ((JLabel)((Object)renderer)).setHorizontalAlignment(4);
                }
            }
            return renderer != null ? renderer : super.getCellRenderer(row, column);
        }
    };
    private Map<String, BGTreeNode> treeNodeMap = new HashMap<String, BGTreeNode>();
    private BGTreeNode currentNode = null;
    private BGTreeNode treeTopNode;
    private BGControlPanelPeriod contractPeriod = new BGControlPanelPeriod();
    private CardLayout cardLayout1 = new CardLayout();
    private JPanel rightPanel = new JPanel(this.cardLayout1);
    private JCheckBox cbDel = new JCheckBox("\u0421\u043a\u0440\u044b\u0442\u044b\u0439");
    private JPanel paramPanel = new JPanel();
    private BGButton titleChange = null;
    private BGTextField contractId = null;
    private boolean balanceMode = true;
    private Supplier<Directory<Domain>> domainDirectory;
    private ContractService contractService = null;
    private ContractParameterService contractParameterService = null;
    private JPanel customerPanel = null;
    ContractSubPanel subPanelCurrent = null;

    public ContractPanel_Parameters(ContractEditor editor) {
        String[] treeNodeOrderArray;
        this.init(editor);
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            this.getContext().processException(e2);
        }
        this.treeTopNode = (BGTreeNode)this.model.getRoot();
        StringBuilder defaultTreeNodeOrder = new StringBuilder();
        for (KEY value : KEY.values()) {
            defaultTreeNodeOrder.append((Object)value);
            defaultTreeNodeOrder.append(" ");
        }
        for (BGPlugInElement extension : BGPluginManagerClient.getManager().getExtensions(ContractPanel_Parameters.class.getCanonicalName(), true)) {
            Element extensionElement = extension.getElement();
            BGPluginClient plugin = (BGPluginClient)extension.getPlugin();
            NodeList list = extensionElement.getElementsByTagName("panel");
            for (int index = 0; index < list.getLength(); ++index) {
                Element panel = (Element)list.item(index);
                try {
                    String key = plugin.getResourceString(panel.getAttribute("key"));
                    String className = panel.getAttribute("class");
                    String defTitle = panel.getAttribute("defTitle");
                    this.treeNodeMap.put(key, new BGTreeNode(defTitle, "", Class.forName(className).asSubclass(ContractSubPanel.class)));
                    continue;
                }
                catch (Exception ex) {
                    this.getContext().processException(ex);
                }
            }
        }
        String treeNodeOrder = this.setup.get("dbinfo.contract.tree.order", defaultTreeNodeOrder.toString());
        for (String treeNodeName : treeNodeOrderArray = treeNodeOrder.split(" ")) {
            if ((treeNodeName = treeNodeName.trim()).equals(KEY.parameters.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.parameters.toString(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "", ContractSubPanel_Parameters.class));
                continue;
            }
            if (treeNodeName.equals(KEY.objects.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.objects.toString(), "\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "", ContractSubPanel_Objects.class));
                continue;
            }
            if (treeNodeName.equals(KEY.hierarchy.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.hierarchy.toString(), "\u0418\u0435\u0440\u0430\u0440\u0445\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", "", ContractSubPanel_Hierarchy.class));
                continue;
            }
            if (treeNodeName.equals(KEY.status.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.status.toString(), "\u0421\u0442\u0430\u0442\u0443\u0441", "", ContractSubPanel_Status.class));
                continue;
            }
            if (treeNodeName.equals(KEY.limit.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.limit.toString(), "\u041b\u0438\u043c\u0438\u0442", "", ContractSubPanel_Limit.class));
                continue;
            }
            if (treeNodeName.equals(KEY.mode.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.mode.toString(), "\u0420\u0435\u0436\u0438\u043c", "", ContractSubPanel_Mode.class));
                continue;
            }
            if (treeNodeName.equals(KEY.face.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.face.toString(), "\u041b\u0438\u0446\u043e", "", ContractSubPanel_Face.class));
                continue;
            }
            if (treeNodeName.equals(KEY.groups.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.groups.toString(), "\u0413\u0440\u0443\u043f\u043f\u044b \u0438 \u043c\u0435\u0442\u043a\u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "", ContractSubPanel_Group.class));
                continue;
            }
            if (treeNodeName.equals(KEY.balance.toString())) {
                ArrayList<BGTreeNode> balanceGroupList = new ArrayList<BGTreeNode>();
                BGTreeNode balance = this.addTreeNode(KEY.balance.toString(), "\u0411\u0430\u043b\u0430\u043d\u0441", "", ContractSubPanel_Balance.class);
                balance.setAttribute("mode", "3");
                balanceGroupList.add(balance);
                balance.setGroupNode(balanceGroupList);
                this.setCurrentNode(balance);
                this.addSubBalanceNode("\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043e\u0441\u0442\u0430\u0442\u043e\u043a", 3, KEY_BALANCE_3, balanceGroupList);
                this.addSubBalanceNode("\u041f\u0440\u0438\u0445\u043e\u0434", 0, KEY_BALANCE_0, balanceGroupList);
                this.addSubBalanceNode("\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430", 2, KEY_BALANCE_2, balanceGroupList);
                this.addSubBalanceNode("\u0420\u0430\u0441\u0445\u043e\u0434", 1, KEY_BALANCE_1, balanceGroupList);
                this.addSubBalanceNode("\u0412\u043e\u0437\u0432\u0440\u0430\u0442", 7, KEY_BALANCE_7, balanceGroupList);
                this.addSubBalanceNode("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043e\u0441\u0442\u0430\u0442\u043e\u043a", 4, KEY_BALANCE_4, balanceGroupList);
                this.addSubBalanceNode("\u0420\u0435\u0437\u0435\u0440\u0432", 5, KEY_BALANCE_5, balanceGroupList);
                this.addSubBalanceNode("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430", 6, KEY_BALANCE_6, balanceGroupList);
                continue;
            }
            if (treeNodeName.equals(KEY.tariff.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.tariff.toString(), "\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043f\u043b\u0430\u043d\u044b", "", ContractSubPanel_TariffPlan.class));
                continue;
            }
            if (treeNodeName.equals(KEY.modules.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.modules.toString(), "\u041c\u043e\u0434\u0443\u043b\u0438", "", ContractSubPanel_Modules.class, "folder-block"));
                this.treeNodeMap.get(KEY.modules.toString()).setAttribute("mid", "-1");
                continue;
            }
            if (treeNodeName.equals(KEY.web.toString())) {
                BGTreeNode web = this.addTreeNode(KEY.web.toString(), "Web", "", ContractSubPanel_WebStat.class);
                web.addChild(new BGTreeNode("\u041f\u0430\u0440\u043e\u043b\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438", "", ContractSubPanel_Password.class));
                web.addChild(new BGTreeNode("\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043b\u0438\u043c\u0438\u0442\u043e\u043c", "", ContractSubPanel_LimitManage.class));
                web.addChild(new BGTreeNode("Web-\u043c\u0435\u043d\u044e", "", ContractSubPanel_WebMenu.class));
                this.setCurrentNode(web);
                continue;
            }
            if (treeNodeName.equals(KEY.script.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.script.toString(), "\u0421\u043a\u0440\u0438\u043f\u0442 \u043f\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f", "", ContractSubPanel_Script.class));
                continue;
            }
            if (treeNodeName.equals(KEY.addAction.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.addAction.toString(), "\u0414\u043e\u043f. \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f", "", ContractSubPanel_Additional.class));
                continue;
            }
            if (treeNodeName.equals(KEY.memo.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.memo.toString(), "\u041f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u044f", "", ContractSubPanel_Note.class));
                continue;
            }
            if (treeNodeName.equals(KEY.period.toString())) {
                this.setCurrentNode(this.addTreeNode(KEY.period.toString(), "\u0423\u0447\u0435\u0442\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434", "", ContractSubPanel_Period.class));
                continue;
            }
            if (!this.treeNodeMap.containsKey(treeNodeName)) continue;
            this.treeTopNode.addChild(this.treeNodeMap.get(treeNodeName));
            this.model.fireTreeStructureChanged(this.treeTopNode);
        }
        if (this.treeNodeMap.containsKey(KEY_BALANCE_3)) {
            this.model.fireTreeStructureChanged(this.treeNodeMap.get(KEY_BALANCE_3));
        }
        if (this.treeNodeMap.containsKey(KEY_BALANCE_4)) {
            this.model.fireTreeStructureChanged(this.treeNodeMap.get(KEY_BALANCE_4));
        }
        this.tree.getTree().setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(0);
        this.tree.setDefaultRenderer(BigDecimal.class, DecimalTableCellRenderer.DEFAULT.get());
        this.showPanel(this.currentNode);
        this.tree.getTree().getSelectionModel().addTreeSelectionListener(e -> {
            if (this.balanceMode) {
                this.tree_valueChanged(e);
            }
        });
        TreeModel treeModel = this.tree.getTree().getModel();
        if (treeModel.getChildCount(treeModel.getRoot()) > 0) {
            this.tree.getTree().getSelectionModel().setSelectionPath(new TreePath(((BGTreeNode)treeModel.getChild(treeModel.getRoot(), 0)).getPath()));
        }
        EventBus.subscribe(UpdateContractTreeEvent.class, (EventSubscriber)this);
    }

    private BGTreeNode addSubBalanceNode(String title, int mode, String key, List<BGTreeNode> balanceGroupList) {
        BGTreeNode bgTreeNode = new BGTreeNode(title, "", ContractSubPanel_Balance.class);
        bgTreeNode.setAttribute("mode", String.valueOf(mode));
        balanceGroupList.add(bgTreeNode);
        bgTreeNode.setGroupNode(balanceGroupList);
        this.treeNodeMap.get(KEY.balance.toString()).addChild(bgTreeNode);
        this.treeNodeMap.put(key, bgTreeNode);
        return bgTreeNode;
    }

    private ContractParameterService getContractParameterService() {
        if (this.contractParameterService == null) {
            this.contractParameterService = this.getContext().getPort(ContractParameterService.class);
        }
        return this.contractParameterService;
    }

    private void jbInit() throws Exception {
        this.paramPanel.setLayout(new GridBagLayout());
        this.contractPeriod.addPropertyChangeListener(this);
        this.titleChange = new BGButton("", "titleChange", this);
        this.titleChange.setToolTipText("\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 [ \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 ]");
        this.cbDel.setActionCommand("cbDel");
        this.cbDel.addActionListener(this);
        Font font = this.titleChange.getFont();
        this.titleChange.setFont(font.getSize() < 12 ? font.deriveFont(1, (float)font.getSize() + 3.0f) : font.deriveFont((float)font.getSize() + 3.0f));
        this.titleChange.setHorizontalAlignment(2);
        this.contractId = new BGTextField();
        this.contractId.setEditable(false);
        this.contractId.setColumns(5);
        this.contractId.setHorizontalAlignment(0);
        this.contractId.setToolTipText("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        JScrollPane treeScroll = new JScrollPane(this.tree);
        treeScroll.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.paramPanel.add((Component)treeScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.paramPanel.add((Component)this.cbDel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.rightPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.rightPanel.setMinimumSize(new Dimension(100, 100));
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, this.paramPanel, (Component)this.rightPanel, 300L);
        this.setLayout(new BorderLayout(0, 3));
        this.add((Component)this.getContractCustomerPeriodPanel(), "North");
        this.add((Component)splitPane, "Center");
        this.revalidate();
        this.domainDirectory = Async.of(() -> {
            Directory<Domain> dir = this.getContext().getDirectory(Domain.class, 0);
            dir.list();
            return dir;
        });
    }

    private JPanel getContractCustomerPeriodPanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getContractPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getCustomerPanel(), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.contractPeriod, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getContractPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder(" \u0414\u043e\u0433\u043e\u0432\u043e\u0440 "));
        panel.add((Component)this.titleChange, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.contractId, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getCustomerPanel() {
        JPanel panel = new JPanel(new CardLayout());
        panel.setBorder(new BGTitleBorder(" \u041a\u043b\u0438\u0435\u043d\u0442 "));
        panel.add((Component)this.getNoCustomerPanel(), "customerNo");
        panel.add((Component)this.getCustomerDataPanel(), "customerData");
        this.customerPanel = panel;
        return panel;
    }

    private JPanel getNoCustomerPanel() {
        JLabel messageLabel = new JLabel("\u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
        messageLabel.setFont(new Font("SansSerif", 1, 16));
        JButton newButton = new JButton("\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        newButton.setToolTipText("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u043d\u043e\u0432\u043e\u0433\u043e");
        newButton.addActionListener(e -> {
            try {
                this.getContractParameterService().customerNewSet(this.getContext().getContractId());
                this.setCustomerPanel();
                EventBus.publish((Object)new CustomerPanelReinitEvent(this.getContext().getContractId()));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        });
        JButton linkButton = new JButton("\u041d\u0430\u0439\u0442\u0438");
        linkButton.setToolTipText("\u041d\u0430\u0439\u0442\u0438 \u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0435\u0433\u043e");
        linkButton.addActionListener(e -> {
            CustomerSelectDialog customerSelectDialog = new CustomerSelectDialog(this.getContext());
            int selectCustomerId = customerSelectDialog.getSelectCustomerId();
            if (selectCustomerId > 0) {
                try {
                    this.getContractParameterService().customerLinkSet(this.getContext().getContractId(), selectCustomerId);
                    this.setCustomerPanel();
                    EventBus.publish((Object)new CustomerPanelReinitEvent(this.getContext().getContractId()));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        });
        JPanel messagePanel = new JPanel(new GridBagLayout());
        messagePanel.setBackground(UIManager.getColor("Table.background"));
        messagePanel.setOpaque(true);
        messagePanel.add((Component)messageLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        messagePanel.add((Component)linkButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        messagePanel.add((Component)newButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)messagePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getCustomerDataPanel() {
        JButton unlinkButton = new JButton("unlink");
        unlinkButton.addActionListener(e -> {
            int customerId = this.getContext().getCustomerId();
            if (customerId == 0) {
                ClientUtils.showMessageDialog("\u041a\u043b\u0438\u0435\u043d\u0442 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d");
            } else if (ClientUtils.confirm("\u0417\u0430\u043a\u0440\u044b\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u043e\u0439 \u0441\u0432\u044f\u0437\u044c \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u0438 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435")) {
                try {
                    boolean fl = this.getContractParameterService().customerUnlinkContract(this.getContext().getContractId(), LocalDateTime.now().minusSeconds(1L));
                    if (fl) {
                        this.getContext().setCustomer(null);
                        this.getContext().setCustomerId(0);
                        this.setCustomerPanel();
                        EventBus.publish((Object)new CustomerPanelReinitEvent(this.getContext().getContractId()));
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        });
        JButton contractButton = new JButton("\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        contractButton.addActionListener(e -> {
            ArrayList<RowData> list = new ArrayList<RowData>();
            try {
                JSONArray contracts = new JSONArray(this.getContractParameterService().customerContracts(this.getContext().getCustomerId(), LocalDateTime.now()));
                for (int index = 0; index < contracts.length(); ++index) {
                    list.add(new RowData(contracts.getJSONObject(index)));
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            new CustomerContractPopup(list).show(contractButton, 0, contractButton.getHeight());
        });
        JButton propertyButton = new JButton("\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430");
        propertyButton.addActionListener(e -> {
            CustomerPropertyDialog customerPropertyDialog = new CustomerPropertyDialog(this.getContext());
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JButton("link"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)unlinkButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)contractButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)propertyButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void setCustomerPanel() {
        try {
            JSONObject customer = new JSONObject(this.getContractParameterService().customerParameterGet(this.getContractId()));
            this.getContext().setCustomer(customer);
            this.getContext().setCustomerId(customer.optInt("customerId"));
            ((CardLayout)this.customerPanel.getLayout()).show(this.customerPanel, this.getContext().getCustomerId() > 0 ? "customerData" : "customerNo");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public void setData() {
        try {
            this.setContractInfo(this.getContractService().contractInfoGet(this.getContractId()));
            if (this.subPanelCurrent != null) {
                this.subPanelCurrent.setData();
            }
            this.setCustomerPanel();
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog(e);
        }
    }

    public void setContractInfo(JSONObject contractInfo) {
        int i;
        JSONObject infoJson;
        this.contractId.setText(String.valueOf(this.getContractId()));
        JSONObject contractJson = contractInfo.optJSONObject("contract");
        this.cbDel.setSelected(contractJson.optInt("del", 0) == 1);
        String title = contractJson.optString("title", " ");
        String comment = contractJson.optString("comment", "");
        this.titleChange.setText(title + " [ " + comment + " ]");
        this.editor.setContractTitle(title);
        this.editor.setAttribute("contractComment", comment);
        this.contractPeriod.setDateString1(contractJson.optString("date1", null));
        this.contractPeriod.setDateString2(contractJson.optString("date2", null));
        this.setNodeValue(KEY.status, contractJson.optString("status"));
        this.setNodeValue(KEY.objects, contractJson.optString("objects"));
        this.setNodeValue(KEY.limit, new BigDecimal(contractJson.optString("limit", "0")));
        this.setNodeValue(KEY.memo, contractJson.optString("comments"));
        this.setNodeValue(KEY.mode, contractJson.optInt("mode", 0) == 0 ? "\u043a\u0440\u0435\u0434\u0438\u0442" : "\u0434\u0435\u0431\u0435\u0442");
        this.setNodeValue(KEY.face, contractJson.optInt("fc", 0) == 0 ? "\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435" : "\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0435");
        try {
            Domain domain = this.domainDirectory.get().get(contractJson.optInt("domainId"));
            this.setNodeValue(KEY.groups, domain != null ? domain.getTitle() : "");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        if (this.treeNodeMap.containsKey(KEY.hierarchy.toString())) {
            BGTreeNode hierarchy = this.treeNodeMap.get(KEY.hierarchy.toString());
            String hierarchyAttr = contractJson.optString("hierarchy");
            if (hierarchyAttr.equals("super")) {
                String dep = contractJson.optString("hierarchyDep", null);
                String indep = contractJson.optString("hierarchyIndep", null);
                hierarchy.setValue(new Object[]{"\u0441\u0443\u043f\u0435\u0440: " + dep + "/" + indep});
            } else if (hierarchyAttr.equals("independent")) {
                hierarchy.setValue(new Object[]{""});
            } else if (hierarchyAttr.equals("depend_sub")) {
                hierarchy.setValue(new Object[]{"\u0437.\u0441\u0443\u0431."});
            } else if (hierarchyAttr.equals("independ_sub")) {
                hierarchy.setValue(new Object[]{"\u043d.\u0441\u0443\u0431."});
            }
        }
        if (!(infoJson = contractInfo.optJSONObject("info")).isEmpty() && this.treeNodeMap.containsKey(KEY.modules.toString())) {
            KEY[] modules = this.treeNodeMap.get(KEY.modules.toString());
            modules.removeChilds();
            this.model.fireTreeStructureChanged((TreeNode)modules);
            JSONArray modulesJson = infoJson.optJSONArray("modules");
            if (modulesJson != null && !modulesJson.isEmpty()) {
                for (int i2 = 0; i2 < modulesJson.length(); ++i2) {
                    JSONObject jSONObject = modulesJson.getJSONObject(i2);
                    String moduleTitle = jSONObject.optString("title", "?");
                    String status = jSONObject.optString("status", null);
                    if (status == null) {
                        status = "";
                    }
                    BGTreeNode moduleNode = new BGTreeNode(moduleTitle, status, ContractSubPanel_Module.class, "block");
                    moduleNode.setAttribute("mid", String.valueOf(jSONObject.optInt("id", -1)));
                    moduleNode.setAttribute("package", jSONObject.optString("package"));
                    modules.addChild(moduleNode);
                    this.model.fireTreeStructureChanged(moduleNode);
                }
            }
            for (String string : infoJson.keySet()) {
                String outSaldo;
                if (string.equals(KEY.groups.toString())) {
                    this.buildLabels(KEY.groups.toString(), this.getNode(infoJson, "groups"));
                    continue;
                }
                if (string.equals(KEY.tariff.toString())) {
                    this.addTreeNodeChilds(KEY.tariff.toString(), this.getNode(infoJson, "tariff"));
                    continue;
                }
                if (string.equals(KEY.script.toString())) {
                    this.addTreeNodeChilds(KEY.script.toString(), this.getNode(infoJson, "script"));
                    continue;
                }
                if (!string.equals(KEY.balance.toString())) continue;
                JSONObject balanceJson = infoJson.optJSONObject("balance");
                BGTreeNode balance = this.treeNodeMap.get(KEY.balance.toString());
                int yy = balanceJson.optInt("yy", -1);
                int mm = balanceJson.optInt("mm", -1);
                if (yy > 0 && mm > 0 && mm <= 12) {
                    balance.setTitle("\u0411\u0430\u043b\u0430\u043d\u0441 (" + TimeUtils.monthNames[mm - 1] + " " + yy + ")");
                    balance.setAttribute("month", String.valueOf(mm));
                    balance.setAttribute("year", String.valueOf(yy));
                }
                try {
                    this.treeNodeMap.get(KEY_BALANCE_3).setValue(new Object[]{new BigDecimal(balanceJson.optString("summa1", "0"))});
                    this.treeNodeMap.get(KEY_BALANCE_0).setValue(new Object[]{new BigDecimal(balanceJson.optString("summa2", "0"))});
                    this.treeNodeMap.get(KEY_BALANCE_2).setValue(new Object[]{new BigDecimal(balanceJson.optString("summa3", "0"))});
                    this.treeNodeMap.get(KEY_BALANCE_1).setValue(new Object[]{new BigDecimal(balanceJson.optString("summa4", "0"))});
                    this.treeNodeMap.get(KEY_BALANCE_4).setValue(new Object[]{new BigDecimal(balanceJson.optString("summa5", "0"))});
                    Async.of(() -> this.getContext().getPort(ReserveService.class).reserveSum(this.getContractId())).thenSwing(a -> {
                        this.treeNodeMap.get(KEY_BALANCE_5).setValue(new Object[]{a});
                        this.fireTreeNodeChanged(KEY_BALANCE_5);
                        this.fireTreeStructureChanged(KEY_BALANCE_5);
                        this.tree.repaint();
                    });
                    this.treeNodeMap.get(KEY_BALANCE_6).setValue(new Object[]{new BigDecimal(balanceJson.optString("summa6", "0"))});
                    this.treeNodeMap.get(KEY_BALANCE_7).setValue(new Object[]{new BigDecimal(balanceJson.optString("summa7", "0"))});
                }
                catch (Exception e) {
                    this.getContext().processException(e);
                }
                if (!Utils.notEmptyString(outSaldo = balanceJson.optString("outSaldo", null))) continue;
                BGTreeNode balance_OutSaldo = this.treeNodeMap.get(KEY_BALANCE_OUTSALDO);
                if (balance_OutSaldo == null) {
                    balance_OutSaldo = new BGTreeNode("\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0435\u0435 \u0441\u0430\u043b\u044c\u0434\u043e", "", ContractSubPanel_Balance.class);
                    balance_OutSaldo.setAttribute("mode", "4");
                    balance.addChild(balance_OutSaldo);
                    this.treeNodeMap.put(KEY_BALANCE_OUTSALDO, balance_OutSaldo);
                }
                balance_OutSaldo.setValue(new Object[]{outSaldo});
            }
        }
        this.fireTreeNodeChanged(KEY.balance.toString());
        this.fireTreeNodeChanged(KEY_BALANCE_0);
        this.fireTreeNodeChanged(KEY_BALANCE_1);
        this.fireTreeNodeChanged(KEY_BALANCE_2);
        this.fireTreeNodeChanged(KEY_BALANCE_3);
        this.fireTreeNodeChanged(KEY_BALANCE_4);
        this.fireTreeNodeChanged(KEY_BALANCE_5);
        this.fireTreeNodeChanged(KEY_BALANCE_6);
        this.fireTreeNodeChanged(KEY_BALANCE_7);
        this.fireTreeNodeChanged(KEY_BALANCE_OUTSALDO);
        this.fireTreeStructureChanged(KEY.balance.toString());
        this.fireTreeStructureChanged(KEY_BALANCE_0);
        this.fireTreeStructureChanged(KEY_BALANCE_1);
        this.fireTreeStructureChanged(KEY_BALANCE_2);
        this.fireTreeStructureChanged(KEY_BALANCE_3);
        this.fireTreeStructureChanged(KEY_BALANCE_4);
        this.fireTreeStructureChanged(KEY_BALANCE_5);
        this.fireTreeStructureChanged(KEY_BALANCE_6);
        this.fireTreeStructureChanged(KEY_BALANCE_7);
        this.fireTreeStructureChanged(KEY_BALANCE_OUTSALDO);
        this.tree.repaint();
        for (KEY kEY : KEY.values()) {
            if (!this.treeNodeMap.containsKey(kEY.toString())) continue;
            this.model.expand(this.treeNodeMap.get(kEY.toString()));
        }
        JSONArray pluginsJson = infoJson.optJSONArray("plugins");
        if (pluginsJson != null) {
            for (i = 0; i < pluginsJson.length(); ++i) {
                JSONObject itemJson = pluginsJson.getJSONObject(i);
                String string = itemJson.optString("key");
                BGTreeNode bgTreeNode = this.treeNodeMap.get(string);
                if (bgTreeNode == null) continue;
                this.treeNodeMap.get(string).setTitle(itemJson.optString("title"));
                this.treeNodeMap.get(string).setValue(new Object[]{itemJson.optString("value")});
            }
        }
        for (i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.getTree().expandRow(i);
        }
    }

    private Element getNode(JSONObject infoJson, String nodeName) {
        Document doc = XMLUtils.newDocument();
        Element node = XMLUtils.createElement(doc, "node");
        JSONArray nodeJson = infoJson.optJSONArray(nodeName);
        for (int index = 0; index < nodeJson.length(); ++index) {
            JSONObject itemJson = nodeJson.optJSONObject(index);
            Element item = XMLUtils.createElement(node, "item");
            item.setAttribute("id", String.valueOf(itemJson.optInt("id")));
            item.setAttribute("title", itemJson.optString("title"));
        }
        return node;
    }

    private BGTreeNode addTreeNode(String key, String title, String value, Class<? extends ContractSubPanel> clazz) {
        return this.addTreeNode(key, title, value, clazz, null);
    }

    private BGTreeNode addTreeNode(String key, String title, String value, Class<? extends ContractSubPanel> clazz, String icon) {
        BGTreeNode node = new BGTreeNode(title, value, clazz, icon);
        this.treeTopNode.addChild(node);
        this.treeNodeMap.put(key, node);
        this.model.fireTreeStructureChanged(this.treeTopNode);
        return node;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("date1".equals(propertyName)) {
            this.updateData("UpdateContractDate1", this.contractPeriod.getDateString1());
        } else if ("date2".equals(propertyName)) {
            int r = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0430\u0442\u0443 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 0, 3);
            if (r == 1) {
                this.contractPeriod.undoDateCalendar2();
                return;
            }
            this.updateData("UpdateContractDate2", this.contractPeriod.getDateString2());
        }
    }

    private void tree_valueChanged(final TreeSelectionEvent e) {
        BGTreeNode node;
        BGTreeNode bGTreeNode = node = e.getNewLeadSelectionPath() != null ? (BGTreeNode)e.getNewLeadSelectionPath().getLastPathComponent() : null;
        if (node != null) {
            this.currentNode = node;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ContractSubPanel comp = node.actionPerformed(e, ContractPanel_Parameters.this.rightPanel, ContractPanel_Parameters.this.cardLayout1, ContractPanel_Parameters.this.editor);
                    if (comp != null) {
                        ContractPanel_Parameters.this.subPanelCurrent = comp;
                        String mode = (String)node.getAttribute("mode");
                        int mid = Utils.parseInt(String.valueOf(node.getAttribute("mid")), -1);
                        if (mid > 0 && comp instanceof ContractSubPanel_Module) {
                            ContractSubPanel_Module cspm = (ContractSubPanel_Module)comp;
                            cspm.init(cspm.getModule(), mid, (String)node.getAttribute("package"));
                            cspm.setData();
                        } else if (mode != null && comp instanceof ContractSubPanel_Balance) {
                            ContractSubPanel_Balance cspb = (ContractSubPanel_Balance)comp;
                            cspb.init(cspb.getModule(), 0);
                            Object year = node.getAttribute("year");
                            Object month = node.getAttribute("month");
                            if (month == null) {
                                year = ((BGTreeNode)node.getParent()).getAttribute("year");
                                month = ((BGTreeNode)node.getParent()).getAttribute("month");
                            }
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.set(1, Utils.parseInt((String)year, cal.get(1)));
                            cal.set(2, Utils.parseInt((String)month, cal.get(2) + 1) - 1);
                            cal.set(5, 1);
                            cspb.setPeriod(cal, cal);
                            cspb.setMode(mode, ContractPanel_Parameters.this);
                            cspb.setData();
                        } else {
                            comp.init(comp.getModule(), 0);
                            comp.setData();
                        }
                    } else {
                        comp = ((BGTreeNode)node.getParent()).actionPerformed(e, ContractPanel_Parameters.this.rightPanel, ContractPanel_Parameters.this.cardLayout1, ContractPanel_Parameters.this.editor);
                        if (comp != null) {
                            ContractPanel_Parameters.this.subPanelCurrent = comp;
                            comp.init(comp.getModule(), 0);
                            comp.setData();
                        }
                    }
                }
            });
        }
    }

    public void balanceModeChanged(String mode) {
        if (mode != null) {
            BGTreeNode node = null;
            switch (mode) {
                case "0": {
                    node = this.treeNodeMap.get(KEY_BALANCE_0);
                    break;
                }
                case "1": {
                    node = this.treeNodeMap.get(KEY_BALANCE_1);
                    break;
                }
                case "2": {
                    node = this.treeNodeMap.get(KEY_BALANCE_2);
                    break;
                }
                case "3": {
                    if (this.currentNode == this.treeNodeMap.get(KEY_BALANCE_3)) break;
                    node = this.treeNodeMap.get(KEY.balance.toString());
                    break;
                }
                case "4": {
                    if (this.currentNode == this.treeNodeMap.get(KEY_BALANCE_OUTSALDO)) break;
                    node = this.treeNodeMap.get(KEY_BALANCE_4);
                    break;
                }
                case "5": {
                    node = this.treeNodeMap.get(KEY_BALANCE_5);
                    break;
                }
                case "6": {
                    node = this.treeNodeMap.get(KEY_BALANCE_6);
                    break;
                }
                case "7": {
                    node = this.treeNodeMap.get(KEY_BALANCE_7);
                }
            }
            if (node != null && node != this.currentNode) {
                this.balanceMode = false;
                this.tree.getTree().setSelectionPath(new TreePath(node.getPath()));
                this.balanceMode = true;
            }
        }
    }

    @Override
    public void newItem() {
        this.subPanelCurrent.newItem();
    }

    @Override
    public void editItem() {
        this.subPanelCurrent.editItem();
    }

    @Override
    public void deleteItem() {
        this.subPanelCurrent.deleteItem();
    }

    private ContractSubPanel showPanel(BGTreeNode treeNode) {
        return treeNode != null ? treeNode.showComponent(this.rightPanel, this.cardLayout1, this.editor) : null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        if ("titleChange".equals(actionCommand)) {
            ContractTitleEditorDialog dialog = new ContractTitleEditorDialog(this.getContractId());
            dialog.setVisible(true);
            this.setData();
        } else if ("cbDel".equals(actionCommand)) {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("SetDelContract");
            if (this.cbDel.isSelected() && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441\u043a\u0440\u044b\u0442\u044b\u043c?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                request.setAttribute("del", this.cbDel.isSelected() ? "1" : "0");
            } else {
                this.cbDel.setSelected(false);
                request.setAttribute("del", this.cbDel.isSelected() ? "1" : "0");
            }
            request.setContractId(this.getContractId());
            ClientUtils.checkStatus(TransferManager.getDocument(request));
        } else if ("refresh".equals(actionCommand)) {
            this.setData();
        } else {
            this.subPanelCurrent.actionPerformed(event);
        }
    }

    private void setCurrentNode(BGTreeNode treeNode) {
        if (this.currentNode == null) {
            this.currentNode = treeNode;
        }
    }

    public void onEvent(UpdateContractTreeEvent event) {
        if (event.getContractId() == this.getContractId()) {
            this.setData();
        }
    }

    public Period getContractPeriod() {
        return this.contractPeriod.getPeriod();
    }

    private void setNodeValue(KEY key, Object value) {
        if (this.treeNodeMap.containsKey(key.toString())) {
            this.treeNodeMap.get(key.toString()).setValue(new Object[]{value});
        }
    }

    private void fireTreeNodeChanged(String key) {
        if (this.treeNodeMap.containsKey(key)) {
            this.model.fireTreeNodeChanged(this.treeNodeMap.get(key));
        }
    }

    private void fireTreeStructureChanged(String key) {
        if (this.treeNodeMap.containsKey(key)) {
            this.model.fireTreeStructureChanged(this.treeNodeMap.get(key));
        }
    }

    private void buildLabels(String key, Element node) {
        BGTreeNode treeNode = this.treeNodeMap.get(key);
        if (treeNode == null) {
            return;
        }
        treeNode.removeChilds();
        try {
            ContractLabelService contractLabelService = this.getContext().getPort(ContractLabelService.class);
            List<Integer> contractLabelItems = contractLabelService.getContractLabelIds(this.getContractId());
            if (Utils.notEmptyCollection(contractLabelItems)) {
                ContractLabelItem rootTree = contractLabelService.getContractLabelTree();
                this.removeNonSelected(rootTree, contractLabelItems);
                this.removeEmptyLabelCategory(rootTree);
                this.buildContractLabelsTree(treeNode, rootTree);
            }
        }
        catch (BGException e) {
            throw new RuntimeException(e);
        }
        this.model.fireTreeStructureChanged(treeNode);
    }

    private void removeNonSelected(ContractLabelItem rootItem, List<Integer> selectedItems) {
        if (Utils.notEmptyCollection(rootItem.getChildren())) {
            Iterator<ContractLabelItem> it = rootItem.getChildren().iterator();
            while (it.hasNext()) {
                ContractLabelItem child = it.next();
                if (Utils.notEmptyCollection(child.getChildren())) {
                    this.removeNonSelected(child, selectedItems);
                    continue;
                }
                if (selectedItems.contains(child.getId())) continue;
                it.remove();
            }
        }
    }

    private void removeEmptyLabelCategory(ContractLabelItem rootItem) {
        if (Utils.notEmptyCollection(rootItem.getChildren())) {
            Iterator<ContractLabelItem> it = rootItem.getChildren().iterator();
            while (it.hasNext()) {
                ContractLabelItem child = it.next();
                if (Utils.notEmptyCollection(child.getChildren())) {
                    this.removeEmptyLabelCategory(child);
                    continue;
                }
                if (!Utils.isEmptyCollection(child.getChildren()) || !child.getContractLabelType().equals((Object)ContractLabelType.LABEL)) continue;
                it.remove();
            }
        }
    }

    private void buildContractLabelsTree(BGTreeNode root, ContractLabelItem labelItem) {
        if (Utils.notEmptyCollection(labelItem.getChildren())) {
            for (ContractLabelItem child : labelItem.getChildren()) {
                BGTreeNode childNode = new BGTreeNode(child.getTitle(), "", ContractSubPanel_Group.class);
                root.addChild(childNode);
                if (!Utils.notEmptyCollection(child.getChildren())) continue;
                this.buildContractLabelsTree(childNode, child);
            }
        }
    }

    private void addTreeNodeChilds(String key, Element node) {
        BGTreeNode treeNode = this.treeNodeMap.get(key);
        if (treeNode == null) {
            return;
        }
        treeNode.removeChilds();
        this.model.fireTreeStructureChanged(treeNode);
        NodeList items = node.getElementsByTagName("item");
        for (int k = 0; k < items.getLength(); ++k) {
            BGTreeNode itemTreeNode = new BGTreeNode(XMLUtils.getAttribute((Element)items.item(k), "title", "?"), "");
            treeNode.addChild(itemTreeNode);
            this.model.fireTreeStructureChanged(itemTreeNode);
        }
    }

    public Contract getContract(int contractId, boolean cache) throws BGException {
        Contract contract;
        if (this.contractMap == null) {
            this.contractMap = new HashMap();
            for (Contract c : this.getContractService().contractSubList(this.getContractId(), 0, true)) {
                this.contractMap.put(c.getId(), c);
            }
        }
        if (!((contract = this.contractMap.get(contractId)) != null && cache || (contract = this.getContractService().contractGet(contractId)) == null)) {
            this.contractMap.put(contractId, contract);
        }
        return contract;
    }

    private ContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = this.getContext().getPort(ContractService.class);
        }
        return this.contractService;
    }

    private static enum KEY {
        parameters,
        objects,
        hierarchy,
        status,
        period,
        limit,
        mode,
        face,
        balance,
        bonus,
        tariff,
        modules,
        web,
        groups,
        script,
        addAction,
        memo;

    }

    class CustomerContractPopup
    extends JPopupMenu {
        public CustomerContractPopup(List<RowData> list) {
            ActionListener actionListener = e -> {
                BGClient.getFrame().getTabbedPane().addContractEditorTab(Integer.parseInt(e.getActionCommand()));
                this.setVisible(false);
            };
            int gridy = 0;
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            buttonPanel.setOpaque(true);
            buttonPanel.setBackground(Color.WHITE);
            for (RowData rowData : list) {
                JSONObject json = rowData.getJson();
                String title = json.optString("title");
                JButton button = new JButton(Utils.notBlankString(title) ? title : "???");
                button.setOpaque(false);
                button.setActionCommand(String.valueOf(json.getInt("id")));
                button.addActionListener(actionListener);
                buttonPanel.add((Component)button, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            Component component = Box.createGlue();
            buttonPanel.add(component, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            JScrollPane scrollPane = new JScrollPane(buttonPanel);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            scrollPane.setOpaque(false);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setOpaque(false);
            panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.setBackground(Color.WHITE);
            this.setPreferredSize(new Dimension(300, 200));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), new BGTitleBorder("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043a\u043b\u0438\u0435\u043d\u0442\u0430")));
            this.add("Center", panel);
        }
    }
}

