/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.contract;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBoxWithSearch;
import bitel.billing.module.common.BGTabbedPane;
import bitel.billing.module.common.BGTextArea;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.common.table.BGTableColumn;
import bitel.billing.module.contract.AddressUtil;
import bitel.billing.module.contract.ParameterEditor;
import bitel.billing.module.contract.directory.HouseEditor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.bushe.swing.event.EventBus;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;

public class AddressEditor
extends ParameterEditor {
    private static String PANEL_ADDRESS = "address";
    private static String PANEL_ADDRESS_CUSTOM = "address_custom";
    private static String PANEL_EDITOR = "editor";
    private static String PANEL_HOUSE = "house";
    protected static int MODE_ADDRESS = 0;
    private static int MODE_HOUSE = 1;
    protected int hid;
    protected int editMode = 0;
    protected String areaValue = null;
    protected String quarterValue = null;
    protected String panel = null;
    private BGButton houseButton = new BGButton();
    private BGButton clearHouseButton = new BGButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043f\u043e\u043b\u0435");
    protected boolean addressCleared = false;
    protected boolean addressCustomFlag = true;
    protected BGTextField flat = new BGTextField();
    protected BGTextField room = new BGTextField();
    protected IntTextField pod = new IntTextField();
    protected IntTextField floor = new IntTextField();
    protected BGTextField index = new BGTextField();
    private BGTextField area = new BGTextField();
    private BGTextField quarter = new BGTextField();
    protected BGTextArea comment = new BGTextArea();
    private CardLayout mainLayout = new CardLayout();
    private HouseEditor houseEditor = new HouseEditor();
    private AddressEditor addressEditor = null;
    private BGButton backToAddressPanelButton = new BGButton("\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c \u0430\u0434\u0440\u0435\u0441\u0430");
    private BGButton backToSelectHousePanelButton = new BGButton("\u0412\u0435\u0440\u043d\u0443\u0442\u044c\u0441\u044f \u0434\u043b\u044f \u0432\u044b\u0431\u043e\u0440\u0430 \u0434\u043e\u043c\u0430");
    private BGComboBoxWithSearch street = new BGComboBoxWithSearch(2);
    private BGTextField house = new BGTextField();
    private BGTable searchTable = new BGTable();
    private BGButton newHouseButton;
    private BGButton newAddressCustomButton;
    private AddressFormatTableModel addressFormatTableModel = new AddressFormatTableModel(AddressFormatTableModel.class.getName());
    private JButton okButton;
    protected String houseAndFrac;
    protected String cityTitle;
    protected String streetTitle;
    private int streetId = -1;
    protected boolean canCreateHouse = false;
    private BGTable additionalInfoTable;
    protected BGTextField addressCustom;
    protected BGTextArea addressCustomComment;
    private String entranceRange = null;
    private String floorRange = null;
    protected int selected = -1;
    private boolean isObject = false;

    public AddressEditor() {
        this.addressEditor = this;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.houseEditor.init(module, mid);
    }

    private void jbInit() throws Exception {
        this.houseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.fillListByHouses(AddressEditor.this.streetId, "");
                AddressEditor.this.street.initPopup(AddressEditor.this.streetId, AddressEditor.this.streetTitle + " (" + AddressEditor.this.cityTitle + ")");
                AddressEditor.this.showPanelHouse(AddressEditor.this.houseAndFrac);
                AddressEditor.this.streetEntered();
                AddressEditor.this.backToAddressPanelButton.setEnabled(true);
                AddressEditor.this.okButton.setEnabled(false);
            }
        });
        this.clearHouseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.selected = -1;
                AddressEditor.this.deleteAddress();
            }
        });
        final BGUTable addressFormatTable = new BGUTable(this.addressFormatTableModel);
        addressFormatTable.setSelectionMode(0);
        addressFormatTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Element element;
                if (mouseEvent.getClickCount() == 1 && (element = (Element)AddressEditor.this.addressFormatTableModel.getSelectedRow()) != null) {
                    AddressEditor.this.addressFormatTableModel.getRows().forEach(row -> row.setAttribute("f1", "false"));
                    AddressEditor.this.selected = addressFormatTable.getSelectedRow();
                    element.setAttribute("f1", "true");
                    addressFormatTable.updateUI();
                    addressFormatTable.repaint();
                }
            }
        });
        this.comment.setMinimumSize(new Dimension(70, 36));
        this.comment.setText("");
        this.comment.setLineWrap(true);
        this.comment.setRows(2);
        this.comment.setWrapStyleWord(true);
        this.room.setHorizontalAlignment(0);
        this.room.getDocument().addDocumentListener(new AddressDocumentListener());
        this.floor.setColumns(5);
        this.floor.getDocument().addDocumentListener(new AddressDocumentListener());
        this.pod.setColumns(5);
        this.pod.getDocument().addDocumentListener(new AddressDocumentListener());
        this.flat.setColumns(10);
        this.flat.setMinimumSize(new Dimension(80, 10));
        this.flat.getDocument().addDocumentListener(new AddressDocumentListener());
        this.flat.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AddressEditor.this.onFlatChanged();
            }
        });
        this.flat.setHorizontalAlignment(0);
        JPanel housePanel = new JPanel(new GridBagLayout());
        housePanel.add((Component)new JLabel("\u0414\u043e\u043c: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        housePanel.add((Component)this.houseButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        housePanel.add((Component)this.clearHouseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel houseInfoPanel = new JPanel(new GridBagLayout());
        houseInfoPanel.setBorder(new BGTitleBorder(" \u041a\u0432\u0430\u0440\u0442\u0438\u0440\u0430 "));
        houseInfoPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)this.flat, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)new JLabel("\u041a\u043e\u043c\u043d\u0430\u0442\u0430: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)this.room, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)new JLabel("\u041f\u043e\u0434\u044a\u0435\u0437\u0434: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)this.pod, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)new JLabel("\u042d\u0442\u0430\u0436: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add((Component)this.floor, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        houseInfoPanel.add(Box.createGlue(), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel commentPanel = new JPanel(new GridBagLayout());
        commentPanel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.additionalInfoTable = new BGTable();
        this.additionalInfoTable.addColumn("paramName", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", new int[]{100, 150, 200}, false);
        this.additionalInfoTable.setAutoResizeMode(1);
        this.additionalInfoTable.addColumn("paramValue", "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", new int[]{-1, -1, -1}, false);
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.add((Component)new JScrollPane(this.additionalInfoTable), "Center");
        BGTabbedPane additionalHouseInfoPanel = new BGTabbedPane();
        additionalHouseInfoPanel.add((Component)commentPanel, "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        additionalHouseInfoPanel.add((Component)infoPanel, "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
        additionalHouseInfoPanel.add((Component)new JScrollPane(addressFormatTable), "\u0424\u043e\u0440\u043c\u0430\u0442 \u0430\u0434\u0440\u0435\u0441\u0430");
        JPanel addressPanel = new JPanel(new GridBagLayout());
        addressPanel.setFocusTraversalPolicy(this.getFocus());
        addressPanel.setFocusCycleRoot(true);
        addressPanel.add((Component)housePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addressPanel.add((Component)houseInfoPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        addressPanel.add((Component)additionalHouseInfoPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.street.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (((long)event.getModifiers() & 0x10L) > 0L) {
                    AddressEditor.this.streetEntered();
                }
            }
        });
        this.street.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fillText")) {
                    AddressEditor.this.fillStreetList(String.valueOf(evt.getNewValue()));
                } else if (evt.getPropertyName().equals("textEntered")) {
                    AddressEditor.this.streetEntered();
                }
            }
        });
        this.house.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                int selectedStreetId;
                if (e.getKeyChar() == '\n' && (selectedStreetId = Integer.valueOf(AddressEditor.this.street.getSelectedId()).intValue()) > 0) {
                    AddressEditor.this.fillListByHouses(selectedStreetId, AddressEditor.this.house.getText());
                }
            }
        });
        this.searchTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BGTable table = (BGTable)mouseEvent.getSource();
                    int row = table.getSelectedRow();
                    int rowId = Integer.valueOf(AddressEditor.this.tableInStreetsMode(table) ? table.getColumnValueString(row, "streetId") : table.getColumnValueString(row, "houseId"));
                    if (rowId > 0) {
                        if (AddressEditor.this.tableInStreetsMode(table)) {
                            AddressEditor.this.fillListByHouses(rowId, AddressEditor.this.house.getText());
                        } else {
                            AddressEditor.this.setSelectedHouse(rowId);
                        }
                    }
                }
            }
        });
        JButton searchButton = new JButton("\u041d\u0430\u0439\u0442\u0438");
        searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.streetEntered();
            }
        });
        this.backToAddressPanelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.mainLayout.show(AddressEditor.this.addressEditor, PANEL_ADDRESS);
                AddressEditor.this.okButton.setEnabled(true);
            }
        });
        this.newHouseButton = new BGButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0439 \u0434\u043e\u043c...");
        this.newHouseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.mainLayout.show(AddressEditor.this.addressEditor, PANEL_EDITOR);
                AddressEditor.this.editMode = MODE_HOUSE;
                AddressEditor.this.okButton.setEnabled(true);
            }
        });
        this.newAddressCustomButton = new BGButton("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0434\u0440\u0435\u0441\u0430");
        this.newAddressCustomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.mainLayout.show(AddressEditor.this.addressEditor, PANEL_ADDRESS_CUSTOM);
                AddressEditor.this.addressCustom.setText("");
                AddressEditor.this.addressCustomComment.setText("");
                AddressEditor.this.okButton.setEnabled(true);
                AddressEditor.this.editMode = MODE_ADDRESS;
                AddressEditor.this.panel = PANEL_ADDRESS_CUSTOM;
            }
        });
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        jPanel4.add((Component)new JLabel("\u0423\u043b\u0438\u0446\u0430:"), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel4.add((Component)this.street, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel4.add((Component)new JLabel("\u0414\u043e\u043c [\u0434\u0440\u043e\u0431\u044c]:"), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
        jPanel4.add((Component)this.house, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel4.add((Component)searchButton, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 11, 2, new Insets(10, 5, 0, 5), 0, 0));
        jPanel4.add((Component)this.backToAddressPanelButton, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 11, 2, new Insets(18, 5, 5, 0), 0, 0));
        jPanel4.add((Component)this.newHouseButton, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 11, 2, new Insets(18, 5, 5, 5), 0, 0));
        jPanel4.add((Component)this.newAddressCustomButton, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.street.setEditable(true);
        JPanel selectHousePanel = new JPanel(new GridBagLayout());
        selectHousePanel.add((Component)jPanel4, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        selectHousePanel.add((Component)new JLabel("\u041d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438:"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
        selectHousePanel.add((Component)new JScrollPane(this.searchTable), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.backToSelectHousePanelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.mainLayout.show(AddressEditor.this.addressEditor, PANEL_HOUSE);
                AddressEditor.this.editMode = MODE_ADDRESS;
                AddressEditor.this.okButton.setEnabled(false);
                AddressEditor.this.panel = PANEL_HOUSE;
            }
        });
        JPanel houseEditorPanel = new JPanel(new GridBagLayout());
        houseEditorPanel.add((Component)this.backToSelectHousePanelButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        houseEditorPanel.add((Component)this.houseEditor, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        JPanel addressCustomEditor = new JPanel(new GridBagLayout());
        BGButton backButton = new BGButton("\u0410\u0434\u0440\u0435\u0441 \u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430");
        backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddressEditor.this.mainLayout.show(AddressEditor.this.addressEditor, PANEL_HOUSE);
                AddressEditor.this.editMode = MODE_ADDRESS;
                AddressEditor.this.okButton.setEnabled(false);
                AddressEditor.this.panel = PANEL_HOUSE;
            }
        });
        this.addressCustom = new BGTextField();
        this.addressCustomComment = new BGTextArea();
        addressCustomEditor.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        addressCustomEditor.add((Component)this.addressCustom, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        addressCustomEditor.add((Component)backButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        addressCustomEditor.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        addressCustomEditor.add((Component)new JScrollPane(this.addressCustomComment), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(this.mainLayout);
        this.add((Component)addressPanel, PANEL_ADDRESS);
        this.add((Component)houseEditorPanel, PANEL_EDITOR);
        this.add((Component)selectHousePanel, PANEL_HOUSE);
        this.add((Component)addressCustomEditor, PANEL_ADDRESS_CUSTOM);
    }

    @Override
    public void setData() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("AddressInfo");
        request.setContractId(this.getContractId());
        request.setAttribute("pid", this.id);
        this.editMode = MODE_ADDRESS;
        this.panel = null;
        this.setDocument(this.getDocument(request));
        this.clearHouseSearchPanel();
    }

    @Override
    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus(doc)) {
            if (this.addressCleared) {
                this.clearHouseInfo();
                this.mainLayout.show(this, PANEL_ADDRESS);
            } else {
                this.houseButton.requestFocusInWindow();
                Element address = XMLUtils.selectElement(doc, "data/address");
                this.houseAndFrac = XMLUtils.getAttribute(address, "house", "") + XMLUtils.getAttribute(address, "frac", "");
                this.houseButton.setText(XMLUtils.getAttribute(address, "city", "") + ", " + XMLUtils.getAttribute(address, "street", "") + ", " + this.houseAndFrac);
                this.flat.setText(XMLUtils.getAttribute(address, "flat", ""));
                this.pod.setText(XMLUtils.getAttribute(address, "pod", ""));
                this.floor.setText(XMLUtils.getAttribute(address, "floor", ""));
                this.room.setText(XMLUtils.getAttribute(address, "room", ""));
                this.comment.setText(XMLUtils.getAttribute(address, "comment", ""));
                if (Utils.notBlankString(XMLUtils.getAttribute(address, "street", ""))) {
                    this.streetTitle = XMLUtils.getAttribute(address, "street", "");
                    this.streetId = Integer.valueOf(XMLUtils.getAttribute(address, "streetid", ""));
                    this.cityTitle = XMLUtils.getAttribute(address, "city", "");
                }
                HashMap<String, String> additionalHouseInfo = new HashMap<String, String>();
                additionalHouseInfo.put("\u0438\u043d\u0434\u0435\u043a\u0441", XMLUtils.getAttribute(address, "index", ""));
                additionalHouseInfo.put("\u0440\u0430\u0439\u043e\u043d", XMLUtils.getAttribute(address, "area", ""));
                additionalHouseInfo.put("\u043a\u0432\u0430\u0440\u0442\u0430\u043b", XMLUtils.getAttribute(address, "quarter", ""));
                this.addExtraParamsToMap(XMLUtils.selectElement(doc, "data/extraParams"), additionalHouseInfo);
                this.setAdditionalInfo(additionalHouseInfo);
                this.setAddressFormatTableData(doc);
                Element object = XMLUtils.selectElement(doc, "//object");
                this.isObject = object.getAttribute("isObject").equals("1");
                Boolean b = Utils.parseBoolean(XMLUtils.selectText(doc, "data/address/create/@value"));
                this.canCreateHouse = b == null ? false : b;
                this.newHouseButton.setEnabled(this.canCreateHouse);
                this.hid = Integer.parseInt(XMLUtils.getAttribute(address, "hid", "-1"));
                if (this.hid > 0) {
                    this.mainLayout.show(this, PANEL_ADDRESS);
                    this.okButton.setEnabled(true);
                } else {
                    String addressCustom = XMLUtils.getAttribute(address, "address", null);
                    if (addressCustom != null && this.addressCustomFlag) {
                        this.mainLayout.show(this, PANEL_ADDRESS_CUSTOM);
                        this.addressCustom.setText(addressCustom);
                        this.addressCustomComment.setText(XMLUtils.getAttribute(address, "comment", ""));
                        this.panel = PANEL_ADDRESS_CUSTOM;
                        this.okButton.setEnabled(true);
                    } else {
                        this.mainLayout.show(this, PANEL_HOUSE);
                        this.backToAddressPanelButton.setEnabled(false);
                        this.okButton.setEnabled(false);
                    }
                }
            }
            this.houseEditor.setAddressMap(doc);
        }
    }

    @Override
    public boolean updateData() {
        if (this.editMode == MODE_ADDRESS) {
            if (this.panel != null && this.panel.equals(PANEL_ADDRESS_CUSTOM)) {
                return this.updateAddressCustom();
            }
            return this.updateAddress();
        }
        if (this.updateHouse()) {
            this.editAddress();
        }
        return false;
    }

    protected boolean updateAddressCustom() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("AddAddressCustom");
        request.setContractId(this.getContractId());
        request.setAttribute("pid", this.id);
        request.setAttribute("address", this.addressCustom.getText());
        request.setAttribute("comment", this.addressCustomComment.getText());
        this.editMode = MODE_ADDRESS;
        this.panel = null;
        Document doc = this.getDocument(request);
        ClientUtils.checkStatus(doc);
        return true;
    }

    public void editHouse() {
        this.mainLayout.show(this, PANEL_HOUSE);
        this.editMode = MODE_HOUSE;
        this.panel = null;
        this.houseEditor.house.setText(this.houseButton.getText());
        this.houseEditor.box_index.setText(this.index.getText());
        this.houseEditor.amount.setText("0");
        this.houseEditor.comment.setText("");
        this.houseEditor.datePanel.setDateString("");
    }

    public void editAddress() {
        this.mainLayout.show(this, PANEL_ADDRESS);
        this.editMode = MODE_ADDRESS;
        this.panel = null;
        this.index.setText(this.houseEditor.box_index.getText());
        this.houseButton.setText(this.houseEditor.house.getText());
        this.houseButton.setText(this.houseEditor.city.getSelectedItem() + ", " + this.houseEditor.street.getSelectedItem() + ", " + this.houseEditor.house.getText());
        this.areaValue = "";
        if (this.houseEditor.area.getSelectedIndex() > 0) {
            this.areaValue = this.houseEditor.area.getSelectedItem().toString();
            this.area.setText(this.areaValue);
        } else {
            this.area.setText("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e");
        }
        this.quarterValue = "";
        if (this.houseEditor.quarter.getSelectedIndex() > 0) {
            this.quarterValue = this.houseEditor.quarter.getSelectedItem().toString();
            this.quarter.setText(this.quarterValue);
        } else {
            this.quarter.setText("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e");
        }
        this.cityTitle = "";
        if (this.houseEditor.city.getSelectedIndex() > 0) {
            this.cityTitle = this.houseEditor.city.getSelectedItem().toString();
        }
        this.streetTitle = this.houseEditor.street.getSelectedItem().toString();
        this.flat.setText("");
        this.room.setText("");
        this.pod.setText("");
        this.floor.setText("");
    }

    private boolean updateHouse() {
        if (!this.houseEditor.checkAddress()) {
            return false;
        }
        Request request = new Request();
        request.setModule("admin");
        request.setAction("UpdateAddressHouse");
        request.setAttribute("id", "new");
        request.setAttribute("cityid", this.houseEditor.city.getSelectedItem().getObject());
        request.setAttribute("areaid", this.houseEditor.area.getSelectedItem().getObject());
        request.setAttribute("quarterid", this.houseEditor.quarter.getSelectedItem().getObject());
        request.setAttribute("streetid", this.houseEditor.street.getSelectedItem().getObject());
        request.setAttribute("houseAndFrac", this.houseEditor.house.getText().toString());
        request.setAttribute("box_index", this.houseEditor.box_index.getText().toString());
        request.setAttribute("amount", this.houseEditor.amount.getText().trim());
        request.setAttribute("dt", this.houseEditor.datePanel.getDateString());
        request.setAttribute("comment", this.houseEditor.comment.getText().trim());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus(doc)) {
            Element address = XMLUtils.selectElement(doc, "data/address");
            this.hid = Integer.parseInt(XMLUtils.getAttribute(address, "hid", "-1"));
            return true;
        }
        return false;
    }

    private boolean checkAddresParameter() {
        if (this.flat.getText().trim().length() > 10) {
            ClientUtils.showMessageDialog("\u041d\u043e\u043c\u0435\u0440 \u043a\u0432\u0430\u0440\u0442\u0438\u0440\u044b \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e 10 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            return false;
        }
        if (this.room.getText().trim().length() > 5) {
            ClientUtils.showMessageDialog("\u041d\u043e\u043c\u0435\u0440 \u043a\u043e\u043c\u043d\u0430\u0442\u044b \u043c\u043e\u0436\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e 5 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
            return false;
        }
        String pd = this.pod.getText().trim();
        if (!pd.isEmpty() && Utils.parseInt(pd, -1) == -1) {
            ClientUtils.showMessageDialog("\"\u041f\u043e\u0434\u044a\u0435\u0437\u0434\" \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u0447\u0438\u0441\u043b\u043e");
            return false;
        }
        String fl = this.floor.getText().trim();
        if (!fl.isEmpty() && Utils.parseInt(fl, -1) == -1) {
            ClientUtils.showMessageDialog("\"\u042d\u0442\u0430\u0436\" \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0431\u043e\u043b\u044c\u0448\u043e\u0435 \u0447\u0438\u0441\u043b\u043e");
            return false;
        }
        return true;
    }

    private boolean updateAddress() {
        boolean result = this.checkAddresParameter();
        if (!result) {
            return result;
        }
        if (!this.addressCleared) {
            Request request = new Request();
            request.setModule("contract");
            request.setAttribute("pid", this.id);
            request.setContractId(this.getContractId());
            request.setAttribute("hid", this.hid);
            request.setAttribute("flat", this.flat.getText().trim());
            request.setAttribute("room", this.room.getText().trim());
            request.setAttribute("pod", this.pod.getText().trim());
            request.setAttribute("floor", this.floor.getText().trim());
            request.setAction("CheckAddressInfo");
            Document doc = this.getDocument(request);
            String status = doc.getDocumentElement().getAttribute("status");
            if (!status.equals("ok")) {
                StringBuilder message = new StringBuilder();
                message.append("\u0410\u043d\u0430\u043b\u043e\u0433\u0438\u0447\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441 \u0435\u0441\u0442\u044c \u0432 ");
                message.append(doc.getDocumentElement().getAttribute("count"));
                message.append(" \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445");
                String contracts = doc.getDocumentElement().getAttribute("contract");
                if (contracts != null && contracts.length() > 0) {
                    message.append("\n( ");
                    message.append(contracts);
                    message.append(" )");
                }
                message.append("\n\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?");
                boolean bl = result = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), message.toString(), "\u0414\u0443\u0431\u043b\u0438\u0440\u0443\u0435\u0442\u0441\u044f \u0430\u0434\u0440\u0435\u0441", 0) == 0;
            }
            if (result) {
                result = this.updateAddressParameter();
            }
        } else {
            this.addressCleared = false;
        }
        return result;
    }

    protected boolean updateAddressParameter() {
        Request request = new Request();
        request.setModule("contract");
        request.setAttribute("pid", this.id);
        request.setContractId(this.getContractId());
        request.setAttribute("formatKey", this.selected);
        request.setAction("UpdateAddressInfo");
        this.setAddressDataToRequest(request);
        boolean result = ClientUtils.checkStatus(TransferManager.getDocument(request));
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
        return result;
    }

    protected void setAddressDataToRequest(Request request) {
        request.setAttribute("hid", this.hid);
        request.setAttribute("flat", this.flat.getText().trim());
        request.setAttribute("room", this.room.getText().trim());
        request.setAttribute("pod", this.pod.getText().trim());
        request.setAttribute("floor", this.floor.getText().trim());
        request.setAttribute("cityStr", this.cityTitle);
        request.setAttribute("quarter", this.quarterValue);
        request.setAttribute("streetStr", this.streetTitle);
        request.setAttribute("area", this.areaValue);
        request.setAttribute("houseAndFrac", this.houseAndFrac);
        request.setAttribute("index", this.index.getText().trim());
        request.setAttribute("comment", this.comment.getText().trim());
    }

    protected void deleteAddress() {
        Request request = new Request();
        request.setModule("admin");
        request.setAction("DeleteAddressParameter");
        request.setContractId(this.getContractId());
        request.setAttribute("pid", this.id);
        if (ClientUtils.checkStatus(this.getDocument(request))) {
            this.addressCleared = true;
            this.setData();
        }
    }

    private void fillStreetList(String streetTitle) {
        Request request = new Request();
        request.setModule("admin");
        request.setAction("GetAddressStreet");
        request.setPageIndex(1);
        request.setPageSize(25);
        int pos = streetTitle.indexOf(40);
        if (pos < 0) {
            request.setAttribute("stname", streetTitle.trim());
        } else {
            request.setAttribute("stname", streetTitle.substring(0, pos).trim());
            if (pos < streetTitle.length() - 1) {
                request.setAttribute("city_title", streetTitle.substring(pos + 1).trim());
            }
        }
        Document doc = this.getDocument(request);
        Iterable<Element> streets = XMLUtils.selectElements(doc, "data/table/data/row");
        this.street.initPopup(streetTitle);
        for (Element s : streets) {
            Integer streetId = Integer.valueOf(XMLUtils.getAttribute(s, "f0"));
            String streetName = XMLUtils.getAttribute(s, "f1") + " (" + XMLUtils.getAttribute(s, "f2") + ")";
            this.street.addItem(new ComboBoxItem(streetId, streetName));
        }
    }

    private void fillListByStreets(String streetSubstring) {
        this.searchTable.removeRows();
        if (Utils.notBlankString(streetSubstring)) {
            this.searchTable.removeColumns();
            BGTableColumn column = null;
            column = BGTableColumn.getInstance("cityTitle", "\u0413\u043e\u0440\u043e\u0434", new int[]{150, 200, 250}, false, "");
            column.setEditable(false);
            column.setCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.searchTable.addColumn(column);
            column = BGTableColumn.getInstance("streetTitle", "\u0423\u043b\u0438\u0446\u0430", new int[]{-1, -1, -1}, false, "");
            column.setEditable(false);
            column.setCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.searchTable.addColumn(column);
            this.searchTable.setAutoResizeMode(1);
            column = BGTableColumn.getInstance("streetId", "ID", new int[]{80, 80, 80}, false, "");
            column.setEditable(false);
            column.setCellRenderer(DecimalTableCellRenderer.INTEGER());
            this.searchTable.addColumn(column);
            Request request = new Request();
            request.setModule("admin");
            request.setAction("GetStreetsBySubstring");
            request.setAttribute("streetSubstring", streetSubstring);
            Document doc = this.getDocument(request);
            for (Element streetEl : XMLUtils.selectElements(doc, "data/streetList/street")) {
                Vector<String> row = new Vector<String>();
                row.add(streetEl.getAttribute("cityTitle"));
                row.add(streetEl.getAttribute("streetTitle"));
                row.add(streetEl.getAttribute("streetId"));
                this.searchTable.addRow(row);
            }
        }
    }

    private void fillListByHouses(int streetId, String houseNum) {
        this.searchTable.removeRows();
        if (streetId > 0) {
            Request request = new Request();
            request.setModule("admin");
            request.setAction("FilterHouse");
            request.setAttribute("street", streetId);
            request.setAttribute("house_frac", houseNum);
            Document doc = this.getDocument(request);
            Iterable<Element> houses = XMLUtils.selectElements(doc, "data/list/item");
            this.searchTable.removeColumns();
            BGTableColumn column = null;
            column = BGTableColumn.getInstance("house", "\u0414\u043e\u043c", new int[]{-1, -1, -1}, false, "");
            column.setEditable(false);
            column.setCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.searchTable.addColumn(column);
            this.searchTable.setAutoResizeMode(3);
            column = BGTableColumn.getInstance("houseId", "ID", new int[]{80, 80, 80}, false, "");
            column.setEditable(false);
            column.setCellRenderer(DecimalTableCellRenderer.INTEGER());
            this.searchTable.addColumn(column);
            for (Element houseItem : houses) {
                String address;
                int pos;
                String addressHouse = houseItem.getAttribute("house");
                if (addressHouse.isEmpty() && (pos = (address = houseItem.getAttribute("title")).indexOf(",")) > -1 && pos < address.length()) {
                    addressHouse = address.substring(pos + 1);
                }
                if (!houseNum.equals("") && addressHouse.indexOf(houseNum) <= -1) continue;
                HashMap<String, String> row = new HashMap<String, String>();
                row.put("house", houseItem.getAttribute("title"));
                row.put("houseId", houseItem.getAttribute("id"));
                this.searchTable.addRow(row);
            }
        }
    }

    private void streetEntered() {
        Object selectedItem = this.street.getSelectedItem();
        if (selectedItem != null) {
            int selectedStreetId = Utils.parseInt(this.street.getSelectedId());
            if (selectedStreetId > 0) {
                this.fillListByHouses(selectedStreetId, this.house.getText());
            } else {
                this.fillListByStreets(selectedItem.toString());
            }
        }
    }

    private boolean tableInStreetsMode(BGTable table) {
        return table.getColumnCount() == 3;
    }

    private void setAdditionalInfo(Map<String, String> info) {
        this.additionalInfoTable.removeRows();
        for (String paramName : info.keySet()) {
            this.addAdditionalParameter(paramName, info.get(paramName));
        }
    }

    private void addAdditionalParameter(String name, String value) {
        Vector<String> paramRow = new Vector<String>();
        paramRow.add(name);
        paramRow.add(value);
        this.additionalInfoTable.addRow(paramRow);
    }

    private void showPanelHouse(String house) {
        this.addressCleared = false;
        this.mainLayout.show(this.addressEditor, PANEL_HOUSE);
        this.house.setText(house);
    }

    private void setSelectedHouse(int houseId) {
        this.clearHouseInfo();
        this.hid = houseId;
        Request request = new Request();
        request.setModule("admin");
        request.setAction("GetHouseInfo");
        request.setPageIndex(1);
        request.setPageSize(25);
        request.setAttribute("houseid", houseId);
        request.setAttribute("pid", this.id);
        request.setAttribute("isObject", this.isObject);
        Document doc = this.getDocument(request);
        Element houseInfo = XMLUtils.selectElement(doc, "data/table/data/row");
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        additionalInfo.put("\u0418\u043d\u0434\u0435\u043a\u0441", houseInfo.getAttribute("f1"));
        additionalInfo.put("\u0420\u0430\u0439\u043e\u043d", houseInfo.getAttribute("f3"));
        additionalInfo.put("\u041a\u0432\u0430\u0440\u0442\u0430\u043b", houseInfo.getAttribute("f4"));
        this.addExtraParamsToMap(XMLUtils.selectElement(doc, "data/extraParams"), additionalInfo);
        this.setAdditionalInfo(additionalInfo);
        this.setAddressFormatTableData(doc);
        this.house.setText(houseInfo.getAttribute("f6"));
        this.area.setText(this.areaValue);
        this.quarter.setText(this.quarterValue);
        this.cityTitle = houseInfo.getAttribute("f2");
        this.streetTitle = houseInfo.getAttribute("f5");
        this.houseAndFrac = houseInfo.getAttribute("f6");
        this.houseButton.setText(this.cityTitle + ", " + this.streetTitle + ", " + this.houseAndFrac);
        this.mainLayout.show(this.addressEditor, PANEL_ADDRESS);
        this.okButton.setEnabled(true);
    }

    private void addExtraParamsToMap(Element extraParams, Map<String, String> map) {
        if (extraParams != null) {
            this.entranceRange = null;
            this.floorRange = null;
            for (Element item : XMLUtils.elements(extraParams.getChildNodes())) {
                String key = item.getAttribute("param_title");
                String value = item.getAttribute("param_value");
                String id = item.getAttribute("param_id");
                if (id.equals("floorRange")) {
                    this.floorRange = value;
                } else if (id.equals("entranceRange")) {
                    this.entranceRange = value;
                }
                map.put(key, value);
            }
        }
    }

    public void setAddressCustomFlag(boolean addressCustomFlag) {
        this.addressCustomFlag = addressCustomFlag;
    }

    private void clearHouseInfo() {
        this.additionalInfoTable.removeRows();
        this.houseButton.requestFocusInWindow();
        this.houseButton.setText("");
        this.flat.setText("");
        this.pod.setText("");
        this.floor.setText("");
        this.room.setText("");
        this.comment.setText("");
    }

    private void onFlatChanged() {
        String flt = this.flat.getText();
        if (Utils.notBlankString(flt)) {
            if (this.entranceRange != null) {
                this.pod.setText(String.valueOf(AddressUtil.getEntrance(this.entranceRange, Integer.valueOf(flt))));
            }
            if (this.floorRange != null) {
                this.floor.setText(String.valueOf(AddressUtil.getFloor(this.floorRange, Integer.valueOf(flt))));
            }
        }
    }

    public void setOkButton(JButton button) {
        this.okButton = button;
    }

    protected void clearHouseSearchPanel() {
        this.searchTable.removeRows();
        ((JTextComponent)this.street.getEditor().getEditorComponent()).setText("");
        this.house.setText("");
    }

    private FocusTraversalPolicy getFocus() {
        Vector<Component> focusOrder = new Vector<Component>();
        focusOrder.add(this.houseButton);
        focusOrder.add(this.flat);
        focusOrder.add(this.room);
        focusOrder.add(this.pod);
        focusOrder.add(this.floor);
        focusOrder.add(this.comment);
        return new AddressEditorFocusTraversalPolicy(focusOrder);
    }

    private void setAddressFormatTableData(Document document) {
        Element selectRadio = XMLUtils.selectElement(document, "//selected");
        int tmpSelected = Utils.parseInt(selectRadio.getAttribute("selected_id"), 0);
        ArrayList addressFormatData = new ArrayList();
        XMLUtils.selectElements(document, "//addressFormatTable/data/row").forEach(i -> {
            int index = Utils.parseInt(i.getAttribute("f0"));
            if (this.selected > tmpSelected) {
                i.setAttribute("f1", String.valueOf(index == this.selected));
            } else {
                i.setAttribute("f1", String.valueOf(index == tmpSelected));
            }
            addressFormatData.add(i);
        });
        this.addressFormatTableModel.setData(addressFormatData);
    }

    class AddressFormatTableModel
    extends BGTableModel<Element> {
        public AddressFormatTableModel(String name) {
            super(name);
        }

        @Override
        protected void initColumns() {
            this.addColumn("X", 30, 30, 30, "f1", true).setTableCellRenderer(new RadioTableCellRenderer(0));
            this.addColumn("\u0410\u0434\u0440\u0435\u0441", -1, -1, -1, "f2", true).setTableCellRenderer(HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("ID", 80, 80, 80, "f0", true).setTableCellRenderer(DecimalTableCellRenderer.INTEGER());
        }
    }

    class AddressDocumentListener
    implements DocumentListener {
        AddressDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateTable(e);
        }

        private void updateTable(DocumentEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Request request = new Request();
                    request.setModule("admin");
                    request.setAction("GetHouseInfo");
                    request.setPageIndex(1);
                    request.setPageSize(25);
                    request.setAttribute("houseid", AddressEditor.this.hid);
                    request.setAttribute("flat", AddressEditor.this.flat.getText());
                    request.setAttribute("room", AddressEditor.this.room.getText());
                    request.setAttribute("pod", AddressEditor.this.pod.getText());
                    request.setAttribute("floor", AddressEditor.this.floor.getText());
                    request.setAttribute("pid", AddressEditor.this.id);
                    request.setAttribute("isObject", AddressEditor.this.isObject);
                    AddressEditor.this.setAddressFormatTableData(AddressEditor.this.getDocument(request));
                }
            });
        }
    }

    class AddressEditorFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order = null;

        public AddressEditorFocusTraversalPolicy(Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

