/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.admin.resource;

import bitel.billing.module.admin.resource.NumberResourceCategoriesTreePanel;
import bitel.billing.module.admin.resource.NumberResourceUseHistory;
import bitel.billing.module.admin.resource.ResourceManager;
import bitel.billing.module.admin.resource.SelectReserveDateDialog;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.resource.common.service.NumberResourceService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class NumberResourceManager
extends ResourceManager
implements ActionListener {
    private JPanel editor;
    private BGTextField fromNumberTa;
    private BGTextField toNumberTa;
    private BGComboBox<ComboBoxItem> numberStatusCb;
    private BGControlPanelDateNoB onDate;
    private JPanel resourceAddEditor;
    private BGControlPanelDateNoB date;
    private BGTextField numbers;
    private JPanel resourcePeriodChangeEditor;
    private BGControlPanelPeriodNoB resourcePeriod;
    private JPanel categoryChangeEditor;
    private JPanel countPanel;
    private JLabel countLabel;
    private JPopupMenu popupMenu1;
    private JPopupMenu popupMenu2;
    private boolean moveFlag = false;

    @Override
    protected void init() {
        this.categoriesTree = new NumberResourceCategoriesTreePanel(false);
        this.historyPanel = new NumberResourceUseHistory();
        this.actionPrefix = "NumberResource";
        this.table.setHeader(this.rb_name, this.moduleDoc, "number_resource");
    }

    @Override
    protected void initManager() {
        JMenuItem addToReserveItem = new JMenuItem("\u0412 \u0440\u0435\u0437\u0435\u0440\u0432");
        addToReserveItem.addActionListener(e -> this.changeReserve());
        this.popupMenu1 = new JPopupMenu();
        this.popupMenu1.add(addToReserveItem);
        JMenuItem removeFromReserveItem = new JMenuItem("\u0418\u0437 \u0440\u0435\u0437\u0435\u0440\u0432\u0430");
        removeFromReserveItem.addActionListener(e -> this.removeReserve());
        JMenuItem changeReserveItem = new JMenuItem("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0434\u0430\u0442\u0443 \u0440\u0435\u0437\u0435\u0440\u0432\u0430");
        changeReserveItem.addActionListener(e -> this.changeReserve());
        this.popupMenu2 = new JPopupMenu();
        this.popupMenu2.add(changeReserveItem);
        this.popupMenu2.add(removeFromReserveItem);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NumberResourceManager.this.editItem();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger() && NumberResourceManager.this.table.getSelectedRow() != -1) {
                    if (Utils.isEmptyString(NumberResourceManager.this.table.getModel().getValueAt(NumberResourceManager.this.table.getSelectedRow(), 3).toString()) && Utils.isEmptyString(NumberResourceManager.this.table.getModel().getValueAt(NumberResourceManager.this.table.getSelectedRow(), 5).toString())) {
                        NumberResourceManager.this.popupMenu1.show(e.getComponent(), e.getX(), e.getY());
                    } else if (!Utils.isEmptyString(NumberResourceManager.this.table.getModel().getValueAt(NumberResourceManager.this.table.getSelectedRow(), 5).toString())) {
                        NumberResourceManager.this.popupMenu2.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.addButton("newItem", "start_from", "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441\u044b");
        toolBar.addButton("editItem", "item_edit", "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
        toolBar.addButton("moveItem", "link", "\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e");
        toolBar.addButton("deleteItem", "item_delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441\u044b");
        toolBar.setActionListener(this);
        toolBar.setToolBar(new String[]{"newItem", "editItem", "moveItem", "deleteItem"});
        toolBar.setFloatable(false);
        this.fromNumberTa = new BGTextField();
        this.toNumberTa = new BGTextField();
        final JLabel onDateLabel = new JLabel("\u043d\u0430 \u0434\u0430\u0442\u0443:");
        this.onDate = new BGControlPanelDateNoB();
        this.onDate.setDateCalendar(new GregorianCalendar());
        this.numberStatusCb = new BGComboBox();
        this.numberStatusCb.addItem(new ComboBoxItem("any", "\u041b\u044e\u0431\u044b\u0435"));
        this.numberStatusCb.addItem(new ComboBoxItem("free", "\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435"));
        this.numberStatusCb.addItem(new ComboBoxItem("busy", "\u0417\u0430\u043d\u044f\u0442\u044b\u0435"));
        this.numberStatusCb.addItem(new ComboBoxItem("lastuse", "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435"));
        this.numberStatusCb.addItem(new ComboBoxItem("reserved", "\u0412 \u0440\u0435\u0437\u0435\u0440\u0432\u0435"));
        this.numberStatusCb.addItem(new ComboBoxItem("free_reserve", "\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435 + \u0432 \u0440\u0435\u0437\u0435\u0440\u0432\u0435"));
        this.numberStatusCb.addItem(new ComboBoxItem("busy_reserve", "\u0417\u0430\u043d\u044f\u0442\u044b\u0435 - \u0432 \u0440\u0435\u0437\u0435\u0440\u0432\u0435 "));
        this.numberStatusCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClientUtils.getIdFromComboBox(NumberResourceManager.this.numberStatusCb).equals("lastuse")) {
                    onDateLabel.setText("");
                } else {
                    onDateLabel.setText("\u043d\u0430 \u0434\u0430\u0442\u0443:");
                }
            }
        });
        JPanel manager = new JPanel(new GridBagLayout());
        JButton findButton = new JButton("\u0412\u044b\u0432\u0435\u0441\u0442\u0438");
        findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberResourceManager.this.showForCategory();
            }
        });
        this.categoriesTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && !NumberResourceManager.this.moveFlag) {
                    NumberResourceManager.this.showForCategory();
                }
            }
        });
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)this.fromNumberTa, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)new JLabel("-"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)this.toNumberTa, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add(this.numberStatusCb, new GridBagConstraints(4, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)onDateLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)this.onDate, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        filterPanel.add((Component)findButton, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberResourceManager.this.stopEdit(e.getActionCommand().equals("ok"));
            }
        };
        this.resourceAddEditor = new JPanel(new GridBagLayout());
        this.resourceAddEditor.setBorder(new BGTitleBorder(" \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 "));
        this.date = new BGControlPanelDateNoB();
        this.numbers = new BGTextField();
        this.resourceAddEditor.add((Component)new JLabel("\u0421 \u0434\u0430\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.resourceAddEditor.add((Component)this.date, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.resourceAddEditor.add((Component)new JLabel("\u0420\u0435\u0441\u0443\u0440\u0441\u044b:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.resourceAddEditor.add((Component)this.numbers, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        this.resourceAddEditor.add((Component)okCancel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        okCancel.addActionListener(al);
        this.resourcePeriodChangeEditor = new JPanel(new GridBagLayout());
        this.resourcePeriodChangeEditor.setBorder(new BGTitleBorder(" \u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 "));
        this.resourcePeriod = new BGControlPanelPeriodNoB();
        this.resourcePeriodChangeEditor.add((Component)new JLabel("\u041d\u043e\u0432\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.resourcePeriodChangeEditor.add((Component)this.resourcePeriod, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        BGButtonPanelOkCancel dateChangeOkCancel = new BGButtonPanelOkCancel();
        this.resourcePeriodChangeEditor.add((Component)dateChangeOkCancel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        dateChangeOkCancel.addActionListener(al);
        this.categoryChangeEditor = new JPanel(new GridBagLayout());
        this.categoryChangeEditor.setBorder(new BGTitleBorder(" \u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u0432 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e "));
        BGButtonPanelOkCancel categoryChangeOkCancel = new BGButtonPanelOkCancel();
        this.categoryChangeEditor.add((Component)new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432 \u0434\u0435\u0440\u0435\u0432\u0435 \u043d\u043e\u0432\u0443\u044e \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u0434\u043b\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u0438 \u043d\u0430\u0436\u043c\u0438\u0442\u0435 \u041e\u043a"), new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.categoryChangeEditor.add((Component)categoryChangeOkCancel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        categoryChangeOkCancel.addActionListener(al);
        this.countLabel = new JLabel();
        JLabel countTextLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u043d\u043e\u043c\u0435\u0440\u043e\u0432:");
        this.countPanel = new JPanel(new GridBagLayout());
        this.countPanel.add((Component)countTextLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.countPanel.add((Component)this.countLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        manager.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        manager.add((Component)filterPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        manager.add((Component)new JScrollPane(this.table), new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        manager.add((Component)this.resourceAddEditor, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        manager.add((Component)this.historyPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        manager.add((Component)this.resourcePeriodChangeEditor, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        manager.add((Component)this.categoryChangeEditor, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        manager.add((Component)this.countPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.resourceAddEditor.setVisible(false);
        this.historyPanel.setVisible(false);
        this.resourcePeriodChangeEditor.setVisible(false);
        this.categoryChangeEditor.setVisible(false);
        this.countPanel.setVisible(true);
        ClientUtils.addOnlyOneShownListener(this.resourceAddEditor, this.historyPanel, this.resourcePeriodChangeEditor, this.categoryChangeEditor, this.countPanel);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String id = ClientUtils.getRowId(NumberResourceManager.this.table);
                    NumberResourceManager.this.historyPanel.setId(id);
                    NumberResourceManager.this.historyPanel.setData();
                    NumberResourceManager.this.historyPanel.setVisible(true);
                }
            }
        });
        this.add((Component)this.createSyncButton(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)manager, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void init(String module, int mid) {
        super.init(module, mid);
        this.historyPanel.init(module, mid);
    }

    @Override
    public void setData() {
        this.categoriesTree.setData();
        this.showForCategory();
    }

    @Override
    public void deleteItem() {
        String id = ClientUtils.getRowIdList(this.table, "id", "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443(\u0438)");
        if (Utils.isBlankString(id)) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0435\u0441\u0443\u0440\u0441(\u044b)");
            return;
        }
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441(\u044b)?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("NumberResourceDelete");
            request.setModuleId(this.getModuleId());
            request.setAttribute("id", id);
            if (ClientUtils.checkStatus(this.getDocument(request))) {
                this.showForCategory();
            }
        }
    }

    @Override
    public void newItem() {
        this.editor = this.resourceAddEditor;
        this.startEdit();
    }

    @Override
    public void editItem() {
        this.editor = this.resourcePeriodChangeEditor;
        this.startEdit();
    }

    private void moveItem() {
        this.editor = this.categoryChangeEditor;
        this.moveFlag = true;
        this.startEdit();
    }

    private void startEdit() {
        if (this.editor == this.resourceAddEditor) {
            this.date.setDateCalendar(new GregorianCalendar());
            this.numbers.setText("");
        }
        this.editor.setVisible(true);
    }

    private void stopEdit(boolean ok) {
        if (ok) {
            if (this.editor == this.resourceAddEditor) {
                String categoryId = this.categoriesTree.getSelectedId();
                String date = this.date.getDateString();
                if (Utils.isBlankString(date)) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443!");
                    return;
                }
                if (Utils.isBlankString(categoryId)) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e!");
                    return;
                }
                String numbers = this.numbers.getText();
                if (Utils.isBlankString(numbers)) {
                    ClientUtils.showErrorMessageDialog("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u043d\u043e\u043c\u0435\u0440\u0430!");
                    return;
                }
                Request req = new Request();
                req.setModule(this.module);
                req.setModuleId(this.getModuleId());
                req.setAttribute("category_id", categoryId);
                req.setAttribute("date", date);
                req.setAttribute("numbers", numbers);
                req.setAction("NumberResourceAdd");
                if (ClientUtils.checkStatus(this.getDocument(req))) {
                    this.countPanel.setVisible(true);
                    this.showForCategory();
                }
            } else if (this.editor == this.resourcePeriodChangeEditor) {
                String ids = ClientUtils.getRowIdList(this.table, "id", "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0441\u0443\u0440\u0441(\u044b)");
                if (Utils.notBlankString(ids)) {
                    Request req = new Request();
                    req.setModule(this.module);
                    req.setModuleId(this.getModuleId());
                    req.setAction("NumberResourcePeriodChange");
                    req.setAttribute("ids", ids);
                    req.setAttribute("date1", this.resourcePeriod.getDateString1());
                    req.setAttribute("date2", this.resourcePeriod.getDateString2());
                    if (ClientUtils.checkStatus(this.getDocument(req))) {
                        this.countPanel.setVisible(true);
                        this.showForCategory();
                    }
                }
            } else if (this.editor == this.categoryChangeEditor) {
                String categoryId = this.categoriesTree.getSelectedId();
                if (Utils.isBlankString(categoryId)) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e!");
                    return;
                }
                String ids = ClientUtils.getRowIdList(this.table, "id", "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0441\u0443\u0440\u0441(\u044b)");
                if (Utils.notBlankString(ids)) {
                    Request req = new Request();
                    req.setModule(this.module);
                    req.setModuleId(this.getModuleId());
                    req.setAction("NumberResourceCategoryChange");
                    req.setAttribute("ids", ids);
                    req.setAttribute("category_id", categoryId);
                    if (ClientUtils.checkStatus(this.getDocument(req))) {
                        this.countPanel.setVisible(true);
                        this.showForCategory();
                    }
                }
                this.moveFlag = false;
            }
        } else {
            this.countPanel.setVisible(true);
        }
    }

    @Override
    protected void showForCategory() {
        super.showForCategory();
        this.countLabel.setText(String.valueOf(this.table.getRowCount()));
    }

    @Override
    protected boolean addFilterParams(Request req) {
        String status = ClientUtils.getIdFromComboBox(this.numberStatusCb);
        String onDate = this.onDate.getDateString();
        if (!status.equals("any") && Utils.isBlankString(onDate)) {
            ClientUtils.showErrorMessageDialog("\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0435 \u0438\u043b\u0438 \u0437\u0430\u043d\u044f\u0442\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u0434\u0430\u0442\u0443!");
            return false;
        }
        req.setAttribute("status", status);
        req.setAttribute("on_date", onDate);
        req.setAttribute("from_number", this.fromNumberTa.getText());
        req.setAttribute("to_number", this.toNumberTa.getText());
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("moveItem")) {
            this.moveItem();
        } else {
            super.actionPerformed(e);
        }
    }

    private void changeReserve() {
        Calendar calendar;
        SelectReserveDateDialog sdd = new SelectReserveDateDialog();
        int resourceId = Utils.parseInt(this.table.getModel().getValueAt(this.table.getSelectedRow(), 0).toString(), -1);
        Date dateReserve = TimeUtils.parseDate(this.table.getModel().getValueAt(this.table.getSelectedRow(), 5).toString(), "dd.MM.yyyy");
        if (dateReserve != null) {
            calendar = new GregorianCalendar();
            calendar.setTime(dateReserve);
            sdd.setCalendar(calendar);
        }
        String comment = this.table.getModel().getValueAt(this.table.getSelectedRow(), 6).toString();
        sdd.setComment(comment);
        sdd.setVisible(true);
        calendar = sdd.getCalendar();
        sdd.dispose();
        if (calendar != null) {
            try {
                this.getContext().getPort(NumberResourceService.class).setReserveDate(resourceId, calendar.getTime(), sdd.getComment());
            }
            catch (BGException e) {
                this.getContext().processException(e);
            }
        }
        this.setData();
    }

    private void removeReserve() {
        int resourceId = Utils.parseInt(this.table.getModel().getValueAt(this.table.getSelectedRow(), 0).toString(), -1);
        try {
            this.getContext().getPort(NumberResourceService.class).removeReserveDate(resourceId);
        }
        catch (BGException e) {
            this.getContext().processException(e);
        }
        this.setData();
    }
}

