/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.util.AbstractPeriodItemSet2;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;

public class ProductPeriodRuntimeList
extends AbstractPeriodItemSet2<ProductPeriodItem> {
    private static final Logger logger = LogManager.getLogger();
    private static final Function<ProductPeriodItem, Integer> PRODUCT_SPEC_CONVERTER = o -> o.productSpecId;

    ProductPeriodRuntimeList(List<ProductPeriodItem> entryList) {
        super(entryList);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(160);
            sb.append("Create: \n");
            for (ProductPeriodItem item : (ProductPeriodItem[])this.entries) {
                item.toString(sb.append("\tProductPeriod: ")).append("\n");
            }
            sb.setLength(sb.length() - 1);
            logger.debug(sb.toString());
        }
    }

    ProductPeriodRuntimeList(ProductPeriodItem[] entries) {
        super((AbstractPeriodItemSet2.PeriodItem[])entries);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(160);
            sb.append("Create: \n");
            for (ProductPeriodItem item : entries) {
                item.toString(sb.append("\tProductPeriod: ")).append("\n");
            }
            sb.setLength(sb.length() - 1);
            logger.debug(sb.toString());
        }
    }

    protected ProductPeriodItem[] newArray(int size) {
        return new ProductPeriodItem[size];
    }

    protected boolean containsMillis(ProductPeriodItem item, long millis) {
        return item.timeFrom <= millis && (item.timeTo == 0L || millis <= item.timeTo);
    }

    protected boolean isCoincide(ProductPeriodItem item, ProductPeriodItem other) {
        return other.productPeriodId == item.productPeriodId && other.productId == other.productId;
    }

    public ProductPeriodRuntimeList add(int productSpecId, int productId, int productPeriodId, Date timeFrom, Date timeTo, Date prolongationTime) {
        return new ProductPeriodRuntimeList((ProductPeriodItem[])super.add((AbstractPeriodItemSet2.PeriodItem)new ProductPeriodItem(productSpecId, productId, productPeriodId, timeFrom, timeTo, prolongationTime)));
    }

    public ProductPeriodRuntimeList update(int productSpecId, int productId, int productPeriodId, Date timeFrom, Date timeTo, Date prolongationTime) {
        return new ProductPeriodRuntimeList((ProductPeriodItem[])super.update((AbstractPeriodItemSet2.PeriodItem)new ProductPeriodItem(productSpecId, productId, productPeriodId, timeFrom, timeTo, prolongationTime)));
    }

    public ProductPeriodRuntimeList remove(int productSpecId, int productId, int productPeriodId, Date timeFrom, Date timeTo, Date prolongationTime) {
        return new ProductPeriodRuntimeList((ProductPeriodItem[])super.remove((AbstractPeriodItemSet2.PeriodItem)new ProductPeriodItem(productSpecId, productId, productPeriodId, timeFrom, timeTo, prolongationTime)));
    }

    public static ProductPeriodRuntimeList newInstance(List<ProductPeriod> productPeriodList) {
        ArrayList<ProductPeriodItem> result = new ArrayList<ProductPeriodItem>();
        for (ProductPeriod productPeriod : productPeriodList) {
            result.add(new ProductPeriodItem(productPeriod.getProductSpecId(), productPeriod.getProductId(), productPeriod.getId(), productPeriod.getTimeFrom(), productPeriod.getTimeTo(), productPeriod.getProlongationTime()));
        }
        return new ProductPeriodRuntimeList(result);
    }

    public ProductPeriodItem[] items() {
        return (ProductPeriodItem[])this.entries;
    }

    public Set<Integer> activeProductSpecIds(long millis) {
        return this.ids(PRODUCT_SPEC_CONVERTER, millis);
    }

    public void activeProductSpecIds(long millis, Set<Integer> result, int exceptProductId) {
        this.ids(PRODUCT_SPEC_CONVERTER, p -> p.productId != exceptProductId, millis, result);
    }

    public void activeProductSpecIds(long millis, Set<Integer> result, Predicate<ProductPeriodItem> predicate) {
        this.ids(PRODUCT_SPEC_CONVERTER, predicate, millis, result);
    }

    public ProductPeriodItem getLast(int productId) {
        for (int i = ((ProductPeriodItem[])this.entries).length - 1; i >= 0; --i) {
            ProductPeriodItem item = ((ProductPeriodItem[])this.entries)[i];
            if (item.productId != productId) continue;
            return item;
        }
        return null;
    }

    public boolean containsActiveProductSpecIds(long millis, Set<Integer> ids) {
        return this.contains(PRODUCT_SPEC_CONVERTER, millis, ids);
    }

    public static final class ProductPeriodItem
    extends AbstractPeriodItemSet2.PeriodItem
    implements Delayed {
        public final int productSpecId;
        public final int productId;
        public final int productPeriodId;
        public final long prolongationTime;

        public ProductPeriodItem(int productSpecId, int productId, int productPeriodId, Date timeFrom, Date timeTo, Date prolongationTime) {
            this(productSpecId, productId, productPeriodId, timeFrom != null ? timeFrom.getTime() : 0L, timeTo != null ? timeTo.getTime() : 0L, prolongationTime != null ? prolongationTime.getTime() : 0L);
        }

        public ProductPeriodItem(int productSpecId, int productId, int productPeriodId, long timeFrom, long timeTo, long prolongationTime) {
            super(timeFrom / 1000L * 1000L, timeTo / 1000L * 1000L + 999L);
            this.productSpecId = productSpecId;
            this.productId = productId;
            this.productPeriodId = productPeriodId;
            this.prolongationTime = prolongationTime;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            assert (this.timeTo != 0L);
            return unit.convert(this.timeTo - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            ProductPeriodItem x = (ProductPeriodItem)other;
            long diff = this.timeTo - x.timeTo;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }

        public StringBuilder toString(StringBuilder sb) {
            return sb.append(this.productSpecId).append('-').append(this.productId).append('-').append(this.productPeriodId).append(": ").append(this.timeFrom == 0L ? "null" : TimeUtils.format((Date)new Date(this.timeFrom), (String)"dd.MM.yyyy HH:mm:ss.S")).append(" - ").append(this.timeTo == 0L ? "null" : TimeUtils.format((Date)new Date(this.timeTo), (String)"dd.MM.yyyy HH:mm:ss.S")).append(" : ").append(this.prolongationTime == 0L ? "null" : TimeUtils.format((Date)new Date(this.prolongationTime), (String)"dd.MM.yyyy HH:mm:ss.S"));
        }
    }
}

