/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrBooleanDao
extends EntityAttrDefaultDao<EntityAttrBoolean> {
    public EntityAttrBooleanDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String intTable) {
        super(con, entityAttrDao, intTable);
    }

    @Override
    protected void createTable() {
    }

    @Override
    public EntityAttrBoolean get(int entityId, int attrSpecId) throws SQLException {
        EntityAttrBoolean result = null;
        try (PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = new EntityAttrBoolean(entityId, attrSpecId, rs.getBoolean(1));
            }
        }
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a) throws SQLException {
        try (PreparedStatement ps = this.getInsertPS(entityId, a.getEntitySpecAttrId());){
            ps.setBoolean(3, ((EntityAttrBoolean)a).getValue());
            ps.executeUpdate();
        }
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrBoolean attr) throws SQLException {
        boolean update = false;
        try (PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());){
            ps.setBoolean(1, attr.getValue());
            update = ps.executeUpdate() == 0;
        }
        if (update) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            try {
                ps.setBoolean(3, attr.getValue());
                ps.executeUpdate();
                boolean bl = true;
                return bl;
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        boolean oldValue = false;
        try (PreparedStatement ps = this.entityAttrDao.getSelectOldValuePS();
             ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                oldValue = rs.getBoolean(1);
            }
        }
        return attr.getValue() != oldValue;
    }

    @Override
    protected void insertHistory(int contractId, EntityAttrBoolean attr) throws SQLException {
        try (PreparedStatement ps = this.getInsertHistiryPS();){
            ps.setInt(1, contractId);
            ps.setInt(2, attr.getEntitySpecAttrId());
            ps.setBoolean(3, attr != null ? Boolean.valueOf(attr.getValue()) : null);
            ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
            ps.setInt(5, this.entityAttrDao.userId);
            ps.executeUpdate();
        }
    }
}

