/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.service;

import bitel.billing.server.admin.bean.AddressManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.GetIndexPoint;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.KeyValue;
import ru.bitel.common.model.Page;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.directories.address.server.bean.AddressUtils;
import ru.bitel.oss.kernel.directories.address.server.bean.AreaDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CityDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CountryDao;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.QuarterDao;
import ru.bitel.oss.kernel.directories.address.server.bean.StreetDao;

@WebService(endpointInterface="ru.bitel.oss.kernel.directories.address.common.service.AddressService")
@XmlSeeAlso(value={KeyValue.class})
public class AddressServiceImpl
extends AbstractService
implements AddressService {
    private static final Logger logger = LogManager.getLogger();
    private Directory<Country> countryDirectory;
    private Directory<City> cityDirectory;
    private Directory<Area> areaDirectory;
    private Directory<Street> streetDirectory;
    private Directory<Quarter> quarterDirectory;
    private AreaDao areaDao;
    private CountryDao countryDao;
    private CityDao cityDao;
    private StreetDao streetDao;
    private QuarterDao quarterDao;
    private HouseDao houseDao;

    @PostConstruct
    protected void init() throws BGException {
        this.countryDirectory = this.context.getDirectory(Country.class, 0);
        this.cityDirectory = this.context.getDirectory(City.class, 0);
        this.areaDirectory = this.context.getDirectory(Area.class, 0);
        this.streetDirectory = this.context.getDirectory(Street.class, 0);
        this.quarterDirectory = this.context.getDirectory(Quarter.class, 0);
        this.countryDao = new CountryDao(this.getConnection());
        this.areaDao = new AreaDao(this.getConnection());
        this.cityDao = new CityDao(this.getConnection());
        this.streetDao = new StreetDao(this.getConnection());
        this.quarterDao = new QuarterDao(this.getConnection());
        this.houseDao = new HouseDao(this.getConnection());
    }

    public Country countryGet(int id) throws BGException {
        return this.countryDirectory.get(id);
    }

    public List<Country> countryList(String title) throws BGException {
        if (Utils.isBlankString((String)title)) {
            return this.countryDirectory.list();
        }
        return this.countryDao.list(title);
    }

    public int countryUpdate(Country b) throws BGException {
        this.countryDirectory.update(b);
        return b.getId();
    }

    public void countryDelete(int id) throws BGException {
        this.countryDirectory.delete(id);
    }

    public City cityGet(int id) throws BGException {
        return this.cityDirectory.get(id);
    }

    public List<City> cityList(int countryId, String title) throws BGException {
        if (countryId <= 0 && Utils.isBlankString((String)title)) {
            return this.cityDirectory.list();
        }
        return this.cityDao.list(countryId, title);
    }

    public int cityUpdate(City b) throws BGException {
        this.cityDirectory.update(b);
        return b.getId();
    }

    public void cityDelete(int id) throws BGException {
        this.cityDirectory.delete(id);
    }

    public Area areaGet(int id) throws BGException {
        return this.areaDirectory.get(id);
    }

    public List<Area> areaList(int cityId, String title) throws BGException {
        if (cityId <= 0 && Utils.isBlankString((String)title)) {
            return this.areaDirectory.list();
        }
        return this.areaDao.list(cityId, title);
    }

    public int areaUpdate(Area b) throws BGException {
        this.areaDirectory.update(b);
        return b.getId();
    }

    public void areaDelete(int id) throws BGException {
        this.areaDirectory.delete(id);
    }

    public Street streetGet(int id) throws BGException {
        return this.streetDirectory.get(id);
    }

    public List<Street> streetList(int cityId, String title) throws BGException {
        if (cityId <= 0 && Utils.isBlankString((String)title)) {
            return this.streetDirectory.list();
        }
        return this.streetDao.list(cityId, title);
    }

    public List<Street> streetSearch(int cityId, String title, String cityTitle, Page page) throws BGException {
        if (cityId <= 0 && Utils.isBlankString((String)title) && Utils.isBlankString((String)cityTitle) && page == null) {
            return this.streetDirectory.list();
        }
        return this.streetDao.search(cityId, title, cityTitle, page);
    }

    public int streetUpdate(Street b) throws BGException {
        this.streetDirectory.update(b);
        return b.getId();
    }

    public void streetDelete(int id) throws BGException {
        this.streetDirectory.delete(id);
    }

    public Quarter quarterGet(int id) throws BGException {
        return this.quarterDirectory.get(id);
    }

    public List<Quarter> quarterList(int cityId, String title) throws BGException {
        if (cityId <= 0 && Utils.isBlankString((String)title)) {
            return this.quarterDirectory.list();
        }
        return this.quarterDao.list(cityId, title);
    }

    public int quarterUpdate(Quarter b) throws BGException {
        this.quarterDirectory.update(b);
        return b.getId();
    }

    public void quarterDelete(int id) throws BGException {
        this.quarterDirectory.delete(id);
    }

    public String postIndexGet(int streetId, String houseAndFrac, int house, String frac) throws BGException {
        Collection<GetIndexPoint> points;
        if (streetId == -1) {
            return null;
        }
        Connection con = this.getConnection();
        String index = this.streetDao.getPostIndex(streetId);
        if (!Utils.isEmptyString((String)index)) {
            return index;
        }
        if (houseAndFrac != null && house <= 0) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < houseAndFrac.length(); ++i) {
                int ch = houseAndFrac.charAt(i);
                if (!Character.isDigit((char)ch)) {
                    frac = houseAndFrac.substring(i);
                    break;
                }
                str.append((char)ch);
            }
            house = Utils.parseInt((String)str.toString(), (int)-1);
        }
        if (house < 1) {
            return null;
        }
        String boxIndexRange = new AddressManager(con, null).getAddressParam("address_street", streetId, "boxIndexRange");
        if (!Utils.isEmptyString((String)boxIndexRange)) {
            for (String tokens : boxIndexRange.split(";")) {
                String[] indexData = tokens.split(":");
                if (indexData.length != 2 && !indexData[0].matches("^\\d{6}$")) continue;
                for (String houseToken : indexData[1].split(",")) {
                    int rangeStop;
                    if ("*".equals(houseToken) || houseToken.equals(String.valueOf(house).concat(frac != null ? frac : ""))) {
                        return indexData[0];
                    }
                    if (!houseToken.matches("^\\d+\\-(\\d+)?$")) continue;
                    String[] range = houseToken.split("-");
                    int rangeStart = Utils.parseInt((String)range[0], (int)-1);
                    int n = rangeStop = range.length > 1 ? Utils.parseInt((String)range[1], (int)-1) : -1;
                    if (rangeStart != -1 && (rangeStart <= 0 || rangeStart > house) || rangeStop != -1 && (rangeStop <= 0 || house > rangeStop)) continue;
                    return indexData[0];
                }
            }
        }
        if ((points = BGPluginManagerServer.getManager().getInvokeables(GetIndexPoint.class, true)).size() > 1) {
            throw new BGMessageException("\u0411\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0433\u0438\u043d\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043a \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0443 \u0432\u044b\u0434\u0430\u0447\u0438 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u0434\u043e\u043c\u0430");
        }
        GetIndexPoint finder = null;
        if (points.size() == 1) {
            finder = points.iterator().next();
        }
        if (finder != null && !Utils.isEmptyString((String)(index = finder.getIndex(this.getConnection(), logger, streetId, house, frac)))) {
            return index;
        }
        return null;
    }

    public House houseGet(int id) throws BGException {
        return this.houseDao.get(id);
    }

    public List<House> houseList(int cityId, int areaId, int streetId, int quarterId, int house, String frac, Page page) throws BGException {
        return this.houseDao.list(cityId, areaId, streetId, quarterId, house, frac, page);
    }

    public int houseUpdate(House b) throws BGException {
        this.houseDao.update(b);
        return b.getId();
    }

    public void houseDelete(int id) throws BGException {
        this.houseDao.delete(id);
    }

    public List<KeyValue<String, String>> addressFormat(int houseId, int pod, int floor, String flat, String room, String comment) throws BGException {
        ArrayList<KeyValue<String, String>> result = new ArrayList<KeyValue<String, String>>();
        Setup setup = this.context.getSetup();
        AddressUtils addressUtils = new AddressUtils(this.context);
        House house = this.houseGet(houseId);
        result.add(new KeyValue((Comparable)((Object)"0"), (Object)addressUtils.getAddress((ParameterMap)setup, "0", house, pod, floor, flat, room, comment)));
        String sortOrder = setup.get("addrs.format.list", null);
        if (sortOrder != null) {
            String[] sortOrderValues;
            for (String item : sortOrderValues = sortOrder.trim().split(";")) {
                String title = house != null ? addressUtils.getAddress((ParameterMap)setup, item, house, pod, floor, flat, room, comment) : "";
                result.add((KeyValue<String, String>)new KeyValue((Comparable)((Object)item), (Object)title));
            }
        }
        return result;
    }
}

